"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import builtins
import google.protobuf.descriptor
import google.protobuf.message
import qwak.feature_store.sources.streaming_pb2
import sys

if sys.version_info >= (3, 8):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class StreamingSink(google.protobuf.message.Message):
    """This section defines the general sink definitions based on the FS type, i.e.-
    a type for streaming featuresets, a type for batch featuresets etc.
    this is necessary for considerations such as attachment points etc. that are
    inherent to the featureset type and not the concrete sink type


    a sink for a streaming featureset (streaming here means the sink is aware of the online/offline
    jobs and defines which of the jobs it attaches to)
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ATTACHMENT_POINT_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    KAFKA_SINK_FIELD_NUMBER: builtins.int
    @property
    def attachment_point(self) -> global___StreamingAttachmentPoint:
        """The attachment point (i.e., which job is responsible for writing to this sink)"""
    name: builtins.str
    """sink name"""
    @property
    def kafka_sink(self) -> global___KafkaSink:
        """A kafka sink
        NOTE: DO NOT USE field number 3, it's already used above
        """
    def __init__(
        self,
        *,
        attachment_point: global___StreamingAttachmentPoint | None = ...,
        name: builtins.str = ...,
        kafka_sink: global___KafkaSink | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["attachment_point", b"attachment_point", "kafka_sink", b"kafka_sink", "sink_type", b"sink_type"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["attachment_point", b"attachment_point", "kafka_sink", b"kafka_sink", "name", b"name", "sink_type", b"sink_type"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["sink_type", b"sink_type"]) -> typing_extensions.Literal["kafka_sink"] | None: ...

global___StreamingSink = StreamingSink

class KafkaSink(google.protobuf.message.Message):
    """######################### Concrete  Sink Types #########################
    these are concrete sink types (e.g., Kafka, Kinesis)
    the relation of sink-by-fs-type:conrete-sink-type is a many:many relation

    A featureset sink that writes to kafka
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TOPIC_FIELD_NUMBER: builtins.int
    BOOTSTRAP_SERVERS_FIELD_NUMBER: builtins.int
    MESSAGE_FORMAT_FIELD_NUMBER: builtins.int
    AUTH_CONFIG_FIELD_NUMBER: builtins.int
    topic: builtins.str
    """Target topic"""
    bootstrap_servers: builtins.str
    """bootstrap servers, separated by a comma"""
    message_format: qwak.feature_store.sources.streaming_pb2.MessageFormat.ValueType
    """The format of the messages written to the sink"""
    @property
    def auth_config(self) -> qwak.feature_store.sources.streaming_pb2.Authentication:
        """Auth configuration"""
    def __init__(
        self,
        *,
        topic: builtins.str = ...,
        bootstrap_servers: builtins.str = ...,
        message_format: qwak.feature_store.sources.streaming_pb2.MessageFormat.ValueType = ...,
        auth_config: qwak.feature_store.sources.streaming_pb2.Authentication | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["auth_config", b"auth_config"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["auth_config", b"auth_config", "bootstrap_servers", b"bootstrap_servers", "message_format", b"message_format", "topic", b"topic"]) -> None: ...

global___KafkaSink = KafkaSink

class OnlineStreamingAttachmentPoint(google.protobuf.message.Message):
    """######################### Attachment Points #########################

    Attachment Point on the online job of streaming featureset
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___OnlineStreamingAttachmentPoint = OnlineStreamingAttachmentPoint

class OfflineStreamingAttachmentPoint(google.protobuf.message.Message):
    """Attachment Point on the offline job of a streaming featureset"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___OfflineStreamingAttachmentPoint = OfflineStreamingAttachmentPoint

class StreamingAttachmentPoint(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ONLINE_STREAMING_ATTACHMENT_POINT_FIELD_NUMBER: builtins.int
    OFFLINE_STREAMING_ATTACHMENT_POINT_FIELD_NUMBER: builtins.int
    @property
    def online_streaming_attachment_point(self) -> global___OnlineStreamingAttachmentPoint: ...
    @property
    def offline_streaming_attachment_point(self) -> global___OfflineStreamingAttachmentPoint: ...
    def __init__(
        self,
        *,
        online_streaming_attachment_point: global___OnlineStreamingAttachmentPoint | None = ...,
        offline_streaming_attachment_point: global___OfflineStreamingAttachmentPoint | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["attachment_point_type", b"attachment_point_type", "offline_streaming_attachment_point", b"offline_streaming_attachment_point", "online_streaming_attachment_point", b"online_streaming_attachment_point"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["attachment_point_type", b"attachment_point_type", "offline_streaming_attachment_point", b"offline_streaming_attachment_point", "online_streaming_attachment_point", b"online_streaming_attachment_point"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["attachment_point_type", b"attachment_point_type"]) -> typing_extensions.Literal["online_streaming_attachment_point", "offline_streaming_attachment_point"] | None: ...

global___StreamingAttachmentPoint = StreamingAttachmentPoint
