"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import builtins
import google.protobuf.descriptor
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _JobState:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _JobStateEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_JobState.ValueType], builtins.type):  # noqa: F821
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    INVALID: _JobState.ValueType  # 0
    """Job state"""
    PENDING: _JobState.ValueType  # 1
    """Job is pending"""
    RUNNING: _JobState.ValueType  # 2
    """Job is running"""
    COMPLETED: _JobState.ValueType  # 3
    """Job has completed"""
    FAILED: _JobState.ValueType  # 4
    """Job has failed"""
    TOO_EARLY: _JobState.ValueType  # 5
    """Job is too early"""

class JobState(_JobState, metaclass=_JobStateEnumTypeWrapper): ...

INVALID: JobState.ValueType  # 0
"""Job state"""
PENDING: JobState.ValueType  # 1
"""Job is pending"""
RUNNING: JobState.ValueType  # 2
"""Job is running"""
COMPLETED: JobState.ValueType  # 3
"""Job has completed"""
FAILED: JobState.ValueType  # 4
"""Job has failed"""
TOO_EARLY: JobState.ValueType  # 5
"""Job is too early"""
global___JobState = JobState

class JobRecord(google.protobuf.message.Message):
    """Feature Store Job Record.
    Represents a job generated from featureset
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    JOB_ID_FIELD_NUMBER: builtins.int
    RUN_ID_FIELD_NUMBER: builtins.int
    FEATURESET_NAME_FIELD_NUMBER: builtins.int
    FEATURESET_ID_FIELD_NUMBER: builtins.int
    ENVIRONMENT_ID_FIELD_NUMBER: builtins.int
    TRY_NUMBER_FIELD_NUMBER: builtins.int
    JOB_STATE_FIELD_NUMBER: builtins.int
    CREATION_TIME_FIELD_NUMBER: builtins.int
    START_TIME_FIELD_NUMBER: builtins.int
    END_TIME_FIELD_NUMBER: builtins.int
    INGESTION_WINDOW_FIELD_NUMBER: builtins.int
    EXECUTION_ID_FIELD_NUMBER: builtins.int
    INGESTION_MESSAGE_FIELD_NUMBER: builtins.int
    job_id: builtins.str
    """Unique id of the job"""
    run_id: builtins.int
    """Run id for the job"""
    featureset_name: builtins.str
    """Featureset name"""
    featureset_id: builtins.str
    """Featureset id"""
    environment_id: builtins.str
    """Environment_id"""
    try_number: builtins.int
    """Try count"""
    job_state: global___JobState.ValueType
    """State of the job - whether it's running, failed, pending, etc"""
    @property
    def creation_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Creation time"""
    @property
    def start_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Start time"""
    @property
    def end_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """End time"""
    @property
    def ingestion_window(self) -> global___IngestionWindow:
        """Ingestion window information"""
    execution_id: builtins.int
    """The execution id of the record"""
    ingestion_message: builtins.str
    """Ingestion message"""
    def __init__(
        self,
        *,
        job_id: builtins.str = ...,
        run_id: builtins.int = ...,
        featureset_name: builtins.str = ...,
        featureset_id: builtins.str = ...,
        environment_id: builtins.str = ...,
        try_number: builtins.int = ...,
        job_state: global___JobState.ValueType = ...,
        creation_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        start_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        end_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        ingestion_window: global___IngestionWindow | None = ...,
        execution_id: builtins.int = ...,
        ingestion_message: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["creation_time", b"creation_time", "end_time", b"end_time", "ingestion_window", b"ingestion_window", "start_time", b"start_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["creation_time", b"creation_time", "end_time", b"end_time", "environment_id", b"environment_id", "execution_id", b"execution_id", "featureset_id", b"featureset_id", "featureset_name", b"featureset_name", "ingestion_message", b"ingestion_message", "ingestion_window", b"ingestion_window", "job_id", b"job_id", "job_state", b"job_state", "run_id", b"run_id", "start_time", b"start_time", "try_number", b"try_number"]) -> None: ...

global___JobRecord = JobRecord

class IngestionWindow(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INGESTED_DATA_START_TIME_FIELD_NUMBER: builtins.int
    INGESTED_DATA_END_TIME_FIELD_NUMBER: builtins.int
    INGESTED_DATA_UPDATED_ROWS_FIELD_NUMBER: builtins.int
    SCHEDULED_EXECUTION_TIME_FIELD_NUMBER: builtins.int
    @property
    def ingested_data_start_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Ingested data window start time"""
    @property
    def ingested_data_end_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Ingested data window end time"""
    ingested_data_updated_rows: builtins.int
    """Ingested data number of updated rows"""
    @property
    def scheduled_execution_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Ingested data scheduled execution date"""
    def __init__(
        self,
        *,
        ingested_data_start_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        ingested_data_end_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        ingested_data_updated_rows: builtins.int = ...,
        scheduled_execution_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["ingested_data_end_time", b"ingested_data_end_time", "ingested_data_start_time", b"ingested_data_start_time", "scheduled_execution_time", b"scheduled_execution_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["ingested_data_end_time", b"ingested_data_end_time", "ingested_data_start_time", b"ingested_data_start_time", "ingested_data_updated_rows", b"ingested_data_updated_rows", "scheduled_execution_time", b"scheduled_execution_time"]) -> None: ...

global___IngestionWindow = IngestionWindow

class FeaturesetLevelJobsSummary(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FEATURESET_ID_FIELD_NUMBER: builtins.int
    TOTAL_NUM_AFFECTED_ROWS_FIELD_NUMBER: builtins.int
    featureset_id: builtins.str
    """Featureset Id"""
    total_num_affected_rows: builtins.int
    """Number of affected rows"""
    def __init__(
        self,
        *,
        featureset_id: builtins.str = ...,
        total_num_affected_rows: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["featureset_id", b"featureset_id", "total_num_affected_rows", b"total_num_affected_rows"]) -> None: ...

global___FeaturesetLevelJobsSummary = FeaturesetLevelJobsSummary
