"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import builtins
import google.protobuf.descriptor
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _JobState:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _JobStateEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_JobState.ValueType], builtins.type):  # noqa: F821
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    INVALID: _JobState.ValueType  # 0
    """Invalid job state"""
    PENDING: _JobState.ValueType  # 1
    """The job is pending"""
    RUNNING: _JobState.ValueType  # 2
    """The job is running"""
    COMPLETED: _JobState.ValueType  # 3
    """The job has completed"""
    FAILED: _JobState.ValueType  # 4
    """The job has failed"""
    FAILED_CLUSTER_INIT: _JobState.ValueType  # 5
    """Cluster init failed"""
    CLUSTER_INIT: _JobState.ValueType  # 6
    """Spark cluster initializing"""

class JobState(_JobState, metaclass=_JobStateEnumTypeWrapper): ...

INVALID: JobState.ValueType  # 0
"""Invalid job state"""
PENDING: JobState.ValueType  # 1
"""The job is pending"""
RUNNING: JobState.ValueType  # 2
"""The job is running"""
COMPLETED: JobState.ValueType  # 3
"""The job has completed"""
FAILED: JobState.ValueType  # 4
"""The job has failed"""
FAILED_CLUSTER_INIT: JobState.ValueType  # 5
"""Cluster init failed"""
CLUSTER_INIT: JobState.ValueType  # 6
"""Spark cluster initializing"""
global___JobState = JobState

class JobRecord(google.protobuf.message.Message):
    """Feature Store Batch Job Record.
    Represents a  batch job generated from a batch feature set
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    JOB_ID_FIELD_NUMBER: builtins.int
    FEATURE_SET_NAME_FIELD_NUMBER: builtins.int
    TRY_NUMBER_FIELD_NUMBER: builtins.int
    JOB_STATE_FIELD_NUMBER: builtins.int
    CREATION_TIME_FIELD_NUMBER: builtins.int
    START_TIME_FIELD_NUMBER: builtins.int
    END_TIME_FIELD_NUMBER: builtins.int
    INGESTION_WINDOW_FIELD_NUMBER: builtins.int
    INGESTION_MESSAGE_FIELD_NUMBER: builtins.int
    job_id: builtins.str
    """Unique id of the job"""
    feature_set_name: builtins.str
    """Batch feature set name the record resulted from"""
    try_number: builtins.int
    """Try count"""
    job_state: global___JobState.ValueType
    """State of the job - whether it's running, failed, pending, etc"""
    @property
    def creation_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Creation time"""
    @property
    def start_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Start time"""
    @property
    def end_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """End time"""
    @property
    def ingestion_window(self) -> global___IngestionWindow:
        """Ingestion window information"""
    ingestion_message: builtins.str
    """Ingestion message"""
    def __init__(
        self,
        *,
        job_id: builtins.str = ...,
        feature_set_name: builtins.str = ...,
        try_number: builtins.int = ...,
        job_state: global___JobState.ValueType = ...,
        creation_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        start_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        end_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        ingestion_window: global___IngestionWindow | None = ...,
        ingestion_message: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["creation_time", b"creation_time", "end_time", b"end_time", "ingestion_window", b"ingestion_window", "start_time", b"start_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["creation_time", b"creation_time", "end_time", b"end_time", "feature_set_name", b"feature_set_name", "ingestion_message", b"ingestion_message", "ingestion_window", b"ingestion_window", "job_id", b"job_id", "job_state", b"job_state", "start_time", b"start_time", "try_number", b"try_number"]) -> None: ...

global___JobRecord = JobRecord

class ElaborateJobRecord(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    JOB_RECORD_FIELD_NUMBER: builtins.int
    STATUS_MESSAGE_FIELD_NUMBER: builtins.int
    ERROR_TECHNICAL_DETAILS_FIELD_NUMBER: builtins.int
    @property
    def job_record(self) -> global___JobRecord:
        """Job record with persisted job info"""
    status_message: builtins.str
    """User friendly message describing the jobs' status"""
    error_technical_details: builtins.str
    """Error technical details"""
    def __init__(
        self,
        *,
        job_record: global___JobRecord | None = ...,
        status_message: builtins.str = ...,
        error_technical_details: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["job_record", b"job_record"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["error_technical_details", b"error_technical_details", "job_record", b"job_record", "status_message", b"status_message"]) -> None: ...

global___ElaborateJobRecord = ElaborateJobRecord

class IngestionWindow(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INGESTED_DATA_START_TIME_FIELD_NUMBER: builtins.int
    INGESTED_DATA_END_TIME_FIELD_NUMBER: builtins.int
    INGESTED_DATA_UPDATED_ROWS_FIELD_NUMBER: builtins.int
    BATCH_EXECUTION_TIME_FIELD_NUMBER: builtins.int
    @property
    def ingested_data_start_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Ingested data window start time"""
    @property
    def ingested_data_end_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Ingested data window end time"""
    ingested_data_updated_rows: builtins.int
    """Ingested data number of updated rows"""
    @property
    def batch_execution_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Ingested data batch execution date"""
    def __init__(
        self,
        *,
        ingested_data_start_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        ingested_data_end_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        ingested_data_updated_rows: builtins.int = ...,
        batch_execution_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["batch_execution_time", b"batch_execution_time", "ingested_data_end_time", b"ingested_data_end_time", "ingested_data_start_time", b"ingested_data_start_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["batch_execution_time", b"batch_execution_time", "ingested_data_end_time", b"ingested_data_end_time", "ingested_data_start_time", b"ingested_data_start_time", "ingested_data_updated_rows", b"ingested_data_updated_rows"]) -> None: ...

global___IngestionWindow = IngestionWindow
