"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.message
import qwak.deployment.deployment_pb2
import sys

if sys.version_info >= (3, 8):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class DeployModelRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class EnvironmentToDeploymentEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> qwak.deployment.deployment_pb2.EnvironmentDeploymentMessage: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: qwak.deployment.deployment_pb2.EnvironmentDeploymentMessage | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    MODEL_ID_FIELD_NUMBER: builtins.int
    BRANCH_ID_FIELD_NUMBER: builtins.int
    BUILD_ID_FIELD_NUMBER: builtins.int
    HOSTING_SERVICE_FIELD_NUMBER: builtins.int
    ENVIRONMENT_TO_DEPLOYMENT_FIELD_NUMBER: builtins.int
    model_id: builtins.str
    """Model named ID, which will be used as a routing key for the model"""
    branch_id: builtins.str
    """Branch ID to deploy the model under"""
    build_id: builtins.str
    """Build ID (which must be successful) to deploy"""
    @property
    def hosting_service(self) -> qwak.deployment.deployment_pb2.HostingService:
        """Downstream hosting service that will serve the Qwak model"""
    @property
    def environment_to_deployment(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, qwak.deployment.deployment_pb2.EnvironmentDeploymentMessage]:
        """Environment ids to their deployment request mapping"""
    def __init__(
        self,
        *,
        model_id: builtins.str = ...,
        branch_id: builtins.str = ...,
        build_id: builtins.str = ...,
        hosting_service: qwak.deployment.deployment_pb2.HostingService | None = ...,
        environment_to_deployment: collections.abc.Mapping[builtins.str, qwak.deployment.deployment_pb2.EnvironmentDeploymentMessage] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["hosting_service", b"hosting_service"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["branch_id", b"branch_id", "build_id", b"build_id", "environment_to_deployment", b"environment_to_deployment", "hosting_service", b"hosting_service", "model_id", b"model_id"]) -> None: ...

global___DeployModelRequest = DeployModelRequest

class DeployModelResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class EnvironmentToDeploymentResultEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> qwak.deployment.deployment_pb2.EnvironmentDeploymentResultMessage: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: qwak.deployment.deployment_pb2.EnvironmentDeploymentResultMessage | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    DEPLOYMENT_NAMED_ID_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    INFO_FIELD_NUMBER: builtins.int
    ENVIRONMENT_TO_DEPLOYMENT_RESULT_FIELD_NUMBER: builtins.int
    deployment_named_id: builtins.str
    """ID of deployment - in order to check up on status changes"""
    status: qwak.deployment.deployment_pb2.ModelDeploymentStatus.ValueType
    """Status of deployment"""
    info: builtins.str
    """Additional info on the deployment"""
    @property
    def environment_to_deployment_result(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, qwak.deployment.deployment_pb2.EnvironmentDeploymentResultMessage]:
        """Environment ids to their deployment result mapping"""
    def __init__(
        self,
        *,
        deployment_named_id: builtins.str = ...,
        status: qwak.deployment.deployment_pb2.ModelDeploymentStatus.ValueType = ...,
        info: builtins.str = ...,
        environment_to_deployment_result: collections.abc.Mapping[builtins.str, qwak.deployment.deployment_pb2.EnvironmentDeploymentResultMessage] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["deployment_named_id", b"deployment_named_id", "environment_to_deployment_result", b"environment_to_deployment_result", "info", b"info", "status", b"status"]) -> None: ...

global___DeployModelResponse = DeployModelResponse

class UndeployModelRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class EnvironmentToUndeploymentEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> qwak.deployment.deployment_pb2.EnvironmentUndeploymentMessage: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: qwak.deployment.deployment_pb2.EnvironmentUndeploymentMessage | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    MODEL_ID_FIELD_NUMBER: builtins.int
    BRANCH_ID_FIELD_NUMBER: builtins.int
    HOSTING_SERVICE_TYPE_FIELD_NUMBER: builtins.int
    TRAFFIC_CONFIG_FIELD_NUMBER: builtins.int
    VARIATION_NAME_FIELD_NUMBER: builtins.int
    ENVIRONMENT_TO_UNDEPLOYMENT_FIELD_NUMBER: builtins.int
    MODEL_UUID_FIELD_NUMBER: builtins.int
    model_id: builtins.str
    """Model named ID to undeploy"""
    branch_id: builtins.str
    """Branch ID to undeploy from"""
    hosting_service_type: qwak.deployment.deployment_pb2.DeploymentHostingServiceType.ValueType
    """The Hosting service to undeploy from"""
    @property
    def traffic_config(self) -> qwak.deployment.deployment_pb2.TrafficConfig:
        """Traffic Config"""
    variation_name: builtins.str
    """Deployment variation name"""
    @property
    def environment_to_undeployment(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, qwak.deployment.deployment_pb2.EnvironmentUndeploymentMessage]:
        """Environment ids to their undeployment request mapping"""
    model_uuid: builtins.str
    """Model UUID to undeploy"""
    def __init__(
        self,
        *,
        model_id: builtins.str = ...,
        branch_id: builtins.str = ...,
        hosting_service_type: qwak.deployment.deployment_pb2.DeploymentHostingServiceType.ValueType = ...,
        traffic_config: qwak.deployment.deployment_pb2.TrafficConfig | None = ...,
        variation_name: builtins.str = ...,
        environment_to_undeployment: collections.abc.Mapping[builtins.str, qwak.deployment.deployment_pb2.EnvironmentUndeploymentMessage] | None = ...,
        model_uuid: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["traffic_config", b"traffic_config"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["branch_id", b"branch_id", "environment_to_undeployment", b"environment_to_undeployment", "hosting_service_type", b"hosting_service_type", "model_id", b"model_id", "model_uuid", b"model_uuid", "traffic_config", b"traffic_config", "variation_name", b"variation_name"]) -> None: ...

global___UndeployModelRequest = UndeployModelRequest

class UndeployModelResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class EnvironmentToUndeploymentResultEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> qwak.deployment.deployment_pb2.EnvironmentUndeploymentResultMessage: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: qwak.deployment.deployment_pb2.EnvironmentUndeploymentResultMessage | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    STATUS_FIELD_NUMBER: builtins.int
    INFO_FIELD_NUMBER: builtins.int
    ENVIRONMENT_TO_UNDEPLOYMENT_RESULT_FIELD_NUMBER: builtins.int
    status: qwak.deployment.deployment_pb2.ModelDeploymentStatus.ValueType
    """Status of un-deployment"""
    info: builtins.str
    @property
    def environment_to_undeployment_result(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, qwak.deployment.deployment_pb2.EnvironmentUndeploymentResultMessage]:
        """Environment ids to their undeployment result mapping"""
    def __init__(
        self,
        *,
        status: qwak.deployment.deployment_pb2.ModelDeploymentStatus.ValueType = ...,
        info: builtins.str = ...,
        environment_to_undeployment_result: collections.abc.Mapping[builtins.str, qwak.deployment.deployment_pb2.EnvironmentUndeploymentResultMessage] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["environment_to_undeployment_result", b"environment_to_undeployment_result", "info", b"info", "status", b"status"]) -> None: ...

global___UndeployModelResponse = UndeployModelResponse

class GetDeploymentRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DEPLOYMENT_ID_FIELD_NUMBER: builtins.int
    deployment_id: builtins.str
    """The deployment id to get"""
    def __init__(
        self,
        *,
        deployment_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["deployment_id", b"deployment_id"]) -> None: ...

global___GetDeploymentRequest = GetDeploymentRequest

class GetDeploymentResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DEPLOYMENTS_DETAILS_FIELD_NUMBER: builtins.int
    DEPLOYMENT_PHASES_DETAILS_FIELD_NUMBER: builtins.int
    @property
    def deployments_details(self) -> qwak.deployment.deployment_pb2.DeploymentDetails:
        """The Deployment details"""
    @property
    def deployment_phases_details(self) -> qwak.deployment.deployment_pb2.DeploymentPhasesDetails:
        """The deployment phase"""
    def __init__(
        self,
        *,
        deployments_details: qwak.deployment.deployment_pb2.DeploymentDetails | None = ...,
        deployment_phases_details: qwak.deployment.deployment_pb2.DeploymentPhasesDetails | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["deployment_phases_details", b"deployment_phases_details", "deployments_details", b"deployments_details"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["deployment_phases_details", b"deployment_phases_details", "deployments_details", b"deployments_details"]) -> None: ...

global___GetDeploymentResponse = GetDeploymentResponse

class GetDeploymentStatusRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DEPLOYMENT_NAMED_ID_FIELD_NUMBER: builtins.int
    HOSTING_SERVICE_TYPE_FIELD_NUMBER: builtins.int
    deployment_named_id: builtins.str
    """ID of deployment to check up on"""
    hosting_service_type: qwak.deployment.deployment_pb2.DeploymentHostingServiceType.ValueType
    """The Hosting service to get status from"""
    def __init__(
        self,
        *,
        deployment_named_id: builtins.str = ...,
        hosting_service_type: qwak.deployment.deployment_pb2.DeploymentHostingServiceType.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["deployment_named_id", b"deployment_named_id", "hosting_service_type", b"hosting_service_type"]) -> None: ...

global___GetDeploymentStatusRequest = GetDeploymentStatusRequest

class GetDeploymentStatusResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STATUS_FIELD_NUMBER: builtins.int
    status: qwak.deployment.deployment_pb2.ModelDeploymentStatus.ValueType
    """Current status of deployment"""
    def __init__(
        self,
        *,
        status: qwak.deployment.deployment_pb2.ModelDeploymentStatus.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["status", b"status"]) -> None: ...

global___GetDeploymentStatusResponse = GetDeploymentStatusResponse

class UpdateDeploymentRuntimeSettingsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class EnvironmentToRuntimeDeploymentSettingsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> qwak.deployment.deployment_pb2.EnvironmentRuntimeDeploymentSettingsMessage: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: qwak.deployment.deployment_pb2.EnvironmentRuntimeDeploymentSettingsMessage | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    MODEL_ID_FIELD_NUMBER: builtins.int
    BRANCH_ID_FIELD_NUMBER: builtins.int
    DEPLOYMENT_SETTINGS_FIELD_NUMBER: builtins.int
    VARIATION_NAME_FIELD_NUMBER: builtins.int
    ENVIRONMENT_TO_RUNTIME_DEPLOYMENT_SETTINGS_FIELD_NUMBER: builtins.int
    MODEL_UUID_FIELD_NUMBER: builtins.int
    model_id: builtins.str
    """Model named ID, which will be used as a routing key for the model"""
    branch_id: builtins.str
    """Branch ID which the model was deployed under"""
    @property
    def deployment_settings(self) -> qwak.deployment.deployment_pb2.RuntimeDeploymentSettings:
        """The new  deployment settings"""
    variation_name: builtins.str
    """Variation name"""
    @property
    def environment_to_runtime_deployment_settings(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, qwak.deployment.deployment_pb2.EnvironmentRuntimeDeploymentSettingsMessage]:
        """Environment ids to their update runtime deployment request mapping"""
    model_uuid: builtins.str
    """Model UUID."""
    def __init__(
        self,
        *,
        model_id: builtins.str = ...,
        branch_id: builtins.str = ...,
        deployment_settings: qwak.deployment.deployment_pb2.RuntimeDeploymentSettings | None = ...,
        variation_name: builtins.str = ...,
        environment_to_runtime_deployment_settings: collections.abc.Mapping[builtins.str, qwak.deployment.deployment_pb2.EnvironmentRuntimeDeploymentSettingsMessage] | None = ...,
        model_uuid: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["deployment_settings", b"deployment_settings"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["branch_id", b"branch_id", "deployment_settings", b"deployment_settings", "environment_to_runtime_deployment_settings", b"environment_to_runtime_deployment_settings", "model_id", b"model_id", "model_uuid", b"model_uuid", "variation_name", b"variation_name"]) -> None: ...

global___UpdateDeploymentRuntimeSettingsRequest = UpdateDeploymentRuntimeSettingsRequest

class UpdateDeploymentRuntimeSettingsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class EnvironmentToRuntimeDeploymentSettingsResponseEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> qwak.deployment.deployment_pb2.EnvironmentRuntimeDeploymentSettingsResultMessage: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: qwak.deployment.deployment_pb2.EnvironmentRuntimeDeploymentSettingsResultMessage | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    ENVIRONMENT_TO_RUNTIME_DEPLOYMENT_SETTINGS_RESPONSE_FIELD_NUMBER: builtins.int
    @property
    def environment_to_runtime_deployment_settings_response(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, qwak.deployment.deployment_pb2.EnvironmentRuntimeDeploymentSettingsResultMessage]:
        """Environment ids to their update runtime deployment response mapping"""
    def __init__(
        self,
        *,
        environment_to_runtime_deployment_settings_response: collections.abc.Mapping[builtins.str, qwak.deployment.deployment_pb2.EnvironmentRuntimeDeploymentSettingsResultMessage] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["environment_to_runtime_deployment_settings_response", b"environment_to_runtime_deployment_settings_response"]) -> None: ...

global___UpdateDeploymentRuntimeSettingsResponse = UpdateDeploymentRuntimeSettingsResponse

class GetDeploymentDetailsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODEL_ID_FIELD_NUMBER: builtins.int
    BRANCH_ID_FIELD_NUMBER: builtins.int
    MODEL_UUID_FIELD_NUMBER: builtins.int
    model_id: builtins.str
    """The model ID"""
    branch_id: builtins.str
    """The branch ID"""
    model_uuid: builtins.str
    """The model UUID"""
    def __init__(
        self,
        *,
        model_id: builtins.str = ...,
        branch_id: builtins.str = ...,
        model_uuid: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["branch_id", b"branch_id", "model_id", b"model_id", "model_uuid", b"model_uuid"]) -> None: ...

global___GetDeploymentDetailsRequest = GetDeploymentDetailsRequest

class GetDeploymentDetailsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class EnvironmentToDeploymentDetailsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> qwak.deployment.deployment_pb2.EnvironmentDeploymentDetailsMessage: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: qwak.deployment.deployment_pb2.EnvironmentDeploymentDetailsMessage | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    class BuildToEnvironmentDeploymentStatusEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> qwak.deployment.deployment_pb2.BuildDeploymentEnvironmentStatus: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: qwak.deployment.deployment_pb2.BuildDeploymentEnvironmentStatus | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    CURRENT_DEPLOYMENT_DETAILS_FIELD_NUMBER: builtins.int
    LAST_DEPLOYMENT_BRIEF_FIELD_NUMBER: builtins.int
    CURRENT_DEPLOYMENTS_DETAILS_FIELD_NUMBER: builtins.int
    ENVIRONMENT_TO_DEPLOYMENT_DETAILS_FIELD_NUMBER: builtins.int
    MULTI_ENV_SUPPORT_FIELD_NUMBER: builtins.int
    BUILD_TO_ENVIRONMENT_DEPLOYMENT_STATUS_FIELD_NUMBER: builtins.int
    @property
    def current_deployment_details(self) -> qwak.deployment.deployment_pb2.DeploymentDetails:
        """The current active deployment details."""
    @property
    def last_deployment_brief(self) -> qwak.deployment.deployment_pb2.DeploymentBrief:
        """The last finalize deployment."""
    @property
    def current_deployments_details(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[qwak.deployment.deployment_pb2.DeploymentDetails]:
        """The current active deployments details"""
    @property
    def environment_to_deployment_details(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, qwak.deployment.deployment_pb2.EnvironmentDeploymentDetailsMessage]:
        """Environment ids to their deployment details mapping"""
    multi_env_support: builtins.bool
    """Flag whether multi env is supported (only for the transition phase)"""
    @property
    def build_to_environment_deployment_status(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, qwak.deployment.deployment_pb2.BuildDeploymentEnvironmentStatus]:
        """Last deployment status by build"""
    def __init__(
        self,
        *,
        current_deployment_details: qwak.deployment.deployment_pb2.DeploymentDetails | None = ...,
        last_deployment_brief: qwak.deployment.deployment_pb2.DeploymentBrief | None = ...,
        current_deployments_details: collections.abc.Iterable[qwak.deployment.deployment_pb2.DeploymentDetails] | None = ...,
        environment_to_deployment_details: collections.abc.Mapping[builtins.str, qwak.deployment.deployment_pb2.EnvironmentDeploymentDetailsMessage] | None = ...,
        multi_env_support: builtins.bool = ...,
        build_to_environment_deployment_status: collections.abc.Mapping[builtins.str, qwak.deployment.deployment_pb2.BuildDeploymentEnvironmentStatus] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["current_deployment_details", b"current_deployment_details", "last_deployment_brief", b"last_deployment_brief"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["build_to_environment_deployment_status", b"build_to_environment_deployment_status", "current_deployment_details", b"current_deployment_details", "current_deployments_details", b"current_deployments_details", "environment_to_deployment_details", b"environment_to_deployment_details", "last_deployment_brief", b"last_deployment_brief", "multi_env_support", b"multi_env_support"]) -> None: ...

global___GetDeploymentDetailsResponse = GetDeploymentDetailsResponse

class GetDeploymentHistoryRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    BRANCH_ID_FIELD_NUMBER: builtins.int
    MODEL_UUID_FIELD_NUMBER: builtins.int
    BUILD_ID_FIELD_NUMBER: builtins.int
    branch_id: builtins.str
    """The branch ID"""
    model_uuid: builtins.str
    """The Model UUID"""
    build_id: builtins.str
    """The Build ID"""
    def __init__(
        self,
        *,
        branch_id: builtins.str = ...,
        model_uuid: builtins.str = ...,
        build_id: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["build_id", b"build_id", "filter_by", b"filter_by", "model_uuid", b"model_uuid"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["branch_id", b"branch_id", "build_id", b"build_id", "filter_by", b"filter_by", "model_uuid", b"model_uuid"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["filter_by", b"filter_by"]) -> typing_extensions.Literal["model_uuid", "build_id"] | None: ...

global___GetDeploymentHistoryRequest = GetDeploymentHistoryRequest

class GetDeploymentHistoryResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class EnvironmentToDeploymentHistoryEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> qwak.deployment.deployment_pb2.EnvironmentDeploymentHistoryMessage: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: qwak.deployment.deployment_pb2.EnvironmentDeploymentHistoryMessage | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    DEPLOYMENTS_FIELD_NUMBER: builtins.int
    ENVIRONMENT_TO_DEPLOYMENT_HISTORY_FIELD_NUMBER: builtins.int
    @property
    def deployments(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[qwak.deployment.deployment_pb2.DeploymentBrief]:
        """All finalized deployments for specific branch"""
    @property
    def environment_to_deployment_history(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, qwak.deployment.deployment_pb2.EnvironmentDeploymentHistoryMessage]:
        """Environment ids to their deployment history mapping"""
    def __init__(
        self,
        *,
        deployments: collections.abc.Iterable[qwak.deployment.deployment_pb2.DeploymentBrief] | None = ...,
        environment_to_deployment_history: collections.abc.Mapping[builtins.str, qwak.deployment.deployment_pb2.EnvironmentDeploymentHistoryMessage] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["deployments", b"deployments", "environment_to_deployment_history", b"environment_to_deployment_history"]) -> None: ...

global___GetDeploymentHistoryResponse = GetDeploymentHistoryResponse

class PushEnvironmentDeploymentStateRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ENVIRONMENT_ID_FIELD_NUMBER: builtins.int
    DEPLOYMENT_STATE_FIELD_NUMBER: builtins.int
    environment_id: builtins.str
    @property
    def deployment_state(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[qwak.deployment.deployment_pb2.KubernetesModelDeploymentState]: ...
    def __init__(
        self,
        *,
        environment_id: builtins.str = ...,
        deployment_state: collections.abc.Iterable[qwak.deployment.deployment_pb2.KubernetesModelDeploymentState] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["deployment_state", b"deployment_state", "environment_id", b"environment_id"]) -> None: ...

global___PushEnvironmentDeploymentStateRequest = PushEnvironmentDeploymentStateRequest

class PushEnvironmentDeploymentStateResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___PushEnvironmentDeploymentStateResponse = PushEnvironmentDeploymentStateResponse

class ApplyModelTrafficRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODEL_ID_FIELD_NUMBER: builtins.int
    VARIATIONS_FIELD_NUMBER: builtins.int
    ENVIRONMENT_IDS_FIELD_NUMBER: builtins.int
    model_id: builtins.str
    """The model Id"""
    @property
    def variations(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[qwak.deployment.deployment_pb2.Variation]:
        """The variations config"""
    @property
    def environment_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Environment ids to apply traffic on"""
    def __init__(
        self,
        *,
        model_id: builtins.str = ...,
        variations: collections.abc.Iterable[qwak.deployment.deployment_pb2.Variation] | None = ...,
        environment_ids: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["environment_ids", b"environment_ids", "model_id", b"model_id", "variations", b"variations"]) -> None: ...

global___ApplyModelTrafficRequest = ApplyModelTrafficRequest

class ApplyModelTrafficResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class EnvironmentToApplyModelTrafficResponseEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> qwak.deployment.deployment_pb2.EnvironmentApplyModelTrafficResponse: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: qwak.deployment.deployment_pb2.EnvironmentApplyModelTrafficResponse | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    ENVIRONMENT_TO_APPLY_MODEL_TRAFFIC_RESPONSE_FIELD_NUMBER: builtins.int
    @property
    def environment_to_apply_model_traffic_response(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, qwak.deployment.deployment_pb2.EnvironmentApplyModelTrafficResponse]:
        """Environment ids to their apply traffic response mapping"""
    def __init__(
        self,
        *,
        environment_to_apply_model_traffic_response: collections.abc.Mapping[builtins.str, qwak.deployment.deployment_pb2.EnvironmentApplyModelTrafficResponse] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["environment_to_apply_model_traffic_response", b"environment_to_apply_model_traffic_response"]) -> None: ...

global___ApplyModelTrafficResponse = ApplyModelTrafficResponse

class GetModelTrafficRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODEL_ID_FIELD_NUMBER: builtins.int
    model_id: builtins.str
    """The model Id"""
    def __init__(
        self,
        *,
        model_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["model_id", b"model_id"]) -> None: ...

global___GetModelTrafficRequest = GetModelTrafficRequest

class GetModelTrafficResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class EnvironmentToModelTrafficEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> qwak.deployment.deployment_pb2.EnvironmentTrafficMessage: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: qwak.deployment.deployment_pb2.EnvironmentTrafficMessage | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    VARIATIONS_FIELD_NUMBER: builtins.int
    ENVIRONMENT_TO_MODEL_TRAFFIC_FIELD_NUMBER: builtins.int
    MULTI_ENV_SUPPORT_FIELD_NUMBER: builtins.int
    @property
    def variations(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[qwak.deployment.deployment_pb2.Variation]:
        """The variations config"""
    @property
    def environment_to_model_traffic(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, qwak.deployment.deployment_pb2.EnvironmentTrafficMessage]:
        """Environment ids to their traffic"""
    multi_env_support: builtins.bool
    """Flag whether multi env is supported (only for the transition phase)"""
    def __init__(
        self,
        *,
        variations: collections.abc.Iterable[qwak.deployment.deployment_pb2.Variation] | None = ...,
        environment_to_model_traffic: collections.abc.Mapping[builtins.str, qwak.deployment.deployment_pb2.EnvironmentTrafficMessage] | None = ...,
        multi_env_support: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["environment_to_model_traffic", b"environment_to_model_traffic", "multi_env_support", b"multi_env_support", "variations", b"variations"]) -> None: ...

global___GetModelTrafficResponse = GetModelTrafficResponse

class IsBuildDeployedRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    BUILD_UUIDS_FIELD_NUMBER: builtins.int
    @property
    def build_uuids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
    def __init__(
        self,
        *,
        build_uuids: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["build_uuids", b"build_uuids"]) -> None: ...

global___IsBuildDeployedRequest = IsBuildDeployedRequest

class IsBuildDeployedResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DEPLOYMENTS_FIELD_NUMBER: builtins.int
    @property
    def deployments(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[qwak.deployment.deployment_pb2.BuildDeploymentStatus]: ...
    def __init__(
        self,
        *,
        deployments: collections.abc.Iterable[qwak.deployment.deployment_pb2.BuildDeploymentStatus] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["deployments", b"deployments"]) -> None: ...

global___IsBuildDeployedResponse = IsBuildDeployedResponse

class IsBuildInUseRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    BUILD_UUIDS_FIELD_NUMBER: builtins.int
    @property
    def build_uuids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
    def __init__(
        self,
        *,
        build_uuids: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["build_uuids", b"build_uuids"]) -> None: ...

global___IsBuildInUseRequest = IsBuildInUseRequest

class IsBuildInUseResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DEPLOYMENTS_FIELD_NUMBER: builtins.int
    @property
    def deployments(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[qwak.deployment.deployment_pb2.BuildDeploymentStatus]: ...
    def __init__(
        self,
        *,
        deployments: collections.abc.Iterable[qwak.deployment.deployment_pb2.BuildDeploymentStatus] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["deployments", b"deployments"]) -> None: ...

global___IsBuildInUseResponse = IsBuildInUseResponse

class CancelDeploymentsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DEPLOYMENT_IDS_FIELD_NUMBER: builtins.int
    MODEL_ID_FIELD_NUMBER: builtins.int
    @property
    def deployment_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """The deployment ids"""
    model_id: builtins.str
    """The model to cancel deployments from"""
    def __init__(
        self,
        *,
        deployment_ids: collections.abc.Iterable[builtins.str] | None = ...,
        model_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["deployment_ids", b"deployment_ids", "model_id", b"model_id"]) -> None: ...

global___CancelDeploymentsRequest = CancelDeploymentsRequest

class CancelDeploymentsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class CancelRequestStatusEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> qwak.deployment.deployment_pb2.CancelDeploymentRequestStatus: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: qwak.deployment.deployment_pb2.CancelDeploymentRequestStatus | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    CANCEL_REQUEST_STATUS_FIELD_NUMBER: builtins.int
    @property
    def cancel_request_status(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, qwak.deployment.deployment_pb2.CancelDeploymentRequestStatus]:
        """The status of the cancel request"""
    def __init__(
        self,
        *,
        cancel_request_status: collections.abc.Mapping[builtins.str, qwak.deployment.deployment_pb2.CancelDeploymentRequestStatus] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["cancel_request_status", b"cancel_request_status"]) -> None: ...

global___CancelDeploymentsResponse = CancelDeploymentsResponse

class ListLiveModelsDeploymentsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODEL_UUID_FIELD_NUMBER: builtins.int
    model_uuid: builtins.str
    def __init__(
        self,
        *,
        model_uuid: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["model_uuid", b"model_uuid"]) -> None: ...

global___ListLiveModelsDeploymentsRequest = ListLiveModelsDeploymentsRequest

class ListLiveModelsDeploymentsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DEPLOYMENTS_FIELD_NUMBER: builtins.int
    @property
    def deployments(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[qwak.deployment.deployment_pb2.DeploymentDetails]: ...
    def __init__(
        self,
        *,
        deployments: collections.abc.Iterable[qwak.deployment.deployment_pb2.DeploymentDetails] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["deployments", b"deployments"]) -> None: ...

global___ListLiveModelsDeploymentsResponse = ListLiveModelsDeploymentsResponse
