"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import qwak.builds.build_pb2
import qwak.deployment.deployment_pb2
import qwak.fitness_service.status_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _BuildStatus:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _BuildStatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_BuildStatus.ValueType], builtins.type):  # noqa: F821
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    INVALID: _BuildStatus.ValueType  # 0
    """An invalid state build status, the default if unset"""
    IN_PROGRESS: _BuildStatus.ValueType  # 1
    """Build is in progress"""
    SUCCESSFUL: _BuildStatus.ValueType  # 2
    """Build is successful"""
    FAILED: _BuildStatus.ValueType  # 3
    """Build failed"""
    REMOTE_BUILD_INITIALIZING: _BuildStatus.ValueType  # 4
    """Remote build is initializing"""
    REMOTE_BUILD_CANCELLED: _BuildStatus.ValueType  # 5
    """Remote build status is cancelled"""
    REMOTE_BUILD_TIMED_OUT: _BuildStatus.ValueType  # 6
    """Remote build status is timed out"""
    REMOTE_BUILD_UNKNOWN: _BuildStatus.ValueType  # 7
    """Remote build is unknown"""
    SYNCING_ENVIRONMENTS: _BuildStatus.ValueType  # 8
    """Build image is syncing between environments"""
    FINISHED_SYNCING: _BuildStatus.ValueType  # 9
    """Build artifact is synced and ready"""

class BuildStatus(_BuildStatus, metaclass=_BuildStatusEnumTypeWrapper): ...

INVALID: BuildStatus.ValueType  # 0
"""An invalid state build status, the default if unset"""
IN_PROGRESS: BuildStatus.ValueType  # 1
"""Build is in progress"""
SUCCESSFUL: BuildStatus.ValueType  # 2
"""Build is successful"""
FAILED: BuildStatus.ValueType  # 3
"""Build failed"""
REMOTE_BUILD_INITIALIZING: BuildStatus.ValueType  # 4
"""Remote build is initializing"""
REMOTE_BUILD_CANCELLED: BuildStatus.ValueType  # 5
"""Remote build status is cancelled"""
REMOTE_BUILD_TIMED_OUT: BuildStatus.ValueType  # 6
"""Remote build status is timed out"""
REMOTE_BUILD_UNKNOWN: BuildStatus.ValueType  # 7
"""Remote build is unknown"""
SYNCING_ENVIRONMENTS: BuildStatus.ValueType  # 8
"""Build image is syncing between environments"""
FINISHED_SYNCING: BuildStatus.ValueType  # 9
"""Build artifact is synced and ready"""
global___BuildStatus = BuildStatus

class Build(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    BUILD_SPEC_FIELD_NUMBER: builtins.int
    BUILD_STATUS_FIELD_NUMBER: builtins.int
    MODEL_SCHEMA_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    CREATED_BY_FIELD_NUMBER: builtins.int
    LAST_MODIFIED_AT_FIELD_NUMBER: builtins.int
    LAST_MODIFIED_BY_FIELD_NUMBER: builtins.int
    DEPLOYMENT_BUILD_STATUS_FIELD_NUMBER: builtins.int
    HOSTING_SERVICE_TYPE_FIELD_NUMBER: builtins.int
    END_DATE_FIELD_NUMBER: builtins.int
    AVAILABLE_ENVIRONMENTS_FIELD_NUMBER: builtins.int
    DEPLOYED_ENVIRONMENTS_FIELD_NUMBER: builtins.int
    PODSTATUS_FIELD_NUMBER: builtins.int
    IMAGE_NAME_TAG_FIELD_NUMBER: builtins.int
    BUILD_INITIATOR_FIELD_NUMBER: builtins.int
    @property
    def build_spec(self) -> global___BuildSpec:
        """Build specifications, needed to register a build and contains base info of a build"""
    build_status: global___BuildStatus.ValueType
    """Build status - in progress, successful or failed"""
    @property
    def model_schema(self) -> global___ModelSchema:
        """Current build model schema (Model interface)"""
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Created at timestamp"""
    created_by: builtins.str
    """Created by"""
    @property
    def last_modified_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Last modified at timestamp"""
    last_modified_by: builtins.str
    """Last modified by"""
    deployment_build_status: qwak.deployment.deployment_pb2.ModelDeploymentStatus.ValueType
    """The deployment build status"""
    hosting_service_type: qwak.deployment.deployment_pb2.DeploymentHostingServiceType.ValueType
    """The Hosting Service"""
    @property
    def end_date(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """End date of build"""
    @property
    def available_environments(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """The environments the build is available on"""
    @property
    def deployed_environments(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """The environments the build is currently deployed on"""
    @property
    def podStatus(self) -> qwak.fitness_service.status_pb2.PodStatus:
        """Pod status"""
    image_name_tag: builtins.str
    """The build image name and tag"""
    @property
    def build_initiator(self) -> qwak.builds.build_pb2.BuildInitiator:
        """Data about the initiator of the build"""
    def __init__(
        self,
        *,
        build_spec: global___BuildSpec | None = ...,
        build_status: global___BuildStatus.ValueType = ...,
        model_schema: global___ModelSchema | None = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        created_by: builtins.str = ...,
        last_modified_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        last_modified_by: builtins.str = ...,
        deployment_build_status: qwak.deployment.deployment_pb2.ModelDeploymentStatus.ValueType = ...,
        hosting_service_type: qwak.deployment.deployment_pb2.DeploymentHostingServiceType.ValueType = ...,
        end_date: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        available_environments: collections.abc.Iterable[builtins.str] | None = ...,
        deployed_environments: collections.abc.Iterable[builtins.str] | None = ...,
        podStatus: qwak.fitness_service.status_pb2.PodStatus | None = ...,
        image_name_tag: builtins.str = ...,
        build_initiator: qwak.builds.build_pb2.BuildInitiator | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["build_initiator", b"build_initiator", "build_spec", b"build_spec", "created_at", b"created_at", "end_date", b"end_date", "last_modified_at", b"last_modified_at", "model_schema", b"model_schema", "podStatus", b"podStatus"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["available_environments", b"available_environments", "build_initiator", b"build_initiator", "build_spec", b"build_spec", "build_status", b"build_status", "created_at", b"created_at", "created_by", b"created_by", "deployed_environments", b"deployed_environments", "deployment_build_status", b"deployment_build_status", "end_date", b"end_date", "hosting_service_type", b"hosting_service_type", "image_name_tag", b"image_name_tag", "last_modified_at", b"last_modified_at", "last_modified_by", b"last_modified_by", "model_schema", b"model_schema", "podStatus", b"podStatus"]) -> None: ...

global___Build = Build

class BuildSpec(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    BUILD_ID_FIELD_NUMBER: builtins.int
    COMMIT_ID_FIELD_NUMBER: builtins.int
    MODEL_ID_FIELD_NUMBER: builtins.int
    BRANCH_NAME_FIELD_NUMBER: builtins.int
    BRANCH_ID_FIELD_NUMBER: builtins.int
    TAGS_FIELD_NUMBER: builtins.int
    EXPERIMENT_TRACKING_VALUES_FIELD_NUMBER: builtins.int
    BUILD_CONFIGURATION_FIELD_NUMBER: builtins.int
    BUILD_CODE_PATH_FIELD_NUMBER: builtins.int
    BUILD_STEPS_FIELD_NUMBER: builtins.int
    ENVIRONMENT_ID_FIELD_NUMBER: builtins.int
    MODEL_UUID_FIELD_NUMBER: builtins.int
    SDK_VERSION_FIELD_NUMBER: builtins.int
    build_id: builtins.str
    """Build id"""
    commit_id: builtins.str
    """The git commit which the build was generated upon"""
    model_id: builtins.str
    """Model id"""
    branch_name: builtins.str
    """Branch name. When none provided - 'main' will be the selected branch"""
    branch_id: builtins.str
    """Branch Id"""
    @property
    def tags(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Build tags"""
    @property
    def experiment_tracking_values(self) -> global___ExperimentTrackingValues:
        """Experiment tracking values - metrics and params"""
    @property
    def build_configuration(self) -> global___BuildConfiguration:
        """Entire build configuration"""
    build_code_path: builtins.str
    """build data code path saved in s3"""
    @property
    def build_steps(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """The build steps the build will handle"""
    environment_id: builtins.str
    """The environment the build will be created on"""
    model_uuid: builtins.str
    sdk_version: builtins.str
    """The build SDK version"""
    def __init__(
        self,
        *,
        build_id: builtins.str = ...,
        commit_id: builtins.str = ...,
        model_id: builtins.str = ...,
        branch_name: builtins.str = ...,
        branch_id: builtins.str = ...,
        tags: collections.abc.Iterable[builtins.str] | None = ...,
        experiment_tracking_values: global___ExperimentTrackingValues | None = ...,
        build_configuration: global___BuildConfiguration | None = ...,
        build_code_path: builtins.str = ...,
        build_steps: collections.abc.Iterable[builtins.str] | None = ...,
        environment_id: builtins.str = ...,
        model_uuid: builtins.str = ...,
        sdk_version: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["build_configuration", b"build_configuration", "experiment_tracking_values", b"experiment_tracking_values"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["branch_id", b"branch_id", "branch_name", b"branch_name", "build_code_path", b"build_code_path", "build_configuration", b"build_configuration", "build_id", b"build_id", "build_steps", b"build_steps", "commit_id", b"commit_id", "environment_id", b"environment_id", "experiment_tracking_values", b"experiment_tracking_values", "model_id", b"model_id", "model_uuid", b"model_uuid", "sdk_version", b"sdk_version", "tags", b"tags"]) -> None: ...

global___BuildSpec = BuildSpec

class ModelSchema(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ENTITIES_FIELD_NUMBER: builtins.int
    FEATURES_FIELD_NUMBER: builtins.int
    PREDICTIONS_FIELD_NUMBER: builtins.int
    INFERENCE_OUTPUT_FIELD_NUMBER: builtins.int
    @property
    def entities(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Entity]:
        """list of model entities"""
    @property
    def features(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Feature]:
        """list of model features (Explicit / Batch / OnTheFly)"""
    @property
    def predictions(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Prediction]:
        """List of model predictions (Model output)"""
    @property
    def inference_output(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___InferenceOutput]:
        """List of model predictions (Model output)"""
    def __init__(
        self,
        *,
        entities: collections.abc.Iterable[global___Entity] | None = ...,
        features: collections.abc.Iterable[global___Feature] | None = ...,
        predictions: collections.abc.Iterable[global___Prediction] | None = ...,
        inference_output: collections.abc.Iterable[global___InferenceOutput] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["entities", b"entities", "features", b"features", "inference_output", b"inference_output", "predictions", b"predictions"]) -> None: ...

global___ModelSchema = ModelSchema

class Entity(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Entity name"""
    @property
    def type(self) -> global___ValueType:
        """Entity type"""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        type: global___ValueType | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["type", b"type"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name", "type", b"type"]) -> None: ...

global___Entity = Entity

class Feature(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    BATCH_FEATURE_FIELD_NUMBER: builtins.int
    EXPLICIT_FEATURE_FIELD_NUMBER: builtins.int
    ON_THE_FLY_FEATURE_FIELD_NUMBER: builtins.int
    STREAMING_FEATURE_FIELD_NUMBER: builtins.int
    REQUEST_INPUT_FIELD_NUMBER: builtins.int
    STREAMING_AGGREGATION_FEATURE_FIELD_NUMBER: builtins.int
    BATCH_FEATURE_V1_FIELD_NUMBER: builtins.int
    STREAMING_FEATURE_V1_FIELD_NUMBER: builtins.int
    @property
    def batch_feature(self) -> global___BatchFeature: ...
    @property
    def explicit_feature(self) -> global___ExplicitFeature: ...
    @property
    def on_the_fly_feature(self) -> global___OnTheFlyFeature: ...
    @property
    def streaming_feature(self) -> global___StreamingFeature: ...
    @property
    def request_input(self) -> global___RequestInput: ...
    @property
    def streaming_aggregation_feature(self) -> global___StreamingAggregationFeature: ...
    @property
    def batch_feature_v1(self) -> global___BatchFeatureV1: ...
    @property
    def streaming_feature_v1(self) -> global___StreamingFeatureV1: ...
    def __init__(
        self,
        *,
        batch_feature: global___BatchFeature | None = ...,
        explicit_feature: global___ExplicitFeature | None = ...,
        on_the_fly_feature: global___OnTheFlyFeature | None = ...,
        streaming_feature: global___StreamingFeature | None = ...,
        request_input: global___RequestInput | None = ...,
        streaming_aggregation_feature: global___StreamingAggregationFeature | None = ...,
        batch_feature_v1: global___BatchFeatureV1 | None = ...,
        streaming_feature_v1: global___StreamingFeatureV1 | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["batch_feature", b"batch_feature", "batch_feature_v1", b"batch_feature_v1", "explicit_feature", b"explicit_feature", "on_the_fly_feature", b"on_the_fly_feature", "request_input", b"request_input", "streaming_aggregation_feature", b"streaming_aggregation_feature", "streaming_feature", b"streaming_feature", "streaming_feature_v1", b"streaming_feature_v1", "type", b"type"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["batch_feature", b"batch_feature", "batch_feature_v1", b"batch_feature_v1", "explicit_feature", b"explicit_feature", "on_the_fly_feature", b"on_the_fly_feature", "request_input", b"request_input", "streaming_aggregation_feature", b"streaming_aggregation_feature", "streaming_feature", b"streaming_feature", "streaming_feature_v1", b"streaming_feature_v1", "type", b"type"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["type", b"type"]) -> typing_extensions.Literal["batch_feature", "explicit_feature", "on_the_fly_feature", "streaming_feature", "request_input", "streaming_aggregation_feature", "batch_feature_v1", "streaming_feature_v1"] | None: ...

global___Feature = Feature

class OnTheFlyFeature(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ENTITY_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    SOURCE_FEATURES_FIELD_NUMBER: builtins.int
    @property
    def entity(self) -> global___Entity:
        """Qwak feature_store entity"""
    name: builtins.str
    """Feature name"""
    @property
    def source_features(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___SourceFeature]:
        """The source feature on the fly build on"""
    def __init__(
        self,
        *,
        entity: global___Entity | None = ...,
        name: builtins.str = ...,
        source_features: collections.abc.Iterable[global___SourceFeature] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["entity", b"entity"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["entity", b"entity", "name", b"name", "source_features", b"source_features"]) -> None: ...

global___OnTheFlyFeature = OnTheFlyFeature

class BatchFeatureV1(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ENTITY_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    @property
    def entity(self) -> global___Entity:
        """Qwak feature_store entity"""
    name: builtins.str
    """Feature name"""
    def __init__(
        self,
        *,
        entity: global___Entity | None = ...,
        name: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["entity", b"entity"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["entity", b"entity", "name", b"name"]) -> None: ...

global___BatchFeatureV1 = BatchFeatureV1

class StreamingFeatureV1(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ENTITY_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    @property
    def entity(self) -> global___Entity:
        """Qwak feature_store entity"""
    name: builtins.str
    """Feature name"""
    def __init__(
        self,
        *,
        entity: global___Entity | None = ...,
        name: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["entity", b"entity"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["entity", b"entity", "name", b"name"]) -> None: ...

global___StreamingFeatureV1 = StreamingFeatureV1

class BatchFeature(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ENTITY_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    @property
    def entity(self) -> global___Entity:
        """Qwak feature_store entity"""
    name: builtins.str
    """Feature name"""
    def __init__(
        self,
        *,
        entity: global___Entity | None = ...,
        name: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["entity", b"entity"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["entity", b"entity", "name", b"name"]) -> None: ...

global___BatchFeature = BatchFeature

class StreamingFeature(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ENTITY_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    @property
    def entity(self) -> global___Entity:
        """Qwak feature_store entity"""
    name: builtins.str
    """Feature name"""
    def __init__(
        self,
        *,
        entity: global___Entity | None = ...,
        name: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["entity", b"entity"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["entity", b"entity", "name", b"name"]) -> None: ...

global___StreamingFeature = StreamingFeature

class StreamingAggregationFeature(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ENTITY_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    @property
    def entity(self) -> global___Entity:
        """Qwak feature_store entity"""
    name: builtins.str
    """Feature name"""
    def __init__(
        self,
        *,
        entity: global___Entity | None = ...,
        name: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["entity", b"entity"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["entity", b"entity", "name", b"name"]) -> None: ...

global___StreamingAggregationFeature = StreamingAggregationFeature

class ExplicitFeature(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Feature name"""
    @property
    def type(self) -> global___ValueType:
        """Feature type"""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        type: global___ValueType | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["type", b"type"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name", "type", b"type"]) -> None: ...

global___ExplicitFeature = ExplicitFeature

class RequestInput(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Feature name"""
    @property
    def type(self) -> global___ValueType:
        """Feature type"""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        type: global___ValueType | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["type", b"type"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name", "type", b"type"]) -> None: ...

global___RequestInput = RequestInput

class SourceFeature(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    EXPLICIT_FEATURE_FIELD_NUMBER: builtins.int
    REQUEST_INPUT_FIELD_NUMBER: builtins.int
    @property
    def explicit_feature(self) -> global___ExplicitFeature: ...
    @property
    def request_input(self) -> global___RequestInput: ...
    def __init__(
        self,
        *,
        explicit_feature: global___ExplicitFeature | None = ...,
        request_input: global___RequestInput | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["explicit_feature", b"explicit_feature", "request_input", b"request_input", "type", b"type"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["explicit_feature", b"explicit_feature", "request_input", b"request_input", "type", b"type"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["type", b"type"]) -> typing_extensions.Literal["explicit_feature", "request_input"] | None: ...

global___SourceFeature = SourceFeature

class Prediction(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Prediction name"""
    @property
    def type(self) -> global___ValueType:
        """Prediction type"""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        type: global___ValueType | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["type", b"type"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name", "type", b"type"]) -> None: ...

global___Prediction = Prediction

class InferenceOutput(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Prediction name"""
    @property
    def type(self) -> global___ValueType:
        """Prediction type"""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        type: global___ValueType | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["type", b"type"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name", "type", b"type"]) -> None: ...

global___InferenceOutput = InferenceOutput

class ValueType(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Types:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _TypesEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[ValueType._Types.ValueType], builtins.type):  # noqa: F821
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        INVALID: ValueType._Types.ValueType  # 0
        BYTES: ValueType._Types.ValueType  # 1
        STRING: ValueType._Types.ValueType  # 2
        INT32: ValueType._Types.ValueType  # 3
        INT64: ValueType._Types.ValueType  # 4
        DOUBLE: ValueType._Types.ValueType  # 5
        FLOAT: ValueType._Types.ValueType  # 6
        BOOL: ValueType._Types.ValueType  # 7

    class Types(_Types, metaclass=_TypesEnumTypeWrapper): ...
    INVALID: ValueType.Types.ValueType  # 0
    BYTES: ValueType.Types.ValueType  # 1
    STRING: ValueType.Types.ValueType  # 2
    INT32: ValueType.Types.ValueType  # 3
    INT64: ValueType.Types.ValueType  # 4
    DOUBLE: ValueType.Types.ValueType  # 5
    FLOAT: ValueType.Types.ValueType  # 6
    BOOL: ValueType.Types.ValueType  # 7

    TYPE_FIELD_NUMBER: builtins.int
    type: global___ValueType.Types.ValueType
    def __init__(
        self,
        *,
        type: global___ValueType.Types.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["type", b"type"]) -> None: ...

global___ValueType = ValueType

class ParameterCategory(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Category:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _CategoryEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[ParameterCategory._Category.ValueType], builtins.type):  # noqa: F821
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        INVALID: ParameterCategory._Category.ValueType  # 0
        """An invalid parameter type, the default if unset"""
        ENTITY: ParameterCategory._Category.ValueType  # 1
        """Entity parameter"""
        FEATURE: ParameterCategory._Category.ValueType  # 2
        """Feature parameter"""
        PREDICTION: ParameterCategory._Category.ValueType  # 3
        """Prediction parameter"""
        INFERENCEOUTPUT: ParameterCategory._Category.ValueType  # 4
        """New Prediction parameter"""

    class Category(_Category, metaclass=_CategoryEnumTypeWrapper): ...
    INVALID: ParameterCategory.Category.ValueType  # 0
    """An invalid parameter type, the default if unset"""
    ENTITY: ParameterCategory.Category.ValueType  # 1
    """Entity parameter"""
    FEATURE: ParameterCategory.Category.ValueType  # 2
    """Feature parameter"""
    PREDICTION: ParameterCategory.Category.ValueType  # 3
    """Prediction parameter"""
    INFERENCEOUTPUT: ParameterCategory.Category.ValueType  # 4
    """New Prediction parameter"""

    def __init__(
        self,
    ) -> None: ...

global___ParameterCategory = ParameterCategory

class RegisterBuildRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    BUILD_SPEC_FIELD_NUMBER: builtins.int
    MODEL_SCHEMA_FIELD_NUMBER: builtins.int
    QWAK_CALLING_USER_ID_FIELD_NUMBER: builtins.int
    @property
    def build_spec(self) -> global___BuildSpec:
        """Build spec to register"""
    @property
    def model_schema(self) -> global___ModelSchema:
        """Deprecated - persist model scheme"""
    qwak_calling_user_id: builtins.str
    """User id of the caller - used to pass the user id whom called the build model process through fitness service"""
    def __init__(
        self,
        *,
        build_spec: global___BuildSpec | None = ...,
        model_schema: global___ModelSchema | None = ...,
        qwak_calling_user_id: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["build_spec", b"build_spec", "model_schema", b"model_schema"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["build_spec", b"build_spec", "model_schema", b"model_schema", "qwak_calling_user_id", b"qwak_calling_user_id"]) -> None: ...

global___RegisterBuildRequest = RegisterBuildRequest

class RegisterModelSchemaRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    BUILD_ID_FIELD_NUMBER: builtins.int
    MODEL_SCHEMA_FIELD_NUMBER: builtins.int
    build_id: builtins.str
    """Build id to update"""
    @property
    def model_schema(self) -> global___ModelSchema:
        """Model schema"""
    def __init__(
        self,
        *,
        build_id: builtins.str = ...,
        model_schema: global___ModelSchema | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["model_schema", b"model_schema"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["build_id", b"build_id", "model_schema", b"model_schema"]) -> None: ...

global___RegisterModelSchemaRequest = RegisterModelSchemaRequest

class RegisterExperimentTrackingValuesRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    BUILD_ID_FIELD_NUMBER: builtins.int
    EXPERIMENT_TRACKING_VALUES_FIELD_NUMBER: builtins.int
    build_id: builtins.str
    """Build id of build with experiment tracking values"""
    @property
    def experiment_tracking_values(self) -> global___ExperimentTrackingValues:
        """Qwak metrics and params"""
    def __init__(
        self,
        *,
        build_id: builtins.str = ...,
        experiment_tracking_values: global___ExperimentTrackingValues | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["experiment_tracking_values", b"experiment_tracking_values"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["build_id", b"build_id", "experiment_tracking_values", b"experiment_tracking_values"]) -> None: ...

global___RegisterExperimentTrackingValuesRequest = RegisterExperimentTrackingValuesRequest

class RegisterExperimentTrackingValuesResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___RegisterExperimentTrackingValuesResponse = RegisterExperimentTrackingValuesResponse

class ExperimentTrackingValues(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    METRICS_FIELD_NUMBER: builtins.int
    PARAMS_FIELD_NUMBER: builtins.int
    @property
    def metrics(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Metric]:
        """Qwak.metric"""
    @property
    def params(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Param]:
        """Qwak.param"""
    def __init__(
        self,
        *,
        metrics: collections.abc.Iterable[global___Metric] | None = ...,
        params: collections.abc.Iterable[global___Param] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["metrics", b"metrics", "params", b"params"]) -> None: ...

global___ExperimentTrackingValues = ExperimentTrackingValues

class BuildConfiguration(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    BUILD_PROPERTIES_FIELD_NUMBER: builtins.int
    BUILD_ENV_FIELD_NUMBER: builtins.int
    PRE_BUILD_FIELD_NUMBER: builtins.int
    POST_BUILD_FIELD_NUMBER: builtins.int
    STEP_FIELD_NUMBER: builtins.int
    VERBOSE_FIELD_NUMBER: builtins.int
    @property
    def build_properties(self) -> global___BuildPropertiesProto: ...
    @property
    def build_env(self) -> global___BuildEnvironment: ...
    @property
    def pre_build(self) -> global___BuildEnvironment: ...
    @property
    def post_build(self) -> global___BuildEnvironment: ...
    @property
    def step(self) -> global___Step: ...
    verbose: builtins.int
    def __init__(
        self,
        *,
        build_properties: global___BuildPropertiesProto | None = ...,
        build_env: global___BuildEnvironment | None = ...,
        pre_build: global___BuildEnvironment | None = ...,
        post_build: global___BuildEnvironment | None = ...,
        step: global___Step | None = ...,
        verbose: builtins.int = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["build_env", b"build_env", "build_properties", b"build_properties", "post_build", b"post_build", "pre_build", b"pre_build", "step", b"step"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["build_env", b"build_env", "build_properties", b"build_properties", "post_build", b"post_build", "pre_build", b"pre_build", "step", b"step", "verbose", b"verbose"]) -> None: ...

global___BuildConfiguration = BuildConfiguration

class Step(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TESTS_FIELD_NUMBER: builtins.int
    VALIDATE_BUILD_ARTIFACT_FIELD_NUMBER: builtins.int
    VALIDATE_BUILD_ARTIFACT_TIMEOUT_FIELD_NUMBER: builtins.int
    tests: builtins.bool
    validate_build_artifact: builtins.bool
    validate_build_artifact_timeout: builtins.int
    def __init__(
        self,
        *,
        tests: builtins.bool = ...,
        validate_build_artifact: builtins.bool = ...,
        validate_build_artifact_timeout: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["tests", b"tests", "validate_build_artifact", b"validate_build_artifact", "validate_build_artifact_timeout", b"validate_build_artifact_timeout"]) -> None: ...

global___Step = Step

class BuildPropertiesProto(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODEL_ID_FIELD_NUMBER: builtins.int
    MODEL_URI_FIELD_NUMBER: builtins.int
    TAGS_FIELD_NUMBER: builtins.int
    BUILD_ID_FIELD_NUMBER: builtins.int
    BRANCH_FIELD_NUMBER: builtins.int
    ENVIRONMENT_NAME_FIELD_NUMBER: builtins.int
    GPU_COMPATIBLE_FIELD_NUMBER: builtins.int
    model_id: builtins.str
    @property
    def model_uri(self) -> global___BuildModelUri: ...
    @property
    def tags(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
    build_id: builtins.str
    branch: builtins.str
    environment_name: builtins.str
    gpu_compatible: builtins.bool
    def __init__(
        self,
        *,
        model_id: builtins.str = ...,
        model_uri: global___BuildModelUri | None = ...,
        tags: collections.abc.Iterable[builtins.str] | None = ...,
        build_id: builtins.str = ...,
        branch: builtins.str = ...,
        environment_name: builtins.str = ...,
        gpu_compatible: builtins.bool = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["model_uri", b"model_uri"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["branch", b"branch", "build_id", b"build_id", "environment_name", b"environment_name", "gpu_compatible", b"gpu_compatible", "model_id", b"model_id", "model_uri", b"model_uri", "tags", b"tags"]) -> None: ...

global___BuildPropertiesProto = BuildPropertiesProto

class BuildModelUri(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    URI_FIELD_NUMBER: builtins.int
    GIT_BRANCH_FIELD_NUMBER: builtins.int
    MAIN_DIR_FIELD_NUMBER: builtins.int
    DEPENDENCY_REQUIRED_FOLDERS_FIELD_NUMBER: builtins.int
    uri: builtins.str
    git_branch: builtins.str
    main_dir: builtins.str
    @property
    def dependency_required_folders(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
    def __init__(
        self,
        *,
        uri: builtins.str = ...,
        git_branch: builtins.str = ...,
        main_dir: builtins.str = ...,
        dependency_required_folders: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["dependency_required_folders", b"dependency_required_folders", "git_branch", b"git_branch", "main_dir", b"main_dir", "uri", b"uri"]) -> None: ...

global___BuildModelUri = BuildModelUri

class BuildEnvironment(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DOCKER_FIELD_NUMBER: builtins.int
    LOCAL_FIELD_NUMBER: builtins.int
    PYTHON_ENV_FIELD_NUMBER: builtins.int
    REMOTE_FIELD_NUMBER: builtins.int
    @property
    def docker(self) -> global___DockerBuild: ...
    @property
    def local(self) -> global___LocalBuild: ...
    @property
    def python_env(self) -> global___PythonBuild: ...
    @property
    def remote(self) -> global___RemoteBuild: ...
    def __init__(
        self,
        *,
        docker: global___DockerBuild | None = ...,
        local: global___LocalBuild | None = ...,
        python_env: global___PythonBuild | None = ...,
        remote: global___RemoteBuild | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["docker", b"docker", "local", b"local", "python_env", b"python_env", "remote", b"remote"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["docker", b"docker", "local", b"local", "python_env", b"python_env", "remote", b"remote"]) -> None: ...

global___BuildEnvironment = BuildEnvironment

class DockerBuild(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class BuildArgsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    BASE_IMAGE_FIELD_NUMBER: builtins.int
    BUILD_ARGS_FIELD_NUMBER: builtins.int
    ENV_VARS_FIELD_NUMBER: builtins.int
    NO_CACHE_FIELD_NUMBER: builtins.int
    PARAMS_FIELD_NUMBER: builtins.int
    ASSUMED_IAM_ROLE_ARN_FIELD_NUMBER: builtins.int
    CACHE_FIELD_NUMBER: builtins.int
    PUSH_FIELD_NUMBER: builtins.int
    base_image: builtins.str
    @property
    def build_args(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]: ...
    @property
    def env_vars(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
    no_cache: builtins.bool
    @property
    def params(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
    assumed_iam_role_arn: builtins.str
    cache: builtins.bool
    push: builtins.bool
    def __init__(
        self,
        *,
        base_image: builtins.str = ...,
        build_args: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        env_vars: collections.abc.Iterable[builtins.str] | None = ...,
        no_cache: builtins.bool = ...,
        params: collections.abc.Iterable[builtins.str] | None = ...,
        assumed_iam_role_arn: builtins.str = ...,
        cache: builtins.bool = ...,
        push: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["assumed_iam_role_arn", b"assumed_iam_role_arn", "base_image", b"base_image", "build_args", b"build_args", "cache", b"cache", "env_vars", b"env_vars", "no_cache", b"no_cache", "params", b"params", "push", b"push"]) -> None: ...

global___DockerBuild = DockerBuild

class LocalBuild(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    AWS_PROFILE_FIELD_NUMBER: builtins.int
    NO_PUSH_FIELD_NUMBER: builtins.int
    aws_profile: builtins.str
    no_push: builtins.bool
    def __init__(
        self,
        *,
        aws_profile: builtins.str = ...,
        no_push: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["aws_profile", b"aws_profile", "no_push", b"no_push"]) -> None: ...

global___LocalBuild = LocalBuild

class PythonBuild(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    QWAK_SDK_EXTRA_INDEX_URL_FIELD_NUMBER: builtins.int
    VIRTUALENV_FIELD_NUMBER: builtins.int
    CONDA_FIELD_NUMBER: builtins.int
    POETRY_FIELD_NUMBER: builtins.int
    DEPENDENCY_FILE_PATH_FIELD_NUMBER: builtins.int
    USE_DEPRECATED_RESOLVER_FIELD_NUMBER: builtins.int
    qwak_sdk_extra_index_url: builtins.str
    @property
    def virtualenv(self) -> global___VirtualEnvironmentBuild: ...
    @property
    def conda(self) -> global___CondaBuild: ...
    @property
    def poetry(self) -> global___PoetryBuild: ...
    dependency_file_path: builtins.str
    use_deprecated_resolver: builtins.bool
    def __init__(
        self,
        *,
        qwak_sdk_extra_index_url: builtins.str = ...,
        virtualenv: global___VirtualEnvironmentBuild | None = ...,
        conda: global___CondaBuild | None = ...,
        poetry: global___PoetryBuild | None = ...,
        dependency_file_path: builtins.str = ...,
        use_deprecated_resolver: builtins.bool = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["conda", b"conda", "poetry", b"poetry", "virtualenv", b"virtualenv"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["conda", b"conda", "dependency_file_path", b"dependency_file_path", "poetry", b"poetry", "qwak_sdk_extra_index_url", b"qwak_sdk_extra_index_url", "use_deprecated_resolver", b"use_deprecated_resolver", "virtualenv", b"virtualenv"]) -> None: ...

global___PythonBuild = PythonBuild

class CondaBuild(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONDA_FILE_FIELD_NUMBER: builtins.int
    conda_file: builtins.str
    def __init__(
        self,
        *,
        conda_file: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["conda_file", b"conda_file"]) -> None: ...

global___CondaBuild = CondaBuild

class PoetryBuild(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PYTHON_VERSION_FIELD_NUMBER: builtins.int
    LOCK_FILE_FIELD_NUMBER: builtins.int
    python_version: builtins.str
    lock_file: builtins.str
    def __init__(
        self,
        *,
        python_version: builtins.str = ...,
        lock_file: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["lock_file", b"lock_file", "python_version", b"python_version"]) -> None: ...

global___PoetryBuild = PoetryBuild

class VirtualEnvironmentBuild(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PYTHON_VERSION_FIELD_NUMBER: builtins.int
    REQUIREMENTS_TXT_FIELD_NUMBER: builtins.int
    python_version: builtins.str
    requirements_txt: builtins.str
    def __init__(
        self,
        *,
        python_version: builtins.str = ...,
        requirements_txt: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["python_version", b"python_version", "requirements_txt", b"requirements_txt"]) -> None: ...

global___VirtualEnvironmentBuild = VirtualEnvironmentBuild

class RemoteBuild(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    IS_REMOTE_FIELD_NUMBER: builtins.int
    RESOURCES_FIELD_NUMBER: builtins.int
    is_remote: builtins.bool
    @property
    def resources(self) -> global___RemoteBuildResources: ...
    def __init__(
        self,
        *,
        is_remote: builtins.bool = ...,
        resources: global___RemoteBuildResources | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["resources", b"resources"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["is_remote", b"is_remote", "resources", b"resources"]) -> None: ...

global___RemoteBuild = RemoteBuild

class RemoteBuildResources(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CPUS_FIELD_NUMBER: builtins.int
    MEMORY_FIELD_NUMBER: builtins.int
    GPU_TYPE_FIELD_NUMBER: builtins.int
    GPU_AMOUNT_FIELD_NUMBER: builtins.int
    INSTANCE_FIELD_NUMBER: builtins.int
    cpus: builtins.float
    memory: builtins.str
    gpu_type: qwak.builds.build_pb2.GpuType.ValueType
    gpu_amount: builtins.int
    instance: builtins.str
    def __init__(
        self,
        *,
        cpus: builtins.float = ...,
        memory: builtins.str = ...,
        gpu_type: qwak.builds.build_pb2.GpuType.ValueType = ...,
        gpu_amount: builtins.int = ...,
        instance: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["cpus", b"cpus", "gpu_amount", b"gpu_amount", "gpu_type", b"gpu_type", "instance", b"instance", "memory", b"memory"]) -> None: ...

global___RemoteBuildResources = RemoteBuildResources

class Metric(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    KEY_FIELD_NUMBER: builtins.int
    VALUE_FIELD_NUMBER: builtins.int
    key: builtins.str
    """Key for Qwak.metric"""
    value: builtins.float
    """Value for Qwak.metric"""
    def __init__(
        self,
        *,
        key: builtins.str = ...,
        value: builtins.float = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

global___Metric = Metric

class Param(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    KEY_FIELD_NUMBER: builtins.int
    VALUE_FIELD_NUMBER: builtins.int
    key: builtins.str
    """Key for Qwak.param"""
    value: builtins.str
    """Value for Qwak.param"""
    def __init__(
        self,
        *,
        key: builtins.str = ...,
        value: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

global___Param = Param

class RegisterModelSchemaResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___RegisterModelSchemaResponse = RegisterModelSchemaResponse

class RegisterBuildResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    BUILD_ID_FIELD_NUMBER: builtins.int
    BUILD_STATUS_FIELD_NUMBER: builtins.int
    build_id: builtins.str
    """Build id of the registered build"""
    build_status: global___BuildStatus.ValueType
    """Build status of the registered build. Will return IN_PROGRESS"""
    def __init__(
        self,
        *,
        build_id: builtins.str = ...,
        build_status: global___BuildStatus.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["build_id", b"build_id", "build_status", b"build_status"]) -> None: ...

global___RegisterBuildResponse = RegisterBuildResponse

class UpdateBuildStatusRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    BUILD_ID_FIELD_NUMBER: builtins.int
    BUILD_STATUS_FIELD_NUMBER: builtins.int
    QWAK_CALLING_USER_ID_FIELD_NUMBER: builtins.int
    AVAILABLE_ENVIRONMENTS_FIELD_NUMBER: builtins.int
    build_id: builtins.str
    """Build id to update"""
    build_status: global___BuildStatus.ValueType
    """Build status to update to"""
    qwak_calling_user_id: builtins.str
    """User id of the caller - used to pass the user id whom called the build model process through fitness service"""
    @property
    def available_environments(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Environments the build is available on"""
    def __init__(
        self,
        *,
        build_id: builtins.str = ...,
        build_status: global___BuildStatus.ValueType = ...,
        qwak_calling_user_id: builtins.str = ...,
        available_environments: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["available_environments", b"available_environments", "build_id", b"build_id", "build_status", b"build_status", "qwak_calling_user_id", b"qwak_calling_user_id"]) -> None: ...

global___UpdateBuildStatusRequest = UpdateBuildStatusRequest

class UpdateBuildStatusResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___UpdateBuildStatusResponse = UpdateBuildStatusResponse

class UpdateBuildBranchRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    BUILD_ID_FIELD_NUMBER: builtins.int
    BRANCH_NAME_FIELD_NUMBER: builtins.int
    build_id: builtins.str
    """Build id to update"""
    branch_name: builtins.str
    """New branch name"""
    def __init__(
        self,
        *,
        build_id: builtins.str = ...,
        branch_name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["branch_name", b"branch_name", "build_id", b"build_id"]) -> None: ...

global___UpdateBuildBranchRequest = UpdateBuildBranchRequest

class UpdateBuildBranchResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___UpdateBuildBranchResponse = UpdateBuildBranchResponse

class GetBuildRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    BUILD_ID_FIELD_NUMBER: builtins.int
    build_id: builtins.str
    """Build id of the requested build"""
    def __init__(
        self,
        *,
        build_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["build_id", b"build_id"]) -> None: ...

global___GetBuildRequest = GetBuildRequest

class GetBuildResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    BUILD_FIELD_NUMBER: builtins.int
    @property
    def build(self) -> global___Build:
        """Requested build information"""
    def __init__(
        self,
        *,
        build: global___Build | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["build", b"build"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["build", b"build"]) -> None: ...

global___GetBuildResponse = GetBuildResponse

class ListBuildsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    BRANCH_ID_FIELD_NUMBER: builtins.int
    MODEL_UUID_FIELD_NUMBER: builtins.int
    BUILD_IDS_FIELD_NUMBER: builtins.int
    branch_id: builtins.str
    """Branch id of the requested builds"""
    model_uuid: builtins.str
    """Model uuid"""
    @property
    def build_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Build ids"""
    def __init__(
        self,
        *,
        branch_id: builtins.str = ...,
        model_uuid: builtins.str = ...,
        build_ids: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["branch_id", b"branch_id", "build_ids", b"build_ids", "model_uuid", b"model_uuid"]) -> None: ...

global___ListBuildsRequest = ListBuildsRequest

class ListBuildsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    BUILDS_FIELD_NUMBER: builtins.int
    @property
    def builds(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Build]:
        """List of the branches' builds information"""
    def __init__(
        self,
        *,
        builds: collections.abc.Iterable[global___Build] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["builds", b"builds"]) -> None: ...

global___ListBuildsResponse = ListBuildsResponse
