# -*- coding: utf-8 -*-

# PLEASE DO NOT EDIT THIS FILE, IT IS GENERATED AND WILL BE OVERWRITTEN:
# https://github.com/ccxt/ccxt/blob/master/CONTRIBUTING.md#how-to-contribute-code

from ccxt.base.exchange import Exchange
import hashlib
from ccxt.base.errors import ExchangeError
from ccxt.base.errors import AuthenticationError
from ccxt.base.errors import PermissionDenied
from ccxt.base.errors import ArgumentsRequired
from ccxt.base.errors import BadRequest
from ccxt.base.errors import InsufficientFunds
from ccxt.base.errors import InvalidAddress
from ccxt.base.errors import InvalidOrder
from ccxt.base.errors import OrderNotFound
from ccxt.base.errors import NotSupported
from ccxt.base.errors import DDoSProtection
from ccxt.base.errors import ExchangeNotAvailable
from ccxt.base.errors import OnMaintenance
from ccxt.base.decimal_to_precision import TICK_SIZE
from ccxt.base.precise import Precise


class deribit(Exchange):

    def describe(self):
        return self.deep_extend(super(deribit, self).describe(), {
            'id': 'deribit',
            'name': 'Deribit',
            'countries': ['NL'],  # Netherlands
            'version': 'v2',
            'userAgent': None,
            # 20 requests per second for non-matching-engine endpoints, 1000ms / 20 = 50ms between requests
            # 5 requests per second for matching-engine endpoints, cost = (1000ms / rateLimit) / 5 = 4
            'rateLimit': 50,
            'pro': True,
            'has': {
                'CORS': True,
                'spot': False,
                'margin': False,
                'swap': True,
                'future': True,
                'option': True,
                'cancelAllOrders': True,
                'cancelOrder': True,
                'cancelOrders': False,
                'createDepositAddress': True,
                'createOrder': True,
                'createStopLimitOrder': True,
                'createStopMarketOrder': True,
                'createStopOrder': True,
                'editOrder': True,
                'fetchAccounts': True,
                'fetchBalance': True,
                'fetchBorrowRate': False,
                'fetchBorrowRateHistories': False,
                'fetchBorrowRateHistory': False,
                'fetchBorrowRates': False,
                'fetchBorrowRatesPerSymbol': False,
                'fetchClosedOrders': True,
                'fetchDeposit': False,
                'fetchDepositAddress': True,
                'fetchDeposits': True,
                'fetchHistoricalVolatility': True,
                'fetchIndexOHLCV': False,
                'fetchLeverageTiers': False,
                'fetchMarginMode': False,
                'fetchMarkets': True,
                'fetchMarkOHLCV': False,
                'fetchMyTrades': True,
                'fetchOHLCV': True,
                'fetchOpenOrders': True,
                'fetchOrder': True,
                'fetchOrderBook': True,
                'fetchOrders': False,
                'fetchOrderTrades': True,
                'fetchPosition': True,
                'fetchPositionMode': False,
                'fetchPositions': True,
                'fetchPremiumIndexOHLCV': False,
                'fetchStatus': True,
                'fetchTicker': True,
                'fetchTickers': True,
                'fetchTime': True,
                'fetchTrades': True,
                'fetchTradingFee': False,
                'fetchTradingFees': True,
                'fetchTransactions': False,
                'fetchTransfer': False,
                'fetchTransfers': True,
                'fetchWithdrawal': False,
                'fetchWithdrawals': True,
                'transfer': True,
                'withdraw': True,
            },
            'timeframes': {
                '1m': '1',
                '3m': '3',
                '5m': '5',
                '10m': '10',
                '15m': '15',
                '30m': '30',
                '1h': '60',
                '2h': '120',
                '3h': '180',
                '6h': '360',
                '12h': '720',
                '1d': '1D',
            },
            'urls': {
                'test': {
                    'rest': 'https://test.deribit.com',
                },
                'logo': 'https://user-images.githubusercontent.com/1294454/41933112-9e2dd65a-798b-11e8-8440-5bab2959fcb8.jpg',
                'api': {
                    'rest': 'https://www.deribit.com',
                },
                'www': 'https://www.deribit.com',
                'doc': [
                    'https://docs.deribit.com/v2',
                    'https://github.com/deribit',
                ],
                'fees': 'https://www.deribit.com/pages/information/fees',
                'referral': {
                    'url': 'https://www.deribit.com/reg-1189.4038',
                    'discount': 0.1,
                },
            },
            'api': {
                'public': {
                    'get': {
                        # Authentication
                        'auth': 1,
                        'exchange_token': 1,
                        'fork_token': 1,
                        # Session management
                        'set_heartbeat': 1,
                        'disable_heartbeat': 1,
                        # Supporting
                        'get_time': 1,
                        'hello': 1,
                        'status': 1,
                        'test': 1,
                        # Subscription management
                        'subscribe': 1,
                        'unsubscribe': 1,
                        'unsubscribe_all': 1,
                        # Account management
                        'get_announcements': 1,
                        # Market data
                        'get_book_summary_by_currency': 1,
                        'get_book_summary_by_instrument': 1,
                        'get_contract_size': 1,
                        'get_currencies': 1,
                        'get_delivery_prices': 1,
                        'get_funding_chart_data': 1,
                        'get_funding_rate_history': 1,
                        'get_funding_rate_value': 1,
                        'get_historical_volatility': 1,
                        'get_index': 1,
                        'get_index_price': 1,
                        'get_index_price_names': 1,
                        'get_instrument': 1,
                        'get_instruments': 1,
                        'get_last_settlements_by_currency': 1,
                        'get_last_settlements_by_instrument': 1,
                        'get_last_trades_by_currency': 1,
                        'get_last_trades_by_currency_and_time': 1,
                        'get_last_trades_by_instrument': 1,
                        'get_last_trades_by_instrument_and_time': 1,
                        'get_mark_price_history': 1,
                        'get_order_book': 1,
                        'get_trade_volumes': 1,
                        'get_tradingview_chart_data': 1,
                        'get_volatility_index_data': 1,
                        'ticker': 1,
                    },
                },
                'private': {
                    'get': {
                        # Authentication
                        'logout': 1,
                        # Session management
                        'enable_cancel_on_disconnect': 1,
                        'disable_cancel_on_disconnect': 1,
                        'get_cancel_on_disconnect': 1,
                        # Subscription management
                        'subscribe': 1,
                        'unsubscribe': 1,
                        'unsubscribe_all': 1,
                        # Account management
                        'change_api_key_name': 1,
                        'change_scope_in_api_key': 1,
                        'change_subaccount_name': 1,
                        'create_api_key': 1,
                        'create_subaccount': 1,
                        'disable_api_key': 1,
                        'disable_tfa_for_subaccount': 1,
                        'enable_affiliate_program': 1,
                        'enable_api_key': 1,
                        'get_access_log': 1,
                        'get_account_summary': 1,
                        'get_affiliate_program_info': 1,
                        'get_email_language': 1,
                        'get_new_announcements': 1,
                        'get_portfolio_margins': 1,
                        'get_position': 1,
                        'get_positions': 1,
                        'get_subaccounts': 1,
                        'get_subaccounts_details': 1,
                        'get_transaction_log': 1,
                        'list_api_keys': 1,
                        'remove_api_key': 1,
                        'remove_subaccount': 1,
                        'reset_api_key': 1,
                        'set_announcement_as_read': 1,
                        'set_api_key_as_default': 1,
                        'set_email_for_subaccount': 1,
                        'set_email_language': 1,
                        'set_password_for_subaccount': 1,
                        'toggle_notifications_from_subaccount': 1,
                        'toggle_subaccount_login': 1,
                        # Block Trade
                        'execute_block_trade': 4,
                        'get_block_trade': 1,
                        'get_last_block_trades_by_currency': 1,
                        'invalidate_block_trade_signature': 1,
                        'verify_block_trade': 4,
                        # Trading
                        'buy': 4,
                        'sell': 4,
                        'edit': 4,
                        'edit_by_label': 4,
                        'cancel': 4,
                        'cancel_all': 4,
                        'cancel_all_by_currency': 4,
                        'cancel_all_by_instrument': 4,
                        'cancel_by_label': 4,
                        'close_position': 4,
                        'get_margins': 1,
                        'get_mmp_config': 1,
                        'get_open_orders_by_currency': 1,
                        'get_open_orders_by_instrument': 1,
                        'get_order_history_by_currency': 1,
                        'get_order_history_by_instrument': 1,
                        'get_order_margin_by_ids': 1,
                        'get_order_state': 1,
                        'get_stop_order_history': 1,  # deprecated
                        'get_trigger_order_history': 1,
                        'get_user_trades_by_currency': 1,
                        'get_user_trades_by_currency_and_time': 1,
                        'get_user_trades_by_instrument': 1,
                        'get_user_trades_by_instrument_and_time': 1,
                        'get_user_trades_by_order': 1,
                        'reset_mmp': 1,
                        'set_mmp_config': 1,
                        'get_settlement_history_by_instrument': 1,
                        'get_settlement_history_by_currency': 1,
                        # Wallet
                        'cancel_transfer_by_id': 1,
                        'cancel_withdrawal': 1,
                        'create_deposit_address': 1,
                        'get_current_deposit_address': 1,
                        'get_deposits': 1,
                        'get_transfers': 1,
                        'get_withdrawals': 1,
                        'submit_transfer_to_subaccount': 1,
                        'submit_transfer_to_user': 1,
                        'withdraw': 1,
                    },
                },
            },
            'exceptions': {
                # 0 or absent Success, No error.
                '9999': PermissionDenied,  # 'api_not_enabled' User didn't enable API for the Account.
                '10000': AuthenticationError,  # 'authorization_required' Authorization issue, invalid or absent signature etc.
                '10001': ExchangeError,  # 'error' Some general failure, no public information available.
                '10002': InvalidOrder,  # 'qty_too_low' Order quantity is too low.
                '10003': InvalidOrder,  # 'order_overlap' Rejection, order overlap is found and self-trading is not enabled.
                '10004': OrderNotFound,  # 'order_not_found' Attempt to operate with order that can't be found by specified id.
                '10005': InvalidOrder,  # 'price_too_low <Limit>' Price is too low, <Limit> defines current limit for the operation.
                '10006': InvalidOrder,  # 'price_too_low4idx <Limit>' Price is too low for current index, <Limit> defines current bottom limit for the operation.
                '10007': InvalidOrder,  # 'price_too_high <Limit>' Price is too high, <Limit> defines current up limit for the operation.
                '10008': InvalidOrder,  # 'price_too_high4idx <Limit>' Price is too high for current index, <Limit> defines current up limit for the operation.
                '10009': InsufficientFunds,  # 'not_enough_funds' Account has not enough funds for the operation.
                '10010': OrderNotFound,  # 'already_closed' Attempt of doing something with closed order.
                '10011': InvalidOrder,  # 'price_not_allowed' This price is not allowed for some reason.
                '10012': InvalidOrder,  # 'book_closed' Operation for instrument which order book had been closed.
                '10013': PermissionDenied,  # 'pme_max_total_open_orders <Limit>' Total limit of open orders has been exceeded, it is applicable for PME users.
                '10014': PermissionDenied,  # 'pme_max_future_open_orders <Limit>' Limit of count of futures' open orders has been exceeded, it is applicable for PME users.
                '10015': PermissionDenied,  # 'pme_max_option_open_orders <Limit>' Limit of count of options' open orders has been exceeded, it is applicable for PME users.
                '10016': PermissionDenied,  # 'pme_max_future_open_orders_size <Limit>' Limit of size for futures has been exceeded, it is applicable for PME users.
                '10017': PermissionDenied,  # 'pme_max_option_open_orders_size <Limit>' Limit of size for options has been exceeded, it is applicable for PME users.
                '10018': PermissionDenied,  # 'non_pme_max_future_position_size <Limit>' Limit of size for futures has been exceeded, it is applicable for non-PME users.
                '10019': PermissionDenied,  # 'locked_by_admin' Trading is temporary locked by admin.
                '10020': ExchangeError,  # 'invalid_or_unsupported_instrument' Instrument name is not valid.
                '10021': InvalidOrder,  # 'invalid_amount' Amount is not valid.
                '10022': InvalidOrder,  # 'invalid_quantity' quantity was not recognized as a valid number(for API v1).
                '10023': InvalidOrder,  # 'invalid_price' price was not recognized as a valid number.
                '10024': InvalidOrder,  # 'invalid_max_show' max_show parameter was not recognized as a valid number.
                '10025': InvalidOrder,  # 'invalid_order_id' Order id is missing or its format was not recognized as valid.
                '10026': InvalidOrder,  # 'price_precision_exceeded' Extra precision of the price is not supported.
                '10027': InvalidOrder,  # 'non_integer_contract_amount' Futures contract amount was not recognized as integer.
                '10028': DDoSProtection,  # 'too_many_requests' Allowed request rate has been exceeded.
                '10029': OrderNotFound,  # 'not_owner_of_order' Attempt to operate with not own order.
                '10030': ExchangeError,  # 'must_be_websocket_request' REST request where Websocket is expected.
                '10031': ExchangeError,  # 'invalid_args_for_instrument' Some of arguments are not recognized as valid.
                '10032': InvalidOrder,  # 'whole_cost_too_low' Total cost is too low.
                '10033': NotSupported,  # 'not_implemented' Method is not implemented yet.
                '10034': InvalidOrder,  # 'stop_price_too_high' Stop price is too high.
                '10035': InvalidOrder,  # 'stop_price_too_low' Stop price is too low.
                '10036': InvalidOrder,  # 'invalid_max_show_amount' Max Show Amount is not valid.
                '10040': ExchangeNotAvailable,  # 'retry' Request can't be processed right now and should be retried.
                '10041': OnMaintenance,  # 'settlement_in_progress' Settlement is in progress. Every day at settlement time for several seconds, the system calculates user profits and updates balances. That time trading is paused for several seconds till the calculation is completed.
                '10043': InvalidOrder,  # 'price_wrong_tick' Price has to be rounded to a certain tick size.
                '10044': InvalidOrder,  # 'stop_price_wrong_tick' Stop Price has to be rounded to a certain tick size.
                '10045': InvalidOrder,  # 'can_not_cancel_liquidation_order' Liquidation order can't be canceled.
                '10046': InvalidOrder,  # 'can_not_edit_liquidation_order' Liquidation order can't be edited.
                '10047': DDoSProtection,  # 'matching_engine_queue_full' Reached limit of pending Matching Engine requests for user.
                '10048': ExchangeError,  # 'not_on_self_server' The requested operation is not available on self server.
                '11008': InvalidOrder,  # 'already_filled' This request is not allowed in regards to the filled order.
                '11029': BadRequest,  # 'invalid_arguments' Some invalid input has been detected.
                '11030': ExchangeError,  # 'other_reject <Reason>' Some rejects which are not considered as very often, more info may be specified in <Reason>.
                '11031': ExchangeError,  # 'other_error <Error>' Some errors which are not considered as very often, more info may be specified in <Error>.
                '11035': DDoSProtection,  # 'no_more_stops <Limit>' Allowed amount of stop orders has been exceeded.
                '11036': InvalidOrder,  # 'invalid_stoppx_for_index_or_last' Invalid StopPx(too high or too low) as to current index or market.
                '11037': BadRequest,  # 'outdated_instrument_for_IV_order' Instrument already not available for trading.
                '11038': InvalidOrder,  # 'no_adv_for_futures' Advanced orders are not available for futures.
                '11039': InvalidOrder,  # 'no_adv_postonly' Advanced post-only orders are not supported yet.
                '11041': InvalidOrder,  # 'not_adv_order' Advanced order properties can't be set if the order is not advanced.
                '11042': PermissionDenied,  # 'permission_denied' Permission for the operation has been denied.
                '11043': BadRequest,  # 'bad_argument' Bad argument has been passed.
                '11044': InvalidOrder,  # 'not_open_order' Attempt to do open order operations with the not open order.
                '11045': BadRequest,  # 'invalid_event' Event name has not been recognized.
                '11046': BadRequest,  # 'outdated_instrument' At several minutes to instrument expiration, corresponding advanced implied volatility orders are not allowed.
                '11047': BadRequest,  # 'unsupported_arg_combination' The specified combination of arguments is not supported.
                '11048': ExchangeError,  # 'wrong_max_show_for_option' Wrong Max Show for options.
                '11049': BadRequest,  # 'bad_arguments' Several bad arguments have been passed.
                '11050': BadRequest,  # 'bad_request' Request has not been parsed properly.
                '11051': OnMaintenance,  # 'system_maintenance' System is under maintenance.
                '11052': ExchangeError,  # 'subscribe_error_unsubscribed' Subscription error. However, subscription may fail without self error, please check list of subscribed channels returned, as some channels can be not subscribed due to wrong input or lack of permissions.
                '11053': ExchangeError,  # 'transfer_not_found' Specified transfer is not found.
                '11090': InvalidAddress,  # 'invalid_addr' Invalid address.
                '11091': InvalidAddress,  # 'invalid_transfer_address' Invalid addres for the transfer.
                '11092': InvalidAddress,  # 'address_already_exist' The address already exists.
                '11093': DDoSProtection,  # 'max_addr_count_exceeded' Limit of allowed addresses has been reached.
                '11094': ExchangeError,  # 'internal_server_error' Some unhandled error on server. Please report to admin. The details of the request will help to locate the problem.
                '11095': ExchangeError,  # 'disabled_deposit_address_creation' Deposit address creation has been disabled by admin.
                '11096': ExchangeError,  # 'address_belongs_to_user' Withdrawal instead of transfer.
                '12000': AuthenticationError,  # 'bad_tfa' Wrong TFA code
                '12001': DDoSProtection,  # 'too_many_subaccounts' Limit of subbacounts is reached.
                '12002': ExchangeError,  # 'wrong_subaccount_name' The input is not allowed as name of subaccount.
                '12998': AuthenticationError,  # 'tfa_over_limit' The number of failed TFA attempts is limited.
                '12003': AuthenticationError,  # 'login_over_limit' The number of failed login attempts is limited.
                '12004': AuthenticationError,  # 'registration_over_limit' The number of registration requests is limited.
                '12005': AuthenticationError,  # 'country_is_banned' The country is banned(possibly via IP check).
                '12100': ExchangeError,  # 'transfer_not_allowed' Transfer is not allowed. Possible wrong direction or other mistake.
                '12999': AuthenticationError,  # 'tfa_used' TFA code is correct but it is already used. Please, use next code.
                '13000': AuthenticationError,  # 'invalid_login' Login name is invalid(not allowed or it contains wrong characters).
                '13001': AuthenticationError,  # 'account_not_activated' Account must be activated.
                '13002': PermissionDenied,  # 'account_blocked' Account is blocked by admin.
                '13003': AuthenticationError,  # 'tfa_required' This action requires TFA authentication.
                '13004': AuthenticationError,  # 'invalid_credentials' Invalid credentials has been used.
                '13005': AuthenticationError,  # 'pwd_match_error' Password confirmation error.
                '13006': AuthenticationError,  # 'security_error' Invalid Security Code.
                '13007': AuthenticationError,  # 'user_not_found' User's security code has been changed or wrong.
                '13008': ExchangeError,  # 'request_failed' Request failed because of invalid input or internal failure.
                '13009': AuthenticationError,  # 'unauthorized' Wrong or expired authorization token or bad signature. For example, please check scope of the token, 'connection' scope can't be reused for other connections.
                '13010': BadRequest,  # 'value_required' Invalid input, missing value.
                '13011': BadRequest,  # 'value_too_short' Input is too short.
                '13012': PermissionDenied,  # 'unavailable_in_subaccount' Subaccount restrictions.
                '13013': BadRequest,  # 'invalid_phone_number' Unsupported or invalid phone number.
                '13014': BadRequest,  # 'cannot_send_sms' SMS sending failed -- phone number is wrong.
                '13015': BadRequest,  # 'invalid_sms_code' Invalid SMS code.
                '13016': BadRequest,  # 'invalid_input' Invalid input.
                '13017': ExchangeError,  # 'subscription_failed' Subscription hailed, invalid subscription parameters.
                '13018': ExchangeError,  # 'invalid_content_type' Invalid content type of the request.
                '13019': ExchangeError,  # 'orderbook_closed' Closed, expired order book.
                '13020': ExchangeError,  # 'not_found' Instrument is not found, invalid instrument name.
                '13021': PermissionDenied,  # 'forbidden' Not enough permissions to execute the request, forbidden.
                '13025': ExchangeError,  # 'method_switched_off_by_admin' API method temporarily switched off by administrator.
                '-32602': BadRequest,  # 'Invalid params' see JSON-RPC spec.
                '-32601': BadRequest,  # 'Method not found' see JSON-RPC spec.
                '-32700': BadRequest,  # 'Parse error' see JSON-RPC spec.
                '-32000': BadRequest,  # 'Missing params' see JSON-RPC spec.
                '11054': InvalidOrder,  # 'post_only_reject' post order would be filled immediately
            },
            'precisionMode': TICK_SIZE,
            'options': {
                'code': 'BTC',
                'fetchBalance': {
                    'code': 'BTC',
                },
                'fetchPositions': {
                    'code': 'BTC',
                },
                'transfer': {
                    'method': 'privateGetSubmitTransferToSubaccount',  # or 'privateGetSubmitTransferToUser'
                },
            },
        })

    def fetch_time(self, params={}):
        """
        fetches the current integer timestamp in milliseconds from the exchange server
        :param dict params: extra parameters specific to the deribit api endpoint
        :returns int: the current integer timestamp in milliseconds from the exchange server
        """
        response = self.publicGetGetTime(params)
        #
        #     {
        #         jsonrpc: '2.0',
        #         result: 1583922446019,
        #         usIn: 1583922446019955,
        #         usOut: 1583922446019956,
        #         usDiff: 1,
        #         testnet: False
        #     }
        #
        return self.safe_integer(response, 'result')

    def code_from_options(self, methodName, params={}):
        defaultCode = self.safe_value(self.options, 'code', 'BTC')
        options = self.safe_value(self.options, methodName, {})
        code = self.safe_value(options, 'code', defaultCode)
        return self.safe_value(params, 'code', code)

    def fetch_status(self, params={}):
        """
        the latest known information on the availability of the exchange API
        :param dict params: extra parameters specific to the deribit api endpoint
        :returns dict: a `status structure <https://docs.ccxt.com/en/latest/manual.html#exchange-status-structure>`
        """
        response = self.publicGetStatus(params)
        #
        #     {
        #         "jsonrpc": "2.0",
        #         "result": {
        #             "locked": "false"  # True, partial, False
        #         },
        #         "usIn": 1650641690226788,
        #         "usOut": 1650641690226836,
        #         "usDiff": 48,
        #         "testnet": False
        #     }
        #
        result = self.safe_value(response, 'result')
        locked = self.safe_string(result, 'locked')
        updateTime = self.safe_integer_product(response, 'usIn', 0.001, self.milliseconds())
        return {
            'status': 'ok' if (locked == 'false') else 'maintenance',
            'updated': updateTime,
            'eta': None,
            'url': None,
            'info': response,
        }

    def fetch_accounts(self, params={}):
        """
        fetch all the accounts associated with a profile
        :param dict params: extra parameters specific to the deribit api endpoint
        :returns dict: a dictionary of `account structures <https://docs.ccxt.com/en/latest/manual.html#account-structure>` indexed by the account type
        """
        self.load_markets()
        response = self.privateGetGetSubaccounts(params)
        #
        #     {
        #         jsonrpc: '2.0',
        #         result: [{
        #                 username: 'someusername',
        #                 type: 'main',
        #                 system_name: 'someusername',
        #                 security_keys_enabled: False,
        #                 security_keys_assignments: [],
        #                 receive_notifications: False,
        #                 login_enabled: True,
        #                 is_password: True,
        #                 id: '238216',
        #                 email: 'pablo@abcdef.com'
        #             },
        #             {
        #                 username: 'someusername_1',
        #                 type: 'subaccount',
        #                 system_name: 'someusername_1',
        #                 security_keys_enabled: False,
        #                 security_keys_assignments: [],
        #                 receive_notifications: False,
        #                 login_enabled: False,
        #                 is_password: False,
        #                 id: '245499',
        #                 email: 'pablo@abcdef.com'
        #             }
        #         ],
        #         usIn: '1652736468292006',
        #         usOut: '1652736468292377',
        #         usDiff: '371',
        #         testnet: False
        #     }
        #
        result = self.safe_value(response, 'result', [])
        return self.parse_accounts(result)

    def parse_account(self, account, currency=None):
        #
        #      {
        #          username: 'someusername_1',
        #          type: 'subaccount',
        #          system_name: 'someusername_1',
        #          security_keys_enabled: False,
        #          security_keys_assignments: [],
        #          receive_notifications: False,
        #          login_enabled: False,
        #          is_password: False,
        #          id: '245499',
        #          email: 'pablo@abcdef.com'
        #      }
        #
        return {
            'info': account,
            'id': self.safe_string(account, 'id'),
            'type': self.safe_string(account, 'type'),
            'code': self.safe_currency_code(None, currency),
        }

    def fetch_markets(self, params={}):
        """
        retrieves data on all markets for deribit
        :param dict params: extra parameters specific to the exchange api endpoint
        :returns [dict]: an array of objects representing market data
        """
        currenciesResponse = self.publicGetGetCurrencies(params)
        #
        #     {
        #         jsonrpc: '2.0',
        #         result: [
        #             {
        #                 withdrawal_priorities: [
        #                     {value: 0.15, name: 'very_low'},
        #                     {value: 1.5, name: 'very_high'},
        #                 ],
        #                 withdrawal_fee: 0.0005,
        #                 min_withdrawal_fee: 0.0005,
        #                 min_confirmations: 1,
        #                 fee_precision: 4,
        #                 currency_long: 'Bitcoin',
        #                 currency: 'BTC',
        #                 coin_type: 'BITCOIN'
        #             }
        #         ],
        #         usIn: 1583761588590479,
        #         usOut: 1583761588590544,
        #         usDiff: 65,
        #         testnet: False
        #     }
        #
        currenciesResult = self.safe_value(currenciesResponse, 'result', [])
        result = []
        for i in range(0, len(currenciesResult)):
            currencyId = self.safe_string(currenciesResult[i], 'currency')
            request = {
                'currency': currencyId,
            }
            instrumentsResponse = self.publicGetGetInstruments(self.extend(request, params))
            #
            #     {
            #         "jsonrpc":"2.0",
            #         "result":[
            #             {
            #                 "tick_size":0.0005,
            #                 "taker_commission":0.0003,
            #                 "strike":52000.0,
            #                 "settlement_period":"month",
            #                 "settlement_currency":"BTC",
            #                 "quote_currency":"BTC",
            #                 "option_type":"put",  # put, call
            #                 "min_trade_amount":0.1,
            #                 "maker_commission":0.0003,
            #                 "kind":"option",
            #                 "is_active":true,
            #                 "instrument_name":"BTC-24JUN22-52000-P",
            #                 "expiration_timestamp":1656057600000,
            #                 "creation_timestamp":1648199543000,
            #                 "counter_currency":"USD",
            #                 "contract_size":1.0,
            #                 "block_trade_commission":0.0003,
            #                 "base_currency":"BTC"
            #             },
            #             {
            #                 "tick_size":0.5,
            #                 "taker_commission":0.0005,
            #                 "settlement_period":"month",  # month, week
            #                 "settlement_currency":"BTC",
            #                 "quote_currency":"USD",
            #                 "min_trade_amount":10.0,
            #                 "max_liquidation_commission":0.0075,
            #                 "max_leverage":50,
            #                 "maker_commission":0.0,
            #                 "kind":"future",
            #                 "is_active":true,
            #                 "instrument_name":"BTC-27MAY22",
            #                 "future_type":"reversed",
            #                 "expiration_timestamp":1653638400000,
            #                 "creation_timestamp":1648195209000,
            #                 "counter_currency":"USD",
            #                 "contract_size":10.0,
            #                 "block_trade_commission":0.0001,
            #                 "base_currency":"BTC"
            #             },
            #             {
            #                 "tick_size":0.5,
            #                 "taker_commission":0.0005,
            #                 "settlement_period":"perpetual",
            #                 "settlement_currency":"BTC",
            #                 "quote_currency":"USD",
            #                 "min_trade_amount":10.0,
            #                 "max_liquidation_commission":0.0075,
            #                 "max_leverage":50,
            #                 "maker_commission":0.0,
            #                 "kind":"future",
            #                 "is_active":true,
            #                 "instrument_name":"BTC-PERPETUAL",
            #                 "future_type":"reversed",
            #                 "expiration_timestamp":32503708800000,
            #                 "creation_timestamp":1534242287000,
            #                 "counter_currency":"USD",
            #                 "contract_size":10.0,
            #                 "block_trade_commission":0.0001,
            #                 "base_currency":"BTC"
            #             },
            #         ],
            #         "usIn":1648691472831791,
            #         "usOut":1648691472831896,
            #         "usDiff":105,
            #         "testnet":false
            #     }
            #
            instrumentsResult = self.safe_value(instrumentsResponse, 'result', [])
            for k in range(0, len(instrumentsResult)):
                market = instrumentsResult[k]
                id = self.safe_string(market, 'instrument_name')
                baseId = self.safe_string(market, 'base_currency')
                quoteId = self.safe_string(market, 'counter_currency')
                settleId = self.safe_string(market, 'settlement_currency')
                base = self.safe_currency_code(baseId)
                quote = self.safe_currency_code(quoteId)
                settle = self.safe_currency_code(settleId)
                kind = self.safe_string(market, 'kind')
                settlementPeriod = self.safe_value(market, 'settlement_period')
                swap = (settlementPeriod == 'perpetual')
                future = not swap and (kind.find('future') >= 0)
                option = (kind.find('option') >= 0)
                isComboMarket = kind.find('combo') >= 0
                expiry = self.safe_integer(market, 'expiration_timestamp')
                strike = None
                optionType = None
                symbol = id
                type = 'swap'
                if future:
                    type = 'future'
                elif option:
                    type = 'option'
                if not isComboMarket:
                    symbol = base + '/' + quote + ':' + settle
                    if option or future:
                        symbol = symbol + '-' + self.yymmdd(expiry, '')
                        if option:
                            strike = self.safe_number(market, 'strike')
                            optionType = self.safe_string(market, 'option_type')
                            letter = 'C' if (optionType == 'call') else 'P'
                            symbol = symbol + '-' + self.number_to_string(strike) + '-' + letter
                minTradeAmount = self.safe_number(market, 'min_trade_amount')
                tickSize = self.safe_number(market, 'tick_size')
                result.append({
                    'id': id,
                    'symbol': symbol,
                    'base': base,
                    'quote': quote,
                    'settle': settle,
                    'baseId': baseId,
                    'quoteId': quoteId,
                    'settleId': settleId,
                    'type': type,
                    'spot': False,
                    'margin': False,
                    'swap': swap,
                    'future': future,
                    'option': option,
                    'active': self.safe_value(market, 'is_active'),
                    'contract': True,
                    'linear': (settle == quote),
                    'inverse': (settle != quote),
                    'taker': self.safe_number(market, 'taker_commission'),
                    'maker': self.safe_number(market, 'maker_commission'),
                    'contractSize': self.safe_number(market, 'contract_size'),
                    'expiry': expiry,
                    'expiryDatetime': self.iso8601(expiry),
                    'strike': strike,
                    'optionType': optionType,
                    'precision': {
                        'amount': minTradeAmount,
                        'price': tickSize,
                    },
                    'limits': {
                        'leverage': {
                            'min': None,
                            'max': None,
                        },
                        'amount': {
                            'min': minTradeAmount,
                            'max': None,
                        },
                        'price': {
                            'min': tickSize,
                            'max': None,
                        },
                        'cost': {
                            'min': None,
                            'max': None,
                        },
                    },
                    'info': market,
                })
        return result

    def parse_balance(self, balance):
        result = {
            'info': balance,
        }
        currencyId = self.safe_string(balance, 'currency')
        currencyCode = self.safe_currency_code(currencyId)
        account = self.account()
        account['free'] = self.safe_string(balance, 'available_funds')
        account['used'] = self.safe_string(balance, 'maintenance_margin')
        account['total'] = self.safe_string(balance, 'equity')
        result[currencyCode] = account
        return self.safe_balance(result)

    def fetch_balance(self, params={}):
        """
        query for balance and get the amount of funds available for trading or funds locked in orders
        :param dict params: extra parameters specific to the deribit api endpoint
        :returns dict: a `balance structure <https://docs.ccxt.com/en/latest/manual.html?#balance-structure>`
        """
        self.load_markets()
        code = self.code_from_options('fetchBalance', params)
        currency = self.currency(code)
        request = {
            'currency': currency['id'],
        }
        response = self.privateGetGetAccountSummary(self.extend(request, params))
        #
        #     {
        #         jsonrpc: '2.0',
        #         result: {
        #             total_pl: 0,
        #             session_upl: 0,
        #             session_rpl: 0,
        #             session_funding: 0,
        #             portfolio_margining_enabled: False,
        #             options_vega: 0,
        #             options_theta: 0,
        #             options_session_upl: 0,
        #             options_session_rpl: 0,
        #             options_pl: 0,
        #             options_gamma: 0,
        #             options_delta: 0,
        #             margin_balance: 0.00062359,
        #             maintenance_margin: 0,
        #             limits: {
        #                 non_matching_engine_burst: 300,
        #                 non_matching_engine: 200,
        #                 matching_engine_burst: 20,
        #                 matching_engine: 2
        #             },
        #             initial_margin: 0,
        #             futures_session_upl: 0,
        #             futures_session_rpl: 0,
        #             futures_pl: 0,
        #             equity: 0.00062359,
        #             deposit_address: '13tUtNsJSZa1F5GeCmwBywVrymHpZispzw',
        #             delta_total: 0,
        #             currency: 'BTC',
        #             balance: 0.00062359,
        #             available_withdrawal_funds: 0.00062359,
        #             available_funds: 0.00062359
        #         },
        #         usIn: 1583775838115975,
        #         usOut: 1583775838116520,
        #         usDiff: 545,
        #         testnet: False
        #     }
        #
        result = self.safe_value(response, 'result', {})
        return self.parse_balance(result)

    def create_deposit_address(self, code, params={}):
        """
        create a currency deposit address
        :param str code: unified currency code of the currency for the deposit address
        :param dict params: extra parameters specific to the deribit api endpoint
        :returns dict: an `address structure <https://docs.ccxt.com/en/latest/manual.html#address-structure>`
        """
        self.load_markets()
        currency = self.currency(code)
        request = {
            'currency': currency['id'],
        }
        response = self.privateGetCreateDepositAddress(self.extend(request, params))
        #
        #     {
        #         'jsonrpc': '2.0',
        #         'id': 7538,
        #         'result': {
        #             'address': '2N8udZGBc1hLRCFsU9kGwMPpmYUwMFTuCwB',
        #             'creation_timestamp': 1550575165170,
        #             'currency': 'BTC',
        #             'type': 'deposit'
        #         }
        #     }
        #
        result = self.safe_value(response, 'result', {})
        address = self.safe_string(result, 'address')
        self.check_address(address)
        return {
            'currency': code,
            'address': address,
            'tag': None,
            'info': response,
        }

    def fetch_deposit_address(self, code, params={}):
        """
        fetch the deposit address for a currency associated with self account
        :param str code: unified currency code
        :param dict params: extra parameters specific to the deribit api endpoint
        :returns dict: an `address structure <https://docs.ccxt.com/en/latest/manual.html#address-structure>`
        """
        self.load_markets()
        currency = self.currency(code)
        request = {
            'currency': currency['id'],
        }
        response = self.privateGetGetCurrentDepositAddress(self.extend(request, params))
        #
        #     {
        #         jsonrpc: '2.0',
        #         result: {
        #             type: 'deposit',
        #             status: 'ready',
        #             requires_confirmation: True,
        #             currency: 'BTC',
        #             creation_timestamp: 1514694684651,
        #             address: '13tUtNsJSZa1F5GeCmwBywVrymHpZispzw'
        #         },
        #         usIn: 1583785137274288,
        #         usOut: 1583785137274454,
        #         usDiff: 166,
        #         testnet: False
        #     }
        #
        result = self.safe_value(response, 'result', {})
        address = self.safe_string(result, 'address')
        self.check_address(address)
        return {
            'currency': code,
            'address': address,
            'tag': None,
            'network': None,
            'info': response,
        }

    def parse_ticker(self, ticker, market=None):
        #
        # fetchTicker /public/ticker
        #
        #     {
        #         timestamp: 1583778859480,
        #         stats: {volume: 60627.57263769, low: 7631.5, high: 8311.5},
        #         state: 'open',
        #         settlement_price: 7903.21,
        #         open_interest: 111543850,
        #         min_price: 7634,
        #         max_price: 7866.51,
        #         mark_price: 7750.02,
        #         last_price: 7750.5,
        #         instrument_name: 'BTC-PERPETUAL',
        #         index_price: 7748.01,
        #         funding_8h: 0.0000026,
        #         current_funding: 0,
        #         best_bid_price: 7750,
        #         best_bid_amount: 19470,
        #         best_ask_price: 7750.5,
        #         best_ask_amount: 343280
        #     }
        #
        # fetchTicker /public/get_book_summary_by_instrument
        # fetchTickers /public/get_book_summary_by_currency
        #
        #     {
        #         volume: 124.1,
        #         underlying_price: 7856.445926872601,
        #         underlying_index: 'SYN.BTC-10MAR20',
        #         quote_currency: 'USD',
        #         open_interest: 121.8,
        #         mid_price: 0.01975,
        #         mark_price: 0.01984559,
        #         low: 0.0095,
        #         last: 0.0205,
        #         interest_rate: 0,
        #         instrument_name: 'BTC-10MAR20-7750-C',
        #         high: 0.0295,
        #         estimated_delivery_price: 7856.29,
        #         creation_timestamp: 1583783678366,
        #         bid_price: 0.0185,
        #         base_currency: 'BTC',
        #         ask_price: 0.021
        #     },
        #
        timestamp = self.safe_integer_2(ticker, 'timestamp', 'creation_timestamp')
        marketId = self.safe_string(ticker, 'instrument_name')
        symbol = self.safe_symbol(marketId, market)
        last = self.safe_string_2(ticker, 'last_price', 'last')
        stats = self.safe_value(ticker, 'stats', ticker)
        return self.safe_ticker({
            'symbol': symbol,
            'timestamp': timestamp,
            'datetime': self.iso8601(timestamp),
            'high': self.safe_string_2(stats, 'high', 'max_price'),
            'low': self.safe_string_2(stats, 'low', 'min_price'),
            'bid': self.safe_string_2(ticker, 'best_bid_price', 'bid_price'),
            'bidVolume': self.safe_string(ticker, 'best_bid_amount'),
            'ask': self.safe_string_2(ticker, 'best_ask_price', 'ask_price'),
            'askVolume': self.safe_string(ticker, 'best_ask_amount'),
            'vwap': None,
            'open': None,
            'close': last,
            'last': last,
            'previousClose': None,
            'change': None,
            'percentage': None,
            'average': None,
            'baseVolume': None,
            'quoteVolume': self.safe_string(stats, 'volume'),
            'info': ticker,
        }, market)

    def fetch_ticker(self, symbol, params={}):
        """
        fetches a price ticker, a statistical calculation with the information calculated over the past 24 hours for a specific market
        :param str symbol: unified symbol of the market to fetch the ticker for
        :param dict params: extra parameters specific to the deribit api endpoint
        :returns dict: a `ticker structure <https://docs.ccxt.com/en/latest/manual.html#ticker-structure>`
        """
        self.load_markets()
        market = self.market(symbol)
        request = {
            'instrument_name': market['id'],
        }
        response = self.publicGetTicker(self.extend(request, params))
        #
        #     {
        #         jsonrpc: '2.0',
        #         result: {
        #             timestamp: 1583778859480,
        #             stats: {volume: 60627.57263769, low: 7631.5, high: 8311.5},
        #             state: 'open',
        #             settlement_price: 7903.21,
        #             open_interest: 111543850,
        #             min_price: 7634,
        #             max_price: 7866.51,
        #             mark_price: 7750.02,
        #             last_price: 7750.5,
        #             instrument_name: 'BTC-PERPETUAL',
        #             index_price: 7748.01,
        #             funding_8h: 0.0000026,
        #             current_funding: 0,
        #             best_bid_price: 7750,
        #             best_bid_amount: 19470,
        #             best_ask_price: 7750.5,
        #             best_ask_amount: 343280
        #         },
        #         usIn: 1583778859483941,
        #         usOut: 1583778859484075,
        #         usDiff: 134,
        #         testnet: False
        #     }
        #
        result = self.safe_value(response, 'result')
        return self.parse_ticker(result, market)

    def fetch_tickers(self, symbols=None, params={}):
        """
        fetches price tickers for multiple markets, statistical calculations with the information calculated over the past 24 hours each market
        :param [str]|None symbols: unified symbols of the markets to fetch the ticker for, all market tickers are returned if not assigned
        :param dict params: extra parameters specific to the deribit api endpoint
        :returns dict: a dictionary of `ticker structures <https://docs.ccxt.com/en/latest/manual.html#ticker-structure>`
        """
        self.load_markets()
        symbols = self.market_symbols(symbols)
        code = self.code_from_options('fetchTickers', params)
        currency = self.currency(code)
        request = {
            'currency': currency['id'],
        }
        response = self.publicGetGetBookSummaryByCurrency(self.extend(request, params))
        #
        #     {
        #         jsonrpc: '2.0',
        #         result: [
        #             {
        #                 volume: 124.1,
        #                 underlying_price: 7856.445926872601,
        #                 underlying_index: 'SYN.BTC-10MAR20',
        #                 quote_currency: 'USD',
        #                 open_interest: 121.8,
        #                 mid_price: 0.01975,
        #                 mark_price: 0.01984559,
        #                 low: 0.0095,
        #                 last: 0.0205,
        #                 interest_rate: 0,
        #                 instrument_name: 'BTC-10MAR20-7750-C',
        #                 high: 0.0295,
        #                 estimated_delivery_price: 7856.29,
        #                 creation_timestamp: 1583783678366,
        #                 bid_price: 0.0185,
        #                 base_currency: 'BTC',
        #                 ask_price: 0.021
        #             },
        #         ],
        #         usIn: 1583783678361966,
        #         usOut: 1583783678372069,
        #         usDiff: 10103,
        #         testnet: False
        #     }
        #
        result = self.safe_value(response, 'result', [])
        tickers = {}
        for i in range(0, len(result)):
            ticker = self.parse_ticker(result[i])
            symbol = ticker['symbol']
            tickers[symbol] = ticker
        return self.filter_by_array(tickers, 'symbol', symbols)

    def fetch_ohlcv(self, symbol, timeframe='1m', since=None, limit=None, params={}):
        """
        fetches historical candlestick data containing the open, high, low, and close price, and the volume of a market
        :param str symbol: unified symbol of the market to fetch OHLCV data for
        :param str timeframe: the length of time each candle represents
        :param int|None since: timestamp in ms of the earliest candle to fetch
        :param int|None limit: the maximum amount of candles to fetch
        :param dict params: extra parameters specific to the deribit api endpoint
        :returns [[int]]: A list of candles ordered as timestamp, open, high, low, close, volume
        """
        self.load_markets()
        market = self.market(symbol)
        request = {
            'instrument_name': market['id'],
            'resolution': self.safe_string(self.timeframes, timeframe, timeframe),
        }
        duration = self.parse_timeframe(timeframe)
        now = self.milliseconds()
        if since is None:
            if limit is None:
                limit = 1000  # at max, it provides 5000 bars, but we set generous default here
            request['start_timestamp'] = now - (limit - 1) * duration * 1000
            request['end_timestamp'] = now
        else:
            request['start_timestamp'] = since
            if limit is None:
                request['end_timestamp'] = now
            else:
                request['end_timestamp'] = self.sum(since, limit * duration * 1000)
        response = self.publicGetGetTradingviewChartData(self.extend(request, params))
        #
        #     {
        #         jsonrpc: '2.0',
        #         result: {
        #             volume: [3.6680847969999992, 22.682721123, 3.011587939, 0],
        #             ticks: [1583916960000, 1583917020000, 1583917080000, 1583917140000],
        #             status: 'ok',
        #             open: [7834, 7839, 7833.5, 7833],
        #             low: [7834, 7833.5, 7832.5, 7833],
        #             high: [7839.5, 7839, 7833.5, 7833],
        #             cost: [28740, 177740, 23590, 0],
        #             close: [7839.5, 7833.5, 7833, 7833]
        #         },
        #         usIn: 1583917166709801,
        #         usOut: 1583917166710175,
        #         usDiff: 374,
        #         testnet: False
        #     }
        #
        result = self.safe_value(response, 'result', {})
        ohlcvs = self.convert_trading_view_to_ohlcv(result, 'ticks', 'open', 'high', 'low', 'close', 'volume', True)
        return self.parse_ohlcvs(ohlcvs, market, timeframe, since, limit)

    def parse_trade(self, trade, market=None):
        #
        # fetchTrades(public)
        #
        #      {
        #          "trade_seq":132564271,
        #          "trade_id":"195402220",
        #          "timestamp":1639684927932,
        #          "tick_direction":0,
        #          "price":47946.5,
        #          "mark_price":47944.13,
        #          "instrument_name":"BTC-PERPETUAL",
        #          "index_price":47925.45,
        #          "direction":"buy",
        #          "amount":580.0
        #      }
        #
        #
        # fetchMyTrades, fetchOrderTrades(private)
        #
        #     {
        #         "trade_seq": 3,
        #         "trade_id": "ETH-34066",
        #         "timestamp": 1550219814585,
        #         "tick_direction": 1,
        #         "state": "open",
        #         "self_trade": False,
        #         "reduce_only": False,
        #         "price": 0.04,
        #         "post_only": False,
        #         "order_type": "limit",
        #         "order_id": "ETH-334607",
        #         "matching_id": null,
        #         "liquidity": "M",
        #         "iv": 56.83,
        #         "instrument_name": "ETH-22FEB19-120-C",
        #         "index_price": 121.37,
        #         "fee_currency": "ETH",
        #         "fee": 0.0011,
        #         "direction": "buy",
        #         "amount": 11
        #     }
        #
        id = self.safe_string(trade, 'trade_id')
        marketId = self.safe_string(trade, 'instrument_name')
        symbol = self.safe_symbol(marketId, market)
        timestamp = self.safe_integer(trade, 'timestamp')
        side = self.safe_string(trade, 'direction')
        priceString = self.safe_string(trade, 'price')
        market = self.safe_market(marketId, market)
        # Amount for inverse perpetual and futures is in USD which in ccxt is the cost
        # For options amount and linear is in corresponding cryptocurrency contracts, e.g., BTC or ETH
        amount = self.safe_string(trade, 'amount')
        cost = Precise.string_mul(amount, priceString)
        if market['inverse']:
            cost = Precise.string_div(amount, priceString)
        liquidity = self.safe_string(trade, 'liquidity')
        takerOrMaker = None
        if liquidity is not None:
            # M = maker, T = taker, MT = both
            takerOrMaker = 'maker' if (liquidity == 'M') else 'taker'
        feeCostString = self.safe_string(trade, 'fee')
        fee = None
        if feeCostString is not None:
            feeCurrencyId = self.safe_string(trade, 'fee_currency')
            feeCurrencyCode = self.safe_currency_code(feeCurrencyId)
            fee = {
                'cost': feeCostString,
                'currency': feeCurrencyCode,
            }
        return self.safe_trade({
            'id': id,
            'info': trade,
            'timestamp': timestamp,
            'datetime': self.iso8601(timestamp),
            'symbol': symbol,
            'order': self.safe_string(trade, 'order_id'),
            'type': self.safe_string(trade, 'order_type'),
            'side': side,
            'takerOrMaker': takerOrMaker,
            'price': priceString,
            'amount': amount,
            'cost': cost,
            'fee': fee,
        }, market)

    def fetch_trades(self, symbol, since=None, limit=None, params={}):
        """
        see https://docs.deribit.com/#private-get_user_trades_by_currency
        get the list of most recent trades for a particular symbol.
        :param str symbol: unified symbol of the market to fetch trades for
        :param int|None since: timestamp in ms of the earliest trade to fetch
        :param int|None limit: the maximum amount of trades to fetch
        :param dict params: extra parameters specific to the deribit api endpoint
        :returns [dict]: a list of `trade structures <https://docs.ccxt.com/en/latest/manual.html?#public-trades>`
        """
        self.load_markets()
        market = self.market(symbol)
        request = {
            'instrument_name': market['id'],
            'include_old': True,
        }
        method = 'publicGetGetLastTradesByInstrument' if (since is None) else 'publicGetGetLastTradesByInstrumentAndTime'
        if since is not None:
            request['start_timestamp'] = since
        if limit is not None:
            request['count'] = limit  # default 10
        response = getattr(self, method)(self.extend(request, params))
        #
        #      {
        #          "jsonrpc":"2.0",
        #          "result": {
        #              "trades": [
        #                  {
        #                      "trade_seq":132564271,
        #                      "trade_id":"195402220",
        #                      "timestamp":1639684927932,
        #                      "tick_direction":0,
        #                      "price":47946.5,
        #                      "mark_price":47944.13,
        #                      "instrument_name":"BTC-PERPETUAL",
        #                      "index_price":47925.45,
        #                      "direction":"buy","amount":580.0
        #                  }
        #              ],
        #              "has_more":true
        #          },
        #          "usIn":1639684931934671,
        #          "usOut":1639684931935337,
        #          "usDiff":666,
        #          "testnet":false
        #      }
        #
        result = self.safe_value(response, 'result', {})
        trades = self.safe_value(result, 'trades', [])
        return self.parse_trades(trades, market, since, limit)

    def fetch_trading_fees(self, params={}):
        """
        fetch the trading fees for multiple markets
        :param dict params: extra parameters specific to the deribit api endpoint
        :returns dict: a dictionary of `fee structures <https://docs.ccxt.com/en/latest/manual.html#fee-structure>` indexed by market symbols
        """
        self.load_markets()
        code = self.code_from_options('fetchTradingFees', params)
        currency = self.currency(code)
        request = {
            'currency': currency['id'],
            'extended': True,
        }
        response = self.privateGetGetAccountSummary(self.extend(request, params))
        #
        #     {
        #         jsonrpc: '2.0',
        #         result: {
        #             total_pl: 0,
        #             session_upl: 0,
        #             session_rpl: 0,
        #             session_funding: 0,
        #             portfolio_margining_enabled: False,
        #             options_vega: 0,
        #             options_theta: 0,
        #             options_session_upl: 0,
        #             options_session_rpl: 0,
        #             options_pl: 0,
        #             options_gamma: 0,
        #             options_delta: 0,
        #             margin_balance: 0.00062359,
        #             maintenance_margin: 0,
        #             limits: {
        #                 non_matching_engine_burst: 300,
        #                 non_matching_engine: 200,
        #                 matching_engine_burst: 20,
        #                 matching_engine: 2
        #             },
        #             initial_margin: 0,
        #             futures_session_upl: 0,
        #             futures_session_rpl: 0,
        #             futures_pl: 0,
        #             equity: 0.00062359,
        #             deposit_address: '13tUtNsJSZa1F5GeCmwBywVrymHpZispzw',
        #             delta_total: 0,
        #             currency: 'BTC',
        #             balance: 0.00062359,
        #             available_withdrawal_funds: 0.00062359,
        #             available_funds: 0.00062359,
        #             fees: [
        #                 currency: '',
        #                 instrument_type: 'perpetual',
        #                 fee_type: 'relative',
        #                 maker_fee: 0,
        #                 taker_fee: 0,
        #             ],
        #         },
        #         usIn: 1583775838115975,
        #         usOut: 1583775838116520,
        #         usDiff: 545,
        #         testnet: False
        #     }
        #
        result = self.safe_value(response, 'result', {})
        fees = self.safe_value(result, 'fees', [])
        perpetualFee = {}
        futureFee = {}
        optionFee = {}
        for i in range(0, len(fees)):
            fee = fees[i]
            instrumentType = self.safe_string(fee, 'instrument_type')
            if instrumentType == 'future':
                futureFee = {
                    'info': fee,
                    'maker': self.safe_number(fee, 'maker_fee'),
                    'taker': self.safe_number(fee, 'taker_fee'),
                }
            elif instrumentType == 'perpetual':
                perpetualFee = {
                    'info': fee,
                    'maker': self.safe_number(fee, 'maker_fee'),
                    'taker': self.safe_number(fee, 'taker_fee'),
                }
            elif instrumentType == 'option':
                optionFee = {
                    'info': fee,
                    'maker': self.safe_number(fee, 'maker_fee'),
                    'taker': self.safe_number(fee, 'taker_fee'),
                }
        parsedFees = {}
        for i in range(0, len(self.symbols)):
            symbol = self.symbols[i]
            market = self.market(symbol)
            fee = {
                'info': market,
                'symbol': symbol,
                'percentage': True,
                'tierBased': True,
                'maker': market['maker'],
                'taker': market['taker'],
            }
            if market['swap']:
                fee = self.extend(fee, perpetualFee)
            elif market['future']:
                fee = self.extend(fee, futureFee)
            elif market['option']:
                fee = self.extend(fee, optionFee)
            parsedFees[symbol] = fee
        return parsedFees

    def fetch_order_book(self, symbol, limit=None, params={}):
        """
        fetches information on open orders with bid(buy) and ask(sell) prices, volumes and other data
        :param str symbol: unified symbol of the market to fetch the order book for
        :param int|None limit: the maximum amount of order book entries to return
        :param dict params: extra parameters specific to the deribit api endpoint
        :returns dict: A dictionary of `order book structures <https://docs.ccxt.com/en/latest/manual.html#order-book-structure>` indexed by market symbols
        """
        self.load_markets()
        market = self.market(symbol)
        request = {
            'instrument_name': market['id'],
        }
        if limit is not None:
            request['depth'] = limit
        response = self.publicGetGetOrderBook(self.extend(request, params))
        #
        #     {
        #         jsonrpc: '2.0',
        #         result: {
        #             timestamp: 1583781354740,
        #             stats: {volume: 61249.66735634, low: 7631.5, high: 8311.5},
        #             state: 'open',
        #             settlement_price: 7903.21,
        #             open_interest: 111536690,
        #             min_price: 7695.13,
        #             max_price: 7929.49,
        #             mark_price: 7813.06,
        #             last_price: 7814.5,
        #             instrument_name: 'BTC-PERPETUAL',
        #             index_price: 7810.12,
        #             funding_8h: 0.0000031,
        #             current_funding: 0,
        #             change_id: 17538025952,
        #             bids: [
        #                 [7814, 351820],
        #                 [7813.5, 207490],
        #                 [7813, 32160],
        #             ],
        #             best_bid_price: 7814,
        #             best_bid_amount: 351820,
        #             best_ask_price: 7814.5,
        #             best_ask_amount: 11880,
        #             asks: [
        #                 [7814.5, 11880],
        #                 [7815, 18100],
        #                 [7815.5, 2640],
        #             ],
        #         },
        #         usIn: 1583781354745804,
        #         usOut: 1583781354745932,
        #         usDiff: 128,
        #         testnet: False
        #     }
        #
        result = self.safe_value(response, 'result', {})
        timestamp = self.safe_integer(result, 'timestamp')
        nonce = self.safe_integer(result, 'change_id')
        orderbook = self.parse_order_book(result, market['symbol'], timestamp)
        orderbook['nonce'] = nonce
        return orderbook

    def parse_order_status(self, status):
        statuses = {
            'open': 'open',
            'cancelled': 'canceled',
            'filled': 'closed',
            'rejected': 'rejected',
            'untriggered': 'open',
        }
        return self.safe_string(statuses, status, status)

    def parse_time_in_force(self, timeInForce):
        timeInForces = {
            'good_til_cancelled': 'GTC',
            'fill_or_kill': 'FOK',
            'immediate_or_cancel': 'IOC',
        }
        return self.safe_string(timeInForces, timeInForce, timeInForce)

    def parse_order_type(self, orderType):
        orderTypes = {
            'stop_limit': 'limit',
            'take_limit': 'limit',
            'stop_market': 'market',
            'take_market': 'market',
        }
        return self.safe_string(orderTypes, orderType, orderType)

    def parse_order(self, order, market=None):
        #
        # createOrder
        #
        #     {
        #         "time_in_force": "good_til_cancelled",
        #         "reduce_only": False,
        #         "profit_loss": 0,
        #         "price": "market_price",
        #         "post_only": False,
        #         "order_type": "market",
        #         "order_state": "filled",
        #         "order_id": "ETH-349249",
        #         "max_show": 40,
        #         "last_update_timestamp": 1550657341322,
        #         "label": "market0000234",
        #         "is_liquidation": False,
        #         "instrument_name": "ETH-PERPETUAL",
        #         "filled_amount": 40,
        #         "direction": "buy",
        #         "creation_timestamp": 1550657341322,
        #         "commission": 0.000139,
        #         "average_price": 143.81,
        #         "api": True,
        #         "amount": 40,
        #         "trades": [],  # injected by createOrder
        #     }
        #
        marketId = self.safe_string(order, 'instrument_name')
        market = self.safe_market(marketId, market)
        timestamp = self.safe_integer(order, 'creation_timestamp')
        lastUpdate = self.safe_integer(order, 'last_update_timestamp')
        id = self.safe_string(order, 'order_id')
        priceString = self.safe_string(order, 'price')
        if priceString == 'market_price':
            priceString = None
        averageString = self.safe_string(order, 'average_price')
        # Inverse contracts amount is in USD which in ccxt is the cost
        # For options and Linear contracts amount is in corresponding cryptocurrency, e.g., BTC or ETH
        filledString = self.safe_string(order, 'filled_amount')
        amount = self.safe_string(order, 'amount')
        cost = Precise.string_mul(filledString, averageString)
        if market['inverse']:
            if self.parse_number(averageString) != 0:
                cost = Precise.string_div(amount, averageString)
        lastTradeTimestamp = None
        if filledString is not None:
            isFilledPositive = Precise.string_gt(filledString, '0')
            if isFilledPositive:
                lastTradeTimestamp = lastUpdate
        status = self.parse_order_status(self.safe_string(order, 'order_state'))
        side = self.safe_string_lower(order, 'direction')
        feeCostString = self.safe_string(order, 'commission')
        fee = None
        if feeCostString is not None:
            feeCostString = Precise.string_abs(feeCostString)
            fee = {
                'cost': feeCostString,
                'currency': market['base'],
            }
        rawType = self.safe_string(order, 'order_type')
        type = self.parse_order_type(rawType)
        # injected in createOrder
        trades = self.safe_value(order, 'trades')
        timeInForce = self.parse_time_in_force(self.safe_string(order, 'time_in_force'))
        stopPrice = self.safe_value(order, 'stop_price')
        postOnly = self.safe_value(order, 'post_only')
        return self.safe_order({
            'info': order,
            'id': id,
            'clientOrderId': None,
            'timestamp': timestamp,
            'datetime': self.iso8601(timestamp),
            'lastTradeTimestamp': lastTradeTimestamp,
            'symbol': market['symbol'],
            'type': type,
            'timeInForce': timeInForce,
            'postOnly': postOnly,
            'side': side,
            'price': priceString,
            'stopPrice': stopPrice,
            'triggerPrice': stopPrice,
            'amount': amount,
            'cost': cost,
            'average': averageString,
            'filled': filledString,
            'remaining': None,
            'status': status,
            'fee': fee,
            'trades': trades,
        }, market)

    def fetch_order(self, id, symbol=None, params={}):
        """
        fetches information on an order made by the user
        :param str|None symbol: unified symbol of the market the order was made in
        :param dict params: extra parameters specific to the deribit api endpoint
        :returns dict: An `order structure <https://docs.ccxt.com/en/latest/manual.html#order-structure>`
        """
        self.load_markets()
        request = {
            'order_id': id,
        }
        response = self.privateGetGetOrderState(self.extend(request, params))
        #
        #     {
        #         "jsonrpc": "2.0",
        #         "id": 4316,
        #         "result": {
        #             "time_in_force": "good_til_cancelled",
        #             "reduce_only": False,
        #             "profit_loss": 0.051134,
        #             "price": 118.94,
        #             "post_only": False,
        #             "order_type": "limit",
        #             "order_state": "filled",
        #             "order_id": "ETH-331562",
        #             "max_show": 37,
        #             "last_update_timestamp": 1550219810944,
        #             "label": "",
        #             "is_liquidation": False,
        #             "instrument_name": "ETH-PERPETUAL",
        #             "filled_amount": 37,
        #             "direction": "sell",
        #             "creation_timestamp": 1550219749176,
        #             "commission": 0.000031,
        #             "average_price": 118.94,
        #             "api": False,
        #             "amount": 37
        #         }
        #     }
        #
        result = self.safe_value(response, 'result')
        return self.parse_order(result)

    def create_order(self, symbol, type, side, amount, price=None, params={}):
        """
        create a trade order
        see https://docs.deribit.com/#private-buy
        :param str symbol: unified symbol of the market to create an order in
        :param str type: 'market' or 'limit'
        :param str side: 'buy' or 'sell'
        :param float amount: how much of currency you want to trade. For perpetual and futures the amount is in USD. For options it is in corresponding cryptocurrency contracts currency.
        :param float|None price: the price at which the order is to be fullfilled, in units of the quote currency, ignored in market orders
        :param dict params: extra parameters specific to the deribit api endpoint
        :returns dict: an `order structure <https://docs.ccxt.com/en/latest/manual.html#order-structure>`
        """
        self.load_markets()
        market = self.market(symbol)
        if market['inverse']:
            amount = self.amount_to_precision(symbol, amount)
        elif market['settle'] == 'USDC':
            amount = self.amount_to_precision(symbol, amount)
        else:
            amount = self.currency_to_precision(symbol, amount)
        request = {
            'instrument_name': market['id'],
            # for perpetual and futures the amount is in USD
            # for options it is in corresponding cryptocurrency contracts, e.g., BTC or ETH
            'amount': amount,
            'type': type,  # limit, stop_limit, market, stop_market, default is limit
            # 'label': 'string',  # user-defined label for the order(maximum 64 characters)
            # 'price': self.price_to_precision(symbol, 123.45),  # only for limit and stop_limit orders
            # 'time_in_force' : 'good_til_cancelled',  # fill_or_kill, immediate_or_cancel
            # 'max_show': 123.45,  # max amount within an order to be shown to other customers, 0 for invisible order
            # 'post_only': False,  # if the new price would cause the order to be filled immediately(as taker), the price will be changed to be just below the spread.
            # 'reject_post_only': False,  # if True the order is put to order book unmodified or request is rejected
            # 'reduce_only': False,  # if True, the order is intended to only reduce a current position
            # 'stop_price': False,  # stop price, required for stop_limit orders
            # 'trigger': 'index_price',  # mark_price, last_price, required for stop_limit orders
            # 'advanced': 'usd',  # 'implv', advanced option order type, options only
        }
        timeInForce = self.safe_string_upper(params, 'timeInForce')
        reduceOnly = self.safe_value_2(params, 'reduceOnly', 'reduce_only')
        # only stop loss sell orders are allowed when price crossed from above
        stopLossPrice = self.safe_value(params, 'stopLossPrice')
        # only take profit buy orders are allowed when price crossed from below
        takeProfitPrice = self.safe_value(params, 'takeProfitPrice')
        isStopLimit = type == 'stop_limit'
        isStopMarket = type == 'stop_market'
        isTakeLimit = type == 'take_limit'
        isTakeMarket = type == 'take_market'
        isStopLossOrder = isStopLimit or isStopMarket or (stopLossPrice is not None)
        isTakeProfitOrder = isTakeLimit or isTakeMarket or (takeProfitPrice is not None)
        if isStopLossOrder and isTakeProfitOrder:
            raise InvalidOrder(self.id + ' createOrder() only allows one of stopLossPrice or takeProfitPrice to be specified')
        isStopOrder = isStopLossOrder or isTakeProfitOrder
        isLimitOrder = (type == 'limit') or isStopLimit or isTakeLimit
        isMarketOrder = (type == 'market') or isStopMarket or isTakeMarket
        exchangeSpecificPostOnly = self.safe_value(params, 'post_only')
        postOnly = self.is_post_only(isMarketOrder, exchangeSpecificPostOnly, params)
        if isLimitOrder:
            request['type'] = 'limit'
            request['price'] = self.price_to_precision(symbol, price)
        else:
            request['type'] = 'market'
        if isStopOrder:
            triggerPrice = stopLossPrice if (stopLossPrice is not None) else takeProfitPrice
            request['trigger_price'] = self.price_to_precision(symbol, triggerPrice)
            request['trigger'] = 'last_price'  # required
            if isStopLossOrder:
                if isMarketOrder:
                    # stop_market(sell only)
                    request['type'] = 'stop_market'
                else:
                    # stop_limit(sell only)
                    request['type'] = 'stop_limit'
            else:
                if isMarketOrder:
                    # take_market(buy only)
                    request['type'] = 'take_market'
                else:
                    # take_limit(buy only)
                    request['type'] = 'take_limit'
        if reduceOnly:
            request['reduce_only'] = True
        if postOnly:
            request['post_only'] = True
            request['reject_post_only'] = True
        if timeInForce is not None:
            if timeInForce == 'GTC':
                request['time_in_force'] = 'good_til_cancelled'
            if timeInForce == 'IOC':
                request['time_in_force'] = 'immediate_or_cancel'
            if timeInForce == 'FOK':
                request['time_in_force'] = 'fill_or_kill'
        method = 'privateGet' + self.capitalize(side)
        params = self.omit(params, ['timeInForce', 'stopLossPrice', 'takeProfitPrice', 'postOnly', 'reduceOnly'])
        response = getattr(self, method)(self.extend(request, params))
        #
        #     {
        #         "jsonrpc": "2.0",
        #         "id": 5275,
        #         "result": {
        #             "trades": [
        #                 {
        #                     "trade_seq": 14151,
        #                     "trade_id": "ETH-37435",
        #                     "timestamp": 1550657341322,
        #                     "tick_direction": 2,
        #                     "state": "closed",
        #                     "self_trade": False,
        #                     "price": 143.81,
        #                     "order_type": "market",
        #                     "order_id": "ETH-349249",
        #                     "matching_id": null,
        #                     "liquidity": "T",
        #                     "label": "market0000234",
        #                     "instrument_name": "ETH-PERPETUAL",
        #                     "index_price": 143.73,
        #                     "fee_currency": "ETH",
        #                     "fee": 0.000139,
        #                     "direction": "buy",
        #                     "amount": 40
        #                 }
        #             ],
        #             "order": {
        #                 "time_in_force": "good_til_cancelled",
        #                 "reduce_only": False,
        #                 "profit_loss": 0,
        #                 "price": "market_price",
        #                 "post_only": False,
        #                 "order_type": "market",
        #                 "order_state": "filled",
        #                 "order_id": "ETH-349249",
        #                 "max_show": 40,
        #                 "last_update_timestamp": 1550657341322,
        #                 "label": "market0000234",
        #                 "is_liquidation": False,
        #                 "instrument_name": "ETH-PERPETUAL",
        #                 "filled_amount": 40,
        #                 "direction": "buy",
        #                 "creation_timestamp": 1550657341322,
        #                 "commission": 0.000139,
        #                 "average_price": 143.81,
        #                 "api": True,
        #                 "amount": 40
        #             }
        #         }
        #     }
        #
        result = self.safe_value(response, 'result', {})
        order = self.safe_value(result, 'order')
        trades = self.safe_value(result, 'trades', [])
        order['trades'] = trades
        return self.parse_order(order, market)

    def edit_order(self, id, symbol, type, side, amount=None, price=None, params={}):
        if amount is None:
            raise ArgumentsRequired(self.id + ' editOrder() requires an amount argument')
        if price is None:
            raise ArgumentsRequired(self.id + ' editOrder() requires a price argument')
        self.load_markets()
        request = {
            'order_id': id,
            # for perpetual and futures the amount is in USD
            # for options it is in corresponding cryptocurrency contracts, e.g., BTC or ETH
            'amount': self.amount_to_precision(symbol, amount),
            'price': self.price_to_precision(symbol, price),  # required
            # 'post_only': False,  # if the new price would cause the order to be filled immediately(as taker), the price will be changed to be just below the spread.
            # 'reject_post_only': False,  # if True the order is put to order book unmodified or request is rejected
            # 'reduce_only': False,  # if True, the order is intended to only reduce a current position
            # 'stop_price': False,  # stop price, required for stop_limit orders
            # 'advanced': 'usd',  # 'implv', advanced option order type, options only
        }
        response = self.privateGetEdit(self.extend(request, params))
        result = self.safe_value(response, 'result', {})
        order = self.safe_value(result, 'order')
        trades = self.safe_value(result, 'trades', [])
        order['trades'] = trades
        return self.parse_order(order)

    def cancel_order(self, id, symbol=None, params={}):
        """
        cancels an open order
        :param str id: order id
        :param str|None symbol: not used by deribit cancelOrder()
        :param dict params: extra parameters specific to the deribit api endpoint
        :returns dict: An `order structure <https://docs.ccxt.com/en/latest/manual.html#order-structure>`
        """
        self.load_markets()
        request = {
            'order_id': id,
        }
        response = self.privateGetCancel(self.extend(request, params))
        result = self.safe_value(response, 'result', {})
        return self.parse_order(result)

    def cancel_all_orders(self, symbol=None, params={}):
        """
        cancel all open orders
        :param str|None symbol: unified market symbol, only orders in the market of self symbol are cancelled when symbol is not None
        :param dict params: extra parameters specific to the deribit api endpoint
        :returns [dict]: a list of `order structures <https://docs.ccxt.com/en/latest/manual.html#order-structure>`
        """
        self.load_markets()
        request = {}
        method = None
        if symbol is None:
            method = 'privateGetCancelAll'
        else:
            method = 'privateGetCancelAllByInstrument'
            market = self.market(symbol)
            request['instrument_name'] = market['id']
        response = getattr(self, method)(self.extend(request, params))
        return response

    def fetch_open_orders(self, symbol=None, since=None, limit=None, params={}):
        """
        fetch all unfilled currently open orders
        :param str|None symbol: unified market symbol
        :param int|None since: the earliest time in ms to fetch open orders for
        :param int|None limit: the maximum number of  open orders structures to retrieve
        :param dict params: extra parameters specific to the deribit api endpoint
        :returns [dict]: a list of `order structures <https://docs.ccxt.com/en/latest/manual.html#order-structure>`
        """
        self.load_markets()
        request = {}
        market = None
        method = None
        if symbol is None:
            code = self.code_from_options('fetchOpenOrders', params)
            currency = self.currency(code)
            request['currency'] = currency['id']
            method = 'privateGetGetOpenOrdersByCurrency'
        else:
            market = self.market(symbol)
            request['instrument_name'] = market['id']
            method = 'privateGetGetOpenOrdersByInstrument'
        response = getattr(self, method)(self.extend(request, params))
        result = self.safe_value(response, 'result', [])
        return self.parse_orders(result, market, since, limit)

    def fetch_closed_orders(self, symbol=None, since=None, limit=None, params={}):
        """
        fetches information on multiple closed orders made by the user
        :param str|None symbol: unified market symbol of the market orders were made in
        :param int|None since: the earliest time in ms to fetch orders for
        :param int|None limit: the maximum number of  orde structures to retrieve
        :param dict params: extra parameters specific to the deribit api endpoint
        :returns [dict]: a list of `order structures <https://docs.ccxt.com/en/latest/manual.html#order-structure>`
        """
        self.load_markets()
        request = {}
        market = None
        method = None
        if symbol is None:
            code = self.code_from_options('fetchClosedOrders', params)
            currency = self.currency(code)
            request['currency'] = currency['id']
            method = 'privateGetGetOrderHistoryByCurrency'
        else:
            market = self.market(symbol)
            request['instrument_name'] = market['id']
            method = 'privateGetGetOrderHistoryByInstrument'
        response = getattr(self, method)(self.extend(request, params))
        result = self.safe_value(response, 'result', [])
        return self.parse_orders(result, market, since, limit)

    def fetch_order_trades(self, id, symbol=None, since=None, limit=None, params={}):
        """
        fetch all the trades made from a single order
        :param str id: order id
        :param str|None symbol: unified market symbol
        :param int|None since: the earliest time in ms to fetch trades for
        :param int|None limit: the maximum number of trades to retrieve
        :param dict params: extra parameters specific to the deribit api endpoint
        :returns [dict]: a list of `trade structures <https://docs.ccxt.com/en/latest/manual.html#trade-structure>`
        """
        self.load_markets()
        request = {
            'order_id': id,
        }
        response = self.privateGetGetUserTradesByOrder(self.extend(request, params))
        #
        #     {
        #         "jsonrpc": "2.0",
        #         "id": 9367,
        #         "result": {
        #             "trades": [
        #                 {
        #                     "trade_seq": 3,
        #                     "trade_id": "ETH-34066",
        #                     "timestamp": 1550219814585,
        #                     "tick_direction": 1,
        #                     "state": "open",
        #                     "self_trade": False,
        #                     "reduce_only": False,
        #                     "price": 0.04,
        #                     "post_only": False,
        #                     "order_type": "limit",
        #                     "order_id": "ETH-334607",
        #                     "matching_id": null,
        #                     "liquidity": "M",
        #                     "iv": 56.83,
        #                     "instrument_name": "ETH-22FEB19-120-C",
        #                     "index_price": 121.37,
        #                     "fee_currency": "ETH",
        #                     "fee": 0.0011,
        #                     "direction": "buy",
        #                     "amount": 11
        #                 },
        #             ],
        #             "has_more": True
        #         }
        #     }
        #
        result = self.safe_value(response, 'result', {})
        return self.parse_trades(result, None, since, limit)

    def fetch_my_trades(self, symbol=None, since=None, limit=None, params={}):
        """
        fetch all trades made by the user
        :param str|None symbol: unified market symbol
        :param int|None since: the earliest time in ms to fetch trades for
        :param int|None limit: the maximum number of trades structures to retrieve
        :param dict params: extra parameters specific to the deribit api endpoint
        :returns [dict]: a list of `trade structures <https://docs.ccxt.com/en/latest/manual.html#trade-structure>`
        """
        self.load_markets()
        request = {
            'include_old': True,
        }
        market = None
        method = None
        if symbol is None:
            code = self.code_from_options('fetchMyTrades', params)
            currency = self.currency(code)
            request['currency'] = currency['id']
            if since is None:
                method = 'privateGetGetUserTradesByCurrency'
            else:
                method = 'privateGetGetUserTradesByCurrencyAndTime'
                request['start_timestamp'] = since
        else:
            market = self.market(symbol)
            request['instrument_name'] = market['id']
            if since is None:
                method = 'privateGetGetUserTradesByInstrument'
            else:
                method = 'privateGetGetUserTradesByInstrumentAndTime'
                request['start_timestamp'] = since
        if limit is not None:
            request['count'] = limit  # default 10
        response = getattr(self, method)(self.extend(request, params))
        #
        #     {
        #         "jsonrpc": "2.0",
        #         "id": 9367,
        #         "result": {
        #             "trades": [
        #                 {
        #                     "trade_seq": 3,
        #                     "trade_id": "ETH-34066",
        #                     "timestamp": 1550219814585,
        #                     "tick_direction": 1,
        #                     "state": "open",
        #                     "self_trade": False,
        #                     "reduce_only": False,
        #                     "price": 0.04,
        #                     "post_only": False,
        #                     "order_type": "limit",
        #                     "order_id": "ETH-334607",
        #                     "matching_id": null,
        #                     "liquidity": "M",
        #                     "iv": 56.83,
        #                     "instrument_name": "ETH-22FEB19-120-C",
        #                     "index_price": 121.37,
        #                     "fee_currency": "ETH",
        #                     "fee": 0.0011,
        #                     "direction": "buy",
        #                     "amount": 11
        #                 },
        #             ],
        #             "has_more": True
        #         }
        #     }
        #
        result = self.safe_value(response, 'result', {})
        trades = self.safe_value(result, 'trades', [])
        return self.parse_trades(trades, market, since, limit)

    def fetch_deposits(self, code=None, since=None, limit=None, params={}):
        """
        fetch all deposits made to an account
        :param str code: unified currency code
        :param int|None since: the earliest time in ms to fetch deposits for
        :param int|None limit: the maximum number of deposits structures to retrieve
        :param dict params: extra parameters specific to the deribit api endpoint
        :returns [dict]: a list of `transaction structures <https://docs.ccxt.com/en/latest/manual.html#transaction-structure>`
        """
        if code is None:
            raise ArgumentsRequired(self.id + ' fetchDeposits() requires a currency code argument')
        self.load_markets()
        currency = self.currency(code)
        request = {
            'currency': currency['id'],
        }
        if limit is not None:
            request['count'] = limit
        response = self.privateGetGetDeposits(self.extend(request, params))
        #
        #     {
        #         "jsonrpc": "2.0",
        #         "id": 5611,
        #         "result": {
        #             "count": 1,
        #             "data": [
        #                 {
        #                     "address": "2N35qDKDY22zmJq9eSyiAerMD4enJ1xx6ax",
        #                     "amount": 5,
        #                     "currency": "BTC",
        #                     "received_timestamp": 1549295017670,
        #                     "state": "completed",
        #                     "transaction_id": "230669110fdaf0a0dbcdc079b6b8b43d5af29cc73683835b9bc6b3406c065fda",
        #                     "updated_timestamp": 1549295130159
        #                 }
        #             ]
        #         }
        #     }
        #
        result = self.safe_value(response, 'result', {})
        data = self.safe_value(result, 'data', [])
        return self.parse_transactions(data, currency, since, limit, params)

    def fetch_withdrawals(self, code=None, since=None, limit=None, params={}):
        """
        fetch all withdrawals made from an account
        :param str code: unified currency code
        :param int|None since: the earliest time in ms to fetch withdrawals for
        :param int|None limit: the maximum number of withdrawals structures to retrieve
        :param dict params: extra parameters specific to the deribit api endpoint
        :returns [dict]: a list of `transaction structures <https://docs.ccxt.com/en/latest/manual.html#transaction-structure>`
        """
        if code is None:
            raise ArgumentsRequired(self.id + ' fetchWithdrawals() requires a currency code argument')
        self.load_markets()
        currency = self.currency(code)
        request = {
            'currency': currency['id'],
        }
        if limit is not None:
            request['count'] = limit
        response = self.privateGetGetWithdrawals(self.extend(request, params))
        #
        #     {
        #         "jsonrpc": "2.0",
        #         "id": 2745,
        #         "result": {
        #             "count": 1,
        #             "data": [
        #                 {
        #                     "address": "2NBqqD5GRJ8wHy1PYyCXTe9ke5226FhavBz",
        #                     "amount": 0.5,
        #                     "confirmed_timestamp": null,
        #                     "created_timestamp": 1550571443070,
        #                     "currency": "BTC",
        #                     "fee": 0.0001,
        #                     "id": 1,
        #                     "priority": 0.15,
        #                     "state": "unconfirmed",
        #                     "transaction_id": null,
        #                     "updated_timestamp": 1550571443070
        #                 }
        #             ]
        #         }
        #     }
        #
        result = self.safe_value(response, 'result', {})
        data = self.safe_value(result, 'data', [])
        return self.parse_transactions(data, currency, since, limit, params)

    def parse_transaction_status(self, status):
        statuses = {
            'completed': 'ok',
            'unconfirmed': 'pending',
        }
        return self.safe_string(statuses, status, status)

    def parse_transaction(self, transaction, currency=None):
        #
        # fetchWithdrawals
        #
        #     {
        #         "address": "2NBqqD5GRJ8wHy1PYyCXTe9ke5226FhavBz",
        #         "amount": 0.5,
        #         "confirmed_timestamp": null,
        #         "created_timestamp": 1550571443070,
        #         "currency": "BTC",
        #         "fee": 0.0001,
        #         "id": 1,
        #         "priority": 0.15,
        #         "state": "unconfirmed",
        #         "transaction_id": null,
        #         "updated_timestamp": 1550571443070
        #     }
        #
        # fetchDeposits
        #
        #     {
        #         "address": "2N35qDKDY22zmJq9eSyiAerMD4enJ1xx6ax",
        #         "amount": 5,
        #         "currency": "BTC",
        #         "received_timestamp": 1549295017670,
        #         "state": "completed",
        #         "transaction_id": "230669110fdaf0a0dbcdc079b6b8b43d5af29cc73683835b9bc6b3406c065fda",
        #         "updated_timestamp": 1549295130159
        #     }
        #
        currencyId = self.safe_string(transaction, 'currency')
        code = self.safe_currency_code(currencyId, currency)
        timestamp = self.safe_integer_2(transaction, 'created_timestamp', 'received_timestamp')
        updated = self.safe_integer(transaction, 'updated_timestamp')
        status = self.parse_transaction_status(self.safe_string(transaction, 'state'))
        address = self.safe_string(transaction, 'address')
        feeCost = self.safe_number(transaction, 'fee')
        type = 'deposit'
        fee = None
        if feeCost is not None:
            type = 'withdrawal'
            fee = {
                'cost': feeCost,
                'currency': code,
            }
        return {
            'info': transaction,
            'id': self.safe_string(transaction, 'id'),
            'txid': self.safe_string(transaction, 'transaction_id'),
            'timestamp': timestamp,
            'datetime': self.iso8601(timestamp),
            'address': address,
            'addressTo': address,
            'addressFrom': None,
            'tag': None,
            'tagTo': None,
            'tagFrom': None,
            'type': type,
            'amount': self.safe_number(transaction, 'amount'),
            'currency': code,
            'status': status,
            'updated': updated,
            'fee': fee,
        }

    def parse_position(self, position, market=None):
        #
        #     {
        #         "jsonrpc": "2.0",
        #         "id": 404,
        #         "result": {
        #             "average_price": 0,
        #             "delta": 0,
        #             "direction": "buy",
        #             "estimated_liquidation_price": 0,
        #             "floating_profit_loss": 0,
        #             "index_price": 3555.86,
        #             "initial_margin": 0,
        #             "instrument_name": "BTC-PERPETUAL",
        #             "leverage": 100,
        #             "kind": "future",
        #             "maintenance_margin": 0,
        #             "mark_price": 3556.62,
        #             "open_orders_margin": 0.000165889,
        #             "realized_profit_loss": 0,
        #             "settlement_price": 3555.44,
        #             "size": 0,
        #             "size_currency": 0,
        #             "total_profit_loss": 0
        #         }
        #     }
        #
        contract = self.safe_string(position, 'instrument_name')
        market = self.safe_market(contract, market)
        side = self.safe_string(position, 'direction')
        side = 'long' if (side == 'buy') else 'short'
        unrealizedPnl = self.safe_string(position, 'floating_profit_loss')
        initialMarginString = self.safe_string(position, 'initial_margin')
        notionalString = self.safe_string(position, 'size_currency')
        maintenanceMarginString = self.safe_string(position, 'maintenance_margin')
        percentage = Precise.string_mul(Precise.string_div(unrealizedPnl, initialMarginString), '100')
        currentTime = self.milliseconds()
        return {
            'info': position,
            'id': None,
            'symbol': self.safe_string(market, 'symbol'),
            'timestamp': currentTime,
            'datetime': self.iso8601(currentTime),
            'initialMargin': self.parse_number(initialMarginString),
            'initialMarginPercentage': self.parse_number(Precise.string_mul(Precise.string_div(initialMarginString, notionalString), '100')),
            'maintenanceMargin': self.parse_number(maintenanceMarginString),
            'maintenanceMarginPercentage': self.parse_number(Precise.string_mul(Precise.string_div(maintenanceMarginString, notionalString), '100')),
            'entryPrice': self.safe_number(position, 'average_price'),
            'notional': self.parse_number(notionalString),
            'leverage': self.safe_integer(position, 'leverage'),
            'unrealizedPnl': self.parse_number(unrealizedPnl),
            'contracts': None,
            'contractSize': self.safe_number(market, 'contractSize'),
            'marginRatio': None,
            'liquidationPrice': self.safe_number(position, 'estimated_liquidation_price'),
            'markPrice': self.safe_number(position, 'mark_price'),
            'collateral': None,
            'marginMode': None,
            'side': side,
            'percentage': self.parse_number(percentage),
        }

    def fetch_position(self, symbol, params={}):
        """
        fetch data on a single open contract trade position
        :param str symbol: unified market symbol of the market the position is held in, default is None
        :param dict params: extra parameters specific to the deribit api endpoint
        :returns dict: a `position structure <https://docs.ccxt.com/en/latest/manual.html#position-structure>`
        """
        self.load_markets()
        market = self.market(symbol)
        request = {
            'instrument_name': market['id'],
        }
        response = self.privateGetGetPosition(self.extend(request, params))
        #
        #     {
        #         "jsonrpc": "2.0",
        #         "id": 404,
        #         "result": {
        #             "average_price": 0,
        #             "delta": 0,
        #             "direction": "buy",
        #             "estimated_liquidation_price": 0,
        #             "floating_profit_loss": 0,
        #             "index_price": 3555.86,
        #             "initial_margin": 0,
        #             "instrument_name": "BTC-PERPETUAL",
        #             "leverage": 100,
        #             "kind": "future",
        #             "maintenance_margin": 0,
        #             "mark_price": 3556.62,
        #             "open_orders_margin": 0.000165889,
        #             "realized_profit_loss": 0,
        #             "settlement_price": 3555.44,
        #             "size": 0,
        #             "size_currency": 0,
        #             "total_profit_loss": 0
        #         }
        #     }
        #
        result = self.safe_value(response, 'result')
        return self.parse_position(result)

    def fetch_positions(self, symbols=None, params={}):
        """
        fetch all open positions
        :param [str]|None symbols: list of unified market symbols
        :param dict params: extra parameters specific to the deribit api endpoint
        :returns [dict]: a list of `position structure <https://docs.ccxt.com/en/latest/manual.html#position-structure>`
        """
        self.load_markets()
        code = None
        if symbols is None:
            code = self.code_from_options('fetchPositions', params)
        elif isinstance(symbols, str):
            code = symbols
            symbols = None  # fix https://github.com/ccxt/ccxt/issues/13961
        else:
            if isinstance(symbols, list):
                length = len(symbols)
                if length != 1:
                    raise BadRequest(self.id + ' fetchPositions() symbols argument cannot contain more than 1 symbol')
                market = self.market(symbols[0])
                code = market['base']
        currency = self.currency(code)
        request = {
            'currency': currency['id'],
            # "kind" : "future", "option"
        }
        response = self.privateGetGetPositions(self.extend(request, params))
        #
        #     {
        #         "jsonrpc": "2.0",
        #         "id": 2236,
        #         "result": [
        #             {
        #                 "average_price": 7440.18,
        #                 "delta": 0.006687487,
        #                 "direction": "buy",
        #                 "estimated_liquidation_price": 1.74,
        #                 "floating_profit_loss": 0,
        #                 "index_price": 7466.79,
        #                 "initial_margin": 0.000197283,
        #                 "instrument_name": "BTC-PERPETUAL",
        #                 "kind": "future",
        #                 "leverage": 34,
        #                 "maintenance_margin": 0.000143783,
        #                 "mark_price": 7476.65,
        #                 "open_orders_margin": 0.000197288,
        #                 "realized_funding": -1e-8,
        #                 "realized_profit_loss": -9e-9,
        #                 "settlement_price": 7476.65,
        #                 "size": 50,
        #                 "size_currency": 0.006687487,
        #                 "total_profit_loss": 0.000032781
        #             },
        #         ]
        #     }
        #
        result = self.safe_value(response, 'result')
        return self.parse_positions(result, symbols)

    def fetch_historical_volatility(self, code, params={}):
        self.load_markets()
        currency = self.currency(code)
        request = {
            'currency': currency['id'],
        }
        response = self.publicGetGetHistoricalVolatility(self.extend(request, params))
        #
        #     {
        #         "jsonrpc": "2.0",
        #         "result": [
        #             [1640142000000,63.828320460740585],
        #             [1640142000000,63.828320460740585],
        #             [1640145600000,64.03821964123213]
        #         ],
        #         "usIn": 1641515379467734,
        #         "usOut": 1641515379468095,
        #         "usDiff": 361,
        #         "testnet": False
        #     }
        #
        volatilityResult = self.safe_value(response, 'result', {})
        result = []
        for i in range(0, len(volatilityResult)):
            timestamp = self.safe_integer(volatilityResult[i], 0)
            volatility = self.safe_number(volatilityResult[i], 1)
            result.append({
                'info': response,
                'timestamp': timestamp,
                'datetime': self.iso8601(timestamp),
                'volatility': volatility,
            })
        return result

    def fetch_transfers(self, code=None, since=None, limit=None, params={}):
        """
        fetch a history of internal transfers made on an account
        :param str code: unified currency code of the currency transferred
        :param int|None since: the earliest time in ms to fetch transfers for
        :param int|None limit: the maximum number of  transfers structures to retrieve
        :param dict params: extra parameters specific to the deribit api endpoint
        :returns [dict]: a list of `transfer structures <https://docs.ccxt.com/en/latest/manual.html#transfer-structure>`
        """
        if code is None:
            raise ArgumentsRequired(self.id + ' fetchTransfers() requires a currency code argument')
        self.load_markets()
        currency = self.currency(code)
        request = {
            'currency': currency['id'],
        }
        if limit is not None:
            request['count'] = limit
        response = self.privateGetGetTransfers(self.extend(request, params))
        #
        #     {
        #         "jsonrpc": "2.0",
        #         "id": 7606,
        #         "result": {
        #             "count": 2,
        #             "data": [
        #                 {
        #                     "amount": 0.2,
        #                     "created_timestamp": 1550579457727,
        #                     "currency": "BTC",
        #                     "direction": "payment",
        #                     "id": 2,
        #                     "other_side": "2MzyQc5Tkik61kJbEpJV5D5H9VfWHZK9Sgy",
        #                     "state": "prepared",
        #                     "type": "user",
        #                     "updated_timestamp": 1550579457727
        #                 },
        #                 {
        #                     "amount": 0.3,
        #                     "created_timestamp": 1550579255800,
        #                     "currency": "BTC",
        #                     "direction": "payment",
        #                     "id": 1,
        #                     "other_side": "new_user_1_1",
        #                     "state": "confirmed",
        #                     "type": "subaccount",
        #                     "updated_timestamp": 1550579255800
        #                 }
        #             ]
        #         }
        #     }
        #
        result = self.safe_value(response, 'result', {})
        transfers = self.safe_value(result, 'data', [])
        return self.parse_transfers(transfers, currency, since, limit, params)

    def transfer(self, code, amount, fromAccount, toAccount, params={}):
        """
        transfer currency internally between wallets on the same account
        :param str code: unified currency code
        :param float amount: amount to transfer
        :param str fromAccount: account to transfer from
        :param str toAccount: account to transfer to
        :param dict params: extra parameters specific to the deribit api endpoint
        :returns dict: a `transfer structure <https://docs.ccxt.com/en/latest/manual.html#transfer-structure>`
        """
        self.load_markets()
        currency = self.currency(code)
        request = {
            'amount': amount,
            'currency': currency['id'],
            'destination': toAccount,
        }
        method = self.safe_string(params, 'method')
        params = self.omit(params, 'method')
        if method is None:
            transferOptions = self.safe_value(self.options, 'transfer', {})
            method = self.safe_string(transferOptions, 'method', 'privateGetSubmitTransferToSubaccount')
        response = getattr(self, method)(self.extend(request, params))
        #
        #     {
        #         "jsonrpc": "2.0",
        #         "id": 9421,
        #         "result": {
        #             "updated_timestamp": 1550232862350,
        #             "type": "user",
        #             "state": "prepared",
        #             "other_side": "0x4aa0753d798d668056920094d65321a8e8913e26",
        #             "id": 3,
        #             "direction": "payment",
        #             "currency": "ETH",
        #             "created_timestamp": 1550232862350,
        #             "amount": 13.456
        #         }
        #     }
        #
        result = self.safe_value(response, 'result', {})
        return self.parse_transfer(result, currency)

    def parse_transfer(self, transfer, currency=None):
        #
        #     {
        #         "updated_timestamp": 1550232862350,
        #         "type": "user",
        #         "state": "prepared",
        #         "other_side": "0x4aa0753d798d668056920094d65321a8e8913e26",
        #         "id": 3,
        #         "direction": "payment",
        #         "currency": "ETH",
        #         "created_timestamp": 1550232862350,
        #         "amount": 13.456
        #     }
        #
        timestamp = self.safe_timestamp(transfer, 'created_timestamp')
        status = self.safe_string(transfer, 'state')
        account = self.safe_string(transfer, 'other_side')
        direction = self.safe_string(transfer, 'direction')
        currencyId = self.safe_string(transfer, 'currency')
        return {
            'info': transfer,
            'id': self.safe_string(transfer, 'id'),
            'status': self.parse_transfer_status(status),
            'amount': self.safe_number(transfer, 'amount'),
            'code': self.safe_currency_code(currencyId, currency),
            'fromAccount': direction != account if 'payment' else None,
            'toAccount': direction == account if 'payment' else None,
            'timestamp': timestamp,
            'datetime': self.iso8601(timestamp),
        }

    def parse_transfer_status(self, status):
        statuses = {
            'prepared': 'pending',
            'confirmed': 'ok',
            'cancelled': 'cancelled',
            'waiting_for_admin': 'pending',
        }
        return self.safe_string(statuses, status, status)

    def withdraw(self, code, amount, address, tag=None, params={}):
        """
        make a withdrawal
        :param str code: unified currency code
        :param float amount: the amount to withdraw
        :param str address: the address to withdraw to
        :param str|None tag:
        :param dict params: extra parameters specific to the deribit api endpoint
        :returns dict: a `transaction structure <https://docs.ccxt.com/en/latest/manual.html#transaction-structure>`
        """
        tag, params = self.handle_withdraw_tag_and_params(tag, params)
        self.check_address(address)
        self.load_markets()
        currency = self.currency(code)
        request = {
            'currency': currency['id'],
            'address': address,  # must be in the address book
            'amount': amount,
            # 'priority': 'high',  # low, mid, high, very_high, extreme_high, insane
            # 'tfa': '123456',  # if enabled
        }
        if self.twofa is not None:
            request['tfa'] = self.oath()
        response = self.privateGetWithdraw(self.extend(request, params))
        return self.parse_transaction(response, currency)

    def nonce(self):
        return self.milliseconds()

    def sign(self, path, api='public', method='GET', params={}, headers=None, body=None):
        request = '/' + 'api/' + self.version + '/' + api + '/' + path
        if api == 'public':
            if params:
                request += '?' + self.urlencode(params)
        if api == 'private':
            self.check_required_credentials()
            nonce = str(self.nonce())
            timestamp = str(self.milliseconds())
            requestBody = ''
            if params:
                request += '?' + self.urlencode(params)
            requestData = method + "\n" + request + "\n" + requestBody + "\n"  # eslint-disable-line quotes
            auth = timestamp + "\n" + nonce + "\n" + requestData  # eslint-disable-line quotes
            signature = self.hmac(self.encode(auth), self.encode(self.secret), hashlib.sha256)
            headers = {
                'Authorization': 'deri-hmac-sha256 id=' + self.apiKey + ',ts=' + timestamp + ',sig=' + signature + ',' + 'nonce=' + nonce,
            }
        url = self.urls['api']['rest'] + request
        return {'url': url, 'method': method, 'body': body, 'headers': headers}

    def handle_errors(self, httpCode, reason, url, method, headers, body, response, requestHeaders, requestBody):
        if not response:
            return  # fallback to default error handler
        #
        #     {
        #         jsonrpc: '2.0',
        #         error: {
        #             message: 'Invalid params',
        #             data: {reason: 'invalid currency', param: 'currency'},
        #             code: -32602
        #         },
        #         testnet: False,
        #         usIn: 1583763842150374,
        #         usOut: 1583763842150410,
        #         usDiff: 36
        #     }
        #
        error = self.safe_value(response, 'error')
        if error is not None:
            errorCode = self.safe_string(error, 'code')
            feedback = self.id + ' ' + body
            self.throw_exactly_matched_exception(self.exceptions, errorCode, feedback)
            raise ExchangeError(feedback)  # unknown message
