"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CanaryCodeBundler = void 0;
const child_process_1 = require("child_process");
const fs = require("fs");
const path = require("path");
const PACKAGE_JSON_PATTERN = /^package\.json$/;
const SOURCE_JS_PATTERN = /^.+\.js$/;
class CanaryCodeBundler {
    constructor(codePath) {
        this.codePath = codePath;
        const codePathStats = fs.lstatSync(this.codePath);
        if (!codePathStats.isDirectory) {
            throw new Error(`Invalid codePath: ${this.codePath}`);
        }
    }
    copy(pattern, outputDir) {
        const outputDirStats = fs.lstatSync(outputDir);
        if (!outputDirStats.isDirectory) {
            throw new Error(`Invalid outputDir: ${outputDir}`);
        }
        fs.readdirSync(this.codePath)
            .filter(f => f.match(pattern))
            .forEach(f => {
            fs.copyFileSync(`${this.codePath}/${f}`, `${outputDir}/${f}`);
        });
    }
    tryBundle(outputDir, _options) {
        fs.mkdirSync(`${outputDir}/nodejs`);
        this.copy(PACKAGE_JSON_PATTERN, `${outputDir}/nodejs`);
        child_process_1.execSync('npm install', { cwd: `${outputDir}/nodejs` });
        this.copy(SOURCE_JS_PATTERN, `${outputDir}/nodejs/node_modules`);
        return true;
    }
    toJSON() {
        return {
            codePath: path.relative(__dirname, this.codePath),
        };
    }
}
exports.CanaryCodeBundler = CanaryCodeBundler;
//# sourceMappingURL=data:application/json;base64,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