/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.data.value;

import brut.androlib.AndrolibException;
import brut.androlib.res.data.ResResource;
import brut.androlib.res.data.value.ResBagValue;
import brut.androlib.res.data.value.ResReferenceValue;
import brut.androlib.res.data.value.ResScalarValue;
import brut.util.Duo;
import java.io.IOException;
import java.util.Arrays;
import org.xmlpull.v1.XmlSerializer;

public class ResArrayValue
extends ResBagValue {
    private final ResScalarValue[] mItems;
    private final String[] AllowedArrayTypes = new String[]{"string", "integer"};

    ResArrayValue(ResReferenceValue parent, Duo<Integer, ResScalarValue>[] items) {
        super(parent);
        this.mItems = new ResScalarValue[items.length];
        for (int i = 0; i < items.length; ++i) {
            this.mItems[i] = (ResScalarValue)items[i].m2;
        }
    }

    @Override
    public void serializeToResValuesXml(XmlSerializer serializer, ResResource res) throws IOException, AndrolibException {
        String type = this.getType();
        type = (type == null ? "" : type + "-") + "array";
        serializer.startTag(null, type);
        serializer.attribute(null, "name", res.getResSpec().getName());
        for (ResScalarValue item : this.mItems) {
            if (!item.hasMultipleNonPositionalSubstitutions()) continue;
            serializer.attribute(null, "formatted", "false");
            break;
        }
        for (ResScalarValue mItem : this.mItems) {
            serializer.startTag(null, "item");
            serializer.text(mItem.encodeAsResXmlNonEscapedItemValue());
            serializer.endTag(null, "item");
        }
        serializer.endTag(null, type);
    }

    public String getType() throws AndrolibException {
        if (this.mItems.length == 0) {
            return null;
        }
        String type = this.mItems[0].getType();
        for (ResScalarValue mItem : this.mItems) {
            if (mItem.encodeAsResXmlItemValue().startsWith("@string")) {
                return "string";
            }
            if (mItem.encodeAsResXmlItemValue().startsWith("@drawable")) {
                return null;
            }
            if (mItem.encodeAsResXmlItemValue().startsWith("@integer")) {
                return "integer";
            }
            if (!"string".equals(type) && !"integer".equals(type)) {
                return null;
            }
            if (type.equals(mItem.getType())) continue;
            return null;
        }
        if (!Arrays.asList(this.AllowedArrayTypes).contains(type)) {
            return "string";
        }
        return type;
    }
}

