"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Secret = void 0;
const base_1 = require("./base");
const k8s = require("./imports/k8s");
/**
 * Kubernetes Secrets let you store and manage sensitive information, such as
 * passwords, OAuth tokens, and ssh keys. Storing confidential information in a
 * Secret is safer and more flexible than putting it verbatim in a Pod
 * definition or in a container image.
 *
 * @see https://kubernetes.io/docs/concepts/configuration/secret
 */
class Secret extends base_1.Resource {
    constructor(scope, id, props = {}) {
        var _a;
        super(scope, id, props);
        this.stringData = (_a = props.stringData) !== null && _a !== void 0 ? _a : {};
        this.apiObject = new k8s.Secret(this, 'Secret', {
            metadata: props.metadata,
            stringData: this.stringData,
        });
    }
    /**
     * Imports a secret from the cluster as a reference.
     * @param name The name of the secret to reference.
     */
    static fromSecretName(name) {
        return { name };
    }
    /**
     * Adds a string data field to the secert.
     * @param key Key
     * @param value Value
     */
    addStringData(key, value) {
        this.stringData[key] = value;
    }
    /**
     * Gets a string data by key or undefined
     * @param key Key
     */
    getStringData(key) {
        return this.stringData[key];
    }
}
exports.Secret = Secret;
//# sourceMappingURL=data:application/json;base64,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