# -*- coding: utf-8 -*-
# Generated by Django 1.9 on 2017-02-03 11:30
from __future__ import unicode_literals

from django.db import migrations, models
from django.utils.text import slugify


def migrate_views(apps, schema_editor):

    View = apps.get_model('views', 'view')

    for view in View.objects.all():
        view.title_en = view.key
        view.title_de = view.key
        view.key = slugify(view.key)
        view.save()


class Migration(migrations.Migration):

    dependencies = [
        ('views', '0006_title_and_help'),
    ]

    operations = [
        migrations.RunPython(migrate_views),
    ]
