from django.db import models

from rdmo.core.managers import (AvailabilityManagerMixin,
                                AvailabilityQuerySetMixin,
                                CurrentSiteManagerMixin,
                                CurrentSiteQuerySetMixin, GroupsManagerMixin,
                                GroupsQuerySetMixin)


class TaskQuestionSet(CurrentSiteQuerySetMixin, GroupsQuerySetMixin, AvailabilityQuerySetMixin, models.QuerySet):

    def filter_catalog(self, catalog):
        return self.filter(models.Q(catalogs=None) | models.Q(catalogs=catalog))


class TaskManager(CurrentSiteManagerMixin, GroupsManagerMixin, AvailabilityManagerMixin, models.Manager):

    def get_queryset(self):
        return TaskQuestionSet(self.model, using=self._db)

    def filter_catalog(self, catalog):
        return self.get_queryset().filter_catalog(catalog)
