# -*- coding: utf-8 -*-
# Generated by Django 1.11.16 on 2019-03-13 10:58
from __future__ import unicode_literals

from django.db import migrations

def set_null_to_blank(queryset, fields):
    for element in queryset:
        for field in fields:
            setattr(element, field, getattr(element, field) or '')
        element.save()


def run_data_migration(apps, schema_editor):
    Catalog = apps.get_model('questions', 'Catalog')
    Section = apps.get_model('questions', 'Section')
    QuestionSet = apps.get_model('questions', 'QuestionSet')
    Question = apps.get_model('questions', 'Question')

    set_null_to_blank(Catalog.objects.all(), [
        'uri',
        'uri_prefix',
        'key',
        'comment',
        'title_lang1',
        'title_lang2',
        'title_lang3',
        'title_lang4',
        'title_lang5',
    ])
    set_null_to_blank(Section.objects.all(), [
        'uri',
        'uri_prefix',
        'key',
        'path',
        'comment',
        'title_lang1',
        'title_lang2',
        'title_lang3',
        'title_lang4',
        'title_lang5',
    ])
    set_null_to_blank(QuestionSet.objects.all(), [
        'uri',
        'uri_prefix',
        'key',
        'path',
        'comment',
        'title_lang1',
        'title_lang2',
        'title_lang3',
        'title_lang4',
        'title_lang5',
        'help_lang1',
        'help_lang2',
        'help_lang3',
        'help_lang4',
        'help_lang5',
    ])
    set_null_to_blank(Question.objects.all(), [
        'uri',
        'uri_prefix',
        'key',
        'comment',
        'text_lang1',
        'text_lang2',
        'text_lang3',
        'text_lang4',
        'text_lang5',
        'help_lang1',
        'help_lang2',
        'help_lang3',
        'help_lang4',
        'help_lang5',
        'value_type',
        'widget_type',
        'unit',
    ])


class Migration(migrations.Migration):

    dependencies = [
        ('questions', '0040_add_language_fields'),
    ]

    operations = [
        migrations.RunPython(run_data_migration),
    ]
