# -*- coding: utf-8 -*-
# Generated by Django 1.9 on 2016-09-28 11:23
from __future__ import unicode_literals

from django.db import migrations


def set_question_unit_and_type(apps, schema_editor):
    Question = apps.get_model('questions', 'Question')

    for question in Question.objects.all():
        try:
            question.value_type = question.attribute_entity.attribute.value_type
        except AttributeError:
            question.value_type = 'text'

        try:
            question.unit = question.attribute_entity.attribute.unit or ''
        except AttributeError:
            question.unit = ''

        question.save()


class Migration(migrations.Migration):

    dependencies = [
        ('questions', '0015_question_unit_and_type'),
    ]

    operations = [
        migrations.RunPython(set_question_unit_and_type),
    ]
