# Generated by Django 2.2.16 on 2020-12-04 12:46

from __future__ import unicode_literals

import django.db.models.deletion
import mptt.fields
from django.db import migrations, models
from mptt import managers, register


def rebuild_tree(apps, schema_editor):
    Project = apps.get_model('projects', 'Project')

    manager = managers.TreeManager()
    manager.model = Project

    register(Project)

    manager.contribute_to_class(Project, 'objects')
    manager.rebuild()


class Migration(migrations.Migration):

    dependencies = [
        ('projects', '0045_value_file'),
    ]

    operations = [
        migrations.AddField(
            model_name='project',
            name='level',
            field=models.PositiveIntegerField(default=0, editable=False),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name='project',
            name='lft',
            field=models.PositiveIntegerField(default=0, editable=False),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name='project',
            name='parent',
            field=mptt.fields.TreeForeignKey(blank=True, help_text='The parent project of this project.', null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='children', to='projects.Project', verbose_name='Parent project'),
        ),
        migrations.AddField(
            model_name='project',
            name='rght',
            field=models.PositiveIntegerField(default=0, editable=False),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name='project',
            name='tree_id',
            field=models.PositiveIntegerField(db_index=True, default=0, editable=False),
            preserve_default=False,
        ),
        migrations.AlterModelOptions(
            name='project',
            options={'ordering': ('tree_id', 'level', 'title'), 'verbose_name': 'Project', 'verbose_name_plural': 'Projects'},
        ),
        migrations.RunPython(rebuild_tree),
    ]
