# -*- coding: utf-8 -*-
# Generated by Django 1.9 on 2017-01-30 15:28
from __future__ import unicode_literals

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ('projects', '0010_add_db_contraint'),
    ]

    operations = [
        migrations.AlterField(
            model_name='project',
            name='catalog',
            field=models.ForeignKey(help_text='The catalog which will be used for this project.', on_delete=django.db.models.deletion.CASCADE, related_name='+', to='questions.Catalog', verbose_name='Catalog'),
        ),
        migrations.AlterField(
            model_name='project',
            name='description',
            field=models.TextField(blank=True, help_text='A description for this project (optional).', verbose_name='Description'),
        ),
        migrations.AlterField(
            model_name='project',
            name='owner',
            field=models.ManyToManyField(help_text='The list of owners for this project.', to=settings.AUTH_USER_MODEL, verbose_name='Owner'),
        ),
        migrations.AlterField(
            model_name='project',
            name='title',
            field=models.CharField(help_text='The title for this project.', max_length=256, verbose_name='Title'),
        ),
        migrations.AlterField(
            model_name='snapshot',
            name='description',
            field=models.TextField(blank=True, help_text='A description for this snapshot (optional).', verbose_name='Description'),
        ),
        migrations.AlterField(
            model_name='snapshot',
            name='project',
            field=models.ForeignKey(help_text='The project this snapshot belongs to.', on_delete=django.db.models.deletion.CASCADE, related_name='snapshots', to='projects.Project', verbose_name='Project'),
        ),
        migrations.AlterField(
            model_name='snapshot',
            name='title',
            field=models.CharField(help_text='The title for this snapshot.', max_length=256, verbose_name='Title'),
        ),
        migrations.AlterField(
            model_name='value',
            name='attribute',
            field=models.ForeignKey(blank=True, help_text='The attribute this value belongs to.', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='values', to='domain.Attribute', verbose_name='Attribute'),
        ),
        migrations.AlterField(
            model_name='value',
            name='collection_index',
            field=models.IntegerField(default=0, help_text='The position of this value in an attribute collection.', verbose_name='Collection index'),
        ),
        migrations.AlterField(
            model_name='value',
            name='option',
            field=models.ForeignKey(blank=True, help_text='The option stored for this value.', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='options.Option', verbose_name='Option'),
        ),
        migrations.AlterField(
            model_name='value',
            name='project',
            field=models.ForeignKey(help_text='The project this value belongs to.', on_delete=django.db.models.deletion.CASCADE, related_name='values', to='projects.Project', verbose_name='Project'),
        ),
        migrations.AlterField(
            model_name='value',
            name='set_index',
            field=models.IntegerField(default=0, help_text='The position of this value in an entity collection (i.e. in the question set)', verbose_name='Set index'),
        ),
        migrations.AlterField(
            model_name='value',
            name='snapshot',
            field=models.ForeignKey(blank=True, help_text='The snapshot this value belongs to.', null=True, on_delete=django.db.models.deletion.CASCADE, related_name='values', to='projects.Snapshot', verbose_name='Snapshot'),
        ),
        migrations.AlterField(
            model_name='value',
            name='text',
            field=models.TextField(blank=True, help_text='The string stored for this value.', null=True, verbose_name='Text'),
        ),
    ]
