# -*- coding: utf-8 -*-
# Generated by Django 1.9 on 2017-01-25 11:34
from __future__ import unicode_literals

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ('options', '0005_refactoring'),
    ]

    operations = [
        migrations.AlterModelOptions(
            name='optionset',
            options={'ordering': ('uri',), 'verbose_name': 'OptionSet', 'verbose_name_plural': 'OptionSets'},
        ),
        migrations.AddField(
            model_name='option',
            name='comment',
            field=models.TextField(blank=True, help_text='Additional information about this option.', null=True, verbose_name='Comment'),
        ),
        migrations.AddField(
            model_name='option',
            name='uri',
            field=models.URLField(blank=True, help_text='The Uniform Resource Identifier of this option (auto-generated).', max_length=640, null=True, verbose_name='URI'),
        ),
        migrations.AddField(
            model_name='option',
            name='uri_prefix',
            field=models.URLField(blank=True, help_text='The prefix for the URI of this option.', max_length=256, null=True, verbose_name='URI Prefix'),
        ),
        migrations.AddField(
            model_name='optionset',
            name='comment',
            field=models.TextField(blank=True, help_text='Additional information about this option set.', null=True, verbose_name='Comment'),
        ),
        migrations.AddField(
            model_name='optionset',
            name='uri',
            field=models.URLField(blank=True, help_text='The Uniform Resource Identifier of this option set (auto-generated).', max_length=640, null=True, verbose_name='URI'),
        ),
        migrations.AddField(
            model_name='optionset',
            name='uri_prefix',
            field=models.URLField(blank=True, help_text='The prefix for the URI of this option set.', max_length=256, null=True, verbose_name='URI Prefix'),
        ),
        migrations.AlterField(
            model_name='option',
            name='additional_input',
            field=models.BooleanField(default=False, help_text='Designates whether an additional input is possible for this option.', verbose_name='Additional input'),
        ),
        migrations.AlterField(
            model_name='option',
            name='key',
            field=models.SlugField(blank=True, help_text='The internal identifier of this option. The URI will be generated from this key.', max_length=128, null=True, verbose_name='Key'),
        ),
        migrations.AlterField(
            model_name='option',
            name='optionset',
            field=models.ForeignKey(blank=True, help_text='The option set this option belongs to.', null=True, on_delete=django.db.models.deletion.CASCADE, related_name='options', to='options.OptionSet', verbose_name='Option set'),
        ),
        migrations.AlterField(
            model_name='option',
            name='order',
            field=models.IntegerField(default=0, help_text='The position of this option in lists.', verbose_name='Order'),
        ),
        migrations.AlterField(
            model_name='option',
            name='text_de',
            field=models.CharField(help_text='The German text displayed for this option.', max_length=256, verbose_name='Text (de)'),
        ),
        migrations.AlterField(
            model_name='option',
            name='text_en',
            field=models.CharField(help_text='The English text displayed for this option.', max_length=256, verbose_name='Text (en)'),
        ),
        migrations.AlterField(
            model_name='optionset',
            name='conditions',
            field=models.ManyToManyField(blank=True, help_text='The list of conditions evaluated for this option set.', to='conditions.Condition', verbose_name='Conditions'),
        ),
        migrations.AlterField(
            model_name='optionset',
            name='key',
            field=models.SlugField(blank=True, help_text='The internal identifier of this option set. The URI will be generated from this key.', max_length=128, null=True, verbose_name='Key'),
        ),
        migrations.AlterField(
            model_name='optionset',
            name='order',
            field=models.IntegerField(default=0, help_text='The position of this option set in lists.', verbose_name='Order'),
        ),
    ]
