# -*- coding: utf-8 -*-
# Generated by Django 1.9 on 2017-01-25 13:56
from __future__ import unicode_literals

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ('conditions', '0010_refactoring'),
    ]

    operations = [
        migrations.AlterModelOptions(
            name='condition',
            options={'ordering': ('uri',), 'verbose_name': 'Condition', 'verbose_name_plural': 'Conditions'},
        ),
        migrations.AddField(
            model_name='condition',
            name='uri',
            field=models.URLField(blank=True, help_text='The Uniform Resource Identifier of this option set (auto-generated).', max_length=640, null=True, verbose_name='URI'),
        ),
        migrations.AddField(
            model_name='condition',
            name='uri_prefix',
            field=models.URLField(blank=True, help_text='The prefix for the URI of this condition.', max_length=256, null=True, verbose_name='URI Prefix'),
        ),
        migrations.AlterField(
            model_name='condition',
            name='comment',
            field=models.TextField(blank=True, help_text='Additional information about this condition.', null=True, verbose_name='Comment'),
        ),
        migrations.AlterField(
            model_name='condition',
            name='key',
            field=models.SlugField(blank=True, help_text='The internal identifier of this condition. The URI will be generated from this key.', max_length=128, null=True, verbose_name='Key'),
        ),
        migrations.AlterField(
            model_name='condition',
            name='relation',
            field=models.CharField(choices=[('eq', 'is equal to (==)'), ('neq', 'is not equal to (!=)'), ('contains', 'contains'), ('gt', 'is greater than (>)'), ('gte', 'is greater than or equal (>=)'), ('lt', 'is lesser than (<)'), ('lte', 'is lesser than or equal (<=)'), ('empty', 'is empty'), ('notempty', 'is not empty')], help_text='Relation this condition is using.', max_length=8, verbose_name='Relation'),
        ),
        migrations.AlterField(
            model_name='condition',
            name='source',
            field=models.ForeignKey(blank=True, db_constraint=False, help_text='Attribute this condition is evaluating.', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='domain.Attribute', verbose_name='Source'),
        ),
        migrations.AlterField(
            model_name='condition',
            name='target_option',
            field=models.ForeignKey(blank=True, db_constraint=False, help_text='Option this condition is checking against.', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='options.Option', verbose_name='Target (Option)'),
        ),
        migrations.AlterField(
            model_name='condition',
            name='target_text',
            field=models.CharField(blank=True, help_text='Raw text value this condition is checking against.', max_length=256, null=True, verbose_name='Target (Text)'),
        ),
    ]
