from enum import Enum


class DeviceModel(Enum):

    # controlers
    VSMART = "vsmart"
    VBOND = "vedge-cloud"
    VMANAGE = "vmanage"

    # vedges
    VEDGE_ISR1100_6G = "vedge-ISR1100-6G"
    VEDGE_ISR1100X_6G = "vedge-ISR1100X-6G"
    VEDGE_ISR1100_4G = "vedge-ISR1100-4G"
    VEDGE_ISR1100X_4G = "vedge-ISR1100X-4G"
    VEDGE_ISR1100_4GLTE = "vedge-ISR1100-4GLTE"
    VEDGE = "vedge-cloud"
    VEDGE_1000 = "vedge-1000"
    VEDGE_2000 = "vedge-2000"
    VEDGE_100 = "vedge-100"
    VEDGE_100_B = "vedge-100-B"
    VEDGE_100_WM = "vedge-100-WM"
    VEDGE_100_M = "vedge-100-M"
    VEDGE_5000 = "vedge-5000"

    # IR1101
    VEDGE_IR_1101 = "vedge-IR-1101"
    VEDGE_ESR_6300 = "vedge-ESR-6300"
    VEDGE_IR_1821 = "vedge-IR-1821"
    VEDGE_IR_1831 = "vedge-IR-1831"
    VEDGE_IR_1833 = "vedge-IR-1833"
    VEDGE_IR_1835 = "vedge-IR-1835"

    # ASR devices
    VEDGE_ASR_1001_X = "vedge-ASR-1001-X"
    VEDGE_ASR_1002_X = "vedge-ASR-1002-X"
    VEDGE_ASR_1002_HX = "vedge-ASR-1002-HX"
    VEDGE_ASR_1001_HX = "vedge-ASR-1001-HX"
    VEDGE_C8500L_8G4X = "vedge-C8500L-8G4X"
    VEDGE_C8500_12X4QC = "vedge-C8500-12X4QC"
    VEDGE_C8500_12X = "vedge-C8500-12X"
    VEDGE_C8500L_8S4X = "vedge-C8500L-8S4X"
    VEDGE_ASR_1006_X = "vedge-ASR-1006-X"
    VEDGE_C8500_20X6C = "vedge-C8500-20X6C"

    # CSR
    VEDGE_CSR_1000V = "vedge-CSR-1000v"
    VEDGE_C8000V = "vedge-C8000V"

    # ISR
    VEDGE_ISR_4331 = "vedge-ISR-4331"
    VEDGE_ISR_4431 = "vedge-ISR-4431"
    VEDGE_ISR_4461 = "vedge-ISR-4461"
    VEDGE_ISR_4451_X = "vedge-ISR-4451-X"
    VEDGE_ISR_4321 = "vedge-ISR-4321"
    VEDGE_ISR_4351 = "vedge-ISR-4351"
    VEDGE_ISR_4221 = "vedge-ISR-4221"
    VEDGE_ISR_4221X = "vedge-ISR-4221X"

    # C1100 DSL
    VEDGE_C1111_8PW = "vedge-C1111-8PW"
    VEDGE_C1111_8PLTELAW = "vedge-C1111-8PLTELAW"
    VEDGE_C1111_8PLTEEAW = "vedge-C1111-8PLTEEAW"
    VEDGE_C1113_8PMLTEEA = "vedge-C1113-8PMLTEEA"
    VEDGE_C1116_4P = "vedge-C1116-4P"
    VEDGE_C1116_4PLTEEA = "vedge-C1116-4PLTEEA"
    VEDGE_C1117_4P = "vedge-C1117-4P"
    VEDGE_C1117_4PM = "vedge-C1117-4PM"
    VEDGE_C1117_4PLTEEA = "vedge-C1117-4PLTEEA"
    VEDGE_C1111_8PLTELA = "vedge-C1111-8PLTELA"
    VEDGE_C1111_8PLTEEA = "vedge-C1111-8PLTEEA"

    # ISRv
    VEDGE_ISRV = "vedge-ISRv"
