/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.explanation.ordering;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLProperty;
import org.semanticweb.owlapi.model.OWLPropertyAxiom;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OWLAxiomVisitorAdapter;
import uk.ac.manchester.cs.owl.explanation.ordering.EntailedAxiomTree;
import uk.ac.manchester.cs.owl.explanation.ordering.ExplanationOrderer;
import uk.ac.manchester.cs.owl.explanation.ordering.ExplanationTree;
import uk.ac.manchester.cs.owl.explanation.ordering.Tree;

public class ExplanationOrdererImpl
implements ExplanationOrderer {
    private Set<OWLAxiom> currentExplanation;
    @Nonnull
    private final Map<OWLEntity, Set<OWLAxiom>> lhs2AxiomMap = new HashMap<OWLEntity, Set<OWLAxiom>>();
    @Nonnull
    private final Map<OWLAxiom, Set<OWLEntity>> entitiesByAxiomRHS = new HashMap<OWLAxiom, Set<OWLEntity>>();
    @Nonnull
    private final SeedExtractor seedExtractor = new SeedExtractor();
    @Nonnull
    private final OWLOntologyManager man;
    private OWLOntology ont;
    @Nonnull
    private final Map<OWLObject, Set<OWLAxiom>> mappedAxioms = new HashMap<OWLObject, Set<OWLAxiom>>();
    @Nonnull
    private final Set<OWLAxiom> consumedAxioms = new HashSet<OWLAxiom>();
    @Nonnull
    private final Set<AxiomType<?>> passTypes = new HashSet();
    @Nonnull
    private static final Comparator<Tree<OWLAxiom>> COMPARATOR = new OWLAxiomTreeComparator();
    private static final AtomicLong RANDOMSTART = new AtomicLong(System.currentTimeMillis());
    private static final PropertiesFirstComparator PROPERTIESFIRSTCOMPARATOR = new PropertiesFirstComparator();

    public ExplanationOrdererImpl(@Nonnull OWLOntologyManager m) {
        this.currentExplanation = CollectionFactory.emptySet();
        this.man = OWLAPIPreconditions.checkNotNull(m, "m cannot be null");
        this.passTypes.add(AxiomType.DISJOINT_CLASSES);
    }

    private void reset() {
        this.lhs2AxiomMap.clear();
        this.entitiesByAxiomRHS.clear();
        this.consumedAxioms.clear();
    }

    @Override
    public ExplanationTree getOrderedExplanation(@Nonnull OWLAxiom entailment, @Nonnull Set<OWLAxiom> axioms) {
        this.currentExplanation = new HashSet<OWLAxiom>(axioms);
        this.buildIndices();
        EntailedAxiomTree root = new EntailedAxiomTree(entailment);
        this.insertChildren(this.seedExtractor.getSource(entailment), root);
        OWLEntity currentTarget = this.seedExtractor.getTarget(entailment);
        Set axs = root.getUserObjectClosure();
        ArrayList<OWLAxiom> rootAxioms = new ArrayList<OWLAxiom>();
        for (OWLAxiom ax : axioms) {
            if (axs.contains(ax)) continue;
            rootAxioms.add(ax);
        }
        Collections.sort(rootAxioms, new TargetAxiomsComparator(this.getTargetAxioms(currentTarget)));
        for (OWLAxiom ax : rootAxioms) {
            assert (ax != null);
            root.addChild(new ExplanationTree(ax));
        }
        return root;
    }

    @Nonnull
    private Set<OWLAxiom> getTargetAxioms(@Nonnull OWLEntity currentTarget) {
        HashSet<OWLAxiom> targetAxioms = new HashSet<OWLAxiom>();
        if (currentTarget.isOWLClass()) {
            targetAxioms.addAll(this.ont.getAxioms(currentTarget.asOWLClass(), Imports.EXCLUDED));
        }
        if (currentTarget.isOWLObjectProperty()) {
            targetAxioms.addAll(this.ont.getAxioms((OWLObjectPropertyExpression)currentTarget.asOWLObjectProperty(), Imports.EXCLUDED));
        }
        if (currentTarget.isOWLDataProperty()) {
            targetAxioms.addAll(this.ont.getAxioms(currentTarget.asOWLDataProperty(), Imports.EXCLUDED));
        }
        if (currentTarget.isOWLNamedIndividual()) {
            targetAxioms.addAll(this.ont.getAxioms((OWLIndividual)currentTarget.asOWLNamedIndividual(), Imports.EXCLUDED));
        }
        return targetAxioms;
    }

    @Nonnull
    private List<OWLEntity> getRHSEntitiesSorted(@Nonnull OWLAxiom ax) {
        Collection<OWLEntity> entities = this.getRHSEntities(ax);
        ArrayList<OWLEntity> sortedEntities = new ArrayList<OWLEntity>(entities);
        Collections.sort(sortedEntities, PROPERTIESFIRSTCOMPARATOR);
        return sortedEntities;
    }

    private void insertChildren(@Nonnull OWLEntity entity, @Nonnull ExplanationTree tree) {
        HashSet currentPath = new HashSet(tree.getUserObjectPathToRoot());
        Set<Object> axioms = CollectionFactory.emptySet();
        if (entity.isOWLClass()) {
            axioms = this.ont.getAxioms(entity.asOWLClass(), Imports.EXCLUDED);
        } else if (entity.isOWLObjectProperty()) {
            axioms = this.ont.getAxioms((OWLObjectPropertyExpression)entity.asOWLObjectProperty(), Imports.EXCLUDED);
        } else if (entity.isOWLDataProperty()) {
            axioms = this.ont.getAxioms(entity.asOWLDataProperty(), Imports.EXCLUDED);
        } else if (entity.isOWLNamedIndividual()) {
            axioms = this.ont.getAxioms((OWLIndividual)entity.asOWLNamedIndividual(), Imports.EXCLUDED);
        }
        for (OWLAxiom oWLAxiom : axioms) {
            if (this.passTypes.contains(oWLAxiom.getAxiomType())) continue;
            Set<OWLAxiom> mapped = ExplanationOrdererImpl.getIndexedSet(entity, this.mappedAxioms, true);
            if (this.consumedAxioms.contains(oWLAxiom) || mapped.contains(oWLAxiom) || currentPath.contains(oWLAxiom)) continue;
            mapped.add(oWLAxiom);
            this.consumedAxioms.add(oWLAxiom);
            ExplanationTree child = new ExplanationTree(oWLAxiom);
            tree.addChild(child);
            for (OWLEntity ent : this.getRHSEntitiesSorted(oWLAxiom)) {
                assert (ent != null);
                this.insertChildren(ent, child);
            }
        }
        ExplanationOrdererImpl.sortChildrenAxioms(tree);
    }

    private static void sortChildrenAxioms(@Nonnull ExplanationTree tree) {
        tree.sortChildren(COMPARATOR);
    }

    private void buildIndices() {
        this.reset();
        AxiomMapBuilder builder = new AxiomMapBuilder();
        for (OWLAxiom ax : this.currentExplanation) {
            ax.accept(builder);
        }
        try {
            if (this.ont != null) {
                this.man.removeOntology(OWLAPIPreconditions.verifyNotNull(this.ont));
            }
            this.ont = this.man.createOntology(IRI.create("http://www.semanticweb.org/", "ontology" + RANDOMSTART.incrementAndGet()));
            ArrayList<AddAxiom> changes = new ArrayList<AddAxiom>();
            for (OWLAxiom ax : this.currentExplanation) {
                assert (ax != null);
                changes.add(new AddAxiom(OWLAPIPreconditions.verifyNotNull(this.ont), ax));
                ax.accept(builder);
            }
            this.man.applyChanges(changes);
        }
        catch (OWLOntologyCreationException e) {
            throw new OWLRuntimeException(e);
        }
    }

    @Nonnull
    private static <K, E> Set<E> getIndexedSet(@Nonnull K obj, @Nonnull Map<K, Set<E>> map, boolean addIfEmpty) {
        Set<E> values = map.get(obj);
        if (values == null) {
            values = new HashSet();
            if (addIfEmpty) {
                map.put(obj, values);
            }
        }
        return values;
    }

    @Nonnull
    protected Set<OWLAxiom> getAxiomsForLHS(@Nonnull OWLEntity lhs) {
        return ExplanationOrdererImpl.getIndexedSet(lhs, this.lhs2AxiomMap, true);
    }

    @Nonnull
    private Collection<OWLEntity> getRHSEntities(@Nonnull OWLAxiom axiom) {
        return ExplanationOrdererImpl.getIndexedSet(axiom, this.entitiesByAxiomRHS, true);
    }

    protected void indexAxiomsByRHSEntities(@Nonnull OWLObject rhs, @Nonnull OWLAxiom axiom) {
        ExplanationOrdererImpl.getIndexedSet(axiom, this.entitiesByAxiomRHS, true).addAll(rhs.getSignature());
    }

    private class AxiomMapBuilder
    extends OWLAxiomVisitorAdapter {
        AxiomMapBuilder() {
        }

        @Override
        public void visit(OWLSubClassOfAxiom axiom) {
            if (!axiom.getSubClass().isAnonymous()) {
                ExplanationOrdererImpl.this.getAxiomsForLHS(axiom.getSubClass().asOWLClass()).add(axiom);
                ExplanationOrdererImpl.this.indexAxiomsByRHSEntities(axiom.getSuperClass(), axiom);
            }
        }

        @Override
        public void visit(OWLAsymmetricObjectPropertyAxiom axiom) {
            if (!((OWLObjectPropertyExpression)axiom.getProperty()).isAnonymous()) {
                ExplanationOrdererImpl.this.getAxiomsForLHS(((OWLObjectPropertyExpression)axiom.getProperty()).asOWLObjectProperty()).add(axiom);
            }
        }

        @Override
        public void visit(OWLReflexiveObjectPropertyAxiom axiom) {
            if (!((OWLObjectPropertyExpression)axiom.getProperty()).isAnonymous()) {
                ExplanationOrdererImpl.this.getAxiomsForLHS(((OWLObjectPropertyExpression)axiom.getProperty()).asOWLObjectProperty()).add(axiom);
            }
        }

        @Override
        public void visit(OWLDisjointClassesAxiom axiom) {
            for (OWLClassExpression desc : axiom.getClassExpressions()) {
                if (!desc.isAnonymous()) {
                    ExplanationOrdererImpl.this.getAxiomsForLHS(desc.asOWLClass()).add(axiom);
                }
                ExplanationOrdererImpl.this.indexAxiomsByRHSEntities(desc, axiom);
            }
        }

        @Override
        public void visit(OWLDataPropertyDomainAxiom axiom) {
            ExplanationOrdererImpl.this.getAxiomsForLHS(((OWLDataPropertyExpression)axiom.getProperty()).asOWLDataProperty()).add(axiom);
            ExplanationOrdererImpl.this.indexAxiomsByRHSEntities(axiom.getDomain(), axiom);
        }

        @Override
        public void visit(OWLObjectPropertyDomainAxiom axiom) {
            if (!((OWLObjectPropertyExpression)axiom.getProperty()).isAnonymous()) {
                ExplanationOrdererImpl.this.getAxiomsForLHS(((OWLObjectPropertyExpression)axiom.getProperty()).asOWLObjectProperty()).add(axiom);
            }
            ExplanationOrdererImpl.this.indexAxiomsByRHSEntities(axiom.getDomain(), axiom);
        }

        @Override
        public void visit(OWLEquivalentObjectPropertiesAxiom axiom) {
            for (OWLObjectPropertyExpression prop : axiom.getProperties()) {
                if (!prop.isAnonymous()) {
                    ExplanationOrdererImpl.this.getAxiomsForLHS(prop.asOWLObjectProperty()).add(axiom);
                }
                ExplanationOrdererImpl.this.indexAxiomsByRHSEntities(prop, axiom);
            }
        }

        @Override
        public void visit(OWLDifferentIndividualsAxiom axiom) {
            for (OWLIndividual ind : axiom.getIndividuals()) {
                if (ind.isAnonymous()) continue;
                ExplanationOrdererImpl.this.getAxiomsForLHS(ind.asOWLNamedIndividual()).add(axiom);
                ExplanationOrdererImpl.this.indexAxiomsByRHSEntities(ind, axiom);
            }
        }

        @Override
        public void visit(OWLDisjointDataPropertiesAxiom axiom) {
            for (OWLDataPropertyExpression prop : axiom.getProperties()) {
                ExplanationOrdererImpl.this.getAxiomsForLHS(prop.asOWLDataProperty()).add(axiom);
                ExplanationOrdererImpl.this.indexAxiomsByRHSEntities(prop, axiom);
            }
        }

        @Override
        public void visit(OWLDisjointObjectPropertiesAxiom axiom) {
            for (OWLObjectPropertyExpression prop : axiom.getProperties()) {
                if (!prop.isAnonymous()) {
                    ExplanationOrdererImpl.this.getAxiomsForLHS(prop.asOWLObjectProperty()).add(axiom);
                }
                ExplanationOrdererImpl.this.indexAxiomsByRHSEntities(prop, axiom);
            }
        }

        @Override
        public void visit(OWLObjectPropertyRangeAxiom axiom) {
            if (!((OWLObjectPropertyExpression)axiom.getProperty()).isAnonymous()) {
                ExplanationOrdererImpl.this.getAxiomsForLHS(((OWLObjectPropertyExpression)axiom.getProperty()).asOWLObjectProperty()).add(axiom);
            }
            ExplanationOrdererImpl.this.indexAxiomsByRHSEntities((OWLObject)axiom.getRange(), axiom);
        }

        @Override
        public void visit(OWLFunctionalObjectPropertyAxiom axiom) {
            if (!((OWLObjectPropertyExpression)axiom.getProperty()).isAnonymous()) {
                ExplanationOrdererImpl.this.getAxiomsForLHS(((OWLObjectPropertyExpression)axiom.getProperty()).asOWLObjectProperty()).add(axiom);
            }
        }

        @Override
        public void visit(OWLSubObjectPropertyOfAxiom axiom) {
            if (!((OWLObjectPropertyExpression)axiom.getSubProperty()).isAnonymous()) {
                ExplanationOrdererImpl.this.getAxiomsForLHS(((OWLObjectPropertyExpression)axiom.getSubProperty()).asOWLObjectProperty()).add(axiom);
            }
            ExplanationOrdererImpl.this.indexAxiomsByRHSEntities((OWLObject)axiom.getSuperProperty(), axiom);
        }

        @Override
        public void visit(OWLDisjointUnionAxiom axiom) {
            ExplanationOrdererImpl.this.getAxiomsForLHS(axiom.getOWLClass()).add(axiom);
        }

        @Override
        public void visit(OWLSymmetricObjectPropertyAxiom axiom) {
            if (!((OWLObjectPropertyExpression)axiom.getProperty()).isAnonymous()) {
                ExplanationOrdererImpl.this.getAxiomsForLHS(((OWLObjectPropertyExpression)axiom.getProperty()).asOWLObjectProperty()).add(axiom);
            }
        }

        @Override
        public void visit(OWLDataPropertyRangeAxiom axiom) {
            if (!((OWLDataPropertyExpression)axiom.getProperty()).isAnonymous()) {
                ExplanationOrdererImpl.this.getAxiomsForLHS(((OWLDataPropertyExpression)axiom.getProperty()).asOWLDataProperty()).add(axiom);
            }
            ExplanationOrdererImpl.this.indexAxiomsByRHSEntities((OWLObject)axiom.getRange(), axiom);
        }

        @Override
        public void visit(OWLFunctionalDataPropertyAxiom axiom) {
            if (!((OWLDataPropertyExpression)axiom.getProperty()).isAnonymous()) {
                ExplanationOrdererImpl.this.getAxiomsForLHS(((OWLDataPropertyExpression)axiom.getProperty()).asOWLDataProperty()).add(axiom);
            }
        }

        @Override
        public void visit(OWLEquivalentDataPropertiesAxiom axiom) {
            for (OWLDataPropertyExpression prop : axiom.getProperties()) {
                ExplanationOrdererImpl.this.getAxiomsForLHS(prop.asOWLDataProperty()).add(axiom);
                ExplanationOrdererImpl.this.indexAxiomsByRHSEntities(prop, axiom);
            }
        }

        @Override
        public void visit(OWLClassAssertionAxiom axiom) {
            if (!axiom.getIndividual().isAnonymous()) {
                ExplanationOrdererImpl.this.getAxiomsForLHS(axiom.getIndividual().asOWLNamedIndividual()).add(axiom);
                ExplanationOrdererImpl.this.indexAxiomsByRHSEntities(axiom.getClassExpression(), axiom);
            }
        }

        @Override
        public void visit(OWLEquivalentClassesAxiom axiom) {
            for (OWLClassExpression desc : axiom.getClassExpressions()) {
                if (!desc.isAnonymous()) {
                    ExplanationOrdererImpl.this.getAxiomsForLHS(desc.asOWLClass()).add(axiom);
                }
                ExplanationOrdererImpl.this.indexAxiomsByRHSEntities(desc, axiom);
            }
        }

        @Override
        public void visit(OWLDataPropertyAssertionAxiom axiom) {
            ExplanationOrdererImpl.this.indexAxiomsByRHSEntities(axiom.getSubject(), axiom);
        }

        @Override
        public void visit(OWLTransitiveObjectPropertyAxiom axiom) {
            if (!((OWLObjectPropertyExpression)axiom.getProperty()).isAnonymous()) {
                ExplanationOrdererImpl.this.getAxiomsForLHS(((OWLObjectPropertyExpression)axiom.getProperty()).asOWLObjectProperty()).add(axiom);
            }
        }

        @Override
        public void visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
            if (!((OWLObjectPropertyExpression)axiom.getProperty()).isAnonymous()) {
                ExplanationOrdererImpl.this.getAxiomsForLHS(((OWLObjectPropertyExpression)axiom.getProperty()).asOWLObjectProperty()).add(axiom);
            }
        }

        @Override
        public void visit(OWLSubDataPropertyOfAxiom axiom) {
            ExplanationOrdererImpl.this.getAxiomsForLHS(((OWLDataPropertyExpression)axiom.getSubProperty()).asOWLDataProperty()).add(axiom);
            ExplanationOrdererImpl.this.indexAxiomsByRHSEntities((OWLObject)axiom.getSuperProperty(), axiom);
        }

        @Override
        public void visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
            if (!((OWLObjectPropertyExpression)axiom.getProperty()).isAnonymous()) {
                ExplanationOrdererImpl.this.getAxiomsForLHS(((OWLObjectPropertyExpression)axiom.getProperty()).asOWLObjectProperty()).add(axiom);
            }
        }

        @Override
        public void visit(OWLSameIndividualAxiom axiom) {
            for (OWLIndividual ind : axiom.getIndividuals()) {
                if (ind.isAnonymous()) continue;
                ExplanationOrdererImpl.this.getAxiomsForLHS(ind.asOWLNamedIndividual()).add(axiom);
                ExplanationOrdererImpl.this.indexAxiomsByRHSEntities(ind, axiom);
            }
        }

        @Override
        public void visit(OWLInverseObjectPropertiesAxiom axiom) {
            if (!axiom.getFirstProperty().isAnonymous()) {
                ExplanationOrdererImpl.this.getAxiomsForLHS(axiom.getFirstProperty().asOWLObjectProperty()).add(axiom);
            }
            ExplanationOrdererImpl.this.indexAxiomsByRHSEntities(axiom.getFirstProperty(), axiom);
            ExplanationOrdererImpl.this.indexAxiomsByRHSEntities(axiom.getSecondProperty(), axiom);
        }

        @Override
        public void visit(OWLHasKeyAxiom axiom) {
            if (!axiom.getClassExpression().isAnonymous()) {
                ExplanationOrdererImpl.this.indexAxiomsByRHSEntities(axiom.getClassExpression().asOWLClass(), axiom);
            }
        }
    }

    private static class SeedExtractor
    extends OWLAxiomVisitorAdapter {
        private OWLEntity source;
        private OWLEntity target;

        SeedExtractor() {
        }

        @Nonnull
        public OWLEntity getSource(@Nonnull OWLAxiom axiom) {
            axiom.accept(this);
            return OWLAPIPreconditions.verifyNotNull(this.source);
        }

        @Nonnull
        public OWLEntity getTarget(@Nonnull OWLAxiom axiom) {
            axiom.accept(this);
            return OWLAPIPreconditions.verifyNotNull(this.target);
        }

        @Override
        public void visit(OWLSubClassOfAxiom axiom) {
            OWLClassExpression classExpression;
            if (!axiom.getSubClass().isAnonymous()) {
                this.source = axiom.getSubClass().asOWLClass();
            }
            if (!axiom.getSuperClass().isOWLNothing() && !(classExpression = axiom.getSuperClass()).isAnonymous()) {
                this.target = classExpression.asOWLClass();
            }
        }

        @Override
        public void visit(OWLDisjointClassesAxiom axiom) {
            for (OWLClassExpression ce : axiom.getClassExpressions()) {
                if (ce.isAnonymous()) continue;
                if (this.source == null) {
                    this.source = ce.asOWLClass();
                    continue;
                }
                if (this.target != null) break;
                this.target = ce.asOWLClass();
            }
        }

        @Override
        public void visit(OWLSubObjectPropertyOfAxiom axiom) {
            if (!((OWLObjectPropertyExpression)axiom.getSubProperty()).isAnonymous()) {
                this.source = ((OWLObjectPropertyExpression)axiom.getSubProperty()).asOWLObjectProperty();
            }
            if (!((OWLObjectPropertyExpression)axiom.getSuperProperty()).isAnonymous()) {
                this.target = ((OWLObjectPropertyExpression)axiom.getSuperProperty()).asOWLObjectProperty();
            }
        }

        @Override
        public void visit(OWLClassAssertionAxiom axiom) {
            if (!axiom.getClassExpression().isAnonymous()) {
                this.source = axiom.getIndividual().asOWLNamedIndividual();
                this.target = axiom.getClassExpression().asOWLClass();
            }
        }

        @Override
        public void visit(OWLEquivalentClassesAxiom axiom) {
            for (OWLClass cls : axiom.getNamedClasses()) {
                if (this.source == null) {
                    this.source = cls;
                    continue;
                }
                if (this.target != null) break;
                this.target = cls;
            }
        }

        @Override
        public void visit(SWRLRule rule) {
        }
    }

    private static class OWLAxiomTreeComparator
    implements Comparator<Tree<OWLAxiom>>,
    Serializable {
        private static final long serialVersionUID = 40000L;

        OWLAxiomTreeComparator() {
        }

        @Override
        public int compare(Tree<OWLAxiom> o1, Tree<OWLAxiom> o2) {
            OWLAxiom ax1 = o1.getUserObject();
            OWLAxiom ax2 = o2.getUserObject();
            if (ax1 instanceof OWLEquivalentClassesAxiom) {
                return 1;
            }
            if (ax2 instanceof OWLEquivalentClassesAxiom) {
                return -1;
            }
            if (ax1 instanceof OWLPropertyAxiom) {
                return -1;
            }
            int diff = OWLAxiomTreeComparator.childDiff(o1, o2);
            if (diff != 0) {
                return diff;
            }
            if (ax1 instanceof OWLSubClassOfAxiom && ax2 instanceof OWLSubClassOfAxiom) {
                OWLSubClassOfAxiom sc1 = (OWLSubClassOfAxiom)ax1;
                OWLSubClassOfAxiom sc2 = (OWLSubClassOfAxiom)ax2;
                return sc1.getSuperClass().compareTo(sc2.getSuperClass());
            }
            return 1;
        }

        private static int childDiff(Tree<OWLAxiom> o1, Tree<OWLAxiom> o2) {
            int childCount1 = o1.getChildCount();
            childCount1 = childCount1 > 0 ? 0 : 1;
            int childCount2 = o2.getChildCount();
            childCount2 = childCount2 > 0 ? 0 : 1;
            return childCount1 - childCount2;
        }
    }

    private static class PropertiesFirstComparator
    implements Comparator<OWLObject>,
    Serializable {
        private static final long serialVersionUID = 40000L;

        PropertiesFirstComparator() {
        }

        @Override
        public int compare(OWLObject o1, OWLObject o2) {
            if (o1 instanceof OWLProperty) {
                return -1;
            }
            if (o1.equals(o2)) {
                return 0;
            }
            return 1;
        }
    }

    private static class TargetAxiomsComparator
    implements Comparator<OWLAxiom>,
    Serializable {
        private static final long serialVersionUID = 40000L;
        private final Set<OWLAxiom> targetAxioms;

        TargetAxiomsComparator(@Nonnull Set<OWLAxiom> targetAxioms) {
            this.targetAxioms = OWLAPIPreconditions.checkNotNull(targetAxioms, "targetAxioms cannot be null");
        }

        @Override
        public int compare(OWLAxiom o1, OWLAxiom o2) {
            if (this.targetAxioms.contains(o1)) {
                return 1;
            }
            if (this.targetAxioms.contains(o2)) {
                return -1;
            }
            return 0;
        }
    }
}

