/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.model.util;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.openrdf.model.Namespace;
import org.openrdf.model.impl.NamespaceImpl;

public class Namespaces {
    public static Map<String, String> asMap(Set<Namespace> namespaces) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Namespace nextNamespace : namespaces) {
            result.put(nextNamespace.getPrefix(), nextNamespace.getName());
        }
        return result;
    }

    public static Map<String, String> wrap(final Set<Namespace> namespaces) {
        return new Map<String, String>(){

            @Override
            public void clear() {
                namespaces.clear();
            }

            @Override
            public boolean containsKey(Object nextKey) {
                if (nextKey instanceof String) {
                    for (Namespace nextNamespace : namespaces) {
                        if (!nextNamespace.getPrefix().equals(nextKey)) continue;
                        return true;
                    }
                }
                return false;
            }

            @Override
            public boolean containsValue(Object nextValue) {
                if (nextValue instanceof String) {
                    for (Namespace nextNamespace : namespaces) {
                        if (!nextNamespace.getName().equals(nextValue)) continue;
                        return true;
                    }
                }
                return false;
            }

            @Override
            public Set<Map.Entry<String, String>> entrySet() {
                LinkedHashSet<AbstractMap.SimpleImmutableEntry<String, String>> result = new LinkedHashSet<AbstractMap.SimpleImmutableEntry<String, String>>();
                for (Namespace nextNamespace : namespaces) {
                    AbstractMap.SimpleImmutableEntry<String, String> nextEntry = new AbstractMap.SimpleImmutableEntry<String, String>(nextNamespace.getPrefix(), nextNamespace.getName());
                    result.add(nextEntry);
                }
                return Collections.unmodifiableSet(result);
            }

            @Override
            public String get(Object nextKey) {
                if (nextKey instanceof String) {
                    for (Namespace nextNamespace : namespaces) {
                        if (!nextNamespace.getPrefix().equals(nextKey)) continue;
                        return nextNamespace.getName();
                    }
                }
                return null;
            }

            @Override
            public boolean isEmpty() {
                return namespaces.isEmpty();
            }

            @Override
            public Set<String> keySet() {
                LinkedHashSet<String> result = new LinkedHashSet<String>();
                for (Namespace nextNamespace : namespaces) {
                    result.add(nextNamespace.getPrefix());
                }
                return result;
            }

            @Override
            public String put(String nextKey, String nextValue) {
                String result = null;
                for (Namespace nextNamespace : new LinkedHashSet(namespaces)) {
                    if (!nextNamespace.getPrefix().equals(nextKey)) continue;
                    result = nextNamespace.getName();
                    namespaces.remove(nextNamespace);
                }
                namespaces.add(new NamespaceImpl(nextKey, nextValue));
                return result;
            }

            @Override
            public void putAll(Map<? extends String, ? extends String> nextSet) {
                for (Map.Entry<? extends String, ? extends String> nextEntry : nextSet.entrySet()) {
                    this.put(nextEntry.getKey(), nextEntry.getValue());
                }
            }

            @Override
            public String remove(Object nextKey) {
                String result = null;
                for (Namespace nextNamespace : new LinkedHashSet(namespaces)) {
                    if (!nextNamespace.getPrefix().equals(nextKey)) continue;
                    result = nextNamespace.getName();
                    namespaces.remove(nextNamespace);
                }
                return result;
            }

            @Override
            public int size() {
                return namespaces.size();
            }

            @Override
            public Collection<String> values() {
                ArrayList<String> result = new ArrayList<String>();
                for (Namespace nextNamespace : namespaces) {
                    result.add(nextNamespace.getName());
                }
                return result;
            }
        };
    }

    private Namespaces() {
    }
}

