/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.translate;

import com.google.api.GoogleAPI;
import com.google.api.GoogleAPIException;
import com.google.api.translate.Language;
import com.google.api.translate.Translate;
import com.tecnick.htmlutils.htmlentities.HTMLEntities;
import java.net.URL;
import java.net.URLEncoder;
import org.json.JSONArray;
import org.json.JSONObject;

public final class TranslateV2
extends GoogleAPI
implements Translate {
    private static final String URL_TEMPLATE = "https://www.googleapis.com/language/translate/v2?key=%s&q=%s&target=%s";

    @Override
    public String execute(String text, Language from, Language to) throws GoogleAPIException {
        try {
            TranslateV2.validateReferrer();
            if (key == null) {
                throw new IllegalStateException("You MUST have a Google API Key to use the V2 APIs. See http://code.google.com/apis/language/translate/v2/getting_started.html");
            }
            String populatedTemplate = String.format(URL_TEMPLATE, key, URLEncoder.encode(text, "UTF-8"), to.toString());
            URL url = new URL(Language.AUTO_DETECT.equals((Object)from) ? populatedTemplate : populatedTemplate + String.format("&source=%s", from.toString()));
            JSONObject json = TranslateV2.retrieveJSON(url);
            return TranslateV2.getJSONResponse(json);
        }
        catch (Exception e) {
            System.out.println("Error: " + e.getMessage());
            throw new GoogleAPIException(e);
        }
    }

    @Override
    public String[] execute(String[] text, Language from, Language to) throws GoogleAPIException {
        try {
            TranslateV2.validateReferrer();
            Language[] fromArgs = new Language[text.length];
            Language[] toArgs = new Language[text.length];
            for (int i = 0; i < text.length; ++i) {
                fromArgs[i] = from;
                toArgs[i] = to;
            }
            return this.execute(text, fromArgs, toArgs);
        }
        catch (Exception e) {
            throw new GoogleAPIException(e);
        }
    }

    @Override
    public String[] execute(String text, Language from, Language[] to) throws GoogleAPIException {
        try {
            TranslateV2.validateReferrer();
            String[] textArgs = new String[to.length];
            Language[] fromArgs = new Language[to.length];
            for (int i = 0; i < to.length; ++i) {
                textArgs[i] = text;
                fromArgs[i] = from;
            }
            return this.execute(textArgs, fromArgs, to);
        }
        catch (Exception e) {
            throw new GoogleAPIException(e);
        }
    }

    @Override
    public String[] execute(String[] text, Language[] from, Language[] to) throws GoogleAPIException {
        try {
            TranslateV2.validateReferrer();
            if (text.length != from.length || from.length != to.length) {
                throw new Exception("[google-api-translate-java] The same number of texts, from and to languages must be supplied.");
            }
            if (text.length == 1) {
                return new String[]{this.execute(text[0], from[0], to[0])};
            }
            String[] responses = new String[text.length];
            for (int i = 0; i < responses.length; ++i) {
                responses[i] = this.execute(text[i], from[i], to[i]);
            }
            return responses;
        }
        catch (Exception e) {
            throw new GoogleAPIException(e);
        }
    }

    private static String getJSONResponse(JSONObject json) throws Exception {
        JSONObject data = json.getJSONObject("data");
        JSONArray translations = data.getJSONArray("translations");
        JSONObject translation = translations.getJSONObject(0);
        String translatedText = translation.getString("translatedText");
        return HTMLEntities.unhtmlentities(translatedText);
    }
}

