/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapitools.builders;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.profiles.OWL2DLProfile;
import org.semanticweb.owlapi.profiles.OWLProfile;
import org.semanticweb.owlapi.profiles.OWLProfileReport;
import org.semanticweb.owlapi.profiles.OWLProfileViolation;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapitools.builders.Builder;

public abstract class BaseBuilder<T extends OWLObject, B>
implements Builder<T> {
    @Nonnull
    protected final OWLDataFactory df;
    @Nonnull
    protected final Set<OWLAnnotation> annotations = new HashSet<OWLAnnotation>();
    @Nonnull
    private final OWLProfile profile = new OWL2DLProfile();

    @Inject
    protected BaseBuilder(OWLDataFactory df) {
        this.df = (OWLDataFactory)OWLAPIPreconditions.checkNotNull((Object)df);
    }

    @Nonnull
    public B withAnnotation(OWLAnnotation arg) {
        this.annotations.add(arg);
        return (B)this;
    }

    @Nonnull
    public B withAnnotations(@Nonnull Collection<OWLAnnotation> arg) {
        this.annotations.addAll(arg);
        return (B)this;
    }

    @Override
    public abstract T buildObject();

    @Override
    @Nonnull
    public List<OWLOntologyChange> applyChanges(@Nonnull OWLOntology o) {
        T object = this.buildObject();
        if (!(object instanceof OWLAxiom)) {
            return CollectionFactory.emptyList();
        }
        AddAxiom change = new AddAxiom(o, (OWLAxiom)object);
        o.getOWLOntologyManager().applyChange((OWLOntologyChange)change);
        ArrayList<OWLOntologyChange> changes = new ArrayList<OWLOntologyChange>();
        OWLProfileReport report = this.profile.checkOntology(o);
        for (OWLProfileViolation v : report.getViolations()) {
            changes.addAll(v.repair());
        }
        o.getOWLOntologyManager().applyChanges(changes);
        changes.add((OWLOntologyChange)change);
        return changes;
    }
}

