/*
 * Decompiled with CFR 0.152.
 */
package org.semarglproject.rdf.rdfa;

import java.util.HashMap;
import java.util.Map;
import org.semarglproject.rdf.rdfa.RdfaParser;
import org.semarglproject.rdf.rdfa.Vocabulary;
import org.semarglproject.ri.MalformedIriException;
import org.semarglproject.ri.RIUtils;

final class DocumentContext {
    static final short FORMAT_UNKNOWN = 0;
    static final short FORMAT_HTML4 = 1;
    static final short FORMAT_HTML5 = 2;
    static final short FORMAT_XML = 3;
    static final short FORMAT_SVG = 4;
    private static final String RDFA_10_STRING = "rdfa 1.0";
    private static final String HTML_ROOT_ELEMENT = "html";
    private static final String HTML_BASE = "base";
    private static final String SVG_ROOT_ELEMENT = "svg";
    short documentFormat;
    short rdfaVersion;
    final RdfaParser parser;
    String base;
    String originUri;
    private Map<String, String> bnodeMapping = new HashMap<String, String>();
    private int nextBnodeId;

    DocumentContext(RdfaParser parser) {
        this.parser = parser;
        this.nextBnodeId = 0;
        this.clear((short)2);
    }

    String resolveBNode(String value) {
        if (value.startsWith("_:") || value.startsWith("[_:") && value.charAt(value.length() - 1) == ']') {
            String name = value.charAt(0) == '[' ? value.substring("_:".length() + 1, value.length() - 1) : value.substring("_:".length());
            if (!this.bnodeMapping.containsKey(name)) {
                this.bnodeMapping.put(name, this.createBnode(false));
            }
            return this.bnodeMapping.get(name);
        }
        return null;
    }

    void detectFormat(String localName, String qName, String version) {
        if (this.documentFormat == 0) {
            this.documentFormat = localName.equals(SVG_ROOT_ELEMENT) ? (short)4 : (localName.equalsIgnoreCase(HTML_ROOT_ELEMENT) ? (short)1 : (short)3);
        }
        if (qName.equalsIgnoreCase(HTML_ROOT_ELEMENT) && version != null && version.toLowerCase().contains(RDFA_10_STRING)) {
            this.rdfaVersion = 1;
        }
    }

    void detectBase(String qName, String xmlBase, String hRef) {
        boolean xmlBaseF;
        boolean bl = xmlBaseF = (this.documentFormat == 3 || this.documentFormat == 4) && xmlBase != null;
        if (xmlBaseF || qName.equalsIgnoreCase(HTML_BASE) && hRef != null) {
            this.base = (xmlBaseF ? xmlBase : hRef).replaceAll("#.*", "");
        }
    }

    String createBnode(boolean shortenable) {
        if (shortenable) {
            return "_:n" + this.nextBnodeId++ + "sbl";
        }
        return "_:n" + this.nextBnodeId++;
    }

    void processDtd(String name, String publicId, String systemId) {
        if (publicId == null) {
            if (HTML_ROOT_ELEMENT.equalsIgnoreCase(name)) {
                this.documentFormat = (short)2;
            }
        } else {
            String publicIdLower = publicId.toLowerCase();
            if (publicIdLower.contains(HTML_ROOT_ELEMENT)) {
                this.documentFormat = 1;
            }
            if (publicIdLower.contains(RDFA_10_STRING)) {
                this.rdfaVersion = 1;
            }
        }
    }

    String resolveIri(String iri) throws MalformedIriException {
        return RIUtils.resolveIri((String)this.base, (String)iri);
    }

    void clear(short defaultRdfaVersion) {
        this.rdfaVersion = defaultRdfaVersion;
        this.documentFormat = 0;
        this.bnodeMapping = new HashMap<String, String>();
        this.base = null;
        this.originUri = null;
    }

    Vocabulary loadVocabulary(String vocabUrl) {
        return this.parser.loadVocabulary(vocabUrl);
    }

    void setBaseUri(String baseUri) {
        if (this.base == null) {
            this.originUri = baseUri;
        }
        this.base = baseUri;
    }
}

