/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.krr.logmap_lite;

import java.net.URL;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import uk.ac.manchester.syntactic_locality.OntologyModuleExtractor;
import uk.ac.ox.krr.logmap2.io.LogOutput;
import uk.ac.ox.krr.logmap2.io.OutPutFilesManager;
import uk.ac.ox.krr.logmap2.owlapi.SynchronizedOWLManager;
import uk.ac.ox.krr.logmap2.reasoning.SatisfiabilityIntegration;
import uk.ac.ox.krr.logmap_lite.MappingObjectStr;
import uk.ac.ox.krr.logmap_lite.OntologyLoader;
import uk.ac.ox.krr.logmap_lite.OntologyProcessing;
import uk.ac.ox.krr.logmap_lite.io.OAEIAlignmentOutput;
import uk.ac.ox.krr.logmap_lite.io.OWLAlignmentFormat;
import uk.ac.ox.krr.logmap_lite.io.RDFAlignmentFormat;
import uk.ac.ox.krr.logmap_lite.io.ReadFile;

public class LogMap_Lite {
    public static final int L2R = 0;
    public static final int R2L = -1;
    public static final int EQ = -2;
    private long init_tot;
    private long init;
    private long fin;
    private double time_loading = 0.0;
    private double total_time = 0.0;
    private OntologyLoader onto_loader1;
    private OntologyLoader onto_loader2;
    private OntologyProcessing onto_proc1;
    private OntologyProcessing onto_proc2;
    private boolean extract_overlapping = false;
    private boolean check_with_gold_standard = false;
    private OWLOntology module1_overlapping;
    private OWLOntology module2_overlapping;
    private OWLOntology mappings_owl;
    private OAEIAlignmentOutput alignment_output;
    private Map<Integer, Set<Integer>> mappings;
    private Map<Integer, Set<Integer>> mappingsOProp;
    private Map<Integer, Set<Integer>> mappingsDProp;
    private Map<Integer, Set<Integer>> mappingsIndiv;
    private boolean outPutOnlyIndiv;
    private String output_path;
    private Set<MappingObjectStr> mappings_gs = new HashSet<MappingObjectStr>();
    private Set<MappingObjectStr> mappings_ll = new HashSet<MappingObjectStr>();
    double precision = 0.0;
    double recall = 0.0;
    double fmeasure = 0.0;
    private int num_unsat = 0;

    public LogMap_Lite() {
        this.extract_overlapping = false;
        this.check_with_gold_standard = false;
    }

    public LogMap_Lite(String iri1_str, String iri2_str, String gs_mappings_file, boolean create_owl_mappings_onto, boolean extract_overlapping, boolean eval_impact) {
        this.extract_overlapping = extract_overlapping;
        try {
            this.outPutOnlyIndiv = false;
            this.init_tot = Calendar.getInstance().getTimeInMillis();
            this.loadingAndProcessingOntologies(iri1_str, iri2_str);
            if (!gs_mappings_file.equals("")) {
                this.check_with_gold_standard = true;
            }
            this.computeMappings();
            if (this.check_with_gold_standard) {
                this.loadMappingsGS(gs_mappings_file);
                this.getPrecisionAndRecallMappings();
            }
            this.fin = Calendar.getInstance().getTimeInMillis();
            this.total_time = (double)((float)((double)this.fin - (double)this.init_tot)) / 1000.0;
            this.total_time -= this.time_loading;
            System.out.println("Time loading ontos (s): " + this.time_loading);
            System.out.println("LogMap Lite Matching Time (s): " + this.total_time);
            if (create_owl_mappings_onto) {
                this.createOWLOntology4Mappings();
            }
            if (extract_overlapping) {
                this.computeOveralapping();
            }
            if (eval_impact) {
                this.init = Calendar.getInstance().getTimeInMillis();
                this.impactIntegration();
                this.fin = Calendar.getInstance().getTimeInMillis();
                this.total_time = (double)((float)((double)this.fin - (double)this.init)) / 1000.0;
                System.out.println("Time checking impact (s): " + this.total_time);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public LogMap_Lite(String iri1_str, String iri2_str, String gs_mappings_file, String output_path) {
        try {
            this.outPutOnlyIndiv = true;
            this.output_path = output_path;
            this.init_tot = Calendar.getInstance().getTimeInMillis();
            this.loadingAndProcessingOntologies(iri1_str, iri2_str);
            if (!gs_mappings_file.equals("")) {
                this.check_with_gold_standard = true;
            }
            this.computeMappings();
            if (this.check_with_gold_standard) {
                this.loadMappingsGS(gs_mappings_file);
                this.getPrecisionAndRecallMappings();
            }
            this.createOWLOntology4Mappings();
            this.saveExtractedIndividualMappings("logmap_lite");
            this.fin = Calendar.getInstance().getTimeInMillis();
            this.total_time = (double)((float)((double)this.fin - (double)this.init_tot)) / 1000.0;
            this.total_time -= this.time_loading;
            System.out.println("Time loading ontos (s): " + this.time_loading);
            System.out.println("LogMap Lite Matching Time (s): " + this.total_time + "\n");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public LogMap_Lite(String iri1_str, String iri2_str, String output_path) {
        try {
            this.align(iri1_str, iri2_str);
            this.saveMapping(output_path);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void align(URL source, URL target) throws Exception {
        this.init_tot = Calendar.getInstance().getTimeInMillis();
        this.loadingAndProcessingOntologies(source.toURI().toString(), target.toURI().toString());
        this.computeMappings();
        this.fin = Calendar.getInstance().getTimeInMillis();
        this.total_time = (double)((float)((double)this.fin - (double)this.init_tot)) / 1000.0;
        this.total_time -= this.time_loading;
        System.out.println("Time loading ontos (s): " + this.time_loading);
        System.out.println("LogMap Lite Matching Time (s): " + this.total_time);
    }

    public void align(String source, String target) throws Exception {
        this.init_tot = Calendar.getInstance().getTimeInMillis();
        this.loadingAndProcessingOntologies(source, target);
        this.computeMappings();
        this.fin = Calendar.getInstance().getTimeInMillis();
        this.total_time = (double)((float)((double)this.fin - (double)this.init_tot)) / 1000.0;
        this.total_time -= this.time_loading;
        System.out.println("Size LogMap Lite mappings: " + this.mappings.size());
        System.out.println("Time loading ontos (s): " + this.time_loading);
        System.out.println("LogMap Lite Matching Time (s): " + this.total_time);
    }

    public URL returnAlignmentFile() throws Exception {
        this.alignment_output = new OAEIAlignmentOutput("alignment", this.onto_loader1.getOntologyIRIStr(), this.onto_loader2.getOntologyIRIStr());
        for (int ide1 : this.mappings.keySet()) {
            for (int ide2 : this.mappings.get(ide1)) {
                this.alignment_output.addClassMapping2Output(this.onto_proc1.getIRI4identifier(ide1), this.onto_proc2.getIRI4identifier(ide2), -2, 1.0);
            }
        }
        for (int ide1 : this.mappingsDProp.keySet()) {
            for (int ide2 : this.mappingsDProp.get(ide1)) {
                this.alignment_output.addDataPropMapping2Output(this.onto_proc1.getIRI4DPropIdentifier(ide1), this.onto_proc2.getIRI4DPropIdentifier(ide2), -2, 1.0);
            }
        }
        for (int ide1 : this.mappingsOProp.keySet()) {
            for (int ide2 : this.mappingsOProp.get(ide1)) {
                this.alignment_output.addObjPropMapping2Output(this.onto_proc1.getIRI4OPropIdentifier(ide1), this.onto_proc2.getIRI4OPropIdentifier(ide2), -2, 1.0);
            }
        }
        for (int ide1 : this.mappingsIndiv.keySet()) {
            for (int ide2 : this.mappingsIndiv.get(ide1)) {
                this.alignment_output.addInstanceMapping2Output(this.onto_proc1.getIRI4Individual(ide1), this.onto_proc2.getIRI4Individual(ide2), 1.0);
            }
        }
        this.alignment_output.saveOutputFile();
        return this.alignment_output.returnAlignmentFile();
    }

    public void saveMapping(String output_folder) throws Exception {
        OutPutFilesManager ouput_manager = new OutPutFilesManager();
        ouput_manager.createOutFiles(output_folder + "logmap-lite-mappings", 4, this.onto_loader1.getOntologyIRIStr(), this.onto_loader2.getOntologyIRIStr());
        for (int ide1 : this.mappings.keySet()) {
            for (int ide2 : this.mappings.get(ide1)) {
                ouput_manager.addClassMapping2Files(this.onto_proc1.getIRI4identifier(ide1), this.onto_proc2.getIRI4identifier(ide2), -2, 1.0);
            }
        }
        for (int ide1 : this.mappingsDProp.keySet()) {
            for (int ide2 : this.mappingsDProp.get(ide1)) {
                ouput_manager.addDataPropMapping2Files(this.onto_proc1.getIRI4DPropIdentifier(ide1), this.onto_proc2.getIRI4DPropIdentifier(ide2), -2, 1.0);
            }
        }
        for (int ide1 : this.mappingsOProp.keySet()) {
            for (int ide2 : this.mappingsOProp.get(ide1)) {
                ouput_manager.addObjPropMapping2Files(this.onto_proc1.getIRI4OPropIdentifier(ide1), this.onto_proc2.getIRI4OPropIdentifier(ide2), -2, 1.0);
            }
        }
        for (int ide1 : this.mappingsIndiv.keySet()) {
            for (int ide2 : this.mappingsIndiv.get(ide1)) {
                ouput_manager.addInstanceMapping2Files(this.onto_proc1.getIRI4Individual(ide1), this.onto_proc2.getIRI4Individual(ide2), 1.0);
            }
        }
        ouput_manager.closeAndSaveFiles();
    }

    private void saveExtractedIndividualMappings(String file_name) throws Exception {
        RDFAlignmentFormat rdf_output = new RDFAlignmentFormat(this.output_path + "/" + file_name + ".rdf", this.onto_loader1.getOntologyIRIStr(), this.onto_loader2.getOntologyIRIStr());
        for (int ide1 : this.mappingsIndiv.keySet()) {
            for (int ide2 : this.mappingsIndiv.get(ide1)) {
                rdf_output.addInstanceMapping2Output(this.onto_proc1.getIRI4Individual(ide1), this.onto_proc2.getIRI4Individual(ide2), 1.0);
            }
        }
        rdf_output.saveOutputFile();
    }

    private void loadingAndProcessingOntologies(String iri1_str, String iri2_str) throws Exception {
        this.init = Calendar.getInstance().getTimeInMillis();
        this.onto_loader1 = new OntologyLoader(iri1_str);
        this.fin = Calendar.getInstance().getTimeInMillis();
        this.time_loading += (double)((float)((double)this.fin - (double)this.init)) / 1000.0;
        this.init = Calendar.getInstance().getTimeInMillis();
        this.onto_proc1 = new OntologyProcessing(this.onto_loader1.getOWLOntology(), this.extract_overlapping);
        this.onto_loader1.createAxiomSet();
        this.onto_loader1.clearOntology();
        this.onto_proc1.clearOntoloy();
        this.fin = Calendar.getInstance().getTimeInMillis();
        this.init = Calendar.getInstance().getTimeInMillis();
        this.onto_loader2 = new OntologyLoader(iri2_str);
        this.fin = Calendar.getInstance().getTimeInMillis();
        this.time_loading += (double)((float)((double)this.fin - (double)this.init)) / 1000.0;
        this.init = Calendar.getInstance().getTimeInMillis();
        this.onto_proc2 = new OntologyProcessing(this.onto_loader2.getOWLOntology(), this.extract_overlapping);
        this.onto_loader2.createAxiomSet();
        this.onto_loader2.clearOntology();
        this.onto_proc2.clearOntoloy();
        this.fin = Calendar.getInstance().getTimeInMillis();
    }

    private void computeMappings() {
        this.computeClassMappings();
        this.computeDataPropMappings();
        this.computeObjPropMappings();
        this.compuetIndividualMappings();
    }

    private void computeClassMappings() {
        this.init = Calendar.getInstance().getTimeInMillis();
        Set<Set<String>> if_exact_intersect = this.onto_proc1.getInvertedFileExact().keySet();
        if_exact_intersect.retainAll(this.onto_proc2.getInvertedFileExact().keySet());
        this.onto_proc2.getInvertedFileExact().keySet().retainAll(if_exact_intersect);
        this.fin = Calendar.getInstance().getTimeInMillis();
        this.mappings = new HashMap<Integer, Set<Integer>>();
        for (Set<String> entry : if_exact_intersect) {
            if (entry.isEmpty()) {
                System.out.println("EMPTY SET IN IF CLASSES");
                continue;
            }
            for (int ide1 : this.onto_proc1.getInvertedFileExact().get(entry)) {
                if (!this.mappings.containsKey(ide1)) {
                    this.mappings.put(ide1, new HashSet());
                }
                for (int ide2 : this.onto_proc2.getInvertedFileExact().get(entry)) {
                    this.mappings.get(ide1).add(ide2);
                }
            }
        }
        if (this.check_with_gold_standard && !this.outPutOnlyIndiv) {
            Iterator<Object> iterator = this.mappings.keySet().iterator();
            while (iterator.hasNext()) {
                int ide1 = (Integer)iterator.next();
                for (int ide2 : this.mappings.get(ide1)) {
                    this.mappings_ll.add(new MappingObjectStr(this.onto_proc1.getIRI4identifier(ide1), this.onto_proc2.getIRI4identifier(ide2)));
                }
            }
        }
    }

    private void compuetIndividualMappings() {
        this.init = Calendar.getInstance().getTimeInMillis();
        Set<Set<String>> if_exact_intersect_indiv = this.onto_proc1.getInvertedFileExactIndividuals().keySet();
        if_exact_intersect_indiv.retainAll(this.onto_proc2.getInvertedFileExactIndividuals().keySet());
        this.onto_proc2.getInvertedFileExactIndividuals().keySet().retainAll(if_exact_intersect_indiv);
        this.fin = Calendar.getInstance().getTimeInMillis();
        this.mappingsIndiv = new HashMap<Integer, Set<Integer>>();
        for (Set<String> entry : if_exact_intersect_indiv) {
            if (entry.isEmpty()) {
                System.out.println("EMPTY SET IN IF CLASSES");
                continue;
            }
            for (int ide1 : this.onto_proc1.getInvertedFileExactIndividuals().get(entry)) {
                if (!this.mappingsIndiv.containsKey(ide1)) {
                    this.mappingsIndiv.put(ide1, new HashSet());
                }
                for (int ide2 : this.onto_proc2.getInvertedFileExactIndividuals().get(entry)) {
                    this.mappingsIndiv.get(ide1).add(ide2);
                }
            }
        }
        if (this.check_with_gold_standard) {
            Iterator<Object> iterator = this.mappingsIndiv.keySet().iterator();
            while (iterator.hasNext()) {
                int ide1 = (Integer)iterator.next();
                for (int ide2 : this.mappingsIndiv.get(ide1)) {
                    this.mappings_ll.add(new MappingObjectStr(this.onto_proc1.getIRI4Individual(ide1), this.onto_proc2.getIRI4Individual(ide2)));
                }
            }
        }
    }

    private void computeDataPropMappings() {
        this.init = Calendar.getInstance().getTimeInMillis();
        Set<Set<String>> if_exact_intersect = this.onto_proc1.getInvertedFileExactDataProp().keySet();
        if_exact_intersect.retainAll(this.onto_proc2.getInvertedFileExactDataProp().keySet());
        this.onto_proc2.getInvertedFileExactDataProp().keySet().retainAll(if_exact_intersect);
        this.fin = Calendar.getInstance().getTimeInMillis();
        this.mappingsDProp = new HashMap<Integer, Set<Integer>>();
        for (Set<String> entry : if_exact_intersect) {
            for (int ide1 : this.onto_proc1.getInvertedFileExactDataProp().get(entry)) {
                if (!this.mappingsDProp.containsKey(ide1)) {
                    this.mappingsDProp.put(ide1, new HashSet());
                }
                for (int ide2 : this.onto_proc2.getInvertedFileExactDataProp().get(entry)) {
                    this.mappingsDProp.get(ide1).add(ide2);
                }
            }
        }
        if (this.check_with_gold_standard && !this.outPutOnlyIndiv) {
            Iterator<Object> iterator = this.mappingsDProp.keySet().iterator();
            while (iterator.hasNext()) {
                int ide1 = (Integer)iterator.next();
                for (int ide2 : this.mappingsDProp.get(ide1)) {
                    this.mappings_ll.add(new MappingObjectStr(this.onto_proc1.getIRI4DPropIdentifier(ide1), this.onto_proc2.getIRI4DPropIdentifier(ide2)));
                }
            }
        }
    }

    private void computeObjPropMappings() {
        this.init = Calendar.getInstance().getTimeInMillis();
        Set<Set<String>> if_exact_intersect = this.onto_proc1.getInvertedFileExactObjectProp().keySet();
        if_exact_intersect.retainAll(this.onto_proc2.getInvertedFileExactObjectProp().keySet());
        this.onto_proc2.getInvertedFileExactObjectProp().keySet().retainAll(if_exact_intersect);
        this.fin = Calendar.getInstance().getTimeInMillis();
        this.mappingsOProp = new HashMap<Integer, Set<Integer>>();
        for (Set<String> entry : if_exact_intersect) {
            for (int ide1 : this.onto_proc1.getInvertedFileExactObjectProp().get(entry)) {
                if (!this.mappingsOProp.containsKey(ide1)) {
                    this.mappingsOProp.put(ide1, new HashSet());
                }
                for (int ide2 : this.onto_proc2.getInvertedFileExactObjectProp().get(entry)) {
                    this.mappingsOProp.get(ide1).add(ide2);
                }
            }
        }
        if (this.check_with_gold_standard && !this.outPutOnlyIndiv) {
            Iterator<Object> iterator = this.mappingsOProp.keySet().iterator();
            while (iterator.hasNext()) {
                int ide1 = (Integer)iterator.next();
                for (int ide2 : this.mappingsOProp.get(ide1)) {
                    this.mappings_ll.add(new MappingObjectStr(this.onto_proc1.getIRI4OPropIdentifier(ide1), this.onto_proc2.getIRI4OPropIdentifier(ide2)));
                }
            }
        }
    }

    private void computeOveralapping() {
        this.init = Calendar.getInstance().getTimeInMillis();
        Set<Set<String>> if_weak_intersect = this.onto_proc1.getWeakInvertedFile().keySet();
        if_weak_intersect.retainAll(this.onto_proc2.getWeakInvertedFile().keySet());
        this.onto_proc2.getWeakInvertedFile().keySet().retainAll(if_weak_intersect);
        this.fin = Calendar.getInstance().getTimeInMillis();
        HashSet<OWLEntity> entities1 = new HashSet<OWLEntity>();
        HashSet<OWLEntity> entities2 = new HashSet<OWLEntity>();
        for (Set<String> str_set : if_weak_intersect) {
            for (int ide1 : this.onto_proc1.getWeakInvertedFile().get(str_set)) {
                entities1.add((OWLEntity)this.onto_proc1.getOWLClass4identifier(ide1));
            }
            for (int ide2 : this.onto_proc2.getWeakInvertedFile().get(str_set)) {
                entities2.add((OWLEntity)this.onto_proc2.getOWLClass4identifier(ide2));
            }
        }
        this.onto_proc1.clearStructures();
        this.onto_proc2.clearStructures();
        this.fin = Calendar.getInstance().getTimeInMillis();
        this.init = Calendar.getInstance().getTimeInMillis();
        OntologyModuleExtractor module_extractor1 = new OntologyModuleExtractor(SynchronizedOWLManager.createOWLOntologyManager(), this.onto_loader1.getAxiomSet(), true, false, true);
        try {
            this.module1_overlapping = module_extractor1.extractAsOntology(entities1, IRI.create((String)this.onto_loader1.getOntologyIRIStr()));
        }
        catch (OWLOntologyCreationException e) {
            LogOutput.print("Error when creating module ontology 1");
        }
        module_extractor1.clearStrutures();
        this.onto_loader1.clearAxiomSet();
        entities1.clear();
        OntologyModuleExtractor module_extractor2 = new OntologyModuleExtractor(SynchronizedOWLManager.createOWLOntologyManager(), this.onto_loader2.getAxiomSet(), true, false, true);
        try {
            this.module2_overlapping = module_extractor2.extractAsOntology(entities2, IRI.create((String)this.onto_loader2.getOntologyIRIStr()));
        }
        catch (OWLOntologyCreationException e) {
            LogOutput.print("Error when creating module ontology 2");
        }
        module_extractor2.clearStrutures();
        this.onto_loader2.clearAxiomSet();
        entities2.clear();
        this.fin = Calendar.getInstance().getTimeInMillis();
    }

    public OWLOntology getModule1() {
        return this.module1_overlapping;
    }

    public OWLOntology getModule2() {
        return this.module2_overlapping;
    }

    public OWLOntology getOWLMappingsOntology() {
        return this.mappings_owl;
    }

    private void createOWLOntology4Mappings() throws Exception {
        OWLAlignmentFormat owl_alignment_output = new OWLAlignmentFormat("alignment.owl");
        for (int ide1 : this.mappings.keySet()) {
            for (int ide2 : this.mappings.get(ide1)) {
                owl_alignment_output.addClassMapping2Output(this.onto_proc1.getIRI4identifier(ide1), this.onto_proc2.getIRI4identifier(ide2), -2, 1.0);
            }
        }
        for (int ide1 : this.mappingsDProp.keySet()) {
            for (int ide2 : this.mappingsDProp.get(ide1)) {
                owl_alignment_output.addDataPropMapping2Output(this.onto_proc1.getIRI4DPropIdentifier(ide1), this.onto_proc2.getIRI4DPropIdentifier(ide2), -2, 1.0);
            }
        }
        for (int ide1 : this.mappingsOProp.keySet()) {
            for (int ide2 : this.mappingsOProp.get(ide1)) {
                owl_alignment_output.addObjPropMapping2Output(this.onto_proc1.getIRI4OPropIdentifier(ide1), this.onto_proc2.getIRI4OPropIdentifier(ide2), -2, 1.0);
            }
        }
        for (int ide1 : this.mappingsIndiv.keySet()) {
            for (int ide2 : this.mappingsIndiv.get(ide1)) {
                owl_alignment_output.addInstanceMapping2Output(this.onto_proc1.getIRI4Individual(ide1), this.onto_proc2.getIRI4Individual(ide2), 1.0);
            }
        }
        this.mappings_owl = owl_alignment_output.getOWLOntology();
    }

    private void loadMappingsGS(String gs_mappings) throws Exception {
        ReadFile reader = new ReadFile(gs_mappings);
        String line = reader.readLine();
        while (line != null) {
            if (line.indexOf("|") < 0 && line.indexOf("\t") < 0) {
                line = reader.readLine();
                continue;
            }
            String[] elements = line.indexOf("|") >= 0 ? line.split("\\|") : line.split("\\t");
            this.mappings_gs.add(new MappingObjectStr(elements[0], elements[1]));
            line = reader.readLine();
        }
        reader.closeBuffer();
    }

    public Map<Integer, Set<Integer>> getClassMappings() {
        return this.mappings;
    }

    public Map<Integer, Set<Integer>> getDataPropMappings() {
        return this.mappingsDProp;
    }

    public Map<Integer, Set<Integer>> getObjectPropMappings() {
        return this.mappingsOProp;
    }

    public Map<Integer, Set<Integer>> getInstanceMappings() {
        return this.mappingsIndiv;
    }

    public double getPrecision() {
        return this.precision;
    }

    public double getRecall() {
        return this.recall;
    }

    public double getFmeasure() {
        return this.fmeasure;
    }

    private void getPrecisionAndRecallMappings() throws Exception {
        HashSet<MappingObjectStr> intersection = new HashSet<MappingObjectStr>(this.mappings_gs);
        intersection.retainAll(this.mappings_ll);
        this.precision = (double)intersection.size() / (double)this.mappings_ll.size();
        this.recall = (double)intersection.size() / (double)this.mappings_gs.size();
        this.fmeasure = 2.0 * this.recall * this.precision / (this.precision + this.recall);
        System.out.println("WRT GS MAPPINGS");
        System.out.println("\tPrecision Mappings: " + this.precision);
        System.out.println("\tRecall Mapping: " + this.recall);
        System.out.println("\tF measure: " + 2.0 * this.recall * this.precision / (this.precision + this.recall));
        HashSet<MappingObjectStr> difference = new HashSet<MappingObjectStr>(this.mappings_gs);
        difference.removeAll(this.mappings_ll);
        System.out.println("Difference in GS: " + difference.size());
        HashSet<MappingObjectStr> difference2 = new HashSet<MappingObjectStr>(this.mappings_ll);
        difference2.removeAll(this.mappings_gs);
        System.out.println("Difference in Candidates: " + difference2.size());
    }

    public Set<MappingObjectStr> getLogMapLiteMappings() {
        return this.mappings_ll;
    }

    private void impactIntegration() throws Exception {
        System.out.println(this.module1_overlapping.getAxiomCount());
        System.out.println(this.module2_overlapping.getAxiomCount());
        System.out.println(this.mappings_owl.getAxiomCount());
        SatisfiabilityIntegration sat_checker = new SatisfiabilityIntegration(this.module1_overlapping, this.module2_overlapping, this.mappings_owl, false, false);
        this.num_unsat = sat_checker.getNumUnsatClasses();
        System.out.println("Num unsat classes: " + this.num_unsat);
    }

    public boolean hasUnsatClasses() {
        return this.num_unsat > 0;
    }

    public int getNumUnsatClasses() {
        return this.num_unsat;
    }

    public static void main(String[] args) {
        String gs_mappings;
        String uri2;
        String uri1;
        int ontos = 1;
        if (ontos == 1) {
            uri1 = "file:/usr/local/data/DataUMLS/UMLS_Onto_Versions/OAEI_datasets/fma2nci_dataset/oaei2012_FMA_whole_ontology.owl";
            uri2 = "file:/usr/local/data/DataUMLS/UMLS_Onto_Versions/OAEI_datasets/fma2nci_dataset/oaei2012_NCI_whole_ontology.owl";
            gs_mappings = "/usr/local/data/DataUMLS/UMLS_source_data/onto_mappings_FMA_NCI_cleantDG.txt";
        } else if (ontos == 2) {
            uri1 = "file:/usr/local/data/DataUMLS/UMLS_Onto_Versions/OAEI_datasets/fma2nci_dataset/oaei2012_FMA_whole_ontology.owl";
            uri2 = "file:/usr/local/data/DataUMLS/UMLS_Onto_Versions/OAEI_datasets/snomed20090131_replab.owl";
            gs_mappings = "/usr/local/data/DataUMLS/UMLS_source_data/onto_mappings_FMA_SNOMED_cleantDG.txt";
        } else if (ontos == 3) {
            uri1 = "file:/usr/local/data/DataUMLS/UMLS_Onto_Versions/OAEI_datasets/snomed20090131_replab.owl";
            uri2 = "file:/usr/local/data/DataUMLS/UMLS_Onto_Versions/OAEI_datasets/fma2nci_dataset/oaei2012_NCI_whole_ontology.owl";
            gs_mappings = "/usr/local/data/DataUMLS/UMLS_source_data/onto_mappings_SNOMED_NCI_cleantDG.txt";
        } else {
            uri1 = "file:/usr/local/data/DataUMLS/UMLS_Onto_Versions/Anatomy/mouse_anatomy_2010.owl";
            uri2 = "file:/usr/local/data/DataUMLS/UMLS_Onto_Versions/Anatomy/nci_anatomy_2010.owl";
            gs_mappings = "/usr/local/data/DataUMLS/UMLS_Onto_Versions/Anatomy/GSAll_Anatomy_2010.txt";
        }
        boolean overlapping = false;
        boolean create_owl_mappings_onto = false;
        boolean eval_impact = false;
        uri1 = "file:/usr/local/data/Benchmark_Track/onto101.owl";
        uri2 = "file:/usr/local/data/Benchmark_Track/onto201.owl";
        uri1 = "http://seals-test.sti2.at/tdrs-web/testdata/persistent/biblio-dataset/biblio-dataset-r1/suite/101/component/source";
        uri2 = "http://seals-test.sti2.at/tdrs-web/testdata/persistent/biblio-dataset/biblio-dataset-r1/suite/202/component/target";
        gs_mappings = "";
        LogMap_Lite logmap = new LogMap_Lite(uri1, uri2, gs_mappings, create_owl_mappings_onto, overlapping, eval_impact);
    }
}

