/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.krr.logmap2.utilities;

import java.util.Set;
import uk.ac.ox.krr.logmap2.mappings.objects.MappingObjectStr;
import uk.ac.ox.krr.logmap2.utilities.HashAlignment;

public class StandardMeasures {
    private static double precision = 0.0;
    private static double recall = 0.0;
    private static double fscore = 0.0;

    public static double getPrecision() {
        return precision;
    }

    public static double getRecall() {
        return recall;
    }

    public static double getFscore() {
        return fscore;
    }

    public static void computeStandardMeasures(Set<MappingObjectStr> system, Set<MappingObjectStr> reference) {
        HashAlignment system_aligment = new HashAlignment(system);
        HashAlignment reference_aligment = new HashAlignment(reference);
        StandardMeasures.computeStandardMeasures(system_aligment, reference_aligment);
    }

    public static void computeStandardMeasures(HashAlignment system, HashAlignment reference) {
        StandardMeasures.evaluationParameters(reference.evaluation(system));
    }

    private static void evaluationParameters(int[] classif) {
        if (classif[0] + classif[1] == 0 || classif[0] + classif[2] == 0) {
            fscore = 0.0;
            recall = 0.0;
            precision = 0.0;
            return;
        }
        precision = Math.min((double)Math.round((double)classif[0] * 1000.0 / (double)(classif[0] + classif[1])) / 1000.0, 1.0);
        recall = Math.min((double)Math.round((double)classif[0] * 1000.0 / (double)(classif[0] + classif[2])) / 1000.0, 1.0);
        fscore = (double)Math.round(2000.0 * precision * recall / (precision + recall)) / 1000.0;
    }
}

