/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.krr.logmap2.reasoning;

import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.reasoner.BufferingMode;
import org.semanticweb.owlapi.reasoner.ClassExpressionNotInProfileException;
import org.semanticweb.owlapi.reasoner.FreshEntitiesException;
import org.semanticweb.owlapi.reasoner.InconsistentOntologyException;
import org.semanticweb.owlapi.reasoner.NodeSet;
import org.semanticweb.owlapi.reasoner.OWLReasonerConfiguration;
import org.semanticweb.owlapi.reasoner.ReasonerInterruptedException;
import org.semanticweb.owlapi.reasoner.SimpleConfiguration;
import org.semanticweb.owlapi.reasoner.TimeOutException;
import org.semanticweb.owlapi.reasoner.impl.OWLClassNodeSet;
import org.semanticweb.owlapi.reasoner.structural.StructuralReasoner;

public class StructuralReasonerExtended
extends StructuralReasoner {
    public StructuralReasonerExtended(OWLOntology rootOntology) {
        super(rootOntology, (OWLReasonerConfiguration)new SimpleConfiguration(), BufferingMode.NON_BUFFERING);
    }

    public NodeSet<OWLClass> getDisjointClasses(OWLClassExpression ce) {
        OWLClassNodeSet nodeSet = new OWLClassNodeSet();
        if (!ce.isAnonymous()) {
            for (OWLOntology ontology : this.getRootOntology().getImportsClosure()) {
                for (OWLDisjointClassesAxiom ax : ontology.getDisjointClassesAxioms(ce.asOWLClass())) {
                    for (OWLClassExpression op : ax.getClassExpressions()) {
                        if (op.isAnonymous() || op.equals(ce)) continue;
                        nodeSet.addNode(this.getEquivalentClasses(op));
                    }
                }
            }
        }
        return nodeSet;
    }

    public boolean isSubClassOf(OWLClass cls1, OWLClass cls2) {
        return this.getSubClasses((OWLClassExpression)cls2, false).getFlattened().contains(cls1);
    }

    public boolean areEquivalent(OWLClass cls1, OWLClass cls2) {
        return this.getEquivalentClasses((OWLClassExpression)cls1).getEntities().contains(cls2) || this.getEquivalentClasses((OWLClassExpression)cls2).getEntities().contains(cls1);
    }

    public NodeSet<OWLClass> getSubClasses(OWLClassExpression ce, boolean direct) throws InconsistentOntologyException, ClassExpressionNotInProfileException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        OWLClassNodeSet ns = new OWLClassNodeSet();
        try {
            return super.getSubClasses(ce, direct);
        }
        catch (StackOverflowError e) {
            System.err.println("StackOverflowError in Structural reasoner: getSubClasses for Class " + ce.toString());
            return ns;
        }
    }

    public NodeSet<OWLClass> getSuperClasses(OWLClassExpression ce, boolean direct) throws InconsistentOntologyException, ClassExpressionNotInProfileException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        OWLClassNodeSet ns = new OWLClassNodeSet();
        try {
            return super.getSuperClasses(ce, direct);
        }
        catch (StackOverflowError e) {
            System.err.println("StackOverflowError in Structural reasoner: getSuperClasses for Class " + ce.toString());
            return ns;
        }
    }

    public String getReasonerName() {
        return "Extended Structural Reasoner";
    }
}

