/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.krr.logmap2.reasoning;

import java.util.HashSet;
import java.util.Set;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import uk.ac.ox.krr.logmap2.owlapi.SynchronizedOWLManager;
import uk.ac.ox.krr.logmap2.reasoning.ELKAccess;
import uk.ac.ox.krr.logmap2.reasoning.HermiTAccess;
import uk.ac.ox.krr.logmap2.reasoning.ReasonerAccess;

public class ReasonerManager {
    public static int NONE = -1;
    public static int HERMIT = 0;
    public static int PELLET = 1;
    public static int ELK = 2;
    public static int FACTpp = 3;
    public static int TrOWL = 4;
    public static int MORe = 5;
    public static int STRUCTURAL = 6;

    public static ReasonerAccess getReasoner(int reasoner_id, OWLOntologyManager ontoManager, OWLOntology onto, boolean useFactory) throws Exception {
        if (reasoner_id == HERMIT) {
            return new HermiTAccess(ontoManager, onto, useFactory);
        }
        if (reasoner_id == ELK) {
            return new ELKAccess(ontoManager, onto, useFactory);
        }
        return new HermiTAccess(ontoManager, onto, useFactory);
    }

    public static ReasonerAccess getMergedOntologyReasoner(int reasoner_id, OWLOntology onto1, OWLOntology onto2, OWLOntology m, boolean useFactory) throws Exception {
        return ReasonerManager.getMergedOntologyReasoner(reasoner_id, onto1.getAxioms(), onto2.getAxioms(), m.getAxioms(), useFactory);
    }

    public static ReasonerAccess getMergedOntologyReasoner(int reasoner_id, Set<OWLAxiom> onto1_ax, Set<OWLAxiom> onto2_ax, Set<OWLAxiom> m_ax, boolean useFactory) throws Exception {
        HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>();
        axioms.addAll(onto1_ax);
        axioms.addAll(onto2_ax);
        axioms.addAll(m_ax);
        OWLOntologyManager managerMerged = SynchronizedOWLManager.createOWLOntologyManager();
        OWLOntology mergedOntology = managerMerged.createOntology(axioms, IRI.create((String)"http://krr.ox.cs.ac.uk/logmap2/integration.owl"));
        if (reasoner_id == HERMIT) {
            return new HermiTAccess(managerMerged, mergedOntology, useFactory);
        }
        if (reasoner_id == ELK) {
            return new ELKAccess(managerMerged, mergedOntology, useFactory);
        }
        return new HermiTAccess(managerMerged, mergedOntology, useFactory);
    }
}

