/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.krr.logmap2.reasoning;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.reasoner.InferenceType;
import org.semanticweb.owlapi.reasoner.Node;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.reasoner.OWLReasonerFactory;
import org.semanticweb.owlapi.util.DLExpressivityChecker;
import org.semanticweb.owlapi.util.InferredAxiomGenerator;
import org.semanticweb.owlapi.util.InferredEquivalentClassAxiomGenerator;
import org.semanticweb.owlapi.util.InferredOntologyGenerator;
import org.semanticweb.owlapi.util.InferredSubClassAxiomGenerator;
import uk.ac.ox.krr.logmap2.Parameters;
import uk.ac.ox.krr.logmap2.io.LogOutput;
import uk.ac.ox.krr.logmap2.owlapi.SynchronizedOWLManager;
import uk.ac.ox.krr.logmap2.reasoning.ReasonerAccess;

public abstract class ReasonerAccessImpl
extends ReasonerAccess {
    protected long init;
    protected long fin;
    protected OWLOntology ontoBase;
    protected OWLOntologyManager ontoManager;
    protected OWLDataFactory datafactory;
    protected OWLReasoner reasoner;
    protected OWLReasonerFactory reasonerFactory;
    protected Set<OWLAxiom> closure;
    protected int closure_lang = 0;
    protected Set<OWLClassExpression> activeConcepts;
    protected String reasonerName = "";
    protected boolean isClassified = false;
    private String DLNameOnto;
    private OWLClassExpression current_cls;
    private int resultClassEval;

    public ReasonerAccessImpl(OWLOntologyManager ontoManager, OWLOntology onto, boolean useFactory) throws Exception {
        this.ontoManager = ontoManager;
        this.ontoBase = onto;
        this.datafactory = ontoManager.getOWLDataFactory();
        this.closure = new HashSet<OWLAxiom>();
        this.setUpReasoner(useFactory);
    }

    @Override
    public void clearStructures() {
        this.closure.clear();
        this.reasoner.dispose();
    }

    public void dispose() {
        this.reasoner.dispose();
    }

    public void interrupt() {
        this.reasoner.interrupt();
    }

    protected void setUpReasoner(boolean withFactory) throws Exception {
    }

    public String getDLNameOntology() {
        return this.DLNameOnto;
    }

    @Override
    public boolean isOntologyClassified() {
        return this.isClassified;
    }

    @Override
    public void classifyOntology_withTimeout(int timeoutSecs) {
        this.isClassified = false;
        ExecutorService executor = Executors.newFixedThreadPool(1);
        Future<?> future = executor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    ReasonerAccessImpl.this.classifyOntologyNoProperties();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
        try {
            future.get(timeoutSecs, TimeUnit.SECONDS);
            future.cancel(true);
            executor.shutdown();
        }
        catch (TimeoutException e) {
            LogOutput.print("Time out classifying with HermiT. Using 'structural' reasoner instead.");
            this.isClassified = false;
            this.reasoner.interrupt();
            this.reasoner.dispose();
            future.cancel(true);
            executor.shutdown();
        }
        catch (Exception e) {
            LogOutput.print("Error classifying ontology with " + this.reasoner.getReasonerName());
            e.printStackTrace();
        }
    }

    @Override
    public void classifyOntology_withTimeout_throws_Exception(int timeoutSecs) throws Exception {
        this.isClassified = false;
        ExecutorService executor = Executors.newFixedThreadPool(1);
        Future<?> future = executor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    ReasonerAccessImpl.this.classifyOntologyNoProperties();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
        try {
            future.get(timeoutSecs, TimeUnit.SECONDS);
            future.cancel(true);
            executor.shutdown();
        }
        catch (TimeoutException e) {
            this.isClassified = false;
            this.reasoner.interrupt();
            this.reasoner.dispose();
            future.cancel(true);
            executor.shutdown();
            LogOutput.print("Timeout classifying ontology with " + this.reasoner.getReasonerName());
            throw new TimeoutException();
        }
        catch (Exception e) {
            this.isClassified = false;
            this.reasoner.dispose();
            future.cancel(true);
            executor.shutdown();
            LogOutput.print("Error classifying ontology with " + this.reasoner.getReasonerName());
            throw new Exception();
        }
    }

    public void classifyOntologyNoProperties() throws Exception {
        this.classifyOntology(false);
    }

    @Override
    public void classifyOntology() throws Exception {
        this.classifyOntology(true);
    }

    @Override
    public void classifyOntology(boolean classproperties) throws Exception {
        this.isClassified = false;
        try {
            HashSet<OWLOntology> importsClosure = new HashSet<OWLOntology>();
            importsClosure.add(this.ontoBase);
            DLExpressivityChecker checker = new DLExpressivityChecker(importsClosure);
            this.init = Calendar.getInstance().getTimeInMillis();
            LogOutput.print("\nClassifying '" + checker.getDescriptionLogicName() + "' Ontology with " + this.reasonerName + "... ");
            this.reasoner.precomputeInferences(new InferenceType[]{InferenceType.CLASS_HIERARCHY});
            if (classproperties) {
                this.reasoner.precomputeInferences(new InferenceType[]{InferenceType.DATA_PROPERTY_HIERARCHY});
                this.reasoner.precomputeInferences(new InferenceType[]{InferenceType.OBJECT_PROPERTY_HIERARCHY});
            }
            if (Parameters.perform_instance_matching) {
                this.reasoner.precomputeInferences(new InferenceType[]{InferenceType.CLASS_ASSERTIONS});
            }
            this.fin = Calendar.getInstance().getTimeInMillis();
            LogOutput.print("Done, Time (s): " + (double)((float)((double)this.fin - (double)this.init)) / 1000.0 + "\n");
            this.isClassified = true;
        }
        catch (Exception e) {
            LogOutput.print("Error classifying ontology with " + this.reasonerName + "\n" + e.getMessage() + "\n" + e.getLocalizedMessage());
            throw new Exception();
        }
    }

    @Override
    public OWLOntology getOntology() {
        return this.ontoBase;
    }

    @Override
    public OWLReasoner getReasoner() {
        return this.reasoner;
    }

    @Override
    public OWLReasonerFactory getReasonerFactory() {
        return this.reasonerFactory;
    }

    @Override
    public boolean isConsistent() {
        return this.reasoner.isConsistent();
    }

    @Override
    public boolean isEntailed(OWLAxiom ax) {
        return this.reasoner.isEntailed(ax);
    }

    @Override
    public boolean isSubClassOf(OWLClass cls1, OWLClass cls2) {
        return this.reasoner.isEntailed((OWLAxiom)this.datafactory.getOWLSubClassOfAxiom((OWLClassExpression)cls1, (OWLClassExpression)cls2));
    }

    @Override
    public boolean areDisjointClasses(OWLClass cls1, OWLClass cls2) {
        return !this.reasoner.isSatisfiable((OWLClassExpression)this.datafactory.getOWLObjectIntersectionOf(new OWLClassExpression[]{cls1, cls2}));
    }

    @Override
    public boolean areEquivalentClasses(OWLClass cls1, OWLClass cls2) {
        return this.reasoner.isEntailed((OWLAxiom)this.datafactory.getOWLEquivalentClassesAxiom((OWLClassExpression)cls1, (OWLClassExpression)cls2));
    }

    @Override
    public boolean isSatisfiable(OWLClass cls) {
        return this.reasoner.isSatisfiable((OWLClassExpression)cls);
    }

    public void doWork_SatCls() {
        try {
            this.resultClassEval = this.reasoner.isSatisfiable(this.current_cls) ? 0 : 1;
        }
        catch (Exception e) {
            if (!this.current_cls.isAnonymous()) {
                System.out.println("Unknown class: " + this.current_cls.asOWLClass().getIRI().toString());
            }
            this.resultClassEval = 2;
        }
    }

    @Override
    public int isSatisfiable_withTimeout(OWLClassExpression cls, int timeoutSecs) {
        this.current_cls = cls;
        this.resultClassEval = 2;
        ExecutorService executor = Executors.newFixedThreadPool(1);
        Future<?> future = executor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    ReasonerAccessImpl.this.doWork_SatCls();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
        try {
            future.get(timeoutSecs, TimeUnit.SECONDS);
            future.cancel(true);
            executor.shutdown();
        }
        catch (TimeoutException e) {
            this.resultClassEval = 2;
            future.cancel(true);
            executor.shutdown();
        }
        catch (Exception e) {
            this.resultClassEval = 2;
        }
        return this.resultClassEval;
    }

    @Override
    public boolean hasUnsatisfiableClasses() {
        return this.getUnsatisfiableClasses().size() > 0;
    }

    @Override
    public Set<OWLClass> getUnsatisfiableClasses() {
        return this.getUnsatisfiableClasses(false);
    }

    private Set<OWLClass> getUnsatisfiableClasses(boolean print) {
        try {
            Node node = this.reasoner.getUnsatisfiableClasses();
            Set set = node.getEntitiesMinusBottom();
            if (!set.isEmpty()) {
                if (print) {
                    System.err.println("The following classes are unsatisfiable: ");
                }
                for (OWLClass cls : set) {
                    if (!print) continue;
                    System.err.println(" " + cls);
                }
            } else if (print) {
                System.out.println("There are '0' unsatisfiable classes.");
            }
            return set;
        }
        catch (Exception e) {
            System.err.println("Error when invoking the reasoner to get unsatisfiable classes.");
            return new HashSet<OWLClass>();
        }
    }

    @Override
    public void setLanguage4Closure(int language) {
        this.closure_lang = language;
    }

    @Override
    public void createClosure(int language) {
        this.setLanguage4Closure(language);
        this.createClosure();
    }

    @Override
    public void createClosure() {
        switch (this.closure_lang) {
            case 0: {
                this.createClosureLSub();
                break;
            }
        }
    }

    @Override
    public Set<OWLAxiom> getClosure() {
        return this.closure;
    }

    private Set<OWLClassExpression> getActiveClassExpressions() {
        return this.activeConcepts;
    }

    private void createClosureLSub() {
        try {
            this.init = Calendar.getInstance().getTimeInMillis();
            LogOutput.print("Extracting Lsub closure... ");
            for (OWLClass cls : this.reasoner.getUnsatisfiableClasses()) {
                if (cls.isOWLNothing()) continue;
                OWLSubClassOfAxiom unsatAx = this.ontoManager.getOWLDataFactory().getOWLSubClassOfAxiom((OWLClassExpression)cls, (OWLClassExpression)this.ontoManager.getOWLDataFactory().getOWLNothing());
                this.closure.add((OWLAxiom)unsatAx);
            }
            OWLOntologyManager classifiedOntoMan = SynchronizedOWLManager.createOWLOntologyManager();
            IRI iri = this.ontoBase.getOntologyID().getOntologyIRI().isPresent() ? (IRI)this.ontoBase.getOntologyID().getOntologyIRI().get() : IRI.create((String)"http://inferred-ontology.owl");
            OWLOntology inferredOnt = classifiedOntoMan.createOntology(iri);
            InferredOntologyGenerator ontGen = new InferredOntologyGenerator(this.reasoner, new ArrayList());
            ontGen.addGenerator((InferredAxiomGenerator)new InferredEquivalentClassAxiomGenerator());
            ontGen.addGenerator((InferredAxiomGenerator)new InferredSubClassAxiomGenerator());
            ontGen.fillOntology(classifiedOntoMan.getOWLDataFactory(), inferredOnt);
            for (OWLAxiom ax : inferredOnt.getAxioms()) {
                if (!(ax instanceof OWLSubClassOfAxiom) || ((OWLSubClassOfAxiom)ax).getSuperClass().isOWLThing() || this.ontoBase.containsAxiom(ax)) continue;
                this.closure.add(ax);
            }
            this.fin = Calendar.getInstance().getTimeInMillis();
            LogOutput.print("Done, Time (s): " + (double)((float)((double)this.fin - (double)this.init)) / 1000.0);
            LogOutput.print("Closure:\n" + this.closure.size());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

