/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.krr.logmap2.overlapping;

import java.util.Calendar;
import java.util.HashSet;
import java.util.Set;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLOntology;
import uk.ac.manchester.syntactic_locality.ModuleExtractor;
import uk.ac.ox.krr.logmap2.Parameters;
import uk.ac.ox.krr.logmap2.io.LogOutput;
import uk.ac.ox.krr.logmap2.mappings.objects.MappingObjectStr;
import uk.ac.ox.krr.logmap2.owlapi.SynchronizedOWLManager;

public class OverlappingExtractor4Mappings {
    protected OWLOntology module1;
    protected OWLOntology module2;
    boolean is_overlapping_onto1 = true;
    boolean is_overlapping_onto2 = true;
    Set<OWLEntity> entities1 = new HashSet<OWLEntity>();
    Set<OWLEntity> entities2 = new HashSet<OWLEntity>();
    OWLDataFactory dataFactory;

    public void createOverlapping(OWLOntology onto1, OWLOntology onto2, Set<MappingObjectStr> mappings) throws Exception {
        long init = Calendar.getInstance().getTimeInMillis();
        this.entities1.clear();
        this.entities2.clear();
        this.dataFactory = SynchronizedOWLManager.createOWLDataFactory();
        if (onto1.getSignature().size() < Parameters.min_size_overlapping) {
            this.is_overlapping_onto1 = false;
        }
        if (onto2.getSignature().size() < Parameters.min_size_overlapping) {
            this.is_overlapping_onto2 = false;
        }
        for (MappingObjectStr map : mappings) {
            if (map.getTypeOfMapping() == 0) {
                if (this.is_overlapping_onto1) {
                    this.entities1.add((OWLEntity)this.dataFactory.getOWLClass(IRI.create((String)map.getIRIStrEnt1())));
                }
                if (!this.is_overlapping_onto2) continue;
                this.entities2.add((OWLEntity)this.dataFactory.getOWLClass(IRI.create((String)map.getIRIStrEnt2())));
                continue;
            }
            if (map.getTypeOfMapping() == 2) {
                if (this.is_overlapping_onto1) {
                    this.entities1.add((OWLEntity)this.dataFactory.getOWLObjectProperty(IRI.create((String)map.getIRIStrEnt1())));
                }
                if (!this.is_overlapping_onto2) continue;
                this.entities2.add((OWLEntity)this.dataFactory.getOWLObjectProperty(IRI.create((String)map.getIRIStrEnt2())));
                continue;
            }
            if (map.getTypeOfMapping() == 1) {
                if (this.is_overlapping_onto1) {
                    this.entities1.add((OWLEntity)this.dataFactory.getOWLDataProperty(IRI.create((String)map.getIRIStrEnt1())));
                }
                if (!this.is_overlapping_onto2) continue;
                this.entities2.add((OWLEntity)this.dataFactory.getOWLDataProperty(IRI.create((String)map.getIRIStrEnt2())));
                continue;
            }
            if (map.getTypeOfMapping() != 3) continue;
            if (this.is_overlapping_onto1) {
                this.entities1.add((OWLEntity)this.dataFactory.getOWLNamedIndividual(IRI.create((String)map.getIRIStrEnt1())));
            }
            if (!this.is_overlapping_onto2) continue;
            this.entities2.add((OWLEntity)this.dataFactory.getOWLNamedIndividual(IRI.create((String)map.getIRIStrEnt2())));
        }
        if (this.is_overlapping_onto1) {
            ModuleExtractor module_extractor1 = new ModuleExtractor(onto1.getAxioms(), SynchronizedOWLManager.createOWLOntologyManager(), false, false, true, true, false);
            this.module1 = module_extractor1.getLocalityModuleForSignatureGroup(this.entities1, onto1.getOntologyID().getOntologyIRI().toString(), false);
            module_extractor1.clearStrutures();
            this.entities1.clear();
        } else {
            this.module1 = onto1;
        }
        if (this.is_overlapping_onto2) {
            ModuleExtractor module_extractor2 = new ModuleExtractor(onto2.getAxioms(), SynchronizedOWLManager.createOWLOntologyManager(), false, false, true, true, false);
            this.module2 = module_extractor2.getLocalityModuleForSignatureGroup(this.entities2, onto2.getOntologyID().getOntologyIRI().toString(), false);
            module_extractor2.clearStrutures();
            this.entities2.clear();
        } else {
            this.module2 = onto2;
        }
        long fin = Calendar.getInstance().getTimeInMillis();
        LogOutput.print("\tSize module 1 (overlapping): " + this.module1.getSignature().size() + "  " + onto1.getSignature().size());
        LogOutput.print("\tSize module 2 (overlapping): " + this.module2.getSignature().size() + "  " + onto2.getSignature().size());
        LogOutput.print("\tTime extracting modules (s): " + (double)((float)((double)fin - (double)init)) / 1000.0);
    }

    public OWLOntology getOverlappingOnto1() {
        return this.module1;
    }

    public OWLOntology getOverlappingOnto2() {
        return this.module2;
    }
}

