/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.krr.logmap2.overlapping;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.semanticweb.owlapi.search.EntitySearcher;
import uk.ac.ox.krr.logmap2.indexing.ExtractStringFromAnnotationAssertionAxiom;
import uk.ac.ox.krr.logmap2.io.LogOutput;
import uk.ac.ox.krr.logmap2.lexicon.LexicalUtilities;
import uk.ac.ox.krr.logmap2.utilities.PrecomputeIndexCombination;
import uk.ac.ox.krr.logmap2.utilities.Utilities;

public class OntologyProcessing4Overlapping {
    protected Map<Set<String>, Set<Integer>> invertedFileWeakLabels = new HashMap<Set<String>, Set<Integer>>();
    Map<Integer, OWLClass> identifier2class = new HashMap<Integer, OWLClass>();
    Map<OWLClass, Integer> class2identifier = new HashMap<OWLClass, Integer>();
    private Map<Integer, Set<List<String>>> identifier2stemmedlabels = new HashMap<Integer, Set<List<String>>>();
    protected String rdf_label_uri = "http://www.w3.org/2000/01/rdf-schema#label";
    protected String synonym_iri = "http://oaei.ontologymatching.org/annotations#synonym";
    OWLOntology onto;
    int max_size_labels = 7;
    int max_size_words_missing = 2;
    private PrecomputeIndexCombination precomputeIndexCombination = new PrecomputeIndexCombination();
    private LexicalUtilities lexicalUtilities;
    private boolean full_overlapping;
    private boolean use_class2identifier_index;
    private ExtractStringFromAnnotationAssertionAxiom annotationExtractor = new ExtractStringFromAnnotationAssertionAxiom();
    protected int ident = 0;

    public OntologyProcessing4Overlapping(OWLOntology ont, LexicalUtilities lexicalUtilities, boolean full_overlapping, boolean use_class2identifier_index) {
        this(ont, lexicalUtilities, full_overlapping, use_class2identifier_index, 0);
    }

    public OntologyProcessing4Overlapping(OWLOntology ont, LexicalUtilities lexicalUtilities, boolean full_overlapping, boolean use_class2identifier_index, int init_index) {
        this.onto = ont;
        this.lexicalUtilities = lexicalUtilities;
        this.full_overlapping = full_overlapping;
        this.use_class2identifier_index = use_class2identifier_index;
        this.ident = init_index;
        this.precomputeIndexCombination.preComputeIdentifierCombination();
    }

    public void clearOntoloy() {
        this.onto = null;
    }

    public int getLastidentifier() {
        return this.ident;
    }

    public void processOntologyClassLabels() {
        HashSet<String> words = new HashSet<String>();
        HashSet<String> stemmed_words = new HashSet<String>();
        for (OWLClass cls : this.onto.getClassesInSignature(Imports.INCLUDED)) {
            if (cls.isTopEntity() || cls.isBottomEntity()) continue;
            this.identifier2class.put(this.ident, cls);
            if (this.use_class2identifier_index) {
                this.class2identifier.put(cls, this.ident);
            }
            this.identifier2stemmedlabels.put(this.ident, new HashSet());
            for (String label : this.extractLabels4OWLCls(cls)) {
                words.addAll(this.cleanLabel(label));
                if (words.size() > 0) {
                    if (!this.invertedFileWeakLabels.containsKey(words)) {
                        this.invertedFileWeakLabels.put(new HashSet(words), new HashSet());
                    }
                    this.invertedFileWeakLabels.get(words).add(this.ident);
                }
                for (String str : words) {
                    stemmed_words.add(this.lexicalUtilities.getStemming4Word(str));
                }
                if (stemmed_words.size() > 0) {
                    if (!this.invertedFileWeakLabels.containsKey(stemmed_words)) {
                        this.invertedFileWeakLabels.put(new HashSet(stemmed_words), new HashSet());
                    }
                    this.invertedFileWeakLabels.get(stemmed_words).add(this.ident);
                }
                this.identifier2stemmedlabels.get(this.ident).add(new ArrayList(stemmed_words));
                words.clear();
                stemmed_words.clear();
            }
            ++this.ident;
        }
        LogOutput.print("\t\tClasses index: " + this.identifier2class.keySet().size());
        LogOutput.print("\t\tClasses labels: " + this.identifier2stemmedlabels.size());
    }

    public void setInvertedFile4Overlapping() {
        this.setInvertedFileWeakLabels();
        this.identifier2stemmedlabels.clear();
        LogOutput.print("\t\tSize inverted file: " + this.invertedFileWeakLabels.size());
    }

    public Map<Set<String>, Set<Integer>> getWeakInvertedFile() {
        return this.invertedFileWeakLabels;
    }

    public OWLClass getClass4identifier(int ident) {
        return this.identifier2class.get(ident);
    }

    public int getIdentifier4Class(OWLClass cls) {
        if (this.class2identifier.containsKey(cls)) {
            return this.class2identifier.get(cls);
        }
        return -1;
    }

    public void clearClass2Identifier() {
        this.class2identifier.clear();
    }

    public void clearStructures() {
        this.invertedFileWeakLabels.clear();
        this.identifier2class.clear();
        this.class2identifier.clear();
        this.identifier2stemmedlabels.clear();
    }

    private Set<String> extractLabels4OWLCls(OWLClass cls) {
        if (this.full_overlapping) {
            return this.extractAllLabels4OWLCls(cls, 20);
        }
        return this.extractLimitedLabels4OWLCls(cls, 3);
    }

    private Set<String> extractLimitedLabels4OWLCls(OWLClass cls, int max_size) {
        HashSet<String> labels = new HashSet<String>();
        for (OWLAnnotationAssertionAxiom annAx : EntitySearcher.getAnnotationAssertionAxioms((OWLEntity)cls, (OWLOntology)this.onto)) {
            if (!annAx.getAnnotation().getProperty().getIRI().toString().equals(this.rdf_label_uri) && !annAx.getAnnotation().getProperty().getIRI().toString().equals(this.synonym_iri)) continue;
            labels.add(((OWLLiteral)annAx.getAnnotation().getValue()).getLiteral());
            if (labels.size() < max_size) continue;
            break;
        }
        String name_class = Utilities.getEntityLabelFromURI(cls.getIRI().toString());
        if (labels.isEmpty() || !name_class.matches(".+[0-9][0-9][0-9]+")) {
            labels.add(name_class);
        }
        return labels;
    }

    private Set<String> extractAllLabels4OWLCls(OWLClass cls, int max_size) {
        HashSet<String> labels = new HashSet<String>();
        for (OWLAnnotationAssertionAxiom annAx : EntitySearcher.getAnnotationAssertionAxioms((OWLEntity)cls, (OWLOntology)this.onto)) {
            labels.addAll(this.annotationExtractor.getAnntotationString(annAx, this.onto, this.onto.getOWLOntologyManager().getOWLDataFactory()));
            if (labels.size() < max_size) continue;
            break;
        }
        String name_class = Utilities.getEntityLabelFromURI(cls.getIRI().toString());
        if (labels.isEmpty() || !name_class.matches(".+[0-9][0-9][0-9]+")) {
            labels.add(name_class);
        }
        return labels;
    }

    private List<String> cleanLabel(String label_value) {
        ArrayList<String> cleanWords = new ArrayList<String>();
        String[] words = (label_value = label_value.replace(",", "")).indexOf("_") > 0 ? label_value.split("_") : (label_value.indexOf(" ") > 0 ? label_value.split(" ") : Utilities.splitStringByCapitalLetter(label_value));
        for (int i = 0; i < words.length; ++i) {
            words[i] = words[i].toLowerCase();
            if (words[i].length() <= 0 || this.lexicalUtilities.getStopwordsSet().contains(words[i])) continue;
            cleanWords.add(words[i]);
        }
        return cleanWords;
    }

    private List<String> extractCleanLabel4OWLCls(OWLClass cls) {
        String label_value = "";
        ArrayList<String> cleanWords = new ArrayList<String>();
        for (OWLAnnotationAssertionAxiom annAx : EntitySearcher.getAnnotationAssertionAxioms((OWLEntity)cls, (OWLOntology)this.onto)) {
            if (!annAx.getAnnotation().getProperty().getIRI().toString().equals(this.rdf_label_uri)) continue;
            label_value = ((OWLLiteral)annAx.getAnnotation().getValue()).getLiteral();
            break;
        }
        if (label_value.equals("")) {
            label_value = Utilities.getEntityLabelFromURI(cls.getIRI().toString());
        }
        String[] words = (label_value = label_value.replace(",", "")).indexOf("_") > 0 ? label_value.split("_") : (label_value.indexOf(" ") > 0 ? label_value.split(" ") : Utilities.splitStringByCapitalLetter(label_value));
        for (int i = 0; i < words.length; ++i) {
            words[i] = words[i].toLowerCase();
            if (words[i].length() <= 0 || this.lexicalUtilities.getStopwordsSet().contains(words[i])) continue;
            cleanWords.add(words[i]);
        }
        return cleanWords;
    }

    private void setInvertedFileWeakLabels() {
        for (int ident : this.identifier2stemmedlabels.keySet()) {
            for (List<String> words : this.identifier2stemmedlabels.get(ident)) {
                if (words.size() > this.max_size_labels || words.size() <= 1) continue;
                this.createWeakLabels4Identifier(words, ident, 1);
                if (words.size() <= 3 || this.max_size_words_missing <= 1) continue;
                this.createWeakLabels4Identifier(words, ident, 2);
                if (words.size() <= 5 || this.max_size_words_missing <= 2) continue;
                this.createWeakLabels4Identifier(words, ident, 3);
                if (words.size() <= 7 || this.max_size_words_missing <= 3) continue;
                this.createWeakLabels4Identifier(words, ident, 4);
            }
        }
    }

    private void createWeakLabels4Identifier(List<String> cleanWords, int ident, int missing_words) {
        HashSet<String> combo = new HashSet<String>();
        Set<Set<Integer>> combination_set = this.precomputeIndexCombination.getIdentifierCombination(cleanWords.size(), missing_words);
        for (Set<Integer> toExclude : combination_set) {
            for (int pos = 0; pos < cleanWords.size(); ++pos) {
                if (toExclude.contains(pos)) continue;
                combo.add(cleanWords.get(pos));
            }
            if (!this.invertedFileWeakLabels.containsKey(combo)) {
                this.invertedFileWeakLabels.put(new HashSet(combo), new HashSet());
            }
            this.invertedFileWeakLabels.get(combo).add(ident);
            combo.clear();
        }
    }
}

