/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.krr.logmap2.oaei.reader;

import java.util.Set;
import uk.ac.ox.krr.logmap2.mappings.objects.MappingObjectStr;
import uk.ac.ox.krr.logmap2.oaei.reader.EmptyReader;
import uk.ac.ox.krr.logmap2.oaei.reader.FlatAlignmentReader;
import uk.ac.ox.krr.logmap2.oaei.reader.MappingsReader;
import uk.ac.ox.krr.logmap2.oaei.reader.OWLAlignmentReader;
import uk.ac.ox.krr.logmap2.oaei.reader.RDFAlignReader;

public class MappingsReaderManager {
    public static final String OWLFormat = "OWL";
    public static final String OAEIFormat = "RDF";
    public static final String FlatFormat = "TXT";
    MappingsReader mappingsReader;

    public MappingsReaderManager(String file_mappings, String format) {
        try {
            if (format.equals(OWLFormat)) {
                this.mappingsReader = new OWLAlignmentReader(file_mappings);
            } else if (format.equals(OAEIFormat)) {
                this.mappingsReader = new RDFAlignReader(file_mappings);
            } else if (format.equals(FlatFormat)) {
                this.mappingsReader = new FlatAlignmentReader(file_mappings);
            } else {
                System.err.println("The given format ('" + format + "') is not currently supported. Accepted: 'OWL', 'RDF' and 'TXT'");
                this.mappingsReader = new EmptyReader();
            }
        }
        catch (Exception e) {
            System.err.println("Error reading mappings file: " + format + "\n" + e.getMessage());
            e.printStackTrace();
            this.mappingsReader = new EmptyReader();
        }
    }

    public Set<MappingObjectStr> getMappingObjects() {
        return this.mappingsReader.getMappingObjects();
    }

    public int getMappingObjectsSize() {
        return this.mappingsReader.getMappingObjectsSize();
    }
}

