/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.krr.logmap2.oaei.oracle;

import uk.ac.ox.krr.logmap2.io.LogOutput;
import uk.ac.ox.krr.logmap2.oaei.oracle.LocalOracle;
import uk.ac.ox.krr.logmap2.oaei.oracle.OAEIOracle;

public class OracleManager {
    private static int numQuestions = 0;
    private static final int NOTSET = 0;
    private static final int NO = 1;
    private static final int YES = 2;
    private static final int LOCAL = 3;
    private static int status_oraculo = 0;
    private static LocalOracle localOracle = new LocalOracle();
    private static OAEIOracle oaeiOracle = new OAEIOracle();

    public static void allowOracle(boolean allow) {
        if (allow) {
            OracleManager.unsetStatusOraculo();
        } else {
            status_oraculo = 1;
        }
    }

    public static void setLocalOracle(boolean active) {
        status_oraculo = active ? 3 : 1;
    }

    public static boolean isActive() {
        if (status_oraculo == 0) {
            try {
                if (oaeiOracle.isActive()) {
                    status_oraculo = 2;
                    return true;
                }
                status_oraculo = 1;
                return false;
            }
            catch (Exception e) {
                LogOutput.printAlways("Error asking Oracle");
                status_oraculo = 1;
                return false;
            }
        }
        if (status_oraculo == 1) {
            return false;
        }
        if (status_oraculo == 2) {
            return true;
        }
        return localOracle.isActive();
    }

    public static boolean isMappingValid(String uri1, String uri2) {
        if (status_oraculo == 3) {
            ++numQuestions;
            return localOracle.isMappingValid(uri1, uri2);
        }
        ++numQuestions;
        return oaeiOracle.isMappingValid(uri1, uri2);
    }

    public static int getNumberOfQuestions() {
        return numQuestions;
    }

    public static int getStatusOraculo() {
        return status_oraculo;
    }

    public static void unsetStatusOraculo() {
        numQuestions = 0;
        status_oraculo = 0;
    }
}

