/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.krr.logmap2.oaei;

import java.util.Collection;
import java.util.Iterator;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.search.Searcher;
import uk.ac.ox.krr.logmap2.io.LogOutput;

public class OAEI2015InstanceProcessing {
    public int getPublicationCount(OWLOntology onto, OWLNamedIndividual indiv) {
        OWLObjectProperty author_of = onto.getOWLOntologyManager().getOWLDataFactory().getOWLObjectProperty(IRI.create((String)"http://islab.di.unimi.it/imoaei2015#author_of"));
        OWLDataProperty publication_count = onto.getOWLOntologyManager().getOWLDataFactory().getOWLDataProperty(IRI.create((String)"http://islab.di.unimi.it/imoaei2015#publication_count"));
        Collection publications = Searcher.values((Collection)onto.getObjectPropertyAssertionAxioms((OWLIndividual)indiv), (OWLObjectPropertyExpression)author_of);
        try {
            if (publications.size() > 1 || publications.isEmpty()) {
                return publications.size();
            }
            for (OWLIndividual pub : publications) {
                Collection data_values = Searcher.values((Collection)onto.getDataPropertyAssertionAxioms(pub), (OWLDataPropertyExpression)publication_count);
                Iterator iterator = data_values.iterator();
                if (!iterator.hasNext()) continue;
                OWLLiteral value = (OWLLiteral)iterator.next();
                return value.parseInteger();
            }
            return 1;
        }
        catch (Exception e) {
            LogOutput.printError("Error extracting information about publications.");
            return 0;
        }
    }

    public int getNumberOfCitations(OWLOntology onto, OWLNamedIndividual indiv) {
        OWLObjectProperty author_of = onto.getOWLOntologyManager().getOWLDataFactory().getOWLObjectProperty(IRI.create((String)"http://islab.di.unimi.it/imoaei2015#author_of"));
        OWLDataProperty citations = onto.getOWLOntologyManager().getOWLDataFactory().getOWLDataProperty(IRI.create((String)"http://islab.di.unimi.it/imoaei2015#citations"));
        OWLDataProperty sum_of_citations = onto.getOWLOntologyManager().getOWLDataFactory().getOWLDataProperty(IRI.create((String)"http://islab.di.unimi.it/imoaei2015#sum_of_citations"));
        Collection publications = Searcher.values((Collection)onto.getObjectPropertyAssertionAxioms((OWLIndividual)indiv), (OWLObjectPropertyExpression)author_of);
        try {
            if (publications.isEmpty()) {
                return 0;
            }
            int num_citations = 0;
            for (OWLIndividual pub : publications) {
                Collection data_values = Searcher.values((Collection)onto.getDataPropertyAssertionAxioms(pub), (OWLDataPropertyExpression)sum_of_citations);
                Iterator iterator = data_values.iterator();
                if (iterator.hasNext()) {
                    OWLLiteral value = (OWLLiteral)iterator.next();
                    return value.parseInteger();
                }
                data_values = Searcher.values((Collection)onto.getDataPropertyAssertionAxioms(pub), (OWLDataPropertyExpression)citations);
                for (OWLLiteral value : data_values) {
                    num_citations += value.parseInteger();
                }
            }
            return num_citations;
        }
        catch (Exception e) {
            LogOutput.printError("Error extracting information about publications.");
            return 0;
        }
    }

    public int getActiveFromYear(OWLOntology onto, OWLNamedIndividual indiv) {
        OWLObjectProperty author_of = onto.getOWLOntologyManager().getOWLDataFactory().getOWLObjectProperty(IRI.create((String)"http://islab.di.unimi.it/imoaei2015#author_of"));
        OWLDataProperty active_from = onto.getOWLOntologyManager().getOWLDataFactory().getOWLDataProperty(IRI.create((String)"http://islab.di.unimi.it/imoaei2015#active_from"));
        OWLDataProperty year = onto.getOWLOntologyManager().getOWLDataFactory().getOWLDataProperty(IRI.create((String)"http://islab.di.unimi.it/imoaei2015#year"));
        Collection publications = Searcher.values((Collection)onto.getObjectPropertyAssertionAxioms((OWLIndividual)indiv), (OWLObjectPropertyExpression)author_of);
        int output_year = 30000;
        try {
            if (publications.isEmpty()) {
                return output_year;
            }
            for (OWLIndividual pub : publications) {
                Collection data_values = Searcher.values((Collection)onto.getDataPropertyAssertionAxioms(pub), (OWLDataPropertyExpression)active_from);
                Iterator iterator = data_values.iterator();
                if (iterator.hasNext()) {
                    OWLLiteral value = (OWLLiteral)iterator.next();
                    return value.parseInteger();
                }
                data_values = Searcher.values((Collection)onto.getDataPropertyAssertionAxioms(pub), (OWLDataPropertyExpression)year);
                for (OWLLiteral value : data_values) {
                    if (value.parseInteger() >= output_year) continue;
                    output_year = value.parseInteger();
                }
            }
            return output_year;
        }
        catch (Exception e) {
            LogOutput.printError("Error extracting information about publications.");
            return output_year;
        }
    }
}

