/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.krr.logmap2.oaei;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.formats.RDFXMLDocumentFormat;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.MissingImportHandlingStrategy;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyLoaderConfiguration;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import uk.ac.ox.krr.logmap2.io.LogOutput;
import uk.ac.ox.krr.logmap2.io.WriteFile;
import uk.ac.ox.krr.logmap2.mappings.objects.MappingObjectStr;
import uk.ac.ox.krr.logmap2.oaei.reader.RDFAlignReader;

public class FromRDFAlign2OWL {
    private RDFAlignReader RDF_mappings_reader;
    private OWLOntologyManager mappings_ontologyManager;
    private OWLOntology ontology1;
    private OWLOntology ontology2;
    private OWLOntology mappings_ontology;
    private OWLDataFactory datafactory;
    private List<OWLOntologyChange> owl_changes = new ArrayList<OWLOntologyChange>();
    private WriteFile writer;
    private String mappings_rdf_file_name;
    private String mappings_owl_file_name;
    private String mappings_txt_file_name;
    private String mappings_IRI = "http://www.cs.ox.ac.uk/ontologies/oaei/owl/mappings.owl";

    public FromRDFAlign2OWL(String mappings_file_name) throws Exception {
        this(null, null, mappings_file_name, true);
    }

    public FromRDFAlign2OWL(String onto_iri1, String onto_iri2, String mappings_file_name) throws Exception {
        this(FromRDFAlign2OWL.loadOntologyStatic(onto_iri1), FromRDFAlign2OWL.loadOntologyStatic(onto_iri2), mappings_file_name, false);
    }

    public FromRDFAlign2OWL(OWLOntology onto1, OWLOntology onto2, String mappings_file_name) throws Exception {
        this(onto1, onto2, mappings_file_name, false);
    }

    public FromRDFAlign2OWL(OWLOntology onto1, OWLOntology onto2, String mappings_file_name, boolean only_individuals) throws Exception {
        String mappings_file = mappings_file_name;
        this.mappings_rdf_file_name = mappings_file_name;
        if (this.mappings_rdf_file_name.lastIndexOf(".") > 0) {
            mappings_file = this.mappings_rdf_file_name.split("\\.")[0];
        }
        this.mappings_owl_file_name = "file:" + mappings_file + ".owl";
        this.mappings_txt_file_name = mappings_file + ".txt";
        this.ontology1 = onto1;
        this.ontology2 = onto2;
        this.writer = new WriteFile(this.mappings_txt_file_name);
        this.RDF_mappings_reader = new RDFAlignReader(mappings_file_name);
        this.RDF_mappings_reader.getMappingObjects();
        this.initOWLMappingsFile();
        this.convertMappings2OWL(only_individuals);
        LogOutput.printAlways("Saving file: " + this.mappings_txt_file_name);
        this.writer.closeBuffer();
        LogOutput.printAlways("Saving file: " + this.mappings_owl_file_name);
        this.saveOWLMappingsFile();
    }

    private void initOWLMappingsFile() throws Exception {
        this.mappings_ontologyManager = OWLManager.createOWLOntologyManager();
        this.mappings_ontology = this.mappings_ontologyManager.createOntology(IRI.create((String)this.mappings_IRI));
        this.datafactory = this.mappings_ontologyManager.getOWLDataFactory();
    }

    private void saveOWLMappingsFile() throws Exception {
        this.mappings_ontologyManager.applyChanges(this.owl_changes);
        this.mappings_ontologyManager.saveOntology(this.mappings_ontology, (OWLDocumentFormat)new RDFXMLDocumentFormat(), IRI.create((String)this.mappings_owl_file_name));
    }

    private void addAxiom2Changes(OWLAxiom ax) {
        this.owl_changes.add((OWLOntologyChange)new AddAxiom(this.mappings_ontology, ax));
    }

    private void convertMappings2OWL(boolean only_individuals) {
        String iri_measure_str = this.mappings_IRI + "#measure";
        String iri_entity1_str = this.mappings_IRI + "#entity1";
        String iri_entity2_str = this.mappings_IRI + "#entity2";
        String iri_relation_str = this.mappings_IRI + "#relation";
        HashSet<OWLAnnotation> annSet = new HashSet<OWLAnnotation>();
        HashSet<OWLNamedIndividual> indivSet = new HashSet<OWLNamedIndividual>();
        for (MappingObjectStr mapping : this.RDF_mappings_reader.getMappingObjects()) {
            String type_mapping_str;
            int type_mapping;
            IRI iri_ent1 = IRI.create((String)mapping.getIRIStrEnt1());
            IRI iri_ent2 = IRI.create((String)mapping.getIRIStrEnt2());
            String relation_str = "=";
            if (mapping.getMappingDirection() == -2) {
                relation_str = "=";
            } else if (mapping.getMappingDirection() == 0) {
                relation_str = "<";
            } else if (mapping.getMappingDirection() == -1) {
                relation_str = ">";
            }
            if (only_individuals) {
                type_mapping = 3;
                type_mapping_str = "INST";
            } else if (this.ontology1.containsClassInSignature(IRI.create((String)mapping.getIRIStrEnt1()), true) && this.ontology2.containsClassInSignature(IRI.create((String)mapping.getIRIStrEnt2()), true)) {
                type_mapping = 0;
                type_mapping_str = "CLS";
            } else if (this.ontology1.containsObjectPropertyInSignature(IRI.create((String)mapping.getIRIStrEnt1()), true) && this.ontology2.containsObjectPropertyInSignature(IRI.create((String)mapping.getIRIStrEnt2()), true)) {
                type_mapping = 2;
                type_mapping_str = "OPROP";
            } else if (this.ontology1.containsDataPropertyInSignature(IRI.create((String)mapping.getIRIStrEnt1()), true) && this.ontology2.containsDataPropertyInSignature(IRI.create((String)mapping.getIRIStrEnt2()), true)) {
                type_mapping = 1;
                type_mapping_str = "DPROP";
            } else if (this.ontology1.containsIndividualInSignature(IRI.create((String)mapping.getIRIStrEnt1()), true) && this.ontology2.containsIndividualInSignature(IRI.create((String)mapping.getIRIStrEnt2()), true)) {
                type_mapping = 3;
                type_mapping_str = "INST";
                relation_str = "=";
            } else {
                System.err.println("Wrong mapping mixing entities ");
                System.err.println("\t" + mapping.getIRIStrEnt1());
                System.err.println("\t" + mapping.getIRIStrEnt2());
                type_mapping = 4;
                continue;
            }
            if (type_mapping != 4) {
                this.writer.writeLine(mapping.getIRIStrEnt1() + "|" + mapping.getIRIStrEnt2() + "|" + relation_str + "|" + mapping.getConfidence() + "|" + type_mapping_str);
            }
            OWLAnnotationProperty ann_property = this.datafactory.getOWLAnnotationProperty(IRI.create((String)iri_measure_str));
            OWLLiteral confidence_literal = this.datafactory.getOWLLiteral(mapping.getConfidence());
            OWLAnnotation ann_measure = this.datafactory.getOWLAnnotation(ann_property, (OWLAnnotationValue)confidence_literal);
            OWLAnnotationProperty ann_property_ent1 = this.datafactory.getOWLAnnotationProperty(IRI.create((String)iri_entity1_str));
            OWLLiteral ent1_literal = this.datafactory.getOWLLiteral(mapping.getIRIStrEnt1());
            OWLAnnotation ann_ent1 = this.datafactory.getOWLAnnotation(ann_property_ent1, (OWLAnnotationValue)ent1_literal);
            OWLAnnotationProperty ann_property_ent2 = this.datafactory.getOWLAnnotationProperty(IRI.create((String)iri_entity2_str));
            OWLLiteral ent2_literal = this.datafactory.getOWLLiteral(mapping.getIRIStrEnt2());
            OWLAnnotation ann_ent2 = this.datafactory.getOWLAnnotation(ann_property_ent2, (OWLAnnotationValue)ent2_literal);
            OWLAnnotationProperty ann_property_relation = this.datafactory.getOWLAnnotationProperty(IRI.create((String)iri_relation_str));
            OWLLiteral relation_literal = this.datafactory.getOWLLiteral(relation_str);
            OWLAnnotation ann_relation = this.datafactory.getOWLAnnotation(ann_property_relation, (OWLAnnotationValue)relation_literal);
            annSet.clear();
            annSet.add(ann_measure);
            annSet.add(ann_ent1);
            annSet.add(ann_ent2);
            annSet.add(ann_relation);
            if (type_mapping == 12) {
                indivSet.clear();
                indivSet.add(this.datafactory.getOWLNamedIndividual(iri_ent1));
                indivSet.add(this.datafactory.getOWLNamedIndividual(iri_ent2));
                this.addAxiom2Changes((OWLAxiom)this.datafactory.getOWLSameIndividualAxiom(indivSet, annSet));
                continue;
            }
            if (type_mapping == 0) {
                if (mapping.getMappingDirection() == -2) {
                    this.addAxiom2Changes((OWLAxiom)this.datafactory.getOWLEquivalentClassesAxiom((OWLClassExpression)this.datafactory.getOWLClass(iri_ent1), (OWLClassExpression)this.datafactory.getOWLClass(iri_ent2), annSet));
                    continue;
                }
                if (mapping.getMappingDirection() == 0) {
                    this.addAxiom2Changes((OWLAxiom)this.datafactory.getOWLSubClassOfAxiom((OWLClassExpression)this.datafactory.getOWLClass(iri_ent1), (OWLClassExpression)this.datafactory.getOWLClass(iri_ent2), annSet));
                    continue;
                }
                if (mapping.getMappingDirection() != -1) continue;
                this.addAxiom2Changes((OWLAxiom)this.datafactory.getOWLSubClassOfAxiom((OWLClassExpression)this.datafactory.getOWLClass(iri_ent2), (OWLClassExpression)this.datafactory.getOWLClass(iri_ent1), annSet));
                continue;
            }
            if (type_mapping == 2) {
                if (mapping.getMappingDirection() == -2) {
                    this.addAxiom2Changes((OWLAxiom)this.datafactory.getOWLEquivalentObjectPropertiesAxiom((OWLObjectPropertyExpression)this.datafactory.getOWLObjectProperty(iri_ent1), (OWLObjectPropertyExpression)this.datafactory.getOWLObjectProperty(iri_ent2), annSet));
                    continue;
                }
                if (mapping.getMappingDirection() == 0) {
                    this.addAxiom2Changes((OWLAxiom)this.datafactory.getOWLSubObjectPropertyOfAxiom((OWLObjectPropertyExpression)this.datafactory.getOWLObjectProperty(iri_ent1), (OWLObjectPropertyExpression)this.datafactory.getOWLObjectProperty(iri_ent2), annSet));
                    continue;
                }
                if (mapping.getMappingDirection() != -1) continue;
                this.addAxiom2Changes((OWLAxiom)this.datafactory.getOWLSubObjectPropertyOfAxiom((OWLObjectPropertyExpression)this.datafactory.getOWLObjectProperty(iri_ent2), (OWLObjectPropertyExpression)this.datafactory.getOWLObjectProperty(iri_ent1), annSet));
                continue;
            }
            if (type_mapping != 1) continue;
            if (mapping.getMappingDirection() == -2) {
                this.addAxiom2Changes((OWLAxiom)this.datafactory.getOWLEquivalentDataPropertiesAxiom((OWLDataPropertyExpression)this.datafactory.getOWLDataProperty(iri_ent1), (OWLDataPropertyExpression)this.datafactory.getOWLDataProperty(iri_ent2), annSet));
                continue;
            }
            if (mapping.getMappingDirection() == 0) {
                this.addAxiom2Changes((OWLAxiom)this.datafactory.getOWLSubDataPropertyOfAxiom((OWLDataPropertyExpression)this.datafactory.getOWLDataProperty(iri_ent1), (OWLDataPropertyExpression)this.datafactory.getOWLDataProperty(iri_ent2), annSet));
                continue;
            }
            if (mapping.getMappingDirection() != -1) continue;
            this.addAxiom2Changes((OWLAxiom)this.datafactory.getOWLSubDataPropertyOfAxiom((OWLDataPropertyExpression)this.datafactory.getOWLDataProperty(iri_ent2), (OWLDataPropertyExpression)this.datafactory.getOWLDataProperty(iri_ent1), annSet));
        }
    }

    private static OWLOntology loadOntologyStatic(String uri) throws Exception {
        System.out.println("\tLoading ontology " + uri);
        return FromRDFAlign2OWL.loadOntologyStatic(IRI.create((String)uri));
    }

    private static OWLOntology loadOntologyStatic(IRI uri) throws Exception {
        OWLOntologyManager ontologyManager = OWLManager.createOWLOntologyManager();
        OWLOntologyLoaderConfiguration config = new OWLOntologyLoaderConfiguration();
        config.setMissingImportHandlingStrategy(MissingImportHandlingStrategy.SILENT);
        ontologyManager.setOntologyLoaderConfiguration(config);
        return ontologyManager.loadOntology(uri);
    }
}

