/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.krr.logmap2.multilingual;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.ictclas4j.bean.SegResult;
import org.ictclas4j.segment.SegTag2;
import uk.ac.ox.krr.logmap2.Parameters;
import uk.ac.ox.krr.logmap2.io.LogOutput;
import uk.ac.ox.krr.logmap2.io.ReadFile;
import uk.ac.ox.krr.logmap2.io.WriteFile;
import uk.ac.ox.krr.logmap2.utilities.Utilities;

public abstract class Translator {
    protected int num_tranlated_characters = 0;
    protected int num_calls = 0;
    private HashMap<String, String> localTranslationMap = new HashMap();
    private HashMap<String, String> ontheFlyTranslationMap = new HashMap();

    public String getTranslation(String label, String originLang) {
        return this.getTranslation(label, originLang, Parameters.target_lang);
    }

    public void reverseDictionary(String originLang, String targetLang) {
        Parameters.target_lang = targetLang;
        this.loadDictionary(originLang);
        HashMap<String, String> tmp = new HashMap<String, String>();
        for (String key : this.ontheFlyTranslationMap.keySet()) {
            tmp.put(this.ontheFlyTranslationMap.get(key), key);
        }
        this.ontheFlyTranslationMap.clear();
        this.ontheFlyTranslationMap.putAll(tmp);
        Parameters.target_lang = originLang;
        this.storeDictionary(targetLang);
    }

    public void loadDictionary(String language) {
        File file;
        if (Parameters.use_local_dict) {
            file = new File(Parameters.path_multilingual_local + "/" + language + "-" + Parameters.target_lang + "." + this.getTranslatorName());
            try {
                this.loadDictionary(file, this.localTranslationMap);
            }
            catch (FileNotFoundException e) {
                LogOutput.printError(e.getMessage());
            }
        }
        file = new File(Parameters.path_multilingual_tmp + "/" + language + "-" + Parameters.target_lang + "." + this.getTranslatorName());
        try {
            this.loadDictionary(file, this.ontheFlyTranslationMap);
        }
        catch (FileNotFoundException e) {
            LogOutput.printError("\tError accessing on-the-fly dictionary");
        }
    }

    public void storeDictionary(String language) {
        if (!this.ontheFlyTranslationMap.isEmpty()) {
            File file = new File(Parameters.path_multilingual_tmp + "/" + language + "-" + Parameters.target_lang + "." + this.getTranslatorName());
            this.storeDictionary(file, this.ontheFlyTranslationMap);
        }
    }

    public boolean isInLocalDictionary(String text) {
        return this.localTranslationMap.containsKey(text) || this.ontheFlyTranslationMap.containsKey(text);
    }

    public String getLocalTranslation(String text) {
        if (this.localTranslationMap.containsKey(text)) {
            return this.localTranslationMap.get(text);
        }
        return this.ontheFlyTranslationMap.get(text);
    }

    public void addTranslation2Map(String text, String translatedText) {
        this.ontheFlyTranslationMap.put(text, translatedText);
    }

    private void loadDictionary(File file, HashMap<String, String> translationMap) throws FileNotFoundException {
        ReadFile reader = new ReadFile(file);
        String line = reader.readLine();
        while (line != null) {
            try {
                if (line.startsWith("#")) {
                    line = reader.readLine();
                    continue;
                }
                if (line.indexOf("|") < 0) {
                    line = reader.readLine();
                    continue;
                }
                String[] elements = line.split("\\|");
                if (elements.length != 2) {
                    LogOutput.printError("Error reading local translations file. Line: " + line + ".\n");
                    line = reader.readLine();
                    continue;
                }
                translationMap.put(elements[0], elements[1]);
                line = reader.readLine();
            }
            catch (Exception e) {
                LogOutput.printError("Error reading local translations file. Line: " + line + ".\n");
                line = reader.readLine();
            }
        }
        reader.closeBuffer();
    }

    private void storeDictionary(File file, HashMap<String, String> translationMap) {
        WriteFile writer = new WriteFile(file);
        writer.writeLine("#This file is initially empty and it will be populated with 'on-the-fly' translations obtained from google/microsoft translate.");
        for (String key : translationMap.keySet()) {
            writer.writeLine(key + "|" + translationMap.get(key));
        }
        writer.closeBuffer();
    }

    public int getNumberOfTranslatedCharacters() {
        return this.num_tranlated_characters;
    }

    public int getNumberOfTranslateCalls() {
        return this.num_calls;
    }

    public abstract String getTranslatorName();

    public abstract String getToolAPITranslation(String var1, String var2, String var3) throws Exception;

    public String getTranslation(String label, String originLangStr, String targetLangStr) {
        ArrayList<Object> split_label = new ArrayList();
        HashSet<String> translations = new HashSet<String>();
        try {
            String translated_label = this.getToolAPITranslation(label, originLangStr, targetLangStr);
            if (!translated_label.equals(label)) {
                translations.add(translated_label);
            }
            if (originLangStr.equals("cn")) {
                split_label = this.splitChineseLabel(label);
                translations.add(this.getTranslationWordByWord(split_label, originLangStr, targetLangStr));
            } else {
                split_label = this.splitRegularLabel(label);
                if (split_label.size() > 0) {
                    translations.add(this.getTranslationWordByWord(split_label, originLangStr, targetLangStr));
                    String sentence_like_label = this.getSentenceFromArray(split_label);
                    if (!sentence_like_label.equals(label)) {
                        translations.add(this.getToolAPITranslation(sentence_like_label, originLangStr, targetLangStr));
                    }
                }
            }
            return this.getStringFromTranslationsSet(translations);
        }
        catch (Exception e) {
            LogOutput.printAlways("Error translating '" + label + "'. " + e.getMessage());
            return label;
        }
    }

    private String getTranslationWordByWord(ArrayList<String> split_label, String originLangStr, String targetLangStr) throws Exception {
        String translation = "";
        for (String word : split_label) {
            if (translation.length() == 0) {
                translation = this.getToolAPITranslation(word, originLangStr, targetLangStr);
                continue;
            }
            translation = translation + " " + this.getToolAPITranslation(word, originLangStr, targetLangStr);
        }
        return translation;
    }

    private String getSentenceFromArray(ArrayList<String> words) {
        StringBuilder sentence = new StringBuilder();
        int il = words.size();
        for (int i = 0; i < il; ++i) {
            if (i > 0) {
                sentence.append(" ");
            }
            sentence.append(words.get(i));
        }
        return sentence.toString();
    }

    private String getStringFromTranslationsSet(Set<String> translations) {
        StringBuilder translation = new StringBuilder();
        for (String t : translations) {
            if (translation.toString().length() > 0) {
                translation.append("|");
            }
            translation.append(t);
        }
        return translation.toString();
    }

    private ArrayList<String> splitRegularLabel(String label_value) {
        ArrayList<String> result = new ArrayList<String>();
        if ((label_value = label_value.replace(",", "")).startsWith("_")) {
            label_value = label_value.substring(1, label_value.length());
        }
        if (label_value.endsWith("_")) {
            label_value = label_value.substring(0, label_value.length() - 1);
        }
        String[] words = label_value.indexOf("_") > 0 ? label_value.split("_") : (label_value.indexOf(" ") > 0 ? label_value.split(" ") : Utilities.splitStringByCapitalLetter(label_value));
        for (int index = 0; index < words.length; ++index) {
            result.add(words[index]);
        }
        return result;
    }

    private ArrayList<String> splitChineseLabel(String label) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            label = label.replaceAll("_", "");
            SegTag2 st = new SegTag2(1);
            SegResult sr = st.split(label);
            String rawResult = sr.getFinalResult();
            String[] words = rawResult.split(" ");
            for (int index = 0; index < words.length; ++index) {
                StringBuffer buffer = new StringBuffer(words[index]);
                String word = buffer.substring(0, buffer.indexOf("/"));
                result.add(word);
            }
        }
        catch (Exception e) {
            LogOutput.printError("Error spliting label: " + label);
            result.clear();
            result.add(label);
        }
        return result;
    }
}

