/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.krr.logmap2.mappings;

import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import uk.ac.ox.krr.logmap2.indexing.IndexManager;
import uk.ac.ox.krr.logmap2.indexing.OntologyProcessing;
import uk.ac.ox.krr.logmap2.mappings.I_Sub;
import uk.ac.ox.krr.logmap2.utilities.Lib;
import uk.ac.ox.krr.logmap2.utilities.Pair;

public class WeakCandidate
extends Pair<Integer, Integer>
implements Comparator<WeakCandidate> {
    public static final double MINSCORE = 0.0;
    public static final int WEIGHTED = 0;
    public static final int WEIGHTEDFILTER = 1;
    public static final int WEIGHTEDFILTERMATCH = 2;
    private OntologyProcessing m_o1 = null;
    private OntologyProcessing m_o2 = null;
    private IndexManager m_index = null;
    private double m_score = 0.0;
    private String rest1 = "";
    private String rest2 = "";

    public WeakCandidate(int id1, int id2, Set<String> label1, Set<String> label2, OntologyProcessing o1, OntologyProcessing o2, int type) {
        super(id1, id2);
        this.m_o1 = o1;
        this.m_o2 = o2;
        this.getScore_weighted(id1, id2, label1, label2, type);
    }

    private void getScore_weighted(int id1, int id2, Set<String> lab1, Set<String> lab2, int type) {
        if (type == 1) {
            Set<String> super1 = this.m_o1.getSuperClass(id1, 10);
            Set<String> super2 = this.m_o2.getSuperClass(id2, 10);
            for (String str : super1) {
                for (String word : str.split("_")) {
                    if (lab1.contains(word)) continue;
                    lab2.remove(word);
                }
            }
            for (String str : super2) {
                for (String word : str.split("_")) {
                    if (lab2.contains(word)) continue;
                    lab1.remove(word);
                }
            }
        }
        this.m_score = this.getScore_weighted(lab1, lab2);
    }

    private double getScore_weighted(Set<String> lab1, Set<String> lab2) {
        double temp;
        double sum = 0.0;
        double value = 0.0;
        HashSet combo = new HashSet();
        for (String word : lab1) {
            temp = 1.0 / (double)this.m_o1.getFrequency(word).intValue();
            sum += temp;
            if (lab2.contains(word)) {
                value += temp;
            }
            this.rest1 = this.rest1 + word;
        }
        for (String word : lab2) {
            temp = 1.0 / (double)this.m_o2.getFrequency(word).intValue();
            sum += temp;
            if (lab1.contains(word)) {
                value += temp;
            }
            this.rest2 = this.rest2 + word;
        }
        return sum == 0.0 ? 1.0 : value / sum;
    }

    public double getScore(I_Sub isub) {
        return isub.score(this.rest1, this.rest2);
    }

    public WeakCandidate(Set<String> combo, int id1, int id2, String label1, String label2, IndexManager index, int f_combo) {
        super(id1, id2);
        this.m_index = index;
        this.getScore_frequency(combo, label1, label2, f_combo);
    }

    private void getScore_frequency(Set<String> combo, String label1, String label2, int f_combo) {
        int fb;
        HashSet<String> set1 = new HashSet<String>();
        HashSet<String> set2 = new HashSet<String>();
        for (String word : label1.split("_")) {
            if (combo.contains(word)) continue;
            set1.add(word);
        }
        for (String word : label2.split("_")) {
            if (combo.contains(word)) continue;
            set2.add(word);
        }
        Set<Integer> list1 = this.m_index.getCooccurrenceOfWords(set1);
        Set<Integer> list2 = this.m_index.getCooccurrenceOfWords(set2);
        int total = this.m_index.getIdentifier2ClassIndexMap().size();
        int fa = list1 == null ? total : list1.size();
        int n = fb = list2 == null ? total : list2.size();
        if ((f_combo - fa) * (f_combo - fb) < 0) {
            this.m_score = 0.0;
            return;
        }
        set1.addAll(set2);
        Set<Integer> list = this.m_index.intersectSet(list1, list2);
        int fab = list == null ? total : list.size();
        set1.clear();
        set2.clear();
        if (list1 != null) {
            list1.clear();
        }
        if (list2 != null) {
            list2.clear();
        }
        if (list != null) {
            list.clear();
        }
        this.m_score = 2.0 * (double)fab / (double)(fa + fb);
    }

    public double getScore() {
        return this.m_score;
    }

    @Override
    public int compare(WeakCandidate c1, WeakCandidate c2) {
        int delta = Lib.dcmp(c1.m_score - c2.m_score);
        return -delta;
    }

    @Override
    public int compareTo(WeakCandidate that) {
        return -this.compare(this, that);
    }

    @Override
    public boolean equals(Object obj) {
        return this.compare(this, (WeakCandidate)obj) == 0;
    }
}

