/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.krr.logmap2.mappings;

import java.util.Calendar;
import uk.ac.ox.krr.logmap2.lexicon.LexicalUtilities;

public class I_Sub {
    public double score(String st1, String st2) {
        double scaledCommon;
        if (st1 == null || st2 == null) {
            return -1.0;
        }
        String s1 = st1.toLowerCase();
        String s2 = st2.toLowerCase();
        s1 = this.normalizeString(s1, '.');
        s2 = this.normalizeString(s2, '.');
        s1 = this.normalizeString(s1, '_');
        s2 = this.normalizeString(s2, '_');
        s1 = this.normalizeString(s1, ' ');
        s2 = this.normalizeString(s2, ' ');
        int l1 = s1.length();
        int l2 = s2.length();
        int L1 = l1;
        int L2 = l2;
        if (L1 == 0 && L2 == 0) {
            return 1.0;
        }
        if (L1 == 0 || L2 == 0) {
            return -1.0;
        }
        double common = 0.0;
        int best = 2;
        int max = Math.min(l1, l2);
        while (s1.length() > 0 && s2.length() > 0 && best != 0) {
            best = 0;
            l1 = s1.length();
            l2 = s2.length();
            int i = 0;
            int j = 0;
            int startS2 = 0;
            int endS2 = 0;
            int startS1 = 0;
            int endS1 = 0;
            int p = 0;
            for (i = 0; i < l1 && l1 - i > best; ++i) {
                j = 0;
                while (l2 - j > best) {
                    int k = i;
                    while (j < l2 && s1.charAt(k) != s2.charAt(j)) {
                        ++j;
                    }
                    if (j == l2) continue;
                    p = j++;
                    ++k;
                    while (j < l2 && k < l1 && s1.charAt(k) == s2.charAt(j)) {
                        ++j;
                        ++k;
                    }
                    if (k - i <= best) continue;
                    best = k - i;
                    startS1 = i;
                    endS1 = k;
                    startS2 = p;
                    endS2 = j;
                }
            }
            char[] newString = new char[s1.length() - (endS1 - startS1)];
            j = 0;
            for (i = 0; i < s1.length(); ++i) {
                if (i >= startS1 && i < endS1) continue;
                newString[j++] = s1.charAt(i);
            }
            s1 = new String(newString);
            newString = new char[s2.length() - (endS2 - startS2)];
            j = 0;
            for (i = 0; i < s2.length(); ++i) {
                if (i >= startS2 && i < endS2) continue;
                newString[j++] = s2.charAt(i);
            }
            s2 = new String(newString);
            if (best > 2) {
                common += (double)best;
                continue;
            }
            best = 0;
        }
        double commonality = 0.0;
        commonality = scaledCommon = 2.0 * common / (double)(L1 + L2);
        double winklerImprovement = this.winklerImprovement(st1, st2, commonality);
        double dissimilarity = 0.0;
        double rest1 = (double)L1 - common;
        double rest2 = (double)L2 - common;
        double unmatchedS1 = Math.max(rest1, 0.0);
        double unmatchedS2 = Math.max(rest2, 0.0);
        unmatchedS1 = rest1 / (double)L1;
        unmatchedS2 = rest2 / (double)L2;
        double suma = unmatchedS1 + unmatchedS2;
        double product = unmatchedS1 * unmatchedS2;
        double p = 0.6;
        dissimilarity = suma - product == 0.0 ? 0.0 : product / (p + (1.0 - p) * (suma - product));
        return commonality - dissimilarity + winklerImprovement;
    }

    private double winklerImprovement(String s1, String s2, double commonality) {
        int i;
        int n = Math.min(s1.length(), s2.length());
        for (i = 0; i < n && s1.charAt(i) == s2.charAt(i); ++i) {
        }
        double commonPrefixLength = Math.min(4, i);
        double winkler = commonPrefixLength * 0.1 * (1.0 - commonality);
        return winkler;
    }

    public String explainScore(String s, String t) {
        return null;
    }

    public String normalizeString(String str, char remo) {
        StringBuffer strBuf = new StringBuffer();
        boolean j = false;
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) == remo) continue;
            strBuf.append(str.charAt(i));
        }
        return strBuf.toString();
    }

    public static void main(String[] args) {
        I_Sub isub = new I_Sub();
        long init = Calendar.getInstance().getTimeInMillis();
        LexicalUtilities lexicalUtilities = new LexicalUtilities();
        System.out.println(lexicalUtilities.getStemming4Word("Bergame"));
        System.out.println(lexicalUtilities.getStemming4Word("Bergamo"));
        System.out.println(isub.score("Comt\u00e9 Milwaukee", "Milwaukee_County"));
        System.out.println(isub.score("Milwaukee Comt\u00e9", "Milwaukee_County"));
        System.out.println(isub.score("Milwaukee Comt\u00e9", "Milwaukee"));
        System.out.println(isub.score("JuvenileArthritis", "ArthritisJuvenile"));
        System.out.println(isub.score("Juvenile_Arthritis", "Juvenile_Rheumatoid_Arthritis"));
        System.out.println(isub.score("Juvenile_Arthritis", "Juvenile_Arthritis"));
        System.out.println(isub.score("Juvenile_Arthritis", "JuvenileArthritis"));
        System.out.println(isub.score("larynx_muscle", "laryngeal_muscle"));
        System.out.println(isub.score("lalaarthritis", "thritis"));
        System.out.println("aoaoaoa\n" + isub.score("arterialcircle", "circular"));
        System.out.println("Moresby: " + isub.score("Moresby Port", "Moresby P."));
        System.out.println("Moresby: " + isub.score("PortMoresby", "Moresby P."));
        System.out.println("Moresby: " + isub.score("Port_Moresby", "Moresby"));
        System.out.println("email: " + isub.score("hasanemail", "Email"));
        System.out.println("conference: " + isub.score("ConferenceEvent", "Conference"));
        long fin = Calendar.getInstance().getTimeInMillis();
        System.out.println("Time I-Sub (s): " + ((double)fin - (double)init) / 1000.0);
    }
}

