/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.krr.logmap2.lexicon.stemming;

import uk.ac.ox.krr.logmap2.lexicon.stemming.LovinsIterStemmerBridge;
import uk.ac.ox.krr.logmap2.lexicon.stemming.LovinsStemmerBridge;
import uk.ac.ox.krr.logmap2.lexicon.stemming.PaiceStemmerBridge;
import uk.ac.ox.krr.logmap2.lexicon.stemming.PorterStemmerBridge;
import uk.ac.ox.krr.logmap2.lexicon.stemming.Stemmer;

public class StemmerManager {
    private static Stemmer stemmer;
    public static final int STEMMER_PORTER = 0;
    public static final int STEMMER_PORTER2 = 1;
    public static final int STEMMER_LOVINS = 2;
    public static final int STEMMER_LOVINSITER = 3;
    public static final int STEMMER_PAICE = 4;
    private static int stemmerType;

    public static void setStemmerType(int aStemmerType) {
        stemmerType = aStemmerType;
        stemmer = null;
    }

    public static Stemmer getStemmer() {
        if (stemmer == null) {
            switch (stemmerType) {
                case 0: {
                    stemmer = new PorterStemmerBridge();
                    break;
                }
                case 2: {
                    stemmer = new LovinsStemmerBridge();
                    break;
                }
                case 3: {
                    stemmer = new LovinsIterStemmerBridge();
                    break;
                }
                case 4: {
                    stemmer = new PaiceStemmerBridge(true);
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid value for Config.stemmerType");
                }
            }
        }
        return stemmer;
    }
}

