/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.krr.logmap2.lexicon;

import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import uk.ac.ox.krr.logmap2.io.LogOutput;
import uk.ac.ox.krr.logmap2.io.ReadFile;
import uk.ac.ox.krr.logmap2.lexicon.LexicalUtilities;
import uk.ac.ox.krr.logmap2.lexicon.NormalizeNumbers;
import uk.ac.ox.krr.logmap2.lexicon.stemming.StemmerManager;

public class LexicalUtilitiesStatic {
    private static ReadFile reader;
    private static InputStream in;
    private static String line;
    private static String[] elements;
    private static Map<String, Set<String>> spelling_variants_map;
    private static Map<String, Set<String>> normalization_map;
    private static String lex_spl_file;
    private static String lex_norm_file;
    private static String lex_plur_file;
    private static Set<String> stopwordsSet;
    private static Set<String> stopwordsSetExtended;
    private static Map<String, Set<String>> label2wordnetsyn;
    private static Map<String, String> word2stemming;
    private static boolean useStemming;

    public static void clearStructures() {
        stopwordsSetExtended.clear();
        label2wordnetsyn.clear();
        word2stemming.clear();
        spelling_variants_map.clear();
        normalization_map.clear();
    }

    public static void clearStopWordsSet() {
        stopwordsSet.clear();
    }

    public static Set<String> getStopwordsSet() {
        return stopwordsSet;
    }

    public static Set<String> getStopwordsSetExtended() {
        return stopwordsSetExtended;
    }

    public static Map<String, Set<String>> getLabel2wordnetsyn() {
        return label2wordnetsyn;
    }

    public static void loadWordNetSynonyms(String wordnet_syn_file) throws Exception {
        ReadFile reader = new ReadFile(wordnet_syn_file);
        HashSet<String> setsyn = new HashSet<String>();
        while ((line = reader.readLine()) != null) {
            if (!line.contains("|") || (elements = line.split("\\|")).length <= 1) continue;
            String[] syn = elements[1].contains(":") ? elements[1].split(":") : new String[]{elements[1]};
            for (int i = 0; i < syn.length; ++i) {
                if (elements[0].equals(syn[i].toLowerCase()) || !syn[i].toLowerCase().matches("[a-z_]+")) continue;
                setsyn.add(syn[i].toLowerCase());
            }
            if (setsyn.size() <= 0) continue;
            label2wordnetsyn.put(elements[0], new HashSet());
            label2wordnetsyn.get(elements[0]).addAll(setsyn);
            setsyn.clear();
        }
        reader.closeBuffer();
        LogOutput.print("Size syn: " + label2wordnetsyn.size());
    }

    public static void setStemming(boolean use_stemming) {
        useStemming = use_stemming;
    }

    public static boolean isStemmingUp() {
        return useStemming;
    }

    public static void setStemmer() {
        StemmerManager.setStemmerType(4);
    }

    public static String getStemming4Word(String str) {
        if (word2stemming.containsKey(str)) {
            return word2stemming.get(str);
        }
        String stemmed_word = StemmerManager.getStemmer().stem(str);
        word2stemming.put(str, stemmed_word);
        return stemmed_word;
    }

    public static void loadStopWords() throws Exception {
        reader = new ReadFile(LexicalUtilities.class.getResourceAsStream("stopwords.txt"));
        while ((line = reader.readLine()) != null) {
            if (line.startsWith("#")) continue;
            stopwordsSet.add(line);
        }
        reader.closeBuffer();
    }

    public static void loadStopWordsExtended() throws Exception {
        reader = new ReadFile(LexicalUtilities.class.getResourceAsStream("stopwords.txt"));
        while ((line = reader.readLine()) != null) {
            if (!line.startsWith("#")) {
                stopwordsSetExtended.add(line);
                continue;
            }
            stopwordsSetExtended.add(line.substring(1));
        }
        reader.closeBuffer();
    }

    public static boolean hasSpellingVariants(String str) {
        return spelling_variants_map.containsKey(str);
    }

    public static boolean hasNormalization(String str) {
        return normalization_map.containsKey(str);
    }

    public static Set<String> getSpellingVariants(String str) {
        return spelling_variants_map.get(str);
    }

    public static Set<String> getNormalization(String str) {
        return normalization_map.get(str);
    }

    public static String getRomanNormalization4Number(String word) {
        return NormalizeNumbers.getRomanNormalization(word);
    }

    public static void loadUMLSLexiconResources() {
        try {
            LexicalUtilitiesStatic.load_UMLS_SpecialistLex_SpellingVariants();
            LexicalUtilitiesStatic.load_UMLS_SpecialistLex_Plurals();
            LexicalUtilitiesStatic.load_UMLS_SpecialistLex_Normalization();
        }
        catch (Exception e) {
            System.err.println("Error loading UMLS lexicon sources: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private static void load_UMLS_SpecialistLex_SpellingVariants() throws Exception {
        in = new GZIPInputStream(LexicalUtilities.class.getResourceAsStream(lex_spl_file));
        reader = new ReadFile(in);
        while ((line = reader.readLine()) != null) {
            if (!line.contains("|") || (elements = line.split("\\|")).length <= 2 || elements[1].toLowerCase().equals(elements[2].toLowerCase())) continue;
            if (!spelling_variants_map.containsKey(elements[1].toLowerCase())) {
                spelling_variants_map.put(elements[1].toLowerCase(), new HashSet());
            }
            spelling_variants_map.get(elements[1].toLowerCase()).add(elements[2].toLowerCase());
        }
        reader.closeBuffer();
    }

    private static void load_UMLS_SpecialistLex_Plurals() throws Exception {
        in = new GZIPInputStream(LexicalUtilities.class.getResourceAsStream(lex_plur_file));
        reader = new ReadFile(in);
        while ((line = reader.readLine()) != null) {
            if (!line.contains("|") || (elements = line.split("\\|")).length <= 5) continue;
            if (!normalization_map.containsKey(elements[1].toLowerCase())) {
                normalization_map.put(elements[1].toLowerCase(), new HashSet());
            }
            normalization_map.get(elements[1].toLowerCase()).add(elements[5].toLowerCase());
        }
        reader.closeBuffer();
    }

    private static void load_UMLS_SpecialistLex_Normalization() throws Exception {
        in = new GZIPInputStream(LexicalUtilities.class.getResourceAsStream(lex_norm_file));
        reader = new ReadFile(in);
        while ((line = reader.readLine()) != null) {
            if (!line.contains("|") || (elements = line.split("\\|")).length <= 4) continue;
            if (!normalization_map.containsKey(elements[1].toLowerCase())) {
                normalization_map.put(elements[1].toLowerCase(), new HashSet());
            }
            normalization_map.get(elements[1].toLowerCase()).add(elements[4].toLowerCase());
        }
        reader.closeBuffer();
    }

    static {
        spelling_variants_map = new HashMap<String, Set<String>>();
        normalization_map = new HashMap<String, Set<String>>();
        lex_spl_file = "Lex_spelling_LRSPL.gz";
        lex_norm_file = "Lex_norm_LRNOM.gz";
        lex_plur_file = "Lex_plurals_LRAGR.gz";
        stopwordsSet = new HashSet<String>();
        stopwordsSetExtended = new HashSet<String>();
        label2wordnetsyn = new HashMap<String, Set<String>>();
        word2stemming = new HashMap<String, String>();
        useStemming = false;
    }
}

