/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.krr.logmap2.interactive.objects;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import uk.ac.ox.krr.logmap2.mappings.MappingManager;
import uk.ac.ox.krr.logmap2.mappings.objects.MappingObject;

public class MappingObjectInteractivity
extends MappingObject {
    private boolean removedFlag = false;
    private boolean addedFlag = false;
    private int dirMapping;
    private boolean assessedDirectlyFlag = false;
    protected List<Double> similarityList = new ArrayList<Double>();
    private double m_score;
    private double scope = 0.0;
    private double lexSim = 0.0;
    private Set<Integer> mappingsInConflict = new HashSet<Integer>();
    private Set<Integer> ambiguousMappings = new HashSet<Integer>();
    private boolean inGSMappings = false;

    public MappingObjectInteractivity(int ide1, int ide2) {
        this(ide1, ide2, -2);
    }

    public MappingObjectInteractivity(int ide1, int ide2, int dirMapping) {
        this.ident_onto1 = ide1;
        this.ident_onto2 = ide2;
        this.setDirMapping(dirMapping);
    }

    public MappingObjectInteractivity(int ide1, int ide2, int dirMapping, double scope, double lexSim) {
        this.ident_onto1 = ide1;
        this.ident_onto2 = ide2;
        this.setDirMapping(dirMapping);
        this.scope = scope;
        this.lexSim = lexSim;
    }

    public double getScope() {
        return this.scope;
    }

    public double getLexSim() {
        return this.lexSim;
    }

    public boolean isRemovedFlagActive() {
        return this.removedFlag;
    }

    public void setRemovedFlag(boolean removedFlag) {
        this.removedFlag = removedFlag;
        if (removedFlag) {
            this.addedFlag = !removedFlag;
        }
    }

    public boolean isAddedFlagActive() {
        return this.addedFlag;
    }

    public void setAddedFlag(boolean addedFlag) {
        this.addedFlag = addedFlag;
        if (addedFlag) {
            this.removedFlag = !addedFlag;
        }
    }

    public boolean hasDecision() {
        return this.addedFlag || this.removedFlag;
    }

    public boolean isAssessedFlagActive() {
        return this.assessedDirectlyFlag;
    }

    public void setAssessedFlag(boolean assessedFlag) {
        this.assessedDirectlyFlag = assessedFlag;
    }

    public List<Double> getSimilarityList() {
        return this.similarityList;
    }

    public void addSimilarityValue2List(double value) {
        this.similarityList.add(value);
    }

    public void setScore(MappingManager manager) {
        this.m_score = manager.getSimWeak4Mapping(this.ident_onto1, this.ident_onto2);
    }

    public double getScore() {
        return this.m_score;
    }

    public void setInGSMappings() {
        this.inGSMappings = true;
    }

    public boolean isInGSMappings() {
        return this.inGSMappings;
    }

    public int getDirMapping() {
        return this.dirMapping;
    }

    public void setDirMapping(int dirMapping) {
        this.dirMapping = dirMapping;
    }

    public Set<Integer> getMappingsInconflict() {
        return this.mappingsInConflict;
    }

    public Set<Integer> getAmbiguousMappings() {
        return this.ambiguousMappings;
    }

    public void addConflictiveMapping(int mapping_id) {
        this.mappingsInConflict.add(mapping_id);
    }

    public void addAmbiguousMapping(int mapping_id) {
        this.ambiguousMappings.add(mapping_id);
    }
}

