/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.krr.logmap2.interactive;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import uk.ac.ox.krr.logmap2.indexing.IndexManager;
import uk.ac.ox.krr.logmap2.interactive.InteractiveProcess;
import uk.ac.ox.krr.logmap2.interactive.MappingInteractivityComparator4Similarity;
import uk.ac.ox.krr.logmap2.interactive.objects.MappingObjectInteractivity;
import uk.ac.ox.krr.logmap2.io.LogOutput;
import uk.ac.ox.krr.logmap2.mappings.MappingManager;
import uk.ac.ox.krr.logmap2.mappings.objects.MappingObjectStr;
import uk.ac.ox.krr.logmap2.repair.AnchorAssessment;

public class InteractiveProcessThreshold
extends InteractiveProcess {
    boolean considerDiscarded = false;
    int left;
    int right;
    private MappingManager m_manager;
    private AnchorAssessment m_assessment;
    private List<MappingObjectInteractivity> mappings2ask = new ArrayList<MappingObjectInteractivity>();
    private Set<Integer> mappingsAsked = new HashSet<Integer>();

    public InteractiveProcessThreshold(IndexManager index, MappingManager mapping_manager) {
        this.m_manager = mapping_manager;
        this.m_assessment = new AnchorAssessment(index, this.m_manager);
        this.setScore2mappings();
        int goodcandidate = 0;
        for (MappingObjectInteractivity mapping : this.mappings2ask) {
            if (!this.m_manager.isMappingInGoldStandard(mapping.getIdentifierOnto1(), mapping.getIdentifierOnto2())) continue;
            mapping.setInGSMappings();
            ++goodcandidate;
        }
        LogOutput.print("total number of good candidates in 2ASK set: " + goodcandidate);
        Collections.sort(this.mappings2ask, new MappingInteractivityComparator4Similarity());
        try {
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream("/auto/users/yzhou/2ask.txt")));
            for (int i = 0; i < this.mappings2ask.size(); ++i) {
                MappingObjectInteractivity mapping = this.mappings2ask.get(i);
                writer.write(mapping.getIdentifierOnto1() + " " + mapping.getIdentifierOnto2() + " " + mapping.getScore() + " " + mapping.isInGSMappings() + "\n");
            }
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void startInteractiveProcess() {
        this.boundaryDecision();
        this.cleanMappingsAndRecordPrecisionAndRecall();
        LogOutput.print(this.right - this.left + "\t" + (this.left + 1) + "\t" + this.right + "\n" + this.mappingsAsked.size() + "\t" + this.mappings2ask.size() + "\n" + this.precision + "\n" + this.recall + "\n" + this.Fmeasure);
    }

    private void boundaryDecision() {
        int mid;
        this.left = 0;
        this.right = this.mappings2ask.size() - 1;
        while (this.left < this.right) {
            mid = (this.left + this.right + 1) / 2;
            if (this.review(mid)) {
                this.left = mid;
                continue;
            }
            this.right = mid - 1;
        }
        int temp = this.left;
        LogOutput.print("finished 1");
        this.right = this.left;
        this.left = 0;
        while (this.left < this.right) {
            mid = (this.left + this.right) / 2;
            if (!this.review(mid)) {
                this.left = mid + 1;
                continue;
            }
            this.right = mid;
        }
        this.right = temp;
        LogOutput.print("finished 2");
    }

    private void markMappingAndAdd2List(MappingObjectInteractivity mapping, boolean inGSMappings) {
        if (inGSMappings) {
            mapping.setAddedFlag(true);
            this.m_manager.addMappingAddedByUser2Structure(mapping.getIdentifierOnto1(), mapping.getIdentifierOnto2());
            this.m_manager.addMappingAddedByUser2Structure(mapping.getIdentifierOnto2(), mapping.getIdentifierOnto1());
        } else {
            mapping.setRemovedFlag(true);
        }
    }

    private void cleanMappingsAndRecordPrecisionAndRecall() {
        for (int i = this.left + 1; i <= this.right; ++i) {
            MappingObjectInteractivity mapping = this.mappings2ask.get(i);
            if (mapping.isRemovedFlagActive()) continue;
            if (mapping.getDirMapping() == -2 || mapping.getDirMapping() == 0) {
                this.m_manager.addSubMapping2Mappings2Review(mapping.getIdentifierOnto1(), mapping.getIdentifierOnto2());
            }
            if (mapping.getDirMapping() != -2 && mapping.getDirMapping() != -1) continue;
            this.m_manager.addSubMapping2Mappings2Review(mapping.getIdentifierOnto2(), mapping.getIdentifierOnto1());
        }
        try {
            this.m_assessment.CheckSatisfiabilityOfIntegration_DandG(this.m_manager.getMappings2Review());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.getPrecisionAndRecall();
        this.m_manager.getMappings2Review().clear();
    }

    private void getPrecisionAndRecall() {
        this.setStringMappings();
        HashSet<MappingObjectStr> intersection = new HashSet<MappingObjectStr>(this.m_manager.getStringLogMapMappings());
        intersection.retainAll(this.m_manager.getStringGoldStandardAnchors());
        this.precision = (double)intersection.size() / (double)this.m_manager.getStringLogMapMappings().size();
        this.recall = (double)intersection.size() / (double)this.m_manager.getStringGoldStandardAnchors().size();
        this.Fmeasure = 2.0 * this.recall * this.precision / (this.precision + this.recall);
        this.m_manager.setStringAnchors();
    }

    private void setStringMappings() {
        this.m_manager.setStringAnchors();
        for (int ide1 : this.m_manager.getMappings2Review().keySet()) {
            for (int ide2 : this.m_manager.getMappings2Review().get(ide1)) {
                this.m_manager.addStringAnchor(ide1, ide2);
            }
        }
        for (int ide1 : this.m_manager.getWeakenedDandGMappings().keySet()) {
            for (int ide2 : this.m_manager.getWeakenedDandGMappings().get(ide1)) {
                if (this.m_manager.isMappingInConflictWithFixedMappings(ide1, ide2) || this.m_manager.isMappingInferred(ide1, ide2) || this.m_manager.isMappingInConflictiveSet(ide1, ide2)) continue;
                this.m_manager.addStringAnchor(ide1, ide2);
            }
        }
    }

    private boolean review(int index) {
        int mark = 2;
        mark = this.review(index, mark);
        if (index > 0) {
            mark = this.review(index - 1, mark);
        }
        if (mark == 0) {
            return true;
        }
        if (mark == 2) {
            return false;
        }
        if (index + 1 < this.mappings2ask.size()) {
            mark = this.review(index + 1, mark);
        }
        return mark == 0;
    }

    private int review(int index, int mark) {
        MappingObjectInteractivity mapping = this.mappings2ask.get(index);
        boolean flag = mapping.isInGSMappings();
        if (!this.mappingsAsked.contains(index)) {
            this.markMappingAndAdd2List(mapping, flag);
        }
        this.mappingsAsked.add(index);
        return flag ? mark - 1 : mark;
    }

    private void setScore2mappings() {
        for (MappingObjectInteractivity mapping : this.m_manager.getListOfMappingsToAskUser()) {
            mapping.setScore(this.m_manager);
            this.mappings2ask.add(mapping);
        }
        if (this.considerDiscarded) {
            for (int ideA : this.m_manager.getDiscardedMappings().keySet()) {
                for (int ideB : this.m_manager.getDiscardedMappings().get(ideA)) {
                    if (ideA >= ideB) continue;
                    MappingObjectInteractivity m = new MappingObjectInteractivity(ideA, ideB);
                    this.mappings2ask.add(m);
                    m.setScore(this.m_manager);
                }
            }
        }
    }

    @Override
    public void endInteractiveProcess(boolean filter) {
    }

    @Override
    public void endInteractiveProcess() {
    }
}

