/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.krr.logmap2.indexing.labelling_schema;

import java.util.HashMap;
import java.util.Set;
import uk.ac.ox.krr.logmap2.indexing.labelling_schema.IntervalLabelledHierarchy;
import uk.ac.ox.krr.logmap2.indexing.labelling_schema.Node;
import uk.ac.ox.krr.logmap2.indexing.labelling_schema.PostNode;
import uk.ac.ox.krr.logmap2.io.LogOutput;

public class PostIntervalLabelledHierarchy
extends IntervalLabelledHierarchy {
    public static final int BASE_INDEX = 1;
    public static final int INDEX_INCREMENT = 1;

    public PostIntervalLabelledHierarchy(HashMap<Integer, Set<Integer>> ontoHierarchy, boolean clearStructures) {
        super(ontoHierarchy, clearStructures);
    }

    public PostIntervalLabelledHierarchy(HashMap<Integer, Set<Integer>> ontoHierarchy) {
        super(ontoHierarchy);
    }

    @Override
    protected Node createNode(int classId) {
        return new PostNode(classId);
    }

    @Override
    protected void walkDescendant() {
        this.walkDescNode(this.root, 1);
    }

    private int walkDescNode(Node node, int orderIndex) {
        node.setDescChildOrder(orderIndex);
        for (Node child : node.getDescTreeChildren()) {
            if (node.equals(child)) {
                LogOutput.print("Same node as children: walkDescNode");
                continue;
            }
            orderIndex = this.walkDescNode(child, orderIndex);
        }
        node.setDescOrder(orderIndex);
        return ++orderIndex;
    }

    @Override
    protected void walkAscendant() {
        this.walkAscNode(this.leaf, 1);
    }

    private int walkAscNode(Node node, int orderIndex) {
        node.setAscChildOrder(orderIndex);
        for (Node child : node.getAscTreeChildren()) {
            if (node.equals(child)) {
                LogOutput.print("Same node as children: walkAscNode");
                continue;
            }
            orderIndex = this.walkAscNode(child, orderIndex);
        }
        node.setAscOrder(orderIndex);
        return ++orderIndex;
    }
}

