/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.krr.logmap2.indexing.labelling_schema;

import java.util.HashSet;
import java.util.Set;
import uk.ac.ox.krr.logmap2.indexing.labelling_schema.Interval;

public abstract class Node {
    protected int classId;
    protected Set<Node> parents;
    protected Set<Node> children;
    protected Node descTreeParent;
    protected Set<Node> descTreeChildren;
    protected Node ascTreeParent;
    protected Set<Node> ascTreeChildren;
    protected Set<Interval> descIntervals;
    protected Set<Interval> ascIntervals;

    public abstract void setDescOrder(int var1);

    public abstract int getDescOrder();

    public abstract void setAscOrder(int var1);

    public abstract int getAscOrder();

    public abstract void setDescChildOrder(int var1);

    public abstract int getDescChildOrder();

    public abstract void setAscChildOrder(int var1);

    public abstract int getAscChildOrder();

    public abstract Interval getDescOrderInterval();

    public abstract Interval getAscOrderInterval();

    public Node(Integer classId) {
        this.classId = classId;
        this.parents = new HashSet<Node>();
        this.children = new HashSet<Node>();
        this.descTreeChildren = new HashSet<Node>();
        this.ascTreeChildren = new HashSet<Node>();
        this.descIntervals = new HashSet<Interval>();
        this.ascIntervals = new HashSet<Interval>();
    }

    public void clearAuxiliarStructures() {
        this.parents.clear();
        this.parents = null;
        this.children.clear();
        this.children = null;
        this.descTreeParent = null;
        this.descTreeChildren.clear();
        this.descTreeChildren = null;
        this.ascTreeParent = null;
        this.ascTreeChildren.clear();
        this.ascTreeChildren = null;
    }

    public void clearIntervalStructures() {
        this.descIntervals.clear();
        this.ascIntervals.clear();
    }

    public Integer getClassId() {
        return this.classId;
    }

    public Set<Interval> getDescIntervals() {
        return this.descIntervals;
    }

    public Set<Interval> getAscIntervals() {
        return this.ascIntervals;
    }

    public Set<Interval> setDescIntervals(Set<Interval> intervals) {
        this.descIntervals = intervals;
        return this.descIntervals;
    }

    public Set<Interval> setAncIntervals(Set<Interval> intervals) {
        this.ascIntervals = intervals;
        return this.ascIntervals;
    }

    Set<Node> getChildren() {
        return this.children;
    }

    Set<Node> getParents() {
        return this.parents;
    }

    Node getDescTreeParent() {
        return this.descTreeParent;
    }

    Set<Node> getDescTreeChildren() {
        return this.descTreeChildren;
    }

    Node getAscTreeParent() {
        return this.ascTreeParent;
    }

    Set<Node> getAscTreeChildren() {
        return this.ascTreeChildren;
    }

    public void addChild(Node child) {
        this.children.add(child);
        this.descTreeChildren.add(child);
        child.parents.add(this);
        child.ascTreeChildren.add(this);
    }

    public void setDescTreeParent(Node node) {
        assert (this.parents.contains(node));
        this.descTreeParent = node;
        for (Node parent : this.parents) {
            if (parent == this.descTreeParent) continue;
            parent.getDescTreeChildren().remove(this);
        }
    }

    public void setAscTreeParent(Node node) {
        assert (this.children.contains(node));
        this.ascTreeParent = node;
        for (Node parent : this.children) {
            if (parent == this.ascTreeParent) continue;
            parent.getAscTreeChildren().remove(this);
        }
    }

    public void addDescInterval(Interval interval) {
        for (Interval ownInterval : this.descIntervals) {
            if (ownInterval.isSuperIntervalOf(interval)) {
                return;
            }
            if (!interval.isSuperIntervalOf(ownInterval)) continue;
            this.descIntervals.remove(ownInterval);
            this.descIntervals.add(interval);
            return;
        }
        if (interval.leftbound >= 0 && interval.rightbound >= 0) {
            this.descIntervals.add(interval);
        }
    }

    public void addAscInterval(Interval interval) {
        for (Interval ownInterval : this.ascIntervals) {
            if (ownInterval.isSuperIntervalOf(interval)) {
                return;
            }
            if (interval.isSuperIntervalOf(ownInterval)) {
                this.ascIntervals.remove(ownInterval);
                this.ascIntervals.add(interval);
                return;
            }
            if (!ownInterval.isAdjacentTo(interval)) continue;
            Interval unionInterval = new Interval(Math.min(ownInterval.getLeftBound(), interval.getLeftBound()), Math.max(ownInterval.getRightBound(), interval.getRightBound()));
            this.ascIntervals.remove(ownInterval);
            this.ascIntervals.add(unionInterval);
            return;
        }
        this.ascIntervals.add(interval);
    }

    public boolean isRoot() {
        return this.parents.size() == 0;
    }

    public boolean isLeaf() {
        return this.children.size() == 0;
    }

    public void unattach() {
        for (Node parent : this.parents) {
            parent.children.remove(this);
            parent.descTreeChildren.remove(this);
        }
        for (Node child : this.children) {
            child.parents.remove(this);
            if (!child.descTreeParent.equals(this)) continue;
            child.descTreeParent = null;
        }
        if (this.descTreeParent != null) {
            this.descTreeParent.descTreeChildren.remove(this);
        }
        for (Node descTreeChild : this.descTreeChildren) {
            descTreeChild.descTreeParent = null;
        }
        if (this.ascTreeParent != null) {
            this.ascTreeParent.ascTreeChildren.remove(this);
        }
        for (Node ascTreeChild : this.ascTreeChildren) {
            ascTreeChild.ascTreeParent = null;
        }
    }

    public void reattach() {
        for (Node parent : this.parents) {
            parent.children.add(this);
        }
        for (Node child : this.children) {
            child.parents.add(this);
        }
        if (this.descTreeParent != null) {
            this.descTreeParent.descTreeChildren.add(this);
        }
        for (Node descTreeChild : this.descTreeChildren) {
            descTreeChild.descTreeParent = this;
        }
        if (this.ascTreeParent != null) {
            this.ascTreeParent.ascTreeChildren.add(this);
        }
        for (Node ascTreeChild : this.ascTreeChildren) {
            ascTreeChild.ascTreeParent = this;
        }
    }

    public String toString() {
        return String.valueOf(this.getClassId());
    }
}

