/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.krr.logmap2.indexing.labelling_schema;

import java.util.ArrayList;
import java.util.List;

public class Interval {
    int leftbound;
    int rightbound;

    public Interval(int leftb, int rightb) {
        this.leftbound = leftb;
        this.rightbound = rightb;
    }

    public Interval(String serialized_interval) {
        if (serialized_interval.indexOf(",") > 0) {
            this.leftbound = Integer.valueOf(serialized_interval.split(",")[0]);
            this.rightbound = Integer.valueOf(serialized_interval.split(",")[1]);
        } else {
            this.leftbound = -1;
            this.rightbound = -1;
        }
    }

    public int getLeftBound() {
        return this.leftbound;
    }

    public int getRightBound() {
        return this.rightbound;
    }

    public void setLeftBound(int leftbound) {
        this.leftbound = leftbound;
    }

    public void setRightBound(int rightbound) {
        this.rightbound = rightbound;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof Interval)) {
            return false;
        }
        Interval i = (Interval)o;
        return this.equals(i);
    }

    public boolean equals(Interval i) {
        if (this.leftbound != i.getLeftBound()) {
            return false;
        }
        return this.rightbound == i.getRightBound();
    }

    public boolean isSuperIntervalOf(Interval i) {
        if (i.getLeftBound() < this.leftbound) {
            return false;
        }
        return i.getRightBound() <= this.rightbound;
    }

    public boolean isSubIntervalOf(Interval i) {
        if (i.getLeftBound() > this.leftbound) {
            return false;
        }
        return i.getRightBound() >= this.rightbound;
    }

    public boolean containsIndex(int index) {
        return index <= this.rightbound && index >= this.leftbound;
    }

    public boolean hasNonEmptyIntersectionWith(Interval i) {
        if (this.rightbound < i.leftbound) {
            return false;
        }
        return i.rightbound >= this.leftbound;
    }

    private int min(int a, int b) {
        if (a < b) {
            return a;
        }
        return b;
    }

    private int max(int a, int b) {
        if (a > b) {
            return a;
        }
        return b;
    }

    public Interval getIntersectionWith(Interval i) {
        if (this.hasNonEmptyIntersectionWith(i)) {
            return new Interval(this.max(this.leftbound, i.getLeftBound()), this.min(this.rightbound, i.getRightBound()));
        }
        return new Interval(-1, -1);
    }

    public boolean isAdjacentTo(Interval i) {
        if (this.hasNonEmptyIntersectionWith(i)) {
            return true;
        }
        if (i.rightbound == this.leftbound - 1) {
            return true;
        }
        return this.rightbound == i.leftbound - 1;
    }

    public Interval getUnionWith(Interval i) {
        return new Interval(this.min(this.leftbound, i.getLeftBound()), this.max(this.rightbound, i.getRightBound()));
    }

    public List<Interval> getUnionWithList(Interval i) {
        ArrayList<Interval> unionList = new ArrayList<Interval>();
        if (this.isAdjacentTo(i)) {
            unionList.add(new Interval(this.min(this.leftbound, i.getLeftBound()), this.max(this.rightbound, i.getRightBound())));
        } else {
            unionList.add(this);
            unionList.add(i);
        }
        return unionList;
    }

    public boolean hasLowerLeftBoundThan(Interval i) {
        return this.leftbound < i.getLeftBound();
    }

    public boolean hasGreaterLeftBoundThan(Interval i) {
        return this.leftbound > i.getLeftBound();
    }

    public boolean isEmptyInterval() {
        return this.leftbound >= 0;
    }

    public String toString() {
        return "<" + this.leftbound + ", " + this.rightbound + ">";
    }

    public String serialize() {
        return this.leftbound + "," + this.rightbound;
    }

    public int hashCode() {
        int code = 10;
        code = 40 * code + this.leftbound;
        code = 40 * code + this.rightbound;
        return code;
    }
}

