/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.krr.logmap2.indexing.entities;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import uk.ac.ox.krr.logmap2.indexing.entities.EntityIndex;
import uk.ac.ox.krr.logmap2.indexing.labelling_schema.Node;
import uk.ac.ox.krr.logmap2.indexing.labelling_schema.PreNode;
import uk.ac.ox.krr.logmap2.utilities.Lib;

public class ClassIndex
extends EntityIndex {
    private Set<String> alternativeLabels;
    private Set<Integer> disjointClasses;
    private Set<Integer> equivalentClasses;
    private Set<Integer> directSubclasses;
    private Set<Integer> directSuperclasses;
    private int hierarchyLevel = -1;
    private Set<Integer> scope4Score;
    private Set<Integer> scope4Exploration;
    private Set<Integer> roots;
    private Set<String> stemmedAltLabels;

    public ClassIndex(int i) {
        this.index = i;
        this.node = new PreNode(i);
    }

    public void addAlternativeLabel(String altLabel) {
        if (this.alternativeLabels == null) {
            this.alternativeLabels = new HashSet<String>();
        }
        this.alternativeLabels.add(altLabel);
    }

    public void setAlternativeLabels(Set<String> altLabels) {
        this.alternativeLabels = new HashSet<String>(altLabels);
    }

    public void setEmptyAlternativeLabels() {
        this.alternativeLabels = new HashSet<String>();
    }

    public Set<String> getAlternativeLabels() {
        if (this.alternativeLabels == null) {
            return Collections.emptySet();
        }
        return this.alternativeLabels;
    }

    public boolean hasAlternativeLabels() {
        return this.alternativeLabels != null;
    }

    public void setNode(Node node) {
        this.node = node;
    }

    public Node getNode() {
        return this.node;
    }

    public boolean hasDirectDisjointClasses() {
        return this.disjointClasses != null;
    }

    public void setDisjointClasses(Set<Integer> disjointClasses) {
        this.disjointClasses = disjointClasses;
    }

    public void setEmptyDisjointClasses() {
        if (this.disjointClasses == null) {
            this.disjointClasses = new HashSet<Integer>();
        } else {
            this.disjointClasses.clear();
        }
    }

    public void addDisjointClass(int disjident) {
        if (this.disjointClasses == null) {
            this.disjointClasses = new HashSet<Integer>();
        }
        this.disjointClasses.add(disjident);
    }

    public void addAllDisjointClasses(Set<Integer> disjclasses) {
        if (this.disjointClasses == null) {
            this.disjointClasses = new HashSet<Integer>();
        }
        this.disjointClasses.addAll(disjclasses);
    }

    public Set<Integer> getDisjointClasses() {
        return this.disjointClasses;
    }

    public boolean hasEquivalentClasses() {
        return this.equivalentClasses != null;
    }

    public void setEquivalentClasses(Set<Integer> equivalentClasses) {
        this.equivalentClasses = equivalentClasses;
    }

    public void setEmptyEquivalentClasses() {
        if (this.equivalentClasses == null) {
            this.equivalentClasses = new HashSet<Integer>();
        } else {
            this.equivalentClasses.clear();
        }
    }

    public void addEquivalentClass(int disjident) {
        if (this.equivalentClasses == null) {
            this.equivalentClasses = new HashSet<Integer>();
        }
        this.equivalentClasses.add(disjident);
    }

    public Set<Integer> getEquivalentClasses() {
        return this.equivalentClasses;
    }

    public boolean hasDirectSubClasses() {
        return this.directSubclasses != null;
    }

    public void setEmptyDirectSubClasses() {
        if (this.directSubclasses == null) {
            this.directSubclasses = new HashSet<Integer>();
        } else {
            this.directSubclasses.clear();
        }
    }

    public void addDirectSubClass(int disjident) {
        if (this.directSubclasses == null) {
            this.directSubclasses = new HashSet<Integer>();
        }
        this.directSubclasses.add(disjident);
    }

    public void setDirectSubclasses(Set<Integer> directSubclasses) {
        this.directSubclasses = directSubclasses;
    }

    public Set<Integer> getDirectSubclasses() {
        return this.directSubclasses;
    }

    public boolean hasDirectSuperClasses() {
        return this.directSuperclasses != null;
    }

    public void setEmptyDirectSuperClasses() {
        if (this.directSuperclasses == null) {
            this.directSuperclasses = new HashSet<Integer>();
        } else {
            this.directSuperclasses.clear();
        }
    }

    public void addDirectSuperClass(int disjident) {
        if (this.directSuperclasses == null) {
            this.directSuperclasses = new HashSet<Integer>();
        }
        this.directSuperclasses.add(disjident);
    }

    public void setDirectSuperclasses(Set<Integer> directSuperclasses) {
        this.directSuperclasses = directSuperclasses;
    }

    public Set<Integer> getDirectSuperclasses() {
        return this.directSuperclasses;
    }

    public boolean hasScope4Scores() {
        return this.scope4Score != null;
    }

    public void setScope4Scores(Set<Integer> scope) {
        this.scope4Score = scope;
    }

    public Set<Integer> getScope4Scores() {
        return this.scope4Score;
    }

    public boolean hasScope4Exploration() {
        return this.scope4Exploration != null;
    }

    public void setScope4Exploration(Set<Integer> scope) {
        this.scope4Exploration = scope;
    }

    public Set<Integer> getScope4Exploration() {
        return this.scope4Exploration;
    }

    public boolean hasRoots() {
        return this.roots != null;
    }

    public void setRoots(Set<Integer> roots) {
        this.roots = roots;
    }

    public Set<Integer> getRoots() {
        return this.roots;
    }

    public void setHierarchyLevel(int hierarchyLevel) {
        this.hierarchyLevel = hierarchyLevel;
    }

    public int getHierarchyLevel() {
        return this.hierarchyLevel;
    }

    public String findSimilarStemmedAltLable(ClassIndex that) {
        String[] words2;
        if (this.stemmedAltLabels == null || that.stemmedAltLabels == null) {
            return null;
        }
        int combo = -1;
        int left = -1;
        String ret = null;
        for (String lab1 : this.stemmedAltLabels) {
            for (String lab2 : that.stemmedAltLabels) {
                int temp_l = -1;
                words2 = lab2.split("_");
                int temp_c = this.getCommonWordsNumber(lab1, words2);
                if (temp_c <= combo && (temp_c != combo || (temp_l = lab1.split("_").length + words2.length) >= left)) continue;
                combo = temp_c;
                left = temp_l == -1 ? lab1.split("_").length + words2.length : temp_l;
                ret = lab1 + " " + lab2;
            }
        }
        words2 = null;
        return ret;
    }

    private int getCommonWordsNumber(String str, String[] words) {
        int ret = 0;
        for (String word : words) {
            if (word.isEmpty() || !str.contains(word)) continue;
            ++ret;
        }
        return ret;
    }

    public String findStemmedAltLabel(Set<String> words) {
        if (this.stemmedAltLabels == null) {
            Lib.debuginfo("The class named " + this.name4Entitity + " has no stemmed alt labels.");
            return null;
        }
        String label = "";
        int maxScore = 0;
        for (String l : this.stemmedAltLabels) {
            int score = this.getCommonWordsNumber(l, words);
            if (maxScore < score) {
                maxScore = score;
                label = l;
                continue;
            }
            if (maxScore != score || l.length() >= label.length()) continue;
            label = l;
        }
        return label;
    }

    private int getCommonWordsNumber(String str, Set<String> words) {
        int ret = 0;
        for (String word : words) {
            if (!str.contains(word)) continue;
            ++ret;
        }
        return ret;
    }

    public void addStemmedAltLabel(String label) {
        if (this.stemmedAltLabels == null) {
            this.stemmedAltLabels = new HashSet<String>();
        }
        this.stemmedAltLabels.add(label);
    }

    public Set<String> getStemmedAltLabels() {
        return this.stemmedAltLabels;
    }

    public boolean hasStemmedAlternativeLabels() {
        return this.stemmedAltLabels != null;
    }

    public void deleteAltStemmedLabels() {
        this.stemmedAltLabels.clear();
    }

    public void deleteAltLabels() {
        this.alternativeLabels.clear();
    }
}

