/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.krr.logmap2.indexing;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import uk.ac.ox.krr.logmap2.indexing.IndexManager;
import uk.ac.ox.krr.logmap2.indexing.LightTarjan;
import uk.ac.ox.krr.logmap2.indexing.entities.ClassIndex;
import uk.ac.ox.krr.logmap2.indexing.labelling_schema.Interval;
import uk.ac.ox.krr.logmap2.indexing.labelling_schema.PreIntervalLabelledHierarchy;
import uk.ac.ox.krr.logmap2.io.LogOutput;

public class JointIndexManager
extends IndexManager {
    Set<Integer> allSuperClasses = new HashSet<Integer>();
    Set<Integer> allSubClasses = new HashSet<Integer>();

    @Override
    public Set<Integer> getScope4Identifier_Big(int ide) {
        return this.getScope4Identifier(ide, 10, 10, 1000);
    }

    @Override
    public Set<Integer> getScope4Identifier_Condifence(int ide) {
        return this.getScope4Identifier(ide, 3, 10, 50);
    }

    @Override
    public Set<Integer> getScope4Identifier_Expansion(int ide) {
        return this.getScope4Identifier(ide, 2, 2, 50);
    }

    @Override
    public Set<Integer> getSubsetOfSuperClasses4Identifier(int ide) {
        return this.getScope4Identifier(ide, 0, 3, 10);
    }

    @Override
    public Set<Integer> getSubsetOfSubClasses4Identifier(int ide) {
        return this.getScope4Identifier(ide, 3, 0, 10);
    }

    public Set<Integer> getScope4Identifier(int ide, int sub_levels, int super_levels, int max_size_subclasses) {
        HashSet<Integer> scope = new HashSet<Integer>();
        this.allSuperClasses.clear();
        this.allSubClasses.clear();
        if (sub_levels > 0) {
            this.getSubclasses4Identifiers(this.getDirectSubClasses4Identifier(ide, false), sub_levels, max_size_subclasses);
            scope.addAll(this.allSubClasses);
        }
        if (super_levels > 0) {
            this.getSuperclasses4Identifiers(this.getDirectSuperClasses4Identifier(ide, false), super_levels);
            scope.addAll(this.allSuperClasses);
        }
        return scope;
    }

    private void getSubclasses4Identifiers(Set<Integer> classes, int level, int max_size_subclasses) {
        this.allSubClasses.addAll(classes);
        if (level < 1 || classes.size() < 1 || this.allSubClasses.size() > max_size_subclasses) {
            return;
        }
        HashSet<Integer> subClasses = new HashSet<Integer>();
        for (int ide : classes) {
            subClasses.addAll(this.getDirectSubClasses4Identifier(ide, false));
        }
        this.getSubclasses4Identifiers(subClasses, level - 1, max_size_subclasses);
    }

    private void getSuperclasses4Identifiers(Set<Integer> classes, int level) {
        this.allSuperClasses.addAll(classes);
        if (level < 1 || classes.size() < 1) {
            return;
        }
        HashSet<Integer> superClasses = new HashSet<Integer>();
        for (int ide : classes) {
            superClasses.addAll(this.getDirectSuperClasses4Identifier(ide, false));
        }
        this.getSuperclasses4Identifiers(superClasses, level - 1);
    }

    @Override
    public void setSmallProjection4MappedEntities(Set<Integer> mapped_entities_identifiers) {
        this.identifiersInModule.clear();
        this.identifiersInModule.addAll(mapped_entities_identifiers);
        this.getSuperclasses4Identifiers(mapped_entities_identifiers, 500);
        this.identifiersInModule.addAll(this.allSuperClasses);
        LogOutput.print("Size projection: " + this.identifiersInModule.size());
    }

    private void duplicateDirectSubClasses() {
        this.ident2DirectSubClasses_integration = new HashMap();
        for (int parent : this.getDirectSubClasses(false).keySet()) {
            if (!this.ident2DirectSubClasses_integration.containsKey(parent)) {
                this.ident2DirectSubClasses_integration.put(parent, new HashSet());
            }
            for (int kid : this.getDirectSubClasses(false).get(parent)) {
                ((Set)this.ident2DirectSubClasses_integration.get(parent)).add(kid);
            }
        }
    }

    private void setAdaptedMap4DirectSubclasses(Map<Integer, Set<Integer>> exact_mappings) {
        this.duplicateDirectSubClasses();
        this.representativesFromMappings = new HashSet();
        LogOutput.print("Original entries DirectSubclasses: " + this.ident2DirectSubClasses_integration.size());
        LogOutput.print("Original entries DirectSubclasses: " + this.getDirectSubClasses(false).size());
        for (int ide_rep : exact_mappings.keySet()) {
            int ide_equiv;
            Iterator<Integer> iterator = exact_mappings.get(ide_rep).iterator();
            while (iterator.hasNext() && ide_rep <= (ide_equiv = iterator.next().intValue())) {
                this.representativesFromMappings.add(ide_rep);
                for (int ide_parent : this.getDirectSuperClasses4Identifier(ide_equiv, false)) {
                    if (!this.ident2DirectSubClasses_integration.containsKey(ide_parent)) continue;
                    ((Set)this.ident2DirectSubClasses_integration.get(ide_parent)).add(ide_rep);
                    ((Set)this.ident2DirectSubClasses_integration.get(ide_parent)).remove(ide_equiv);
                }
                if (!this.ident2DirectSubClasses_integration.containsKey(ide_equiv)) continue;
                if (!this.ident2DirectSubClasses_integration.containsKey(ide_rep)) {
                    this.ident2DirectSubClasses_integration.put(ide_rep, new HashSet());
                }
                ((Set)this.ident2DirectSubClasses_integration.get(ide_rep)).addAll((Collection)this.ident2DirectSubClasses_integration.get(ide_equiv));
                ((Set)this.ident2DirectSubClasses_integration.get(ide_equiv)).clear();
                this.ident2DirectSubClasses_integration.remove(ide_equiv);
            }
        }
        LogOutput.print("Adapted entries DirectSubclasses: " + this.ident2DirectSubClasses_integration.size());
        LogOutput.print("Adapted entries DirectSubclasses: " + this.getDirectSubClasses(false).size());
        LogOutput.print("Representatives from Mappings: " + this.representativesFromMappings.size());
        LogOutput.print("Mapping entries (sub mappings): " + exact_mappings.keySet().size());
    }

    @Override
    public void setIntervalLabellingIndex(Map<Integer, Set<Integer>> exact_mappings) {
        this.setAdaptedMap4DirectSubclasses(exact_mappings);
        PreIntervalLabelledHierarchy interval_schema = new PreIntervalLabelledHierarchy(this.dealWithCyclesIntervalLabellingSchema(true));
        for (int ident : interval_schema.getClassesToNodesMap().keySet()) {
            ((ClassIndex)this.identifier2ClassIndex.get(ident)).setNode(interval_schema.getClassesToNodesMap().get(ident));
        }
        for (int iRep : this.getRepresentativeNodes()) {
            if (!((ClassIndex)this.identifier2ClassIndex.get(iRep)).hasEquivalentClasses()) continue;
            for (int iEquiv : ((ClassIndex)this.identifier2ClassIndex.get(iRep)).getEquivalentClasses()) {
                ((ClassIndex)this.identifier2ClassIndex.get(iEquiv)).setNode(((ClassIndex)this.identifier2ClassIndex.get(iRep)).getNode());
            }
        }
        for (int iRep : this.getRepresentativesFromMappings()) {
            if (!exact_mappings.containsKey(iRep)) continue;
            for (int iEquiv : exact_mappings.get(iRep)) {
                ((ClassIndex)this.identifier2ClassIndex.get(iEquiv)).setNode(((ClassIndex)this.identifier2ClassIndex.get(iRep)).getNode());
            }
        }
        this.createDisjointIntervalsStructure();
        this.checkBasicSatisfiability();
    }

    private HashMap<Integer, Set<Integer>> dealWithCyclesIntervalLabellingSchema(boolean fixCycles) {
        HashMap<Integer, Set<Integer>> ontoHierarchy = null;
        HashSet<Set<Integer>> nonTrivialSCCs = new HashSet<Set<Integer>>();
        if (fixCycles) {
            ontoHierarchy = this.getIdent2DirectSubClasses_Integration();
            Map<Integer, Set<Integer>> sccs = new LightTarjan().executeTarjan(ontoHierarchy);
            for (Set<Integer> scc : sccs.values()) {
                if (scc.size() <= 1) continue;
                nonTrivialSCCs.add(scc);
                Integer n = scc.iterator().next();
                HashSet<Integer> sccMinusRepr = new HashSet<Integer>(scc);
                sccMinusRepr.remove(n);
                Iterator<Object> iterator = sccMinusRepr.iterator();
                while (iterator.hasNext()) {
                    Integer n2 = (Integer)iterator.next();
                    ontoHierarchy.get(n2).removeAll(scc);
                    ontoHierarchy.get(n).addAll((Collection<Integer>)ontoHierarchy.get(n2));
                }
                ontoHierarchy.get(n).removeAll(sccMinusRepr);
                for (Map.Entry entry : ontoHierarchy.entrySet()) {
                    if (scc.contains(entry.getKey())) continue;
                    int pre = ((Set)entry.getValue()).size();
                    ((Set)entry.getValue()).removeAll(sccMinusRepr);
                    if (((Set)entry.getValue()).size() == pre) continue;
                    ((Set)entry.getValue()).add(n);
                }
            }
            if (!nonTrivialSCCs.isEmpty()) {
                LogOutput.printAlways("Fixed " + nonTrivialSCCs.size() + " cycle(s)");
                sccs = new LightTarjan().executeTarjan(ontoHierarchy);
                int unsolved = 0;
                for (Set set : sccs.values()) {
                    if (set.size() <= 1) continue;
                    ++unsolved;
                    for (Integer i : set) {
                        System.out.println(i + ": " + ontoHierarchy.get(i));
                    }
                }
                if (unsolved > 0) {
                    throw new Error(unsolved + " unsolved SCCs");
                }
            }
            for (Set<Integer> scc : nonTrivialSCCs) {
                for (Integer i : scc) {
                    HashSet<Integer> sccMinusSelf = new HashSet<Integer>(scc);
                    sccMinusSelf.remove(i);
                    if (((ClassIndex)this.identifier2ClassIndex.get(i)).getEquivalentClasses() == null) {
                        ((ClassIndex)this.identifier2ClassIndex.get(i)).setEquivalentClasses(new HashSet<Integer>(sccMinusSelf));
                        continue;
                    }
                    ((ClassIndex)this.identifier2ClassIndex.get(i)).getEquivalentClasses().addAll(sccMinusSelf);
                }
            }
        }
        if (ontoHierarchy == null) {
            return this.getIdent2DirectSubClasses_Integration();
        }
        return ontoHierarchy;
    }

    private void createDisjointIntervalsStructure() {
        long init1 = Calendar.getInstance().getTimeInMillis();
        ArrayList<Interval> list_intervals = new ArrayList<Interval>();
        this.interval2disjointIntervals.clear();
        int wrong_preorder = 0;
        int wrong_desc_intervals = 0;
        Iterator iterator = this.identifier2ClassIndex.keySet().iterator();
        while (iterator.hasNext()) {
            int icls = (Integer)iterator.next();
            if (((ClassIndex)this.identifier2ClassIndex.get(icls)).getNode().getDescOrder() < 0) {
                ++wrong_preorder;
                continue;
            }
            for (Interval cls_interval : ((ClassIndex)this.identifier2ClassIndex.get(icls)).getNode().getDescIntervals()) {
                if (cls_interval.getLeftBound() >= 0 && cls_interval.getRightBound() >= 0) continue;
                ++wrong_desc_intervals;
            }
            if (!((ClassIndex)this.identifier2ClassIndex.get(icls)).hasDirectDisjointClasses()) continue;
            Iterator<Object> iterator2 = ((ClassIndex)this.identifier2ClassIndex.get(icls)).getDisjointClasses().iterator();
            while (iterator2.hasNext()) {
                int disjcls = (Integer)iterator2.next();
                for (Interval disjcls_interval : ((ClassIndex)this.identifier2ClassIndex.get(disjcls)).getNode().getDescIntervals()) {
                    if (disjcls_interval.getLeftBound() < 0 || disjcls_interval.getRightBound() < 0) continue;
                    list_intervals.add(disjcls_interval);
                }
            }
            if (list_intervals.size() >= 3) {
                Interval[] array_intervals = new Interval[list_intervals.size()];
                array_intervals = list_intervals.toArray(array_intervals);
                this._Quicksort(array_intervals, 0, array_intervals.length - 1);
                list_intervals.clear();
                Interval current_interval = array_intervals[0];
                for (int i = 1; i < array_intervals.length; ++i) {
                    if (current_interval.isAdjacentTo(array_intervals[i])) {
                        current_interval = current_interval.getUnionWith(array_intervals[i]);
                        continue;
                    }
                    list_intervals.add(current_interval);
                    current_interval = array_intervals[i];
                }
                list_intervals.add(current_interval);
                for (Interval cls_interval : ((ClassIndex)this.identifier2ClassIndex.get(icls)).getNode().getDescIntervals()) {
                    List<Interval> tmpList = new LinkedList<Interval>(list_intervals);
                    if (this.interval2disjointIntervals.containsKey(cls_interval)) {
                        tmpList.addAll((Collection)this.interval2disjointIntervals.get(cls_interval));
                        tmpList = this.mergeIntervals(tmpList);
                    }
                    this.interval2disjointIntervals.put(cls_interval, new HashSet(tmpList));
                }
            } else if (list_intervals.size() == 2) {
                List<Interval> originalList = ((Interval)list_intervals.get(0)).getUnionWithList((Interval)list_intervals.get(1));
                for (Interval cls_interval : ((ClassIndex)this.identifier2ClassIndex.get(icls)).getNode().getDescIntervals()) {
                    List<Interval> tmpList = new LinkedList<Interval>(originalList);
                    if (this.interval2disjointIntervals.containsKey(cls_interval)) {
                        tmpList.addAll((Collection)this.interval2disjointIntervals.get(cls_interval));
                        tmpList = this.mergeIntervals(tmpList);
                    }
                    this.interval2disjointIntervals.put(cls_interval, new HashSet<Interval>(tmpList));
                }
            } else if (list_intervals.size() == 1) {
                for (Interval cls_interval : ((ClassIndex)this.identifier2ClassIndex.get(icls)).getNode().getDescIntervals()) {
                    List<Interval> originalList = new LinkedList<Interval>(list_intervals);
                    if (this.interval2disjointIntervals.containsKey(cls_interval)) {
                        originalList.addAll((Collection)this.interval2disjointIntervals.get(cls_interval));
                        originalList = this.mergeIntervals(originalList);
                    }
                    this.interval2disjointIntervals.put(cls_interval, new HashSet(originalList));
                }
            }
            list_intervals.clear();
        }
        LogOutput.print("Classes with wrong/negative preorder (-1 or -d): " + wrong_preorder);
        LogOutput.print("Classes with wrong/negative descendants intervals (<-1,-1> or <-id,-id>): " + wrong_desc_intervals);
        long fin1 = Calendar.getInstance().getTimeInMillis();
        LogOutput.print("Time Getting Disjoint Intervals (merged) (s): " + (double)((float)((double)fin1 - (double)init1)) / 1000.0);
    }

    public List<Interval> mergeIntervals(List<Interval> list_intervals) {
        if (list_intervals.size() >= 3) {
            Interval[] array_intervals = new Interval[list_intervals.size()];
            array_intervals = list_intervals.toArray(array_intervals);
            this._Quicksort(array_intervals, 0, array_intervals.length - 1);
            list_intervals.clear();
            Interval current_interval = array_intervals[0];
            for (int i = 1; i < array_intervals.length; ++i) {
                if (current_interval.isAdjacentTo(array_intervals[i])) {
                    current_interval = current_interval.getUnionWith(array_intervals[i]);
                    continue;
                }
                list_intervals.add(current_interval);
                current_interval = array_intervals[i];
            }
            list_intervals.add(current_interval);
        } else if (list_intervals.size() == 2) {
            list_intervals = list_intervals.get(0).getUnionWithList(list_intervals.get(1));
        }
        return list_intervals;
    }

    private void checkBasicSatisfiability() {
        boolean sat = true;
        this.unsatisfiableClassesILS.clear();
        for (Interval interv1 : this.interval2disjointIntervals.keySet()) {
            for (Interval disj_interv : (Set)this.interval2disjointIntervals.get(interv1)) {
                if (!interv1.hasNonEmptyIntersectionWith(disj_interv)) continue;
                LogOutput.print("Classes in '" + interv1.getIntersectionWith(disj_interv) + "' are unsatisfiable");
                LogOutput.print("Involved intervals: " + interv1 + "  " + disj_interv);
                for (int pre = interv1.getIntersectionWith(disj_interv).getLeftBound(); pre <= interv1.getIntersectionWith(disj_interv).getRightBound(); ++pre) {
                    if (this.getIdentifier4PreorderDesc(pre) > 0) {
                        this.unsatisfiableClassesILS.add(this.getIdentifier4PreorderDesc(pre));
                        continue;
                    }
                    LogOutput.print("\tPreorder has not identifier");
                }
                LogOutput.print("\t" + interv1 + "   " + disj_interv);
                sat = false;
            }
        }
        if (sat) {
            LogOutput.print("There are non unsatisfiable clases (non-empty intersection of disjoint intervals))");
        }
    }

    public List<Interval> getDisjointIntervals4Identifier(int cIdent) {
        ArrayList<Interval> disj_intervals = new ArrayList<Interval>();
        int preorder = this.getPreOrderNumber(cIdent);
        for (Interval disj_int1 : this.interval2disjointIntervals.keySet()) {
            if (!disj_int1.containsIndex(preorder)) continue;
            for (Interval disj_int2 : (Set)this.interval2disjointIntervals.get(disj_int1)) {
                disj_intervals.add(disj_int2);
            }
        }
        return disj_intervals;
    }

    private void _Quicksort(Interval[] matrix, int a, int b) {
        int from = a;
        int to = b;
        Interval pivot = matrix[(from + to) / 2];
        while (true) {
            if (from <= b && matrix[from].hasLowerLeftBoundThan(pivot)) {
                ++from;
                continue;
            }
            while (to >= a && matrix[to].hasGreaterLeftBoundThan(pivot)) {
                --to;
            }
            if (from <= to) {
                Interval buf = matrix[from];
                matrix[from] = matrix[to];
                matrix[to] = buf;
                ++from;
                --to;
            }
            if (from > to) break;
        }
        if (a < to) {
            this._Quicksort(matrix, a, to);
        }
        if (from < b) {
            this._Quicksort(matrix, from, b);
        }
    }
}

