/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.krr.logmap2.indexing;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.search.EntitySearcher;
import org.semanticweb.owlapi.search.Searcher;
import uk.ac.ox.krr.logmap2.Parameters;

public class ExtractStringFromAnnotationAssertionAxiom {
    private OWLAnonymousIndividual geneid_value;
    private OWLNamedIndividual namedIndiv;
    private IRI namedIndivIRI;
    private String rdf_label_uri = "http://www.w3.org/2000/01/rdf-schema#label";
    private String fma_name_uri = "http://bioontology.org/projects/ontologies/fma/fmaOwlDlComponent_2_0#name";

    public String getAnntotationLanguage(OWLAnnotationAssertionAxiom entityAnnAx) {
        String lang;
        try {
            lang = ((OWLLiteral)entityAnnAx.getAnnotation().getValue()).getLang();
        }
        catch (Exception e) {
            System.err.println("Error accessing object.");
            lang = "";
        }
        return lang;
    }

    public String getSingleLabel(OWLAnnotationAssertionAxiom entityAnnAx, OWLOntology onto, OWLDataFactory datafactory) {
        String label_value = "";
        String uri_ann = entityAnnAx.getAnnotation().getProperty().getIRI().toString();
        if (Parameters.accepted_annotation_URIs_for_classes.contains(uri_ann)) {
            label_value = this.asDirectValue(entityAnnAx);
            if (!label_value.equals("")) {
                return label_value;
            }
            label_value = this.asAnonymousIndividual(entityAnnAx, onto);
            if (!label_value.equals("")) {
                return label_value;
            }
            label_value = this.asNamedIndividual(entityAnnAx, onto, datafactory);
            if (!label_value.equals("")) {
                return label_value;
            }
            label_value = this.asNamedIndividualFMA(entityAnnAx, onto, datafactory);
            if (!label_value.equals("")) {
                return label_value;
            }
        }
        return label_value;
    }

    public Set<String> getAnntotationString(OWLAnnotationAssertionAxiom entityAnnAx, OWLOntology onto, OWLDataFactory datafactory) {
        String label_value = "";
        String uri_ann = entityAnnAx.getAnnotation().getProperty().getIRI().toString();
        if (Parameters.accepted_annotation_URIs_for_classes.contains(uri_ann)) {
            label_value = this.asDirectValue(entityAnnAx);
            if (!label_value.equals("")) {
                return this.processLongLabels(label_value);
            }
            label_value = this.asAnonymousIndividual(entityAnnAx, onto);
            if (!label_value.equals("")) {
                return this.processLongLabels(label_value);
            }
            label_value = this.asNamedIndividual(entityAnnAx, onto, datafactory);
            if (!label_value.equals("")) {
                return this.processLongLabels(label_value);
            }
            label_value = this.asNamedIndividualFMA(entityAnnAx, onto, datafactory);
            if (!label_value.equals("")) {
                return this.processLongLabels(label_value);
            }
        }
        return new HashSet<String>();
    }

    private String asDirectValue(OWLAnnotationAssertionAxiom entityAnnAx) {
        try {
            String label = ((OWLLiteral)entityAnnAx.getAnnotation().getValue()).getLiteral().toLowerCase();
            if (label == null || label.equals("null") || label.equals("")) {
                return "";
            }
            return label;
        }
        catch (Exception e) {
            return "";
        }
    }

    private String asAnonymousIndividual(OWLAnnotationAssertionAxiom entityAnnAx, OWLOntology onto) {
        try {
            this.geneid_value = ((OWLAnonymousIndividual)entityAnnAx.getAnnotation().getValue()).asOWLAnonymousIndividual();
            for (OWLAnnotationAssertionAxiom annGeneidAx : onto.getAnnotationAssertionAxioms((OWLAnnotationSubject)this.geneid_value)) {
                if (!annGeneidAx.getAnnotation().getProperty().getIRI().toString().equals(this.rdf_label_uri)) continue;
                return ((OWLLiteral)annGeneidAx.getAnnotation().getValue()).getLiteral().toLowerCase();
            }
            return "";
        }
        catch (Exception e) {
            return "";
        }
    }

    private String asNamedIndividual(OWLAnnotationAssertionAxiom entityAnnAx, OWLOntology onto, OWLDataFactory datafactory) {
        try {
            this.namedIndivIRI = (IRI)entityAnnAx.getAnnotation().getValue();
            this.namedIndiv = datafactory.getOWLNamedIndividual(this.namedIndivIRI);
            for (OWLAnnotationAssertionAxiom annIdiv : EntitySearcher.getAnnotationAssertionAxioms((OWLEntity)this.namedIndiv, (OWLOntology)onto)) {
                if (!annIdiv.getAnnotation().getProperty().getIRI().toString().equals(this.rdf_label_uri)) continue;
                return ((OWLLiteral)annIdiv.getAnnotation().getValue()).getLiteral().toLowerCase();
            }
            return "";
        }
        catch (Exception e) {
            return "";
        }
    }

    private String asNamedIndividualFMA(OWLAnnotationAssertionAxiom entityAnnAx, OWLOntology onto, OWLDataFactory datafactory) {
        try {
            this.namedIndivIRI = (IRI)entityAnnAx.getAnnotation().getValue();
            this.namedIndiv = datafactory.getOWLNamedIndividual(this.namedIndivIRI);
            Iterator iterator = Searcher.values((Collection)onto.getDataPropertyAssertionAxioms((OWLIndividual)this.namedIndiv), (OWLDataPropertyExpression)datafactory.getOWLDataProperty(IRI.create((String)this.fma_name_uri))).iterator();
            if (iterator.hasNext()) {
                OWLLiteral literal_syn = (OWLLiteral)iterator.next();
                return literal_syn.getLiteral().toLowerCase();
            }
            return "";
        }
        catch (Exception e) {
            return "";
        }
    }

    private Set<String> processLongLabels(String label) {
        HashSet<String> annotation_labels = new HashSet<String>();
        if (label.length() < 2) {
            return annotation_labels;
        }
        if (label.indexOf("|") >= 0) {
            String[] elements;
            for (String e : elements = label.split("\\|")) {
                annotation_labels.add(e);
            }
            return annotation_labels;
        }
        if (label.indexOf(".") < 0 || label.length() < 15) {
            annotation_labels.add(label);
            return annotation_labels;
        }
        String[] words = (label = label.split("\\.")[0]).split(" ");
        if (words.length > 12) {
            return annotation_labels;
        }
        annotation_labels.add(label);
        return annotation_labels;
    }
}

