/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.krr.logmap2.bioportal;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.semanticweb.owlapi.model.OWLOntology;
import uk.ac.ox.krr.logmap2.Parameters;
import uk.ac.ox.krr.logmap2.bioportal.BioPortalOntologyInfo;
import uk.ac.ox.krr.logmap2.bioportal.CandidateMediatingOntology;
import uk.ac.ox.krr.logmap2.bioportal.RESTBioPortalAccess;

public class MediatingOntologyExtractor {
    private RESTBioPortalAccess bioportal;
    private TreeSet<CandidateMediatingOntology> ordered_candidate_mo = new TreeSet<CandidateMediatingOntology>(new CandidateMediatingOntologyComparator());
    private Map<String, CandidateMediatingOntology> candiateMOs = new HashMap<String, CandidateMediatingOntology>();
    private List<String> selectedMediatingOntologies = new ArrayList<String>();
    private Set<String> representative_labels;
    private Set<String> acronyms = new HashSet<String>();
    private Set<String> bad_ontologies = new HashSet<String>();
    private final int MAX_SIZE_ONTOLOGY = 20000;
    private final int MAX_NUM_CALLS = 200;
    private final int MIN_NUM_CALLS = 35;
    private final int SIZE_SELECTED_ONTOS = Parameters.max_mediating_ontologies;
    public final int MAX_MO_FOR_MATCHING = Parameters.max_mediating_ontologies;
    private int num_calls = 0;

    public MediatingOntologyExtractor(Set<String> representative_labels) {
        this.bioportal = new RESTBioPortalAccess();
        if (this.bioportal.isActive()) {
            this.bad_ontologies.add("OPE");
            this.bad_ontologies.add("NIFSTD");
            this.bad_ontologies.add("RADLEX");
            this.bad_ontologies.add("SOPHARM");
            this.bad_ontologies.add("EP");
            this.bad_ontologies.add("GO-PLUS");
            this.representative_labels = representative_labels;
            this.extractMediatingOntologies();
            this.printMediatingOntologies();
        } else {
            System.out.println("BioPotal is not accessible. No mediating ontology has been extracted.");
        }
    }

    private void printMediatingOntologies() {
        System.out.println("Necessary number of calls to BioPortal: " + this.num_calls);
        for (int i = 0; i < this.selectedMediatingOntologies.size(); ++i) {
            System.out.println(this.selectedMediatingOntologies.get(i));
            System.out.println("\tPos hits: " + this.candiateMOs.get(this.selectedMediatingOntologies.get(i)).getPositiveHits());
            System.out.println("\tSize: " + this.candiateMOs.get(this.selectedMediatingOntologies.get(i)).getNumberOfClasses());
            System.out.println("\tLanguage: " + this.candiateMOs.get(this.selectedMediatingOntologies.get(i)).getOntologyLanguage());
        }
    }

    private void extractMediatingOntologies() {
        for (String rep_label : this.representative_labels) {
            ++this.num_calls;
            this.extractSuitableOntologiesForLabel(rep_label);
            if (this.num_calls > 200) {
                this.createOrderedMediatingOntologiesList();
                break;
            }
            if (this.num_calls % 10 != 0 || this.createOrderedMediatingOntologiesList()) continue;
            break;
        }
    }

    private void extractSuitableOntologiesForLabel(String label) {
        try {
            this.acronyms.clear();
            JsonNode jsonConcepts = this.bioportal.getConcepts4Label(label, true);
            for (JsonNode concept : jsonConcepts) {
                this.bioportal.getClass();
                JsonNode jsonNode = concept.get("links");
                this.bioportal.getClass();
                String acronym = this.bioportal.getOntologyAcronym(jsonNode.get("ontology").asText());
                if (this.acronyms.contains(acronym) || this.bad_ontologies.contains(acronym)) continue;
                this.acronyms.add(acronym);
                int size_synset = 0;
                this.bioportal.getClass();
                if (concept.has("synonym")) {
                    this.bioportal.getClass();
                    size_synset = concept.get("synonym").size();
                }
                if (this.candiateMOs.containsKey(acronym)) {
                    this.candiateMOs.get(acronym).increasePositiveHits();
                    this.candiateMOs.get(acronym).increaseNumberOfProvidedSynonyms(size_synset);
                    continue;
                }
                BioPortalOntologyInfo onto_bio = this.bioportal.getMetricInfo4Onto(acronym);
                this.candiateMOs.put(acronym, new CandidateMediatingOntology(onto_bio, size_synset));
            }
        }
        catch (JsonProcessingException e) {
            System.out.println("Error performing the BioPortal call for: " + label + ". Mediating ontology search.");
        }
        catch (IOException e) {
            System.out.println("Error performing the BioPortal call for: " + label + ". Mediating ontology search.");
        }
    }

    private boolean createOrderedMediatingOntologiesList() {
        int i;
        CandidateMediatingOntology[] former_order = new CandidateMediatingOntology[this.ordered_candidate_mo.size()];
        former_order = this.ordered_candidate_mo.toArray(former_order);
        this.ordered_candidate_mo.clear();
        for (String key : this.candiateMOs.keySet()) {
            this.ordered_candidate_mo.add(this.candiateMOs.get(key));
        }
        CandidateMediatingOntology[] new_order = new CandidateMediatingOntology[this.ordered_candidate_mo.size()];
        new_order = this.ordered_candidate_mo.toArray(new_order);
        this.selectedMediatingOntologies.clear();
        int size = new_order.length >= this.SIZE_SELECTED_ONTOS ? this.SIZE_SELECTED_ONTOS : new_order.length;
        for (i = 0; i < size; ++i) {
            this.selectedMediatingOntologies.add(new_order[i].getOntologyAcronym());
        }
        if (this.num_calls < 35) {
            return true;
        }
        if (new_order.length >= 5 && former_order.length >= 5) {
            if (new_order[4].getPositiveHits() < 20) {
                return true;
            }
            for (i = 0; i < 5; ++i) {
                if (new_order[i].equals(former_order[i])) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public int getNumCallsBioPortal() {
        return this.num_calls;
    }

    public List<String> getSelectedMediatingOntologies() {
        return this.selectedMediatingOntologies;
    }

    public OWLOntology downloadBioPortalOntology(String ontoAcronym, int attempts) {
        return this.bioportal.downLoadOntology(ontoAcronym, attempts);
    }

    private class CandidateMediatingOntologyComparator
    implements Comparator<CandidateMediatingOntology> {
        private CandidateMediatingOntologyComparator() {
        }

        @Override
        public int compare(CandidateMediatingOntology mo1, CandidateMediatingOntology mo2) {
            if (mo1.getSuitabilityValue() < mo2.getSuitabilityValue()) {
                return 1;
            }
            return -1;
        }
    }
}

