/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.krr.logmap2.background;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import uk.ac.ox.krr.logmap2.mappings.objects.MappingObjectStr;
import uk.ac.ox.krr.logmap2.oaei.reader.MappingsReaderManager;

public class CategoryMappingsLoader {
    private Map<String, Set<String>> category_mappings = new HashMap<String, Set<String>>();

    public void loadMappings(String path) {
        File directory = new File(path);
        if (!directory.exists()) {
            return;
        }
        String[] filenames = directory.list();
        for (int i = 0; i < filenames.length; ++i) {
            MappingsReaderManager manager;
            if (filenames[i].contains(".rdf")) {
                manager = new MappingsReaderManager(directory.getAbsolutePath() + "/" + filenames[i], "RDF");
                this.addMappings(manager.getMappingObjects());
                continue;
            }
            if (!filenames[i].contains(".csv")) continue;
            manager = new MappingsReaderManager(directory.getAbsolutePath() + "/" + filenames[i], "TXT");
            this.addMappings(manager.getMappingObjects());
        }
    }

    private void addMappings(Set<MappingObjectStr> mappings) {
        for (MappingObjectStr mapping : mappings) {
            if (mapping.getMappingDirection() == -2) {
                this.addMapping(mapping.getIRIStrEnt1(), mapping.getIRIStrEnt2());
                this.addMapping(mapping.getIRIStrEnt2(), mapping.getIRIStrEnt1());
                continue;
            }
            if (mapping.getMappingDirection() == 0) {
                this.addMapping(mapping.getIRIStrEnt2(), mapping.getIRIStrEnt1());
                continue;
            }
            if (mapping.getMappingDirection() != -1) continue;
            this.addMapping(mapping.getIRIStrEnt1(), mapping.getIRIStrEnt2());
        }
    }

    private void addMapping(String uri1, String uri2) {
        if (!this.category_mappings.containsKey(uri1)) {
            this.category_mappings.put(uri1, new HashSet());
        }
        this.category_mappings.get(uri1).add(uri2);
    }

    public Map<String, Set<String>> getCategoryMappings() {
        return this.category_mappings;
    }

    public boolean hasMappings(String uri) {
        return this.category_mappings.containsKey(uri);
    }

    public Set<String> getMappings(String uri) {
        return this.category_mappings.get(uri);
    }

    public Set<String> getMappingsWithCheck(String uri) {
        if (this.category_mappings.containsKey(uri)) {
            return this.category_mappings.get(uri);
        }
        return new HashSet<String>();
    }
}

