/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.krr.logmap2.SIAssessment;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import uk.ac.ox.krr.logmap2.SIAssessment.PropertyMappingAssessment;
import uk.ac.ox.krr.logmap2.indexing.IndexManager;
import uk.ac.ox.krr.logmap2.mappings.MappingManager;

public class DataPropertyMappingAssessment
extends PropertyMappingAssessment<String> {
    public DataPropertyMappingAssessment(IndexManager index, MappingManager mapping_manager) {
        this.index = index;
        this.mapping_manager = mapping_manager;
    }

    @Override
    protected int arePropertiesCompatible(int ident1, int ident2) {
        Set<Integer> domain1 = this.index.getDomainDataProp4Identifier(ident1);
        HashSet<Integer> mapped_domain1 = new HashSet<Integer>();
        Set<Integer> domain2 = this.index.getDomainDataProp4Identifier(ident2);
        Set<String> range1 = this.index.getRangeDataProp4Identifier(ident1);
        Set<String> range2 = this.index.getRangeDataProp4Identifier(ident2);
        boolean same_domain = false;
        boolean same_range = false;
        if (domain1.isEmpty() && domain2.isEmpty() && range1.isEmpty() && range2.isEmpty()) {
            return 0;
        }
        if (domain1.isEmpty() && !domain2.isEmpty() || range1.isEmpty() && !range2.isEmpty() || !domain1.isEmpty() && domain2.isEmpty() || !range1.isEmpty() && range2.isEmpty()) {
            return 4;
        }
        for (int ide1 : domain1) {
            if (!this.index.getDangerousClasses().contains(ide1)) continue;
            return 4;
        }
        for (int ide2 : domain2) {
            if (!this.index.getDangerousClasses().contains(ide2)) continue;
            return 4;
        }
        if (!domain1.isEmpty() && !domain2.isEmpty()) {
            for (int cls1 : domain1) {
                if (!this.mapping_manager.getLogMapMappings().containsKey(cls1)) continue;
                mapped_domain1.addAll((Collection<Integer>)this.mapping_manager.getLogMapMappings().get(cls1));
            }
        }
        same_domain = this.haveSameDomain(mapped_domain1, domain2);
        same_range = this.haveSameRange(range1, range2);
        if (same_domain && same_range) {
            return 1;
        }
        if (same_range) {
            for (int cls1 : domain1) {
                for (int cls2 : domain2) {
                    if (!this.mapping_manager.isMappingInConflictWithFixedMappings(cls1, cls2)) continue;
                    return 4;
                }
            }
            return 3;
        }
        return 4;
    }

    @Override
    protected int arePropertiesCompatibleLight(int ident1, int ident2) {
        Set<Integer> domain1 = this.index.getDomainDataProp4Identifier(ident1);
        HashSet<Integer> mapped_domain1 = new HashSet<Integer>();
        Set<Integer> domain2 = this.index.getDomainDataProp4Identifier(ident2);
        Set<String> range1 = this.index.getRangeDataProp4Identifier(ident1);
        Set<String> range2 = this.index.getRangeDataProp4Identifier(ident2);
        boolean same_domain = false;
        boolean same_range = false;
        if (domain1.isEmpty() && domain2.isEmpty() && range1.isEmpty() && range2.isEmpty()) {
            return 0;
        }
        for (int ide1 : domain1) {
            if (!this.index.getDangerousClasses().contains(ide1)) continue;
            return 4;
        }
        for (int ide2 : domain2) {
            if (!this.index.getDangerousClasses().contains(ide2)) continue;
            return 4;
        }
        if (!domain1.isEmpty() && !domain2.isEmpty()) {
            for (int cls1 : domain1) {
                if (!this.mapping_manager.getLogMapMappings().containsKey(cls1)) continue;
                mapped_domain1.addAll((Collection<Integer>)this.mapping_manager.getLogMapMappings().get(cls1));
            }
        }
        same_domain = this.haveSameDomain(mapped_domain1, domain2);
        same_range = this.haveSameRange(range1, range2);
        if (range1.size() == 1 && range1.contains("Literal")) {
            same_range = true;
        } else if (range2.size() == 1 && range2.contains("Literal")) {
            same_range = true;
        }
        if (same_domain && same_range) {
            return 1;
        }
        if (same_range) {
            for (int cls1 : domain1) {
                for (int cls2 : domain2) {
                    if (!this.mapping_manager.isMappingInConflictWithFixedMappings(cls1, cls2)) continue;
                    return 4;
                }
            }
            return 3;
        }
        return 4;
    }
}

